/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.resource;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.ValidationContext;
import gaml.compiler.gaml.resource.GamlResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImportedResources {
    public ListMultimap<String, GamlResource> micromodels;
    public Set<GamlResource> imports;

    public void add(String string, GamlResource gamlResource) {
        if (string == null) {
            this.addOwnImport(gamlResource);
        } else {
            this.addMicroModel(string, gamlResource);
        }
    }

    private void addMicroModel(String string, GamlResource gamlResource) {
        if (this.micromodels == null) {
            this.micromodels = ArrayListMultimap.create();
        }
        this.micromodels.put((Object)string, (Object)gamlResource);
    }

    private void addOwnImport(GamlResource gamlResource) {
        if (this.imports == null) {
            this.imports = Sets.newLinkedHashSet();
        }
        this.imports.add(gamlResource);
    }

    public Iterable<ISyntacticElement> computeDirectImports(ISyntacticElement iSyntacticElement) {
        return this.imports == null ? Collections.singleton(iSyntacticElement) : Iterables.concat(Collections.singleton(iSyntacticElement), (Iterable)Iterables.transform(this.imports, GamlResource.TO_SYNTACTIC_CONTENTS));
    }

    public Map<String, ModelDescription> computeMicroModels(String string, String string2, ValidationContext validationContext) {
        if (this.micromodels == null) {
            return null;
        }
        HashMap hashMap = Maps.newHashMap();
        for (String string3 : this.micromodels.keySet()) {
            ModelDescription modelDescription = GAML.getModelFactory().createModelDescription(string, string2, Iterables.transform((Iterable)this.micromodels.get((Object)string3), GamlResource.TO_SYNTACTIC_CONTENTS), validationContext, null);
            modelDescription.setAlias(string3);
            hashMap.put(string3, modelDescription);
        }
        return hashMap;
    }
}

