/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.validation;

import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.IGamlTextValidator;
import gaml.compiler.gaml.resource.GamlResource;
import gaml.compiler.gaml.resource.GamlResourceServices;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;

public class GamlTextValidator
implements IGamlTextValidator {
    public void validateModel(String string, List<GamlCompilationError> list, boolean bl) {
        GamlResource gamlResource = GamlResourceServices.getTemporaryResource(null);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            try {
                gamlResource.loadSynthetic(byteArrayInputStream, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (gamlResource.hasErrors()) {
                for (Resource.Diagnostic diagnostic : gamlResource.getErrors()) {
                    GamlCompilationError gamlCompilationError;
                    if (diagnostic instanceof EObjectDiagnosticImpl) {
                        EObjectDiagnosticImpl eObjectDiagnosticImpl = (EObjectDiagnosticImpl)diagnostic;
                        gamlCompilationError = new GamlCompilationError(eObjectDiagnosticImpl.getMessage(), "gaml.syntactic.error", eObjectDiagnosticImpl.getProblematicObject(), Severity.WARNING.equals((Object)eObjectDiagnosticImpl.getSeverity()) ? GamlCompilationError.GamlCompilationErrorType.Warning : (Severity.INFO.equals((Object)eObjectDiagnosticImpl.getSeverity()) ? GamlCompilationError.GamlCompilationErrorType.Info : GamlCompilationError.GamlCompilationErrorType.Error), eObjectDiagnosticImpl.getData());
                    } else if (diagnostic instanceof XtextLinkingDiagnostic) {
                        XtextLinkingDiagnostic xtextLinkingDiagnostic = (XtextLinkingDiagnostic)diagnostic;
                        gamlCompilationError = new GamlCompilationError(xtextLinkingDiagnostic.getMessage(), "gaml.linking.error", xtextLinkingDiagnostic.getUriToProblem(), GamlCompilationError.GamlCompilationErrorType.Error, xtextLinkingDiagnostic.getData());
                    } else if (diagnostic instanceof XtextSyntaxDiagnostic) {
                        XtextSyntaxDiagnostic xtextSyntaxDiagnostic = (XtextSyntaxDiagnostic)diagnostic;
                        gamlCompilationError = new GamlCompilationError(xtextSyntaxDiagnostic.getMessage(), "gaml.syntactic.error", xtextSyntaxDiagnostic.getUriToProblem(), GamlCompilationError.GamlCompilationErrorType.Error, xtextSyntaxDiagnostic.getData());
                    } else {
                        gamlCompilationError = new GamlCompilationError(diagnostic.getMessage(), "gaml.syntactic.error", gamlResource.getURI(), GamlCompilationError.GamlCompilationErrorType.Error, new String[0]);
                    }
                    list.add(gamlCompilationError);
                }
            }
            if (bl) {
                return;
            }
            gamlResource.validate();
            if (gamlResource.hasSemanticErrors()) {
                for (Resource.Diagnostic diagnostic : gamlResource.getValidationContext().getInternalErrors()) {
                    list.add((GamlCompilationError)diagnostic);
                }
            }
        }
        finally {
            GamlResourceServices.discardTemporaryResource(gamlResource);
        }
    }
}

