/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.gaml.compilation.kernel.GamaSkillRegistry;
import gama.gaml.types.Types;
import gaml.compiler.gaml.EGaml;
import gaml.compiler.gaml.GamlDefinition;
import gaml.compiler.gaml.GamlPackage;
import gaml.compiler.gaml.indexer.GamlResourceIndexer;
import gaml.compiler.gaml.resource.GamlResource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;

@Singleton
public class BuiltinGlobalScopeProvider
extends ImportUriGlobalScopeProvider {
    private final IMap<EClass, EClassBasedScope> scopes = GamaMapFactory.createUnordered();
    private final Set<QualifiedName> allQualifiedNames = new HashSet<QualifiedName>();
    private final EClass eType;
    private final EClass eVar;
    private final EClass eSkill;
    private final EClass eAction;
    private final EClass eUnit;
    private final EClass eEquation;
    private final XtextResourceSet rs = new XtextResourceSet();

    static {
        DEBUG.ON();
    }

    public BuiltinGlobalScopeProvider() {
        this.eType = GamlPackage.eINSTANCE.getTypeDefinition();
        this.eVar = GamlPackage.eINSTANCE.getVarDefinition();
        this.eSkill = GamlPackage.eINSTANCE.getSkillFakeDefinition();
        this.eAction = GamlPackage.eINSTANCE.getActionDefinition();
        this.eUnit = GamlPackage.eINSTANCE.getUnitFakeDefinition();
        this.eEquation = GamlPackage.eINSTANCE.getEquationDefinition();
        DEBUG.TIMER((String)"GAML", (String)"Artifacts", (String)"built in", () -> {
            this.scopes.put((Object)this.eType, (Object)new EClassBasedScope("types.xmi"));
            this.scopes.put((Object)this.eVar, (Object)new EClassBasedScope("vars.xmi"));
            this.scopes.put((Object)this.eSkill, (Object)new EClassBasedScope("skills.xmi"));
            this.scopes.put((Object)this.eAction, (Object)new EClassBasedScope("units.xmi"));
            this.scopes.put((Object)this.eUnit, (Object)new EClassBasedScope("actions.xmi"));
            this.scopes.put((Object)this.eEquation, (Object)new EClassBasedScope("equations.xmi"));
            this.add("__synthetic__action__", this.eAction);
            Types.getTypeNames().forEach(string -> this.add((String)string, this.eType, this.eVar, this.eAction));
            GAML.CONSTANTS.forEach(string -> {
                try {
                    this.add((String)string, this.eType, this.eVar);
                }
                catch (Exception exception) {
                    GamaBundleLoader.ERROR((String)("Error when bulding constant artefact " + string), (Exception)exception);
                }
            });
            GAML.UNITS.forEach((string, unitConstantExpression) -> {
                try {
                    this.add((String)string, this.eUnit);
                }
                catch (Exception exception) {
                    GamaBundleLoader.ERROR((String)("Error when bulding unit artefact " + string), (Exception)exception);
                }
            });
            GAML.getAllFields().forEach(operatorProto -> {
                try {
                    this.add(operatorProto.getName(), this.eVar);
                }
                catch (Exception exception) {
                    GamaBundleLoader.ERROR((String)("Error when bulding field artefact " + String.valueOf(operatorProto)), (Exception)exception);
                }
            });
            GAML.getAllVars().forEach(iDescription -> {
                try {
                    this.add(iDescription.getName(), this.eVar);
                }
                catch (Exception exception) {
                    GamaBundleLoader.ERROR((String)("Error when bulding var artefact " + iDescription.getName()), (Exception)exception);
                }
            });
            GamaSkillRegistry.INSTANCE.getAllSkillNames().forEach(string -> {
                try {
                    this.add((String)string, this.eSkill, this.eVar);
                }
                catch (Exception exception) {
                    GamaBundleLoader.ERROR((String)("Error when bulding skill artefact " + string), (Exception)exception);
                }
            });
            GAML.getAllActions().forEach(iDescription -> {
                try {
                    this.add(iDescription.getName(), this.eAction, this.eVar);
                }
                catch (Exception exception) {
                    GamaBundleLoader.ERROR((String)("Error when bulding action artefact " + iDescription.getName()), (Exception)exception);
                }
            });
            GAML.OPERATORS.forEach((string, iMap) -> {
                try {
                    this.add((String)string, this.eAction);
                }
                catch (Exception exception) {
                    GamaBundleLoader.ERROR((String)("Error when bulding action artefact " + string), (Exception)exception);
                }
            });
        }, (Consumer[])new Consumer[0]);
    }

    public boolean contains(QualifiedName qualifiedName) {
        return this.allQualifiedNames.contains(qualifiedName);
    }

    void add(String string, EClass ... eClassArray) {
        QualifiedName qualifiedName = QualifiedName.create((String)string);
        this.allQualifiedNames.add(qualifiedName);
        EClass[] eClassArray2 = eClassArray;
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray2[n2];
            ((EClassBasedScope)this.scopes.get((Object)eClass)).add(qualifiedName, EGaml.getInstance().createGamlDefinition(string, eClass));
            ++n2;
        }
    }

    protected IScope getScope(Resource resource, boolean bl, EClass eClass, Predicate<IEObjectDescription> predicate) {
        IScope iScope = (IScope)this.scopes.get((Object)eClass);
        Collection<Object> collection = GamlResourceIndexer.allImportsOf((GamlResource)resource).keySet();
        int n = collection.size();
        if (n == 0) {
            return iScope;
        }
        if (n > 1) {
            collection = Lists.newArrayList(collection);
            Collections.reverse((List)collection);
        }
        IResourceDescriptions iResourceDescriptions = this.getResourceDescriptions(resource, collection);
        return SelectableBasedScope.createScope((IScope)iScope, (ISelectable)iResourceDescriptions, predicate, (EClass)eClass, (boolean)false);
    }

    class EClassBasedScope
    implements IScope {
        final Resource resource;
        final IMap<QualifiedName, IEObjectDescription> elements = GamaMapFactory.createUnordered();

        public EClassBasedScope(String string) {
            Resource resource = BuiltinGlobalScopeProvider.this.rs.getResource(URI.createURI((String)string, (boolean)false), false);
            if (resource == null) {
                resource = BuiltinGlobalScopeProvider.this.rs.createResource(URI.createURI((String)string, (boolean)false));
            }
            this.resource = resource;
        }

        public IEObjectDescription getSingleElement(QualifiedName qualifiedName) {
            return (IEObjectDescription)this.elements.get((Object)qualifiedName);
        }

        public Iterable<IEObjectDescription> getAllElements() {
            return this.elements.values();
        }

        public Iterable<IEObjectDescription> getElements(QualifiedName qualifiedName) {
            IEObjectDescription iEObjectDescription = (IEObjectDescription)this.elements.get((Object)qualifiedName);
            if (iEObjectDescription == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(iEObjectDescription);
        }

        public IEObjectDescription getSingleElement(EObject eObject) {
            URI uRI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)eObject);
            for (Map.Entry entry : this.elements.entrySet()) {
                IEObjectDescription iEObjectDescription = (IEObjectDescription)entry.getValue();
                if (iEObjectDescription.getEObjectOrProxy() != eObject && !uRI.equals(iEObjectDescription.getEObjectURI())) continue;
                return iEObjectDescription;
            }
            return null;
        }

        public List<IEObjectDescription> getElements(EObject eObject) {
            URI uRI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)eObject);
            for (Map.Entry entry : this.elements.entrySet()) {
                IEObjectDescription iEObjectDescription = (IEObjectDescription)entry.getValue();
                if (iEObjectDescription.getEObjectOrProxy() != eObject && !uRI.equals(iEObjectDescription.getEObjectURI())) continue;
                return Collections.singletonList(iEObjectDescription);
            }
            return Collections.EMPTY_LIST;
        }

        public void add(QualifiedName qualifiedName, GamlDefinition gamlDefinition) {
            this.resource.getContents().add((Object)gamlDefinition);
            this.elements.put((Object)qualifiedName, (Object)EObjectDescription.create((QualifiedName)qualifiedName, (EObject)gamlDefinition));
        }
    }
}

