/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml;

import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.dev.COUNTER;
import gama.gaml.compilation.IGamlEcoreUtils;
import gaml.compiler.gaml.Access;
import gaml.compiler.gaml.ActionRef;
import gaml.compiler.gaml.ArgumentDefinition;
import gaml.compiler.gaml.ArgumentPair;
import gaml.compiler.gaml.Array;
import gaml.compiler.gaml.BinaryOperator;
import gaml.compiler.gaml.Block;
import gaml.compiler.gaml.EquationRef;
import gaml.compiler.gaml.Expression;
import gaml.compiler.gaml.Facet;
import gaml.compiler.gaml.Function;
import gaml.compiler.gaml.GamlDefinition;
import gaml.compiler.gaml.GamlFactory;
import gaml.compiler.gaml.GamlPackage;
import gaml.compiler.gaml.HeadlessExperiment;
import gaml.compiler.gaml.If;
import gaml.compiler.gaml.Model;
import gaml.compiler.gaml.Parameter;
import gaml.compiler.gaml.Point;
import gaml.compiler.gaml.S_Action;
import gaml.compiler.gaml.S_Assignment;
import gaml.compiler.gaml.S_Definition;
import gaml.compiler.gaml.S_DirectAssignment;
import gaml.compiler.gaml.S_Display;
import gaml.compiler.gaml.S_Equations;
import gaml.compiler.gaml.S_If;
import gaml.compiler.gaml.S_Reflex;
import gaml.compiler.gaml.SkillRef;
import gaml.compiler.gaml.Statement;
import gaml.compiler.gaml.StringLiteral;
import gaml.compiler.gaml.TerminalExpression;
import gaml.compiler.gaml.TypeRef;
import gaml.compiler.gaml.Unary;
import gaml.compiler.gaml.UnitName;
import gaml.compiler.gaml.VariableRef;
import gaml.compiler.gaml.impl.ActionArgumentsImpl;
import gaml.compiler.gaml.impl.BlockImpl;
import gaml.compiler.gaml.impl.ExpressionListImpl;
import gaml.compiler.gaml.impl.HeadlessExperimentImpl;
import gaml.compiler.gaml.impl.ModelImpl;
import gaml.compiler.gaml.impl.S_ActionImpl;
import gaml.compiler.gaml.impl.S_EquationsImpl;
import gaml.compiler.gaml.impl.S_IfImpl;
import gaml.compiler.gaml.impl.StatementImpl;
import gaml.compiler.gaml.util.GamlSwitch;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class EGaml
implements IGamlEcoreUtils {
    private static final EGaml instance = new EGaml();
    private final GamlSwitch<Boolean> childrenSwitch = new GamlSwitch<Boolean>(){

        @Override
        public Boolean caseModel(Model model) {
            return ((ModelImpl)model).eIsSet(3);
        }

        @Override
        public Boolean caseS_Action(S_Action s_Action) {
            if (((S_ActionImpl)s_Action).eIsSet(7)) {
                return true;
            }
            return this.caseStatement(s_Action);
        }

        @Override
        public Boolean caseBlock(Block block) {
            return ((BlockImpl)block).eIsSet(0);
        }

        @Override
        public Boolean caseStatement(Statement statement) {
            if (!((StatementImpl)statement).eIsSet(4) && !EGaml.this.hasFacet(statement, "virtual")) {
                return false;
            }
            return true;
        }

        @Override
        public Boolean caseHeadlessExperiment(HeadlessExperiment headlessExperiment) {
            return ((HeadlessExperimentImpl)headlessExperiment).eIsSet(5);
        }

        @Override
        public Boolean caseS_Equations(S_Equations s_Equations) {
            return ((S_EquationsImpl)s_Equations).eIsSet(6);
        }

        @Override
        public Boolean caseS_If(S_If s_If) {
            if (!this.caseStatement(s_If).booleanValue() && !((S_IfImpl)s_If).eIsSet(5)) {
                return false;
            }
            return true;
        }

        @Override
        public Boolean defaultCase(EObject eObject) {
            return false;
        }
    };

    public static EGaml getInstance() {
        return instance;
    }

    public String getNameOf(EObject eObject) {
        String string;
        if (eObject instanceof S_Reflex && (string = ((S_Reflex)eObject).getName()) == null) {
            return "_internal_" + this.getKeyOf(eObject) + String.valueOf(COUNTER.COUNT());
        }
        if (eObject instanceof GamlDefinition) {
            return ((GamlDefinition)eObject).getName();
        }
        if (eObject instanceof S_Display) {
            return ((S_Display)eObject).getName();
        }
        if (eObject instanceof HeadlessExperiment) {
            return ((HeadlessExperiment)eObject).getName();
        }
        return null;
    }

    public List<Expression> getExprsOf(EObject eObject) {
        ExpressionListImpl expressionListImpl;
        if (eObject instanceof ExpressionListImpl && (expressionListImpl = (ExpressionListImpl)eObject).eIsSet(0)) {
            return expressionListImpl.getExprs();
        }
        return Collections.EMPTY_LIST;
    }

    public List<ArgumentDefinition> getArgsOf(EObject eObject) {
        if (eObject == null) {
            return Collections.EMPTY_LIST;
        }
        if (eObject instanceof ActionArgumentsImpl && ((ActionArgumentsImpl)eObject).eIsSet(0)) {
            return ((ActionArgumentsImpl)eObject).getArgs();
        }
        return Collections.EMPTY_LIST;
    }

    public List<Facet> getFacetsOf(EObject eObject) {
        if (eObject instanceof StatementImpl) {
            if (((StatementImpl)eObject).eIsSet(3)) {
                return ((StatementImpl)eObject).getFacets();
            }
        } else if (eObject instanceof HeadlessExperimentImpl && ((HeadlessExperimentImpl)eObject).eIsSet(4)) {
            return ((HeadlessExperimentImpl)eObject).getFacets();
        }
        return Collections.EMPTY_LIST;
    }

    public Map<String, Facet> getFacetsMapOf(EObject eObject) {
        List<Facet> list = this.getFacetsOf(eObject);
        if (list.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        IMap iMap = GamaMapFactory.create();
        for (EObject eObject2 : list) {
            if (!(eObject2 instanceof Facet)) continue;
            iMap.put(this.getKeyOf(eObject2), (Facet)eObject2);
        }
        return iMap;
    }

    public boolean hasFacet(EObject eObject, String string) {
        List<Facet> list = this.getFacetsOf(eObject);
        if (list.isEmpty()) {
            return false;
        }
        for (EObject eObject2 : list) {
            String string2;
            if (!(eObject2 instanceof Facet) || !string.equals(string2 = this.getKeyOf(eObject2))) continue;
            return true;
        }
        return false;
    }

    public Expression getExpressionAtKey(EObject eObject, String string) {
        if (eObject == null || string == null) {
            return null;
        }
        if ("value".equals(string) && eObject instanceof S_DirectAssignment) {
            return ((S_DirectAssignment)eObject).getValue();
        }
        List<Facet> list = this.getFacetsOf(eObject);
        for (Facet facet : list) {
            String string2 = this.getKeyOf(facet);
            if (eObject instanceof Statement && ("value".equals(string) || "init".equals(string)) ? "<-".equals(string2) : eObject instanceof S_Assignment && "item".equals(string) && (string2.contains("<") || string2.contains(">"))) {
                return facet.getExpr();
            }
            if (!string.equals(string2)) continue;
            return facet.getExpr();
        }
        return null;
    }

    public Expression getExprOf(EObject eObject) {
        if (eObject instanceof Expression) {
            return (Expression)eObject;
        }
        if (eObject instanceof Statement) {
            return ((Statement)eObject).getExpr();
        }
        return null;
    }

    public boolean hasChildren(EObject eObject) {
        return (Boolean)this.childrenSwitch.doSwitch(eObject);
    }

    public List<Statement> getStatementsOf(EObject eObject) {
        if (eObject instanceof BlockImpl) {
            if (((BlockImpl)eObject).eIsSet(0)) {
                return ((BlockImpl)eObject).getStatements();
            }
        } else if (eObject instanceof Model) {
            return this.getStatementsOf(((Model)eObject).getBlock());
        }
        return Collections.EMPTY_LIST;
    }

    public List<S_Assignment> getEquationsOf(EObject eObject) {
        if (eObject instanceof S_EquationsImpl && ((S_EquationsImpl)eObject).eIsSet(6)) {
            return ((S_EquationsImpl)eObject).getEquations();
        }
        return Collections.EMPTY_LIST;
    }

    public String getKeyOf(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        return this.getKeyOf(eObject, eObject.eClass());
    }

    public String getKeyOf(EObject eObject, EClass eClass) {
        int n = eClass.getClassifierID();
        return switch (n) {
            case 56 -> ((Unary)eObject).getOp();
            case 53 -> ((BinaryOperator)eObject).getOp();
            case 34 -> this.getKeyOfArgumentPair((ArgumentPair)eObject);
            case 61 -> this.getKeyOfParameter((Parameter)eObject);
            case 3 -> "model";
            case 9 -> this.getKeyOfStatement((Statement)eObject);
            case 32 -> this.getKeyOfFacet((Facet)eObject);
            case 60 -> this.getKeyOf(((Function)eObject).getLeft());
            case 63 -> this.getKeyOfTypeRef((TypeRef)eObject);
            case 54 -> "?";
            case 36, 62, 64, 65, 66 -> this.getNameOfRef(eObject, n);
            case 49, 50, 67, 68, 69, 70 -> ((TerminalExpression)eObject).getOp();
            default -> {
                EList var4_4 = eClass.getESuperTypes();
                yield var4_4.isEmpty() ? null : this.getKeyOf(eObject, (EClass)var4_4.get(0));
            }
        };
    }

    public String getKeyOfArgumentPair(ArgumentPair argumentPair) {
        String string = argumentPair.getOp();
        return string.endsWith(":") ? string.substring(0, string.length() - 1) : string;
    }

    private String getKeyOfFacet(Facet facet) {
        String string = facet.getKey();
        return string.endsWith(":") ? string.substring(0, string.length() - 1) : string;
    }

    private String getKeyOfTypeRef(TypeRef typeRef) {
        String string = this.getNameOfRef(typeRef, 63);
        if (string.contains("<") && "species".equals(string = string.split("<")[0])) {
            string = "species_var";
        }
        return string;
    }

    public String getKeyOfParameter(Parameter parameter) {
        String string = this.getKeyOf(parameter.getLeft());
        if (string == null) {
            string = parameter.getBuiltInFacetKey();
        }
        return string.endsWith(":") ? string.substring(0, string.length() - 1) : string;
    }

    private String getKeyOfStatement(Statement statement) {
        S_Definition s_Definition;
        TypeRef typeRef;
        String string = statement.getKey();
        if (string == null && statement instanceof S_Definition && (typeRef = (TypeRef)(s_Definition = (S_Definition)statement).getTkey()) != null) {
            return this.getKeyOfTypeRef(typeRef);
        }
        return string;
    }

    public String getNameOfRef(EObject eObject) {
        return this.getNameOfRef(eObject, eObject.eClass().getClassifierID());
    }

    private String getNameOfRef(EObject eObject, int n) {
        GamlDefinition gamlDefinition;
        Object object = "";
        switch (n) {
            case 62: {
                gamlDefinition = ((UnitName)eObject).getRef();
                if (gamlDefinition == null) break;
                object = gamlDefinition.getName();
                break;
            }
            case 36: {
                gamlDefinition = ((VariableRef)eObject).getRef();
                if (gamlDefinition == null) break;
                if (gamlDefinition instanceof ModelImpl) {
                    object = gamlDefinition.getName() + "_model";
                    break;
                }
                object = gamlDefinition.getName();
                break;
            }
            case 65: {
                gamlDefinition = ((ActionRef)eObject).getRef();
                if (gamlDefinition == null) break;
                object = gamlDefinition.getName();
                break;
            }
            case 64: {
                gamlDefinition = ((SkillRef)eObject).getRef();
                if (gamlDefinition == null) break;
                object = gamlDefinition.getName();
                break;
            }
            case 66: {
                gamlDefinition = ((EquationRef)eObject).getRef();
                if (gamlDefinition == null) break;
                object = gamlDefinition.getName();
                break;
            }
            case 63: {
                gamlDefinition = ((TypeRef)eObject).getRef();
                if (gamlDefinition == null) break;
                object = gamlDefinition.getName();
            }
        }
        if ((object == null || ((String)object).isBlank()) && (gamlDefinition = NodeModelUtils.getNode((EObject)eObject)) != null) {
            object = NodeModelUtils.getTokenText((INode)gamlDefinition);
        }
        return object;
    }

    public GamlFactory getFactory() {
        return (GamlFactory)GamlPackage.eINSTANCE.getEFactoryInstance();
    }

    public String toString(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        if (eObject instanceof Statement) {
            return this.getNameOf(eObject);
        }
        if (eObject instanceof Facet) {
            return ((Facet)eObject).getName();
        }
        if (!(eObject instanceof Expression)) {
            return eObject.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        this.serialize(stringBuilder, (Expression)eObject);
        return stringBuilder.toString();
    }

    private void serialize(StringBuilder stringBuilder, Expression expression) {
        if (expression != null) {
            if (expression instanceof If) {
                stringBuilder.append("(");
                this.serialize(stringBuilder, ((If)expression).getLeft());
                stringBuilder.append(")").append(((If)expression).getOp()).append("(");
                this.serialize(stringBuilder, ((If)expression).getRight());
                stringBuilder.append(")").append(":");
                this.serialize(stringBuilder, ((If)expression).getIfFalse());
            } else if (expression instanceof StringLiteral) {
                stringBuilder.append(((StringLiteral)expression).getOp());
            } else if (expression instanceof TerminalExpression) {
                stringBuilder.append(((TerminalExpression)expression).getOp());
            } else if (expression instanceof Point) {
                stringBuilder.append("{").append("(");
                this.serialize(stringBuilder, ((Point)expression).getLeft());
                stringBuilder.append(")").append(((Point)expression).getOp()).append("(");
                this.serialize(stringBuilder, ((Point)expression).getRight());
                stringBuilder.append(")");
                if (((Point)expression).getZ() != null) {
                    stringBuilder.append(',').append("(");
                    this.serialize(stringBuilder, ((Point)expression).getZ());
                    stringBuilder.append(")");
                }
                stringBuilder.append("}");
            } else if (expression instanceof Array) {
                this.array(stringBuilder, (List<? extends EObject>)((Array)expression).getExprs().getExprs(), false);
            } else if (expression instanceof VariableRef || expression instanceof TypeRef || expression instanceof SkillRef || expression instanceof ActionRef || expression instanceof UnitName) {
                stringBuilder.append(this.getKeyOf(expression));
            } else if (expression instanceof Unary) {
                stringBuilder.append(((Unary)expression).getOp()).append("(");
                this.serialize(stringBuilder, ((Unary)expression).getRight());
                stringBuilder.append(")");
            } else if (expression instanceof Function) {
                this.function(stringBuilder, (Function)expression);
            } else if (expression instanceof Access) {
                Access access = (Access)expression;
                this.serialize(stringBuilder, access.getLeft());
                stringBuilder.append('.');
                this.serialize(stringBuilder, access.getRight());
            }
        }
    }

    private void function(StringBuilder stringBuilder, Function function) {
        List<Expression> list = this.getExprsOf(function.getRight());
        String string = this.getKeyOf(function.getLeft());
        switch (list.size()) {
            case 1: {
                stringBuilder.append(string).append("(");
                this.serialize(stringBuilder, list.get(0));
                stringBuilder.append(")");
                break;
            }
            case 2: {
                stringBuilder.append("(");
                this.serialize(stringBuilder, list.get(0));
                stringBuilder.append(")").append(string).append("(");
                this.serialize(stringBuilder, list.get(1));
                stringBuilder.append(")");
                break;
            }
            default: {
                stringBuilder.append(string);
                stringBuilder.append("(");
                this.array(stringBuilder, list, true);
                stringBuilder.append(")");
            }
        }
    }

    private void array(StringBuilder stringBuilder, List<? extends EObject> list, boolean bl) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Expression expression = (Expression)list.get(n2);
            if (bl) {
                stringBuilder.append("arg").append(n2).append("::");
            }
            this.serialize(stringBuilder, expression);
            if (n2 < n - 1) {
                stringBuilder.append(",");
            }
            ++n2;
        }
    }

    public Statement getStatement(EObject eObject) {
        if (eObject instanceof Statement) {
            return (Statement)eObject;
        }
        if (eObject instanceof TypeRef && eObject.eContainer() instanceof S_Definition && ((S_Definition)eObject.eContainer()).getTkey() == eObject) {
            return (Statement)eObject.eContainer();
        }
        return null;
    }

    public Statement getSurroundingStatement(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        if (eObject instanceof Statement) {
            return (Statement)eObject;
        }
        return this.getSurroundingStatement(eObject.eContainer());
    }

    public boolean isBatch(EObject eObject) {
        block5: {
            block4: {
                if (!(eObject instanceof StatementImpl)) break block4;
                if (!((StatementImpl)eObject).eIsSet(3)) {
                    return false;
                }
                for (Facet facet : ((Statement)eObject).getFacets()) {
                    String string;
                    if (!"type".equals(this.getKeyOf(facet)) || !"batch".equals(string = EGaml.getInstance().getKeyOf(facet.getExpr())) && !"test".equals(string)) continue;
                    return true;
                }
                break block5;
            }
            if (!(eObject instanceof HeadlessExperimentImpl)) break block5;
            if (!((HeadlessExperimentImpl)eObject).eIsSet(4)) {
                return false;
            }
            for (Facet facet : ((HeadlessExperimentImpl)eObject).getFacets()) {
                String string;
                if (!"type".equals(this.getKeyOf(facet)) || !"batch".equals(string = EGaml.getInstance().getKeyOf(facet.getExpr()))) continue;
                return true;
            }
        }
        return false;
    }

    public GamlDefinition createGamlDefinition(String string, EClass eClass) {
        GamlDefinition gamlDefinition = (GamlDefinition)this.getFactory().create(eClass);
        gamlDefinition.setName(string);
        return gamlDefinition;
    }

    public boolean hasImports(EObject eObject) {
        ModelImpl modelImpl;
        return eObject instanceof ModelImpl && !(modelImpl = (ModelImpl)eObject).getImports().isEmpty();
    }
}

