/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler;

import com.google.inject.Binder;
import com.google.inject.name.Names;
import gama.dev.DEBUG;
import gama.gaml.expressions.IExpressionCompiler;
import gaml.compiler.AbstractGamlRuntimeModule;
import gaml.compiler.gaml.expression.GamlExpressionCompiler;
import gaml.compiler.gaml.formatting.GamlFormatter;
import gaml.compiler.gaml.linking.GamlLinkingErrorMessageProvider;
import gaml.compiler.gaml.linking.GamlLinkingService;
import gaml.compiler.gaml.naming.GamlNameConverter;
import gaml.compiler.gaml.naming.GamlQualifiedNameProvider;
import gaml.compiler.gaml.parsing.GamlSyntaxErrorMessageProvider;
import gaml.compiler.gaml.resource.GamlEncodingProvider;
import gaml.compiler.gaml.resource.GamlResource;
import gaml.compiler.gaml.resource.GamlResourceDescriptionManager;
import gaml.compiler.gaml.resource.GamlResourceDescriptionStrategy;
import gaml.compiler.gaml.scoping.BuiltinGlobalScopeProvider;
import gaml.compiler.gaml.validation.ErrorToDiagnoticTranslator;
import gaml.compiler.gaml.validation.GamlResourceValidator;
import java.lang.annotation.Annotation;
import org.eclipse.xtext.formatting.IFormatter;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.parser.antlr.ISyntaxErrorMessageProvider;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.eclipse.xtext.resource.containers.ResourceSetBasedAllContainersStateProvider;
import org.eclipse.xtext.resource.containers.StateBasedContainerManager;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.service.DispatchingProvider;
import org.eclipse.xtext.service.SingletonBinding;
import org.eclipse.xtext.validation.IResourceValidator;

public class GamlRuntimeModule
extends AbstractGamlRuntimeModule {
    static {
        DEBUG.OFF();
    }

    @Override
    public void configure(Binder binder) {
        DEBUG.OUT((Object)"Initialization of GAML XText runtime module begins");
        super.configure(binder);
        binder.bind(IDefaultResourceDescriptionStrategy.class).to(GamlResourceDescriptionStrategy.class);
        binder.bind(IQualifiedNameConverter.class).to(GamlNameConverter.class);
        binder.bind(IResourceValidator.class).to(GamlResourceValidator.class);
        binder.bind(ErrorToDiagnoticTranslator.class);
        DEBUG.OUT((Object)"Initialization of GAML XText runtime module finished");
    }

    @Override
    public Class<? extends IQualifiedNameProvider> bindIQualifiedNameProvider() {
        return GamlQualifiedNameProvider.class;
    }

    public Class<? extends IExpressionCompiler> bindIGamlExpressionCompiler() {
        return GamlExpressionCompiler.class;
    }

    @Override
    @SingletonBinding
    public Class<? extends IGlobalScopeProvider> bindIGlobalScopeProvider() {
        return BuiltinGlobalScopeProvider.class;
    }

    public Class<? extends ISyntaxErrorMessageProvider> bindISyntaxErrorMessageProvider() {
        return GamlSyntaxErrorMessageProvider.class;
    }

    public Class<? extends ILinkingService> bindILinkingService() {
        return GamlLinkingService.class;
    }

    public Class<? extends ILinkingDiagnosticMessageProvider.Extended> bindILinkingDiagnosticMessageProvider() {
        return GamlLinkingErrorMessageProvider.class;
    }

    public Class<? extends XtextResource> bindXtextResource() {
        return GamlResource.class;
    }

    public void configureRuntimeEncodingProvider(Binder binder) {
        binder.bind(IEncodingProvider.class).annotatedWith(DispatchingProvider.Runtime.class).to(GamlEncodingProvider.class);
    }

    @Override
    public Class<? extends IContainer.Manager> bindIContainer$Manager() {
        return StateBasedContainerManager.class;
    }

    @Override
    public Class<? extends IAllContainersState.Provider> bindIAllContainersState$Provider() {
        return ResourceSetBasedAllContainersStateProvider.class;
    }

    @Override
    public void configureIResourceDescriptions(Binder binder) {
        binder.bind(IResourceDescriptions.class).to(ResourceSetBasedResourceDescriptions.class);
    }

    public Class<? extends IResourceDescription.Manager> bindIResourceDescription$Manager() {
        return GamlResourceDescriptionManager.class;
    }

    @Override
    public void configureIResourceDescriptionsPersisted(Binder binder) {
        binder.bind(IResourceDescriptions.class).annotatedWith((Annotation)Names.named((String)"org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS")).to(ResourceSetBasedResourceDescriptions.class);
    }

    public Class<? extends IFormatter> bindIFormatter() {
        return GamlFormatter.class;
    }
}

