/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.scoping;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.impl.SimpleLocalScopeProvider;

public class GamlScopeProvider
extends SimpleLocalScopeProvider {
    protected ISelectable getAllDescriptions(Resource resource) {
        GamlMultimapBasedSelectable gamlMultimapBasedSelectable = new GamlMultimapBasedSelectable();
        IQualifiedNameProvider iQualifiedNameProvider = this.getNameProvider();
        TreeIterator treeIterator = resource.getAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            QualifiedName qualifiedName = (QualifiedName)iQualifiedNameProvider.apply((Object)eObject);
            if (qualifiedName == null) continue;
            gamlMultimapBasedSelectable.add(qualifiedName, new EObjectDescription(qualifiedName, eObject, null));
        }
        return gamlMultimapBasedSelectable;
    }

    private class GamlMultimapBasedSelectable
    implements ISelectable {
        List<IEObjectDescription> descriptions;
        private Multimap<QualifiedName, IEObjectDescription> nameToObjects;

        private GamlMultimapBasedSelectable() {
        }

        public boolean isEmpty() {
            return this.descriptions == null;
        }

        public Iterable<IEObjectDescription> getExportedObjectsByType(EClass eClass) {
            if (this.descriptions == null) {
                return Collections.emptyList();
            }
            return Iterables.filter(this.descriptions, iEObjectDescription -> EcoreUtil2.isAssignableFrom((EClass)eClass, (EClass)iEObjectDescription.getEClass()));
        }

        public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject eObject) {
            if (this.descriptions == null) {
                return Collections.emptyList();
            }
            URI uRI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)eObject);
            return Iterables.filter(this.descriptions, iEObjectDescription -> {
                if (iEObjectDescription.getEObjectOrProxy() == eObject) {
                    return true;
                }
                return uRI.equals(iEObjectDescription.getEObjectURI());
            });
        }

        public Iterable<IEObjectDescription> getExportedObjects(EClass eClass, QualifiedName qualifiedName, boolean bl) {
            if (this.nameToObjects == null) {
                return Collections.emptyList();
            }
            if (this.nameToObjects.containsKey((Object)qualifiedName)) {
                for (IEObjectDescription iEObjectDescription : this.nameToObjects.get((Object)qualifiedName)) {
                    if (!EcoreUtil2.isAssignableFrom((EClass)eClass, (EClass)iEObjectDescription.getEClass())) continue;
                    return Collections.singleton(iEObjectDescription);
                }
            }
            return Collections.emptyList();
        }

        public Iterable<IEObjectDescription> getExportedObjects() {
            return this.descriptions == null ? Collections.EMPTY_LIST : this.descriptions;
        }

        private void add(QualifiedName qualifiedName, EObjectDescription eObjectDescription) {
            if (this.descriptions == null) {
                this.descriptions = new ArrayList<IEObjectDescription>();
                this.nameToObjects = LinkedHashMultimap.create();
            }
            this.descriptions.add((IEObjectDescription)eObjectDescription);
            this.nameToObjects.put((Object)qualifiedName, (Object)eObjectDescription);
        }
    }
}

