/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import gama.annotations.precompiler.GamlProperties;
import gama.core.kernel.model.IModel;
import gama.dev.DEBUG;
import gama.gaml.compilation.GamaCompilationFailedException;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.IGamlModelBuilder;
import gama.gaml.descriptions.ModelDescription;
import gaml.compiler.gaml.resource.GamlResource;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import one.util.streamex.StreamEx;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;

public class GamlModelBuilder
implements IGamlModelBuilder {
    private static GamlModelBuilder defaultInstance = new GamlModelBuilder();
    private final ResourceSet buildResourceSet;

    public static GamlModelBuilder getDefaultInstance() {
        return defaultInstance;
    }

    public GamlModelBuilder(Injector injector) {
        this.buildResourceSet = (ResourceSet)injector.getInstance(ResourceSet.class);
    }

    private GamlModelBuilder() {
        this.buildResourceSet = new SynchronizedXtextResourceSet();
    }

    public IModel compile(URL uRL, List<GamlCompilationError> list) {
        try {
            java.net.URI uRI = new java.net.URI(uRL.getProtocol(), uRL.getPath(), null).normalize();
            URI uRI2 = URI.createURI((String)uRI.toString());
            return this.compile(uRI2, list);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
    }

    public synchronized IModel compile(File file, List<GamlCompilationError> list, GamlProperties gamlProperties) throws IOException, GamaCompilationFailedException {
        if (file == null) {
            throw new IOException("Model file is null");
        }
        String string = file.getAbsolutePath();
        if (!file.exists()) {
            throw new IOException("Model file does not exist: " + string);
        }
        DEBUG.LOG((Object)(string + " model is being compiled..."));
        IModel iModel = GamlModelBuilder.getDefaultInstance().compile(URI.createFileURI((String)string), list);
        if (iModel == null) {
            DEBUG.LOG((Object)("Model didn't compile because of the following compilation errors: \n" + (list == null ? "" : StreamEx.of(list).joining((CharSequence)"\n"))));
            throw new GamaCompilationFailedException(list);
        }
        if (gamlProperties != null) {
            iModel.getDescription().collectMetaInformation(gamlProperties);
        }
        return iModel;
    }

    public IModel compile(URI uRI, List<GamlCompilationError> list) {
        ModelDescription modelDescription = this.buildModelDescription(uRI, list);
        return modelDescription == null ? null : (IModel)modelDescription.compile();
    }

    private ModelDescription buildModelDescription(URI uRI, List<GamlCompilationError> list) {
        try {
            GamlResource gamlResource = (GamlResource)this.buildResourceSet.getResource(uRI, true);
            if (gamlResource.hasErrors()) {
                if (list != null) {
                    String string = gamlResource.getErrors() != null && gamlResource.getErrors().size() > 0 ? ((Resource.Diagnostic)gamlResource.getErrors().get(0)).toString() : "";
                    list.add(new GamlCompilationError("Syntax errors: " + string, "gaml.general.issue", (EObject)gamlResource.getContents().get(0), GamlCompilationError.GamlCompilationErrorType.Error, new String[0]));
                }
                return null;
            }
            ModelDescription modelDescription = gamlResource.buildCompleteDescription();
            if (modelDescription != null) {
                modelDescription.validate();
            }
            if (list != null) {
                Iterables.addAll(list, (Iterable)gamlResource.getValidationContext());
            }
            if (gamlResource.getValidationContext().hasErrors()) {
                return null;
            }
            ModelDescription modelDescription2 = modelDescription;
            return modelDescription2;
        }
        finally {
            boolean bl = this.buildResourceSet.eDeliver();
            try {
                this.buildResourceSet.eSetDeliver(false);
                this.buildResourceSet.getResources().clear();
            }
            finally {
                this.buildResourceSet.eSetDeliver(bl);
            }
        }
    }

    public void loadURLs(List<URL> list) {
        for (URL uRL : list) {
            try {
                java.net.URI uRI = new java.net.URI(uRL.getProtocol(), uRL.getPath(), null).normalize();
                URI uRI2 = URI.createURI((String)uRI.toString());
                this.buildResourceSet.getResource(uRI2, true);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
    }
}

