/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.resource;

import com.google.common.collect.Iterables;
import gama.core.common.interfaces.IDocManager;
import gama.core.runtime.GAMA;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.ValidationContext;
import gaml.compiler.gaml.documentation.GamlResourceDocumenter;
import gaml.compiler.gaml.indexer.GamlResourceIndexer;
import gaml.compiler.gaml.parsing.GamlSyntacticConverter;
import gaml.compiler.gaml.resource.GamlResource;
import gaml.compiler.gaml.validation.IGamlBuilderListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;
import org.eclipse.xtext.resource.XtextResourceSet;

public class GamlResourceServices {
    private static int resourceCount;
    private static GamlResourceDocumenter documenter;
    private static GamlSyntacticConverter converter;
    private static final Map<URI, IGamlBuilderListener> resourceListeners;
    private static final Map<URI, ValidationContext> resourceErrors;
    private static final Map<URI, ISyntacticElement> cachedResourceContents;
    private static volatile XtextResourceSet poolSet;
    private static volatile XtextResourceSet resourceSet;

    static {
        DEBUG.ON();
        resourceCount = 0;
        documenter = new GamlResourceDocumenter();
        converter = new GamlSyntacticConverter();
        resourceListeners = GamaMapFactory.createUnordered();
        resourceErrors = GamaMapFactory.createUnordered();
        cachedResourceContents = GamaMapFactory.concurrentMap();
    }

    public static URI properlyEncodedURI(URI uRI) {
        String string;
        if (uRI == null) {
            return null;
        }
        URI uRI2 = uRI;
        if (GAMA.isInHeadLessMode() && !uRI.isPlatformResource() && (string = uRI.toFileString()) != null) {
            try {
                uRI2 = URI.createFileURI((String)new File(string).getCanonicalPath());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return uRI;
            }
        }
        return URI.createURI((String)uRI2.toString(), (boolean)true);
    }

    public static boolean isEdited(URI uRI) {
        return resourceListeners.containsKey(uRI);
    }

    public static boolean isEdited(Resource resource) {
        return GamlResourceServices.isEdited(resource.getURI());
    }

    public static void updateState(URI uRI, ModelDescription modelDescription, boolean bl, ValidationContext validationContext) {
        URI uRI2 = uRI;
        IGamlBuilderListener iGamlBuilderListener = resourceListeners.get(uRI2);
        if (iGamlBuilderListener == null) {
            return;
        }
        Iterable iterable = modelDescription == null ? (bl ? Collections.EMPTY_SET : null) : Iterables.filter((Iterable)modelDescription.getExperiments(), experimentDescription -> !experimentDescription.isAbstract());
        iGamlBuilderListener.validationEnded(modelDescription, iterable, validationContext);
    }

    public static void addResourceListener(URI uRI, IGamlBuilderListener iGamlBuilderListener) {
        URI uRI2 = uRI;
        resourceListeners.put(uRI2, iGamlBuilderListener);
    }

    public static void removeResourceListener(IGamlBuilderListener iGamlBuilderListener) {
        Iterator<Map.Entry<URI, IGamlBuilderListener>> iterator = resourceListeners.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<URI, IGamlBuilderListener> entry = iterator.next();
            if (entry.getValue() != iGamlBuilderListener) continue;
            GamlResourceServices.getResourceDocumenter().invalidate(entry.getKey());
            ValidationContext validationContext = GamlResourceServices.getValidationContext(entry.getKey());
            if (validationContext != null) {
                validationContext.shouldDocument(false);
            }
            iterator.remove();
            return;
        }
    }

    public static ValidationContext getOrCreateValidationContext(GamlResource gamlResource) {
        URI uRI = gamlResource.getURI();
        if (!resourceErrors.containsKey(uRI)) {
            resourceErrors.put(uRI, new ValidationContext(uRI, gamlResource.hasErrors(), (IDocManager)GamlResourceServices.getResourceDocumenter()));
        }
        ValidationContext validationContext = resourceErrors.get(uRI);
        return validationContext;
    }

    public static ValidationContext getValidationContext(URI uRI) {
        return resourceErrors.get(uRI);
    }

    public static void discardValidationContext(GamlResource gamlResource) {
        resourceErrors.remove(gamlResource.getURI());
    }

    public static IPath getPathOf(Resource resource) {
        URI uRI = resource.getURI();
        Path path = uRI.isPlatform() ? new Path(uRI.toPlatformString(false)) : (uRI.isFile() ? new Path(uRI.toFileString()) : new Path(uRI.path()));
        try {
            path = new Path(URLDecoder.decode(path.toOSString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return path;
    }

    public static String getModelPathOf(Resource resource) {
        if (resource.getURI().isFile()) {
            return new Path(resource.getURI().toFileString()).toOSString();
        }
        IPath iPath = GamlResourceServices.getPathOf(resource);
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
        IPath iPath2 = iFile.getLocation();
        return iPath2 == null ? "" : iPath2.toOSString();
    }

    private static boolean isProject(File file) {
        String[] stringArray = file.list();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (".project".equals(string)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String getProjectPathOf(Resource resource) {
        if (resource == null) {
            return "";
        }
        URI uRI = resource.getURI();
        if (uRI == null) {
            return "";
        }
        if (!uRI.isFile()) {
            IPath iPath = GamlResourceServices.getPathOf(resource);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
            IPath iPath2 = iFile.getProject().getLocation();
            return iPath2 == null ? "" : iPath2.toOSString();
        }
        File file = new File(uRI.toFileString());
        while (file != null && !GamlResourceServices.isProject(file)) {
            file = file.getParentFile();
        }
        return file == null ? "" : file.getAbsolutePath();
    }

    public static GamlResource getTemporaryResource(IDescription iDescription) {
        Object object;
        ModelDescription modelDescription;
        XtextResourceSet xtextResourceSet = null;
        GamlResource gamlResource = null;
        if (iDescription != null && (modelDescription = iDescription.getModelDescription()) != null && (object = modelDescription.getUnderlyingElement()) != null && (gamlResource = (GamlResource)object.eResource()) != null) {
            xtextResourceSet = gamlResource.getResourceSet();
        }
        if (xtextResourceSet == null) {
            xtextResourceSet = GamlResourceServices.getPoolSet();
        }
        modelDescription = URI.createURI((String)("__synthetic__" + resourceCount++ + ".gaml"), (boolean)false);
        object = (GamlResource)xtextResourceSet.createResource((URI)modelDescription);
        IMap iMap = GamaMapFactory.create();
        iMap.put((Object)modelDescription, null);
        if (gamlResource != null) {
            iMap.put((Object)gamlResource.getURI(), null);
            Map<URI, String> map = GamlResourceIndexer.allImportsOf(gamlResource);
            iMap.putAll(map);
        }
        ((GamlResource)((Object)object)).getCache().getOrCreate((Resource)object).set(GamlResourceIndexer.IMPORTED_URIS, (Object)iMap);
        return object;
    }

    public static void discardTemporaryResource(GamlResource gamlResource) {
        try {
            gamlResource.delete(null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static GamlResourceDocumenter getResourceDocumenter() {
        return documenter;
    }

    public static ISyntacticElement buildSyntacticContents(GamlResource gamlResource) {
        return converter.buildSyntacticContents(gamlResource.getParseResult().getRootASTElement(), null);
    }

    private static XtextResourceSet getPoolSet() {
        if (poolSet == null) {
            poolSet = new SynchronizedXtextResourceSet(){
                {
                    this.setClasspathURIContext(GamlResourceServices.class);
                }
            };
        }
        return poolSet;
    }

    static XtextResourceSet getResourceSet() {
        if (resourceSet == null) {
            resourceSet = new SynchronizedXtextResourceSet();
        }
        return resourceSet;
    }

    public static boolean equals(URI uRI, URI uRI2) {
        if (uRI == null) {
            return uRI2 == null;
        }
        if (uRI2 == null) {
            return false;
        }
        return GamlResourceServices.properlyEncodedURI(uRI).equals(GamlResourceServices.properlyEncodedURI(uRI2));
    }

    public static ISyntacticElement getOrCreateSyntacticContents(URI uRI) {
        try {
            ISyntacticElement iSyntacticElement;
            GamlResource gamlResource = (GamlResource)GamlResourceServices.getResourceSet().getResource(uRI, true);
            ISyntacticElement iSyntacticElement2 = iSyntacticElement = GamlResourceServices.buildSyntacticContents(gamlResource);
            return iSyntacticElement2;
        }
        finally {
            GamlResourceServices.clearResourceSet((ResourceSet)GamlResourceServices.getResourceSet());
        }
    }

    public static void invalidateSyntacticContents(URI uRI) {
        ISyntacticElement iSyntacticElement = cachedResourceContents.remove(uRI);
        if (iSyntacticElement != null) {
            iSyntacticElement.dispose();
        }
    }

    protected static void clearResourceSet(ResourceSet resourceSet) {
        boolean bl = resourceSet.eDeliver();
        try {
            try {
                resourceSet.eSetDeliver(false);
                resourceSet.getResources().clear();
            }
            catch (Exception exception) {
                resourceSet.eSetDeliver(bl);
            }
        }
        finally {
            resourceSet.eSetDeliver(bl);
        }
    }
}

