/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.sampling;

import gama.core.kernel.batch.exploration.sampling.SamplingUtils;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;

public class MorrisSampling
extends SamplingUtils {
    public static int DEFAULT_LEVEL = 4;

    public static List<Object> makeMorrisSampling(int n, int n2, List<IParameter.Batch> list, IScope iScope) {
        if (n % 2 != 0) {
            throw GamaRuntimeException.error("The number of value should be even", iScope);
        }
        int n3 = list.size();
        List<Trajectory> list2 = new ArrayList<Trajectory>();
        list2 = MorrisSampling.morrisTrajectories(n3, n, n2, iScope.getRandom().getGenerator(), list2);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        while (n4 < list.size()) {
            arrayList.add(list.get(n4).getName());
            ++n4;
        }
        ArrayList<Map<String, Double>> arrayList2 = new ArrayList<Map<String, Double>>();
        list2.forEach(trajectory -> trajectory.points.forEach(list3 -> {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            IntStream.range(0, n3).forEach(n -> linkedHashMap.put((String)arrayList.get(n), (Double)list3.get(n)));
            arrayList2.add(linkedHashMap);
        }));
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        arrayList3.add(arrayList2);
        arrayList3.add(MorrisSampling.buildParametersSetfromSample(iScope, list, arrayList2));
        return arrayList3;
    }

    public static List<ParametersSet> makeMorrisSamplingOnly(int n, int n2, List<IParameter.Batch> list, IScope iScope) {
        if (n % 2 != 0) {
            throw GamaRuntimeException.error("The number of value should be even", iScope);
        }
        int n3 = list.size();
        List<Trajectory> list2 = new ArrayList<Trajectory>();
        list2 = MorrisSampling.morrisTrajectories(n3, n, n2, iScope.getRandom().getGenerator(), list2);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        while (n4 < list.size()) {
            arrayList.add(list.get(n4).getName());
            ++n4;
        }
        ArrayList<Map<String, Double>> arrayList2 = new ArrayList<Map<String, Double>>();
        list2.forEach(trajectory -> trajectory.points.forEach(list3 -> {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            IntStream.range(0, n3).forEach(n -> linkedHashMap.put((String)arrayList.get(n), (Double)list3.get(n)));
            arrayList2.add(linkedHashMap);
        }));
        return MorrisSampling.buildParametersSetfromSample(iScope, list, arrayList2);
    }

    private static List<Trajectory> morrisTrajectories(int n, int n2, int n3, Random random, List<Trajectory> list) {
        if (n3 == 0) {
            return list;
        }
        list.add(MorrisSampling.generateTraj(n, n2, random));
        return MorrisSampling.morrisTrajectories(n, n2, n3 - 1, random, list);
    }

    private static Trajectory generateTraj(int n, int n2, Random random) {
        double d = (double)n2 / (2.0 * (double)(n2 - 1));
        RealMatrix realMatrix = MatrixUtils.createRealIdentityMatrix((int)n);
        int n3 = realMatrix.getColumnDimension();
        int n4 = realMatrix.getRowDimension();
        RealMatrix realMatrix2 = MatrixUtils.createRealMatrix((int)(n4 + 1), (int)n4);
        MorrisSampling.tril(realMatrix2);
        RealMatrix realMatrix3 = MatrixUtils.createRealMatrix((int)n4, (int)n4);
        MorrisSampling.shuffleRow(realMatrix3);
        RealMatrix realMatrix4 = MorrisSampling.ones(n4 + 1, n4);
        double[][] dArray = new double[n3][n3];
        int n5 = 0;
        while (n5 < n3) {
            dArray[n5][n5] = random.nextBoolean() ? -1 : 1;
            ++n5;
        }
        RealMatrix realMatrix5 = MatrixUtils.createRealMatrix((double[][])dArray);
        double[] dArray2 = MorrisSampling.seed(n3, d, n2, random);
        RealMatrix realMatrix6 = realMatrix.multiply(realMatrix3).transpose();
        RealMatrix realMatrix7 = realMatrix2.scalarMultiply(2.0).multiply(realMatrix6);
        RealMatrix realMatrix8 = realMatrix7.subtract(realMatrix4).multiply(realMatrix5);
        RealMatrix realMatrix9 = realMatrix8.add(realMatrix4).scalarMultiply(d / 2.0);
        RealMatrix realMatrix10 = MorrisSampling.rowise_add(dArray2, realMatrix9);
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>();
        int n6 = 0;
        while (n6 < realMatrix10.getRowDimension()) {
            arrayList.add(Arrays.stream(realMatrix10.getRow(n6)).boxed().collect(Collectors.toList()));
            ++n6;
        }
        return new Trajectory(arrayList);
    }

    private static RealMatrix rowise_add(double[] dArray, RealMatrix realMatrix) {
        int n = 0;
        while (n < realMatrix.getRowDimension()) {
            int n3 = n;
            realMatrix.setRow(n, IntStream.range(0, realMatrix.getColumnDimension()).mapToDouble(n2 -> realMatrix.getEntry(n3, n2) + dArray[n2]).toArray());
            ++n;
        }
        return realMatrix;
    }

    private static double[] seed(int n, double d, int n2, Random random) {
        double[] dArray = new double[n];
        double d2 = 1.0 - d;
        double[] dArray2 = new double[n2 / 2];
        int n3 = 0;
        while (n3 < dArray2.length) {
            dArray2[n3] = (double)n3 * (d2 / (double)(dArray2.length - 1));
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            dArray[n3] = dArray2[random.nextInt(dArray2.length)];
            ++n3;
        }
        return dArray;
    }

    private static RealMatrix ones(int n, int n2) {
        double[][] dArray = new double[n][n2];
        int n3 = 0;
        while (n3 < n) {
            Arrays.fill(dArray[n3], 1.0);
            ++n3;
        }
        return MatrixUtils.createRealMatrix((double[][])dArray);
    }

    private static RealMatrix tril(RealMatrix realMatrix) {
        int n = 1;
        while (n < realMatrix.getRowDimension()) {
            int n2 = 0;
            while (n2 < n) {
                realMatrix.setEntry(n, n2, 1.0);
                ++n2;
            }
            ++n;
        }
        return realMatrix;
    }

    private static RealMatrix shuffleRow(RealMatrix realMatrix) {
        List list = IntStream.range(0, realMatrix.getColumnDimension()).boxed().collect(Collectors.toList());
        Collections.shuffle(list);
        int n = 0;
        while (n < realMatrix.getColumnDimension()) {
            realMatrix.setEntry(((Integer)list.remove(0)).intValue(), n, 1.0);
            ++n;
        }
        return realMatrix;
    }

    public static class Trajectory {
        List<List<Double>> points;

        public Trajectory(List<List<Double>> list) {
            this.points = list;
        }
    }
}

