/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.charts;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.outputs.layers.charts.ChartDataSet;
import gama.core.outputs.layers.charts.ChartDataSourceList;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.doc(value="add a list of series to a chart. The number of series can be dynamic (the size of the list changes each step). See Ant Foraging (Charts) model in ChartTest for examples.")
@GamlAnnotations.inside(symbols={"chart"}, kinds={11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="value", type={5}, optional=false, doc={@GamlAnnotations.doc(value="the values to display. Has to be a matrix, a list or a List of List. Each element can be a number (series/histogram) or a list with two values (XY chart)")}), @GamlAnnotations.facet(name="y_err_values", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the Y Error bar values to display. Has to be a List. Each element can be a number or a list with two values (low and high value)")}), @GamlAnnotations.facet(name="x_err_values", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the X Error bar values to display. Has to be a List. Each element can be a number or a list with two values (low and high value)")}), @GamlAnnotations.facet(name="use_second_y_axis", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Use second y axis for this serie")}), @GamlAnnotations.facet(name="y_minmax_values", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the Y MinMax bar values to display (BW charts). Has to be a List. Each element can be a number or a list with two values (low and high value)")}), @GamlAnnotations.facet(name="marker_size", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the marker sizes to display. Can be a list of numbers (same size for each marker of the series) or a list of list (different sizes by point)")}), @GamlAnnotations.facet(name="legend", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the name of the series: a list of strings (can be a variable with dynamic names)")}), @GamlAnnotations.facet(name="marker", type={3}, optional=true, doc={@GamlAnnotations.doc(value="marker visible or not")}), @GamlAnnotations.facet(name="marker_shape", type={-201}, values={"marker_empty", "marker_square", "marker_circle", "marker_up_triangle", "marker_diamond", "marker_hor_rectangle", "marker_down_triangle", "marker_hor_ellipse", "marker_right_triangle", "marker_vert_rectangle", "marker_left_triangle"}, optional=true, doc={@GamlAnnotations.doc(value="Shape of the marker. Same one for all series.")}), @GamlAnnotations.facet(name="accumulate_values", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Force to replace values at each step (false) or accumulate with previous steps (true)")}), @GamlAnnotations.facet(name="line_visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Line visible or not (same for all series)")}), @GamlAnnotations.facet(name="fill", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Marker filled (true) or not (false), same for all series.")}), @GamlAnnotations.facet(name="color", type={5}, optional=true, doc={@GamlAnnotations.doc(value="list of colors, for heatmaps can be a list of [minColor,maxColor] or [minColor,medColor,maxColor]")}), @GamlAnnotations.facet(name="thickness", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The thickness of the lines to draw")}), @GamlAnnotations.facet(name="style", type={-201}, values={"line", "area", "bar", "dot", "step", "spline", "stack", "3d", "ring", "exploded"}, optional=true, doc={@GamlAnnotations.doc(value="Style for the serie (if not the default one sepecified on chart statement)")})}, omissible="legend")
public class ChartDataListStatement
extends AbstractStatement {
    public ChartDataListStatement(IDescription iDescription) {
        super(iDescription);
    }

    public ChartDataSourceList createDataSource(IScope iScope, ChartDataSet chartDataSet) throws GamaRuntimeException {
        ChartDataSourceList chartDataSourceList = new ChartDataSourceList();
        chartDataSourceList.setDataset(iScope, chartDataSet);
        String string = this.getLiteral("style");
        if (string != null) {
            chartDataSourceList.setStyle(iScope, string);
        }
        IExpression iExpression = this.getFacet("legend").resolveAgainst(iScope);
        chartDataSourceList.setNameExp(iScope, iExpression);
        iExpression = this.getFacet("value").resolveAgainst(iScope);
        chartDataSourceList.setValueExp(iScope, iExpression);
        iExpression = this.getFacet("y_err_values");
        if (iExpression != null) {
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceList.setYErrValueExp(iScope, iExpression);
        }
        if ((iExpression = this.getFacet("x_err_values")) != null) {
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceList.setXErrValueExp(iScope, iExpression);
        }
        if ((iExpression = this.getFacet("y_minmax_values")) != null) {
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceList.setYMinMaxValueExp(iScope, iExpression);
        }
        if ((iExpression = this.getFacet("color")) != null) {
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceList.setColorExp(iScope, iExpression);
        }
        if ((iExpression = this.getFacet("thickness")) != null) {
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceList.setLineThickness(iExpression);
        }
        boolean bl = this.getFacetValue(iScope, "marker", true);
        chartDataSourceList.setMarkerBool(iScope, bl);
        bl = this.getFacetValue(iScope, "use_second_y_axis", false);
        chartDataSourceList.setUseSecondYAxis(iScope, bl);
        bl = this.getFacetValue(iScope, "line_visible", true);
        chartDataSourceList.setShowLine(iScope, bl);
        bl = this.getFacetValue(iScope, "fill", true);
        chartDataSourceList.setFillMarker(iScope, bl);
        string = this.getFacetValue(iScope, "marker_shape", null);
        chartDataSourceList.setMarkerShape(iScope, string);
        Object var7_7 = this.getFacetValue(iScope, "accumulate_values", null);
        if (var7_7 != null) {
            chartDataSourceList.setCumulative(iScope, Cast.asBool(iScope, var7_7));
            chartDataSourceList.setForceCumulative(iScope, true);
        }
        chartDataSourceList.createInitialSeries(iScope);
        iExpression = this.getFacet("marker_size");
        if (iExpression != null) {
            chartDataSourceList.setUseSize(true);
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceList.setMarkerSize(iScope, iExpression);
        }
        return chartDataSourceList;
    }

    @Override
    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        ChartDataSet chartDataSet = (ChartDataSet)iScope.getVarValue("chart_dataset_transfer");
        ChartDataSourceList chartDataSourceList = this.createDataSource(iScope, chartDataSet);
        chartDataSet.addDataSource(chartDataSourceList);
        return chartDataSourceList;
    }
}

