/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.charts;

import gama.core.common.util.FileUtils;
import gama.core.outputs.layers.charts.ChartDataSeries;
import gama.core.outputs.layers.charts.ChartDataSource;
import gama.core.outputs.layers.charts.ChartDataSourceList;
import gama.core.outputs.layers.charts.ChartHistory;
import gama.core.outputs.layers.charts.ChartOutput;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Files;
import gama.gaml.operators.Strings;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ChartDataSet {
    private static String chartFolder;
    final ArrayList<ChartDataSource> sources = new ArrayList();
    final LinkedHashMap<String, ChartDataSeries> series = new LinkedHashMap();
    final LinkedHashMap<String, ChartDataSeries> deletedseries = new LinkedHashMap();
    final ArrayList<String> Xcategories = new ArrayList();
    final ArrayList<Double> XSeriesValues = new ArrayList();
    final ArrayList<String> Ycategories = new ArrayList();
    final ArrayList<Double> YSeriesValues = new ArrayList();
    final LinkedHashMap<String, Integer> serieCreationDate = new LinkedHashMap();
    int commonXindex = -1;
    int commonYindex = -1;
    IExpression xsource;
    IExpression ysource;
    IExpression xlabels;
    IExpression ylabels;
    final LinkedHashMap<String, Integer> serieRemovalDate = new LinkedHashMap();
    final LinkedHashMap<String, Integer> serieToUpdateBefore = new LinkedHashMap();
    ChartOutput mainoutput;
    int resetAllBefore = 0;
    boolean forceResetAll = false;
    String defaultstyle = "default";
    int lastchartcycle = -1;
    boolean forceNoXAccumulate = false;
    boolean forceNoYAccumulate = false;
    boolean useXSource = false;
    boolean useXLabels = false;
    boolean useYLabels = false;
    boolean commonXSeries = false;
    boolean commonYSeries = false;
    boolean byCategory = false;
    final boolean keepHistory;
    final ChartHistory history;
    final boolean isBatchAndPermanent;

    static {
        DEBUG.OFF();
        chartFolder = "charts";
    }

    public int getCommonXIndex() {
        return this.commonXindex;
    }

    public int getCommonYIndex() {
        return this.commonYindex;
    }

    public int getResetAllBefore() {
        return this.resetAllBefore;
    }

    public void setResetAllBefore(int n) {
        this.resetAllBefore = n;
        this.forceResetAll = true;
    }

    public String getCategories(IScope iScope, int n) {
        if (this.Xcategories.size() > n) {
            return this.Xcategories.get(n);
        }
        int n2 = this.Xcategories.size();
        while (n2 <= n) {
            this.Xcategories.add("c" + n2);
            ++n2;
        }
        return this.Xcategories.get(n);
    }

    public String getLastCategories(IScope iScope) {
        if (this.Xcategories.size() > 0) {
            return this.Xcategories.get(this.Xcategories.size() - 1);
        }
        this.Xcategories.add("c0");
        return this.Xcategories.get(this.Xcategories.size() - 1);
    }

    public void setCategories(ArrayList<String> arrayList) {
        this.Xcategories.clear();
        this.Xcategories.addAll(arrayList);
    }

    public ArrayList<Double> getXSeriesValues() {
        return this.XSeriesValues;
    }

    public ArrayList<Double> getYSeriesValues() {
        return this.YSeriesValues;
    }

    public void setXSeriesValues(ArrayList<Double> arrayList) {
        this.XSeriesValues.clear();
        this.XSeriesValues.addAll(arrayList);
    }

    public boolean isByCategory() {
        return this.byCategory;
    }

    public void setByCategory(boolean bl) {
        this.byCategory = bl;
    }

    public boolean isCommonXSeries() {
        return this.commonXSeries;
    }

    public void setCommonXSeries(boolean bl) {
        this.commonXSeries = bl;
    }

    public boolean isCommonYSeries() {
        return this.commonYSeries;
    }

    public void setCommonYSeries(boolean bl) {
        this.commonYSeries = bl;
    }

    public LinkedHashMap<String, Integer> getSerieCreationDate() {
        return this.serieCreationDate;
    }

    public LinkedHashMap<String, Integer> getSerieRemovalDate() {
        return this.serieRemovalDate;
    }

    public ChartDataSet(boolean bl, boolean bl2) {
        this.keepHistory = bl;
        this.isBatchAndPermanent = bl2;
        this.history = bl ? new ChartHistory() : null;
    }

    public boolean keepsHistory() {
        return this.keepHistory;
    }

    public ChartHistory getHistory() {
        return this.history;
    }

    public ChartOutput getOutput() {
        return this.mainoutput;
    }

    public void setOutput(ChartOutput chartOutput) {
        this.mainoutput = chartOutput;
        this.defaultstyle = chartOutput.getStyle();
    }

    public void addNewSerie(String string, ChartDataSeries chartDataSeries, int n) {
        if (this.series.containsKey(string)) {
            this.series.put(string, chartDataSeries);
        } else {
            this.series.put(string, chartDataSeries);
            this.serieCreationDate.put(string, n);
        }
        this.serieToUpdateBefore.put(string, n);
        this.serieRemovalDate.put(string, -1);
    }

    public ArrayList<ChartDataSource> getSources() {
        return this.sources;
    }

    public void addDataSource(ChartDataSource chartDataSource) {
        this.sources.add(chartDataSource);
        LinkedHashMap<String, ChartDataSeries> linkedHashMap = chartDataSource.getSeries();
        for (Map.Entry<String, ChartDataSeries> entry : linkedHashMap.entrySet()) {
            this.addNewSerie(entry.getKey(), entry.getValue(), -1);
        }
    }

    public boolean doResetAll(IScope iScope, int n) {
        if (this.resetAllBefore > n || this.forceResetAll) {
            this.forceResetAll = false;
            return true;
        }
        return false;
    }

    public Set<String> getDataSeriesIds(IScope iScope) {
        return this.series.keySet();
    }

    public ChartDataSeries getDataSeries(IScope iScope, String string) {
        return this.series.get(string);
    }

    public boolean didReload(IScope iScope, int n) {
        DEBUG.OUT((Object)("Asked if did reload with cycle = " + n), (boolean)false);
        if (this.lastchartcycle >= n) {
            DEBUG.OUT((Object)(" TRUE as lastChartCycle = " + this.lastchartcycle));
            this.lastchartcycle = n - 1;
            return true;
        }
        DEBUG.OUT((Object)(" FALSE as lastChartCycle = " + this.lastchartcycle));
        this.lastchartcycle = n;
        return false;
    }

    public void backwardSim(IScope iScope, int n) {
        Object object;
        int n2 = n + 1;
        this.setResetAllBefore(n2);
        ArrayList<ChartDataSource> arrayList = new ArrayList<ChartDataSource>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (ChartDataSource object22 : this.sources) {
            if (!object22.isCumulative() && !object22.isCumulativeY) continue;
            object = object22.getClone(iScope, n2);
            ((ChartDataSource)object).createInitialSeries(iScope);
            arrayList.add(object22);
            arrayList2.add(object);
        }
        for (ChartDataSource chartDataSource : arrayList) {
            object = chartDataSource.getSeries();
            for (Map.Entry entry : ((LinkedHashMap)object).entrySet()) {
                ChartDataSeries chartDataSeries = (ChartDataSeries)entry.getValue();
                if (chartDataSeries.xvalues.size() >= 2) continue;
                this.removeserie(iScope, (String)entry.getKey());
            }
            this.sources.remove(chartDataSource);
        }
        for (ChartDataSource chartDataSource : arrayList2) {
            this.addDataSource(chartDataSource);
        }
        if (this.getXSeriesValues().size() > 0) {
            ArrayList<Double> arrayList3 = this.getXSeriesValues();
            int n3 = 0;
            while (n3 < this.getXSeriesValues().size()) {
                if (arrayList3.get(n3) == (double)(n2 - 1)) {
                    this.commonXindex = n3;
                }
                ++n3;
            }
        }
        if (this.getYSeriesValues().size() > 0) {
            ArrayList<Double> arrayList4 = this.getYSeriesValues();
            int n4 = 0;
            while (n4 < this.getYSeriesValues().size()) {
                if (arrayList4.get(n4) == (double)(n2 - 1)) {
                    this.commonYindex = n4;
                }
                ++n4;
            }
        }
    }

    public void updatedataset(IScope iScope, int n) {
        ++this.commonXindex;
        ++this.commonYindex;
        if (iScope.getExperiment().isRecord() && this.didReload(iScope, n)) {
            this.backwardSim(iScope, n);
        }
        this.updateXValues(iScope, n);
        this.updateYValues(iScope, n);
        if (this.commonXindex >= this.getXSeriesValues().size()) {
            this.commonXindex = this.getXSeriesValues().size() - 1;
        }
        if (this.commonYindex >= this.getYSeriesValues().size()) {
            this.commonYindex = this.getYSeriesValues().size() - 1;
        }
        for (ChartDataSource chartDataSource : this.sources) {
            chartDataSource.updatevalues(iScope, n);
            if (!this.keepHistory) continue;
            chartDataSource.savehistory(iScope, this.history);
        }
        if (this.keepHistory) {
            this.history.append(Strings.LN);
        }
    }

    public void updateYValues(IScope iScope, int n, int n2) {
        int n3 = n2;
        if (this.useYLabels) {
            Object object = this.ylabels.resolveAgainst(iScope).value(iScope);
            if (n3 == -1 && !this.forceNoYAccumulate) {
                n3 = this.YSeriesValues.size() + 1;
            }
            while (this.YSeriesValues.size() < n3) {
                this.YSeriesValues.add(this.getYCycleOrPlusOneForBatch(iScope, n));
                this.Ycategories.add(Cast.asString(iScope, object));
            }
        } else {
            if (n3 == -1 && !this.forceNoYAccumulate && this.commonYindex >= this.YSeriesValues.size()) {
                n3 = this.YSeriesValues.size() + 1;
            }
            while (this.YSeriesValues.size() < n3) {
                double d = this.getYCycleOrPlusOneForBatch(iScope, n);
                if (this.YSeriesValues.size() > 0 && this.YSeriesValues.get(this.YSeriesValues.size() - 1) >= d) {
                    d = this.YSeriesValues.get(this.YSeriesValues.size() - 1) + 1.0;
                }
                this.addCommonYValue(iScope, d);
            }
        }
    }

    public void updateYValues(IScope iScope, int n) {
        this.updateYValues(iScope, n, -1);
    }

    public Double getYCycleOrPlusOneForBatch(IScope iScope, int n) {
        if (this.isBatchAndPermanent && this.YSeriesValues.isEmpty()) {
            return 1.0;
        }
        double d = n;
        if (this.YSeriesValues.size() > 0 && this.YSeriesValues.get(this.YSeriesValues.size() - 1) >= d) {
            d = this.YSeriesValues.get(this.YSeriesValues.size() - 1) + 1.0;
        }
        return d;
    }

    private void addCommonYValue(IScope iScope, Double d) {
        this.YSeriesValues.add(d);
        this.Ycategories.add(String.valueOf(d));
    }

    public double getCurrentCommonYValue() {
        return this.YSeriesValues.get(this.commonYindex);
    }

    public double getCurrentCommonXValue() {
        return this.XSeriesValues.get(this.commonXindex);
    }

    public void updateXValues(IScope iScope, int n, int n2) {
        int n3 = n2;
        if (this.useXSource || this.useXLabels) {
            Object object = this.useXSource ? this.xsource.resolveAgainst(iScope).value(iScope) : this.xlabels.resolveAgainst(iScope).value(iScope);
            Object object2 = this.useXLabels ? this.xlabels.resolveAgainst(iScope).value(iScope) : this.xsource.resolveAgainst(iScope).value(iScope);
            if (object instanceof IList) {
                IList iList = Cast.asList(iScope, object);
                IList iList2 = Cast.asList(iScope, object2);
                if (this.useXSource && iList.size() > 0 && iList.get(0) instanceof Number) {
                    this.XSeriesValues.clear();
                    this.Xcategories.clear();
                    var9_11 = 0;
                    while (var9_11 < iList.size()) {
                        this.XSeriesValues.add(Cast.asFloat(iScope, iList.get(var9_11)));
                        this.Xcategories.add(Cast.asString(iScope, iList2.get(var9_11)));
                        ++var9_11;
                    }
                } else if (iList.size() > this.Xcategories.size()) {
                    this.Xcategories.clear();
                    var9_11 = 0;
                    while (var9_11 < iList.size()) {
                        if (var9_11 >= this.XSeriesValues.size()) {
                            this.XSeriesValues.add(this.getXCycleOrPlusOneForBatch(iScope, n));
                        }
                        this.Xcategories.add(Cast.asString(iScope, iList2.get(var9_11)));
                        ++var9_11;
                    }
                }
                if (iList.size() < n3) {
                    throw GamaRuntimeException.error("The x-serie length (" + iList.size() + ") should NOT be shorter than any series length (" + n3 + ") !", iScope);
                }
            } else {
                if (this.useXSource && object instanceof Number) {
                    double d = Cast.asFloat(iScope, object);
                    String string = Cast.asString(iScope, object2);
                    this.XSeriesValues.add(d);
                    this.Xcategories.add(string);
                }
                if (n3 == -1 && !this.forceNoXAccumulate) {
                    n3 = this.XSeriesValues.size() + 1;
                }
                while (this.XSeriesValues.size() < n3) {
                    this.XSeriesValues.add(this.getXCycleOrPlusOneForBatch(iScope, n));
                    this.Xcategories.add(Cast.asString(iScope, object2));
                }
            }
        }
        if (!this.useXSource && !this.useXLabels) {
            if (n3 == -1 && !this.forceNoXAccumulate && this.commonXindex >= this.XSeriesValues.size()) {
                n3 = this.XSeriesValues.size() + 1;
            }
            while (this.XSeriesValues.size() < n3) {
                double d = this.getXCycleOrPlusOneForBatch(iScope, n);
                if (this.XSeriesValues.size() > 0 && this.XSeriesValues.get(this.XSeriesValues.size() - 1) >= d) {
                    d = this.XSeriesValues.get(this.XSeriesValues.size() - 1) + 1.0;
                }
                this.addCommonXValue(iScope, d);
            }
        }
    }

    public void updateXValues(IScope iScope, int n) {
        this.updateXValues(iScope, n, -1);
    }

    public Double getXCycleOrPlusOneForBatch(IScope iScope, int n) {
        if (this.isBatchAndPermanent && this.XSeriesValues.isEmpty()) {
            return 1.0;
        }
        double d = n;
        if (this.XSeriesValues.size() > 0 && this.XSeriesValues.get(this.XSeriesValues.size() - 1) >= d) {
            d = this.XSeriesValues.get(this.XSeriesValues.size() - 1) + 1.0;
        }
        return d;
    }

    private void addCommonXValue(IScope iScope, Double d) {
        this.XSeriesValues.add(d);
        this.Xcategories.add(String.valueOf(d));
    }

    public int getDate(IScope iScope) {
        return iScope.getClock().getCycle();
    }

    public void setXSource(IScope iScope, IExpression iExpression) {
        this.useXSource = true;
        this.xsource = iExpression;
    }

    public void setXLabels(IScope iScope, IExpression iExpression) {
        this.useXLabels = true;
        this.xlabels = iExpression;
    }

    public void setYLabels(IScope iScope, IExpression iExpression) {
        this.useYLabels = true;
        this.ylabels = iExpression;
    }

    public ChartDataSeries createOrGetSerie(IScope iScope, String string, ChartDataSourceList chartDataSourceList) {
        if (this.series.containsKey(string)) {
            return this.series.get(string);
        }
        if (this.deletedseries.containsKey(string)) {
            ChartDataSeries chartDataSeries = this.deletedseries.get(string);
            this.deletedseries.remove(string);
            this.serieRemovalDate.put(string, -1);
            chartDataSeries.setMysource(chartDataSourceList);
            chartDataSeries.setDataset(this);
            chartDataSeries.setName(string);
            this.addNewSerie(string, chartDataSeries, this.getDate(iScope));
            return chartDataSeries;
        }
        ChartDataSeries chartDataSeries = new ChartDataSeries();
        chartDataSeries.setMysource(chartDataSourceList);
        chartDataSeries.setDataset(this);
        chartDataSeries.setName(string);
        this.addNewSerie(string, chartDataSeries, this.getDate(iScope));
        return chartDataSeries;
    }

    public void removeserie(IScope iScope, String string) {
        ChartDataSeries chartDataSeries = this.getDataSeries(iScope, string);
        if (chartDataSeries != null) {
            this.deletedseries.put(string, chartDataSeries);
            this.series.remove(string);
            this.serieRemovalDate.put(string, this.getDate(iScope));
            this.serieToUpdateBefore.put(string, this.getDate(iScope));
            this.deletedseries.put(string, chartDataSeries);
            this.setResetAllBefore(this.getDate(iScope));
        }
    }

    public String getStyle(IScope iScope) {
        return this.defaultstyle;
    }

    public void setForceNoYAccumulate(boolean bl) {
        this.forceNoYAccumulate = bl;
    }

    public void saveHistory(IScope iScope, String string) {
        if (iScope == null) {
            return;
        }
        if (this.keepHistory) {
            try {
                Files.newFolder(iScope, chartFolder);
                Object object = chartFolder + "/chart_" + string + ".csv";
                object = FileUtils.constructAbsoluteFilePath(iScope, (String)object, false);
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((String)object));){
                    this.history.writeTo(bufferedWriter);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

