/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.GamaFile;
import gama.gaml.statements.Facets;
import gama.gaml.types.IContainerType;
import gama.gaml.types.Types;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

@GamlAnnotations.file(name="property", extensions={"properties"}, buffer_type=10, buffer_content=4, buffer_index=4, concept={"file"}, doc={@GamlAnnotations.doc(value="Represents property files")})
public class GamaPropertyFile
extends GamaFile<IMap<String, String>, String> {
    @GamlAnnotations.doc(value="This file constructor allows to read a property file (.properties)", examples={@GamlAnnotations.example(value="file f <-property_file(\"file.properties\");", isExecutable=false)})
    public GamaPropertyFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    @GamlAnnotations.doc(value="This file constructor allows to store a map in a property file (it does not save it - just store it in memory)", examples={@GamlAnnotations.example(value="file f <-property_file(\"file.properties\", map([\"param1\"::1.0,\"param3\"::10.0 ]));", isExecutable=false)})
    public GamaPropertyFile(IScope iScope, String string, IMap<String, String> iMap) throws GamaRuntimeException {
        super(iScope, string, iMap);
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        Properties properties = new Properties();
        IMap iMap = GamaMapFactory.create(Types.STRING, Types.STRING);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileReader fileReader = new FileReader(this.getFile(iScope));){
                properties.load(fileReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create(iOException, iScope);
        }
        iMap.putAll(properties);
        this.setBuffer(iMap);
    }

    @Override
    public IContainerType<?> getGamlType() {
        return Types.FILE.of(Types.STRING, Types.STRING);
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.EMPTY_LIST;
    }

    @Override
    protected void flushBuffer(IScope iScope, Facets facets2) throws GamaRuntimeException {
        Properties properties = new Properties();
        if (this.getBuffer() != null && !((IMap)this.getBuffer()).isEmpty()) {
            ((IMap)this.getBuffer()).forEach((string, string2) -> properties.setProperty((String)string, (String)string2));
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileWriter fileWriter = new FileWriter(this.getFile(iScope));){
                properties.store(fileWriter, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        return null;
    }
}

