/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph.layout;

import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.IList;
import gama.core.util.graph.IGraph;
import gama.gaml.operators.Maths;
import gama.gaml.operators.spatial.SpatialPunctal;
import java.util.Collections;
import java.util.List;

public class LayoutCircle {
    private final IGraph<IShape, IShape> graph;
    private final IShape envelopeGeometry;

    public LayoutCircle(IGraph<IShape, IShape> iGraph, IShape iShape) {
        this.graph = iGraph;
        this.envelopeGeometry = iShape;
    }

    public void applyLayout(IScope iScope, boolean bl) {
        double d = this.envelopeGeometry.getCentroid().euclidianDistanceTo(SpatialPunctal._closest_point_to(this.envelopeGeometry.getCentroid(), (IShape)this.envelopeGeometry.getExteriorRing(iScope)));
        List<IShape> list = this.minimizeEdgeLength(this.graph, bl);
        int n = 0;
        for (IShape iShape : list) {
            double d2 = (double)(360 * n++) / (double)this.graph.vertexSet().size();
            double d3 = Maths.cos(d2) * d + this.envelopeGeometry.getCentroid().x;
            double d4 = Maths.sin(d2) * d + this.envelopeGeometry.getCentroid().x;
            iShape.setLocation(new GamaPoint(d3, d4));
        }
    }

    private List<IShape> minimizeEdgeLength(IGraph<IShape, IShape> iGraph, boolean bl) {
        IList<IShape> iList = iGraph.getVertices();
        if (bl) {
            Collections.shuffle(iList);
        }
        return iList;
    }
}

