/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation.ast;

import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.statements.Facets;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractSyntacticElement
implements ISyntacticElement {
    private Facets facets;
    private String keyword;
    final EObject element;

    AbstractSyntacticElement(String string, Facets facets2, EObject eObject) {
        this.keyword = string;
        this.facets = facets2;
        this.element = eObject;
    }

    @Override
    public EObject getElement() {
        return this.element;
    }

    public String toString() {
        return this.getKeyword() + " " + this.getName() + " " + (this.facets == null ? "" : this.facets.toString());
    }

    @Override
    public void addChild(ISyntacticElement iSyntacticElement) {
        throw new RuntimeException("No children allowed for " + this.getKeyword());
    }

    @Override
    public void setKeyword(String string) {
        this.keyword = string;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public final boolean hasFacets() {
        return this.facets != null;
    }

    @Override
    public final boolean hasFacet(String string) {
        return this.facets != null && this.facets.containsKey(string);
    }

    @Override
    public final IExpressionDescription getExpressionAt(String string) {
        return this.facets == null ? null : (IExpressionDescription)this.facets.get(string);
    }

    @Override
    public final Facets copyFacets(SymbolProto symbolProto) {
        if (this.facets != null) {
            Facets facets2 = new Facets();
            this.visitFacets((string, iExpressionDescription) -> {
                if (iExpressionDescription != null) {
                    facets2.put((String)string, symbolProto != null && symbolProto.isLabel((String)string) ? iExpressionDescription.cleanCopy().compileAsLabel() : iExpressionDescription.cleanCopy());
                }
                return true;
            });
            return facets2;
        }
        return null;
    }

    @Override
    public void setFacet(String string, IExpressionDescription iExpressionDescription) {
        if (iExpressionDescription == null) {
            return;
        }
        if (this.facets == null) {
            this.facets = new Facets();
        }
        this.facets.put(string, iExpressionDescription);
    }

    @Override
    public String getName() {
        IExpressionDescription iExpressionDescription = this.getExpressionAt("name");
        return iExpressionDescription == null ? null : iExpressionDescription.toString();
    }

    protected void removeFacet(String string) {
        if (this.facets == null) {
            return;
        }
        this.facets.remove(string);
        if (this.facets.isEmpty()) {
            this.facets = null;
        }
    }

    @Override
    public boolean isSpecies() {
        return false;
    }

    @Override
    public boolean isExperiment() {
        return false;
    }

    @Override
    public void computeStats(Map<String, Integer> map) {
        String string = this.getClass().getSimpleName();
        if (!map.containsKey(string)) {
            map.put(string, 1);
        } else {
            map.put(string, map.get(string) + 1);
        }
        this.visitAllChildren(iSyntacticElement -> iSyntacticElement.computeStats(map));
    }

    @Override
    public void visitFacets(IDescription.IFacetVisitor iFacetVisitor) {
        if (this.facets == null) {
            return;
        }
        this.facets.forEachFacet(iFacetVisitor);
    }

    @Override
    public void compact() {
        if (this.facets == null) {
            return;
        }
        if (this.facets.isEmpty()) {
            this.facets.dispose();
            this.facets = null;
        }
    }

    @Override
    public void visitThisAndAllChildrenRecursively(ISyntacticElement.SyntacticVisitor syntacticVisitor) {
        syntacticVisitor.visit(this);
    }

    @Override
    public void visitChildren(ISyntacticElement.SyntacticVisitor syntacticVisitor) {
    }

    @Override
    public void visitSpecies(ISyntacticElement.SyntacticVisitor syntacticVisitor) {
    }

    @Override
    public void visitExperiments(ISyntacticElement.SyntacticVisitor syntacticVisitor) {
    }

    @Override
    public void visitGrids(ISyntacticElement.SyntacticVisitor syntacticVisitor) {
    }

    @Override
    public void visitAllChildren(ISyntacticElement.SyntacticVisitor syntacticVisitor) {
        this.visitGrids(syntacticVisitor);
        this.visitSpecies(syntacticVisitor);
        this.visitChildren(syntacticVisitor);
    }

    @Override
    public void dispose() {
        if (this.facets != null) {
            this.facets.dispose();
        }
    }
}

