/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.base.Function;
import gama.core.common.interfaces.IBenchmarkable;
import gama.core.common.interfaces.IDisposable;
import gama.core.common.interfaces.IKeyword;
import gama.core.common.interfaces.ISkill;
import gama.core.common.interfaces.ITyped;
import gama.core.util.BiConsumerWithPruning;
import gama.core.util.ConsumerWithPruning;
import gama.core.util.ICollector;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.IVarDescriptionProvider;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.descriptions.ValidationContext;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.interfaces.INamed;
import gama.gaml.statements.Facets;
import gama.gaml.types.IType;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public interface IDescription
extends IGamlDescription,
IKeyword,
ITyped,
IDisposable,
IVarDescriptionProvider,
IVarDescriptionUser,
IBenchmarkable {
    public static final SymbolSerializer<SymbolDescription> SYMBOL_SERIALIZER = new SymbolSerializer();
    public static final SymbolSerializer.VarSerializer VAR_SERIALIZER = new SymbolSerializer.VarSerializer();
    public static final SymbolSerializer.SpeciesSerializer SPECIES_SERIALIZER = new SymbolSerializer.SpeciesSerializer();
    public static final SymbolSerializer.ModelSerializer MODEL_SERIALIZER = new SymbolSerializer.ModelSerializer();
    public static final SymbolSerializer.StatementSerializer STATEMENT_SERIALIZER = new SymbolSerializer.StatementSerializer();
    public static final Function<? super IDescription, ? extends String> TO_NAME = INamed::getName;
    public static final Function<TypeDescription, Class<? extends ISkill>> TO_CLASS = TypeDescription::getJavaBase;
    public static final DescriptionVisitor<IDescription> VALIDATING_VISITOR = iDescription -> iDescription.validate() != null;
    public static final DescriptionVisitor<IDescription> DISPOSING_VISITOR = iDescription -> {
        iDescription.dispose();
        return true;
    };

    public void error(String var1);

    public void error(String var1, String var2);

    public void error(String var1, String var2, String var3, String ... var4);

    public void error(String var1, String var2, EObject var3, String ... var4);

    public void warning(String var1, String var2);

    public void warning(String var1, String var2, String var3, String ... var4);

    public void warning(String var1, String var2, EObject var3, String ... var4);

    public String getKeyword();

    public ModelDescription getModelDescription();

    public SpeciesDescription getSpeciesContext();

    public void setEnclosingDescription(IDescription var1);

    public EObject getUnderlyingElement(Object var1, boolean var2);

    default public EObject getUnderlyingElement() {
        return this.getUnderlyingElement(null, false);
    }

    public SymbolProto getMeta();

    public IDescription getEnclosingDescription();

    public IVarDescriptionProvider getDescriptionDeclaringVar(String var1);

    public IDescription getDescriptionDeclaringAction(String var1, boolean var2);

    public Iterable<IDescription> getChildrenWithKeyword(String var1);

    public Iterable<IDescription> getOwnChildren();

    public IDescription getChildWithKeyword(String var1);

    public IType getTypeNamed(String var1);

    public SpeciesDescription getSpeciesDescription(String var1);

    public ActionDescription getAction(String var1);

    public ValidationContext getValidationContext();

    public IDescription copy(IDescription var1);

    public IDescription validate();

    public ISymbol compile();

    public int getKind();

    public boolean isBuiltIn();

    public String getOriginName();

    public void setOriginName(String var1);

    public void setDefiningPlugin(String var1);

    public void info(String var1, String var2, String var3, String ... var4);

    public void info(String var1, String var2, EObject var3, String ... var4);

    public void info(String var1, String var2);

    public void resetOriginName();

    public boolean manipulatesVar(String var1);

    public String getLitteral(String var1);

    public IExpression getFacetExpr(String ... var1);

    public boolean hasFacet(String var1);

    public IExpressionDescription getFacet(String var1);

    public IExpressionDescription getFacet(String ... var1);

    public String firstFacetFoundAmong(String ... var1);

    public void setFacetExprDescription(String var1, IExpressionDescription var2);

    public void setFacet(String var1, IExpression var2);

    public void removeFacets(String ... var1);

    default public boolean visitFacets(IFacetVisitor iFacetVisitor) {
        return this.visitFacets(null, iFacetVisitor);
    }

    @Override
    default public String getNameForBenchmarks() {
        StringBuilder stringBuilder = new StringBuilder();
        this.getSerializer().serializeNoRecursion(stringBuilder, this, false);
        return stringBuilder.toString();
    }

    @Override
    default public void collectUsedVarsOf(SpeciesDescription speciesDescription, ICollector<IVarDescriptionUser> iCollector, ICollector<VariableDescription> iCollector2) {
        if (iCollector.contains(this)) {
            return;
        }
        iCollector.add(this);
        this.visitFacets((string, iExpressionDescription) -> {
            IExpression iExpression = iExpressionDescription.getExpression();
            if (iExpression != null) {
                iExpression.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
            }
            return true;
        });
        this.visitOwnChildren(iDescription -> {
            iDescription.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
            return true;
        });
    }

    public boolean visitFacets(Set<String> var1, IFacetVisitor var2);

    public boolean visitChildren(DescriptionVisitor<IDescription> var1);

    public boolean visitOwnChildrenRecursively(DescriptionVisitor<IDescription> var1);

    public boolean visitOwnChildren(DescriptionVisitor<IDescription> var1);

    public void document(EObject var1, IGamlDescription var2);

    public Facets getFacets();

    public void attachAlternateVarDescriptionProvider(IVarDescriptionProvider var1);

    public void replaceChildrenWith(Iterable<IDescription> var1);

    public SymbolSerializer getSerializer();

    default public boolean isIn(String string) {
        IDescription iDescription = this.getEnclosingDescription();
        if (iDescription == null || iDescription == this) {
            return false;
        }
        if (iDescription.getKeyword().equals(string)) {
            return true;
        }
        return iDescription.isIn(string);
    }

    default public IDescription getParentWithKeyword(String string) {
        IDescription iDescription = this.getEnclosingDescription();
        if (iDescription == null || iDescription == this) {
            return null;
        }
        if (iDescription.getKeyword().equals(string)) {
            return iDescription;
        }
        return iDescription.getParentWithKeyword(string);
    }

    default public boolean isID() {
        return "arg".equals(this.getKeyword()) && "true".equals(this.getLitteral("id"));
    }

    public boolean isInvocation();

    @FunctionalInterface
    public static interface DescriptionVisitor<T extends IDescription>
    extends ConsumerWithPruning<T> {
    }

    public static enum Flag {
        Abstract,
        Validated,
        Synthetic,
        StartingDateDefined,
        IsControl,
        ControlFinalized,
        CanUseMinimalAgents,
        IsInvocation,
        IsSuperInvocation,
        Breakable,
        Continuable,
        BuiltIn,
        Global,
        Unmodifiable,
        Updatable,
        IsParameter,
        isMirror,
        isGrid,
        isContextualType,
        isFunction,
        isMemorize,
        isBatch,
        IsCreate,
        NoTypeInference;

    }

    @FunctionalInterface
    public static interface IFacetVisitor
    extends BiConsumerWithPruning<String, IExpressionDescription> {
    }
}

