/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.metamodel.topology.graph.ISpatialGraph;
import gama.core.metamodel.topology.grid.IGridAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaList;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMap;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph.GraphAlgorithmsHandmade;
import gama.core.util.graph.GraphFromAgentContainerSynchronizer;
import gama.core.util.graph.IGraph;
import gama.core.util.graph.PathComputer;
import gama.core.util.graph.layout.LayoutCircle;
import gama.core.util.graph.layout.LayoutForceDirected;
import gama.core.util.graph.layout.LayoutGrid;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.GamaMatrix;
import gama.core.util.path.GamaSpatialPath;
import gama.core.util.path.IPath;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Containers;
import gama.gaml.operators.spatial.SpatialProperties;
import gama.gaml.operators.spatial.SpatialPunctal;
import gama.gaml.operators.spatial.SpatialRelations;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaGraphType;
import gama.gaml.types.GamaPathType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.ArrayUtils;
import org.jgrapht.Graph;
import org.jgrapht.alg.clique.BronKerboschCliqueFinder;
import org.jgrapht.alg.clustering.GirvanNewmanClustering;
import org.jgrapht.alg.clustering.KSpanningTreeClustering;
import org.jgrapht.alg.clustering.LabelPropagationClustering;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.drawing.FRLayoutAlgorithm2D;
import org.jgrapht.alg.drawing.IndexedFRLayoutAlgorithm2D;
import org.jgrapht.alg.drawing.model.Box2D;
import org.jgrapht.alg.drawing.model.LayoutModel2D;
import org.jgrapht.alg.drawing.model.MapLayoutModel2D;
import org.jgrapht.alg.drawing.model.Point2D;
import org.jgrapht.alg.flow.EdmondsKarpMFImpl;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.alg.interfaces.MaximumFlowAlgorithm;
import org.jgrapht.generate.BarabasiAlbertGraphGenerator;
import org.jgrapht.generate.ComplementGraphGenerator;
import org.jgrapht.generate.GnmRandomGraphGenerator;
import org.jgrapht.generate.WattsStrogatzGraphGenerator;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.Multigraph;
import org.jgrapht.util.SupplierUtil;
import org.locationtech.jts.geom.Coordinate;

public class Graphs {
    @GamlAnnotations.operator(value={"agent_from_geometry"}, type=11, category={"Graphs-related operators", "Path-related operators"}, concept={"graph", "geometry"})
    @GamlAnnotations.doc(value="returns the agent corresponding to given geometry (right-hand operand) in the given path (left-hand operand).", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, returns nil")}, examples={@GamlAnnotations.example(value="geometry line <- one_of(path_followed.segments);", isExecutable=false), @GamlAnnotations.example(value="road ag <- road(path_followed agent_from_geometry line);", isExecutable=false)}, see={"path"})
    public static IAgent getAgentFromGeom(IPath iPath, IShape iShape) {
        if (iPath == null) {
            return null;
        }
        return (IAgent)iPath.getRealObject(iShape);
    }

    @GamlAnnotations.operator(value={"contains_vertex"}, type=3, category={"Graphs-related operators"}, concept={"graph", "node"})
    @GamlAnnotations.doc(value="returns true if the graph(left-hand operand) contains the given vertex (righ-hand operand), false otherwise", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, returns false")}, examples={@GamlAnnotations.example(value="graph graphFromMap<-  as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);"), @GamlAnnotations.example(value="graphFromMap contains_vertex {1,5}", equals="true")}, see={"contains_edge"})
    public static Boolean containsVertex(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("In the contains_vertex operator, the graph should not be null!", iScope);
        }
        if (object instanceof NodeToAdd) {
            return iGraph.containsVertex(((NodeToAdd)object).object);
        }
        return iGraph.containsVertex(object);
    }

    @GamlAnnotations.operator(value={"contains_edge"}, type=3, category={"Graphs-related operators"}, concept={"graph", "edge"})
    @GamlAnnotations.doc(value="returns true if the graph(left-hand operand) contains the given edge (righ-hand operand), false otherwise", masterDoc=true, usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, returns false")}, examples={@GamlAnnotations.example(value="graph graphFromMap <-  as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);"), @GamlAnnotations.example(value="graphFromMap contains_edge link({1,5},{12,45})", equals="true")}, see={"contains_vertex"})
    public static Boolean containsEdge(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("graph is nil", iScope);
        }
        if (object instanceof EdgeToAdd) {
            EdgeToAdd edgeToAdd = (EdgeToAdd)object;
            if (edgeToAdd.object != null) {
                return iGraph.containsEdge(edgeToAdd.object);
            }
            if (edgeToAdd.source != null && edgeToAdd.target != null) {
                return iGraph.containsEdge(edgeToAdd.source, edgeToAdd.target);
            }
        }
        return iGraph.containsEdge(object);
    }

    @GamlAnnotations.operator(value={"contains_edge"}, type=3, category={"Graphs-related operators"}, concept={})
    @GamlAnnotations.doc(value="returns true if the graph(left-hand operand) contains the given edge (righ-hand operand), false otherwise", usages={@GamlAnnotations.usage(value="if the right-hand operand is a pair, returns true if it exists an edge between the two elements of the pair in the graph", examples={@GamlAnnotations.example(value="graphEpidemio contains_edge (node(0)::node(3))", equals="true", isExecutable=false)})})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n(g contains_edge ({10,5}::{20,3})) = true")
    public static Boolean containsEdge(IScope iScope, IGraph iGraph, GamaPair gamaPair) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        return iGraph.containsEdge(gamaPair.first(), gamaPair.last());
    }

    @GamlAnnotations.operator(value={"source_of"}, type=-399, category={"Graphs-related operators"}, concept={"graph", "edge", "node"})
    @GamlAnnotations.doc(value="returns the source of the edge (right-hand operand) contained in the graph given in left-hand operand.", usages={@GamlAnnotations.usage(value="if the lef-hand operand (the graph) is nil, throws an Exception")}, examples={@GamlAnnotations.example(value="graph graphEpidemio <- generate_barabasi_albert( [\"edges_species\"::edge,\"vertices_specy\"::node,\"size\"::3,\"m\"::5] );", isExecutable=false), @GamlAnnotations.example(value="graphEpidemio source_of(edge(3))", equals="node1", isExecutable=false), @GamlAnnotations.example(value="graph graphFromMap <-  as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);"), @GamlAnnotations.example(value="graphFromMap source_of(link({1,5},{12,45}))", returnType="point", equals="{1,5}")}, see={"target_of"})
    public static Object sourceOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        if (iGraph.containsEdge(object)) {
            return iGraph.getEdgeSource(object);
        }
        return null;
    }

    @GamlAnnotations.operator(value={"target_of"}, type=-399, category={"Graphs-related operators"}, concept={"graph", "edge", "node"})
    @GamlAnnotations.doc(value="returns the target of the edge (right-hand operand) contained in the graph given in left-hand operand.", usages={@GamlAnnotations.usage(value="if the lef-hand operand (the graph) is nil, returns nil")}, examples={@GamlAnnotations.example(value="graph graphEpidemio <- generate_barabasi_albert( [\"edges_species\"::edge,\"vertices_specy\"::node,\"size\"::3,\"m\"::5] );", isExecutable=false), @GamlAnnotations.example(value="graphEpidemio source_of(edge(3))", equals="node1", isExecutable=false), @GamlAnnotations.example(value="graph graphFromMap <-  as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);"), @GamlAnnotations.example(value="graphFromMap target_of(link({1,5},{12,45}))", equals="{12,45}")}, see={"source_of"})
    public static Object targetOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        if (iGraph.containsEdge(object)) {
            return iGraph.getEdgeTarget(object);
        }
        return null;
    }

    @GamlAnnotations.operator(value={"weight_of"}, category={"Graphs-related operators"}, concept={"graph", "graph_weight"})
    @GamlAnnotations.doc(value="returns the weight of the given edge (right-hand operand) contained in the graph given in right-hand operand.", comment="In a localized graph, an edge has a weight by default (the distance between both vertices).", usages={@GamlAnnotations.usage(value="if the left-operand (the graph) is nil, returns nil"), @GamlAnnotations.usage(value="if the right-hand operand is not an edge of the given graph, weight_of checks whether it is a node of the graph and tries to return its weight"), @GamlAnnotations.usage(value="if the right-hand operand is neither a node, nor an edge, returns 1.")}, examples={@GamlAnnotations.example(value="graph graphFromMap <-  as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);"), @GamlAnnotations.example(value="graphFromMap weight_of(link({1,5},{12,45}))", equals="1.0")})
    public static Double weightOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        if (object instanceof GraphObjectToAdd) {
            if (object instanceof EdgeToAdd) {
                EdgeToAdd edgeToAdd = (EdgeToAdd)object;
                if (edgeToAdd.object != null) {
                    return iGraph.getEdgeWeight(edgeToAdd.object);
                }
                if (edgeToAdd.source != null && edgeToAdd.target != null) {
                    Object object2 = iGraph.getEdge(edgeToAdd.source, edgeToAdd.target);
                    return iGraph.getEdgeWeight(object2);
                }
            } else if (object instanceof NodeToAdd) {
                return iGraph.getVertexWeight(((NodeToAdd)object).object);
            }
        }
        if (iGraph.containsEdge(object)) {
            return iGraph.getEdgeWeight(object);
        }
        if (iGraph.containsVertex(object)) {
            return iGraph.getVertexWeight(object);
        }
        return 1.0;
    }

    @GamlAnnotations.operator(value={"in_edges_of"}, type=5, content_type=-299, category={"Graphs-related operators"}, concept={"graph", "edge"})
    @GamlAnnotations.doc(value="returns the list of the in-edges of a vertex (right-hand operand) in the graph given as left-hand operand.", examples={@GamlAnnotations.example(value="graph graphFromMap <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="graphFromMap in_edges_of node({12,45})", equals="[LineString]", test=false)}, see={"out_edges_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g2 <- directed(as_edge_graph([ edge({10,5}, {30,30}), edge({30,30}, {80,35}), node ({30,30})]));\r\nfirst(link({10,5},{30,30})) = first(g2 in_edges_of {30,30})")
    public static IList inEdgesOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        if (iGraph.containsVertex(object)) {
            return GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), iGraph.incomingEdgesOf(object));
        }
        return GamaListFactory.create(iGraph.getGamlType().getKeyType());
    }

    @GamlAnnotations.operator(value={"edge_between"}, content_type=-299, category={"Graphs-related operators", "edge"})
    @GamlAnnotations.doc(value="returns the edge linking two nodes", examples={@GamlAnnotations.example(value="graphFromMap edge_between node1::node2", equals="edge1", isExecutable=false)}, see={"out_edges_of", "in_edges_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5}), node ({50,50})]));\r\n(g edge_between ({10,5}::{20,3})) = g.edges[0]")
    public static Object edgeBetween(IScope iScope, IGraph iGraph, GamaPair gamaPair) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        if (iGraph.containsVertex(gamaPair.key) && iGraph.containsVertex(gamaPair.value)) {
            return iGraph.getEdge(gamaPair.key, gamaPair.value);
        }
        return null;
    }

    @GamlAnnotations.operator(value={"in_degree_of"}, type=1, category={"Graphs-related operators"}, concept={"graph", "node"})
    @GamlAnnotations.doc(value="returns the in degree of a vertex (right-hand operand) in the graph given as left-hand operand.", examples={@GamlAnnotations.example(value="graph graphFromMap <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="graphFromMap in_degree_of (node(3))", equals="2", test=false)}, see={"out_degree_of", "degree_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n(g in_degree_of ({20,3})) = 1")
    public static int inDregreeOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        if (iGraph.containsVertex(object)) {
            return iGraph.inDegreeOf(object);
        }
        return 0;
    }

    @GamlAnnotations.operator(value={"out_edges_of"}, type=5, content_type=-299, category={"Graphs-related operators"}, concept={"graph", "node", "edge"})
    @GamlAnnotations.doc(value="returns the list of the out-edges of a vertex (right-hand operand) in the graph given as left-hand operand.", masterDoc=true, examples={@GamlAnnotations.example(value="graph graphFromMap <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="graphFromMap out_edges_of (node(3))", equals="3", test=false)}, see={"in_edges_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n list li <- g out_edges_of {10,5};  length(li) = 2")
    public static IList outEdgesOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        if (iGraph.containsVertex(object)) {
            return GamaListFactory.create(iScope, iGraph.getGamlType().getContentType(), iGraph.outgoingEdgesOf(object));
        }
        return GamaListFactory.create(iGraph.getGamlType().getContentType());
    }

    @GamlAnnotations.operator(value={"out_degree_of"}, type=1, category={"Graphs-related operators"}, concept={"graph", "node", "edge"})
    @GamlAnnotations.doc(value="returns the out degree of a vertex (right-hand operand) in the graph given as left-hand operand.", examples={@GamlAnnotations.example(value="graph graphFromMap <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="graphFromMap out_degree_of (node(3))", equals="4", test=false)}, see={"in_degree_of", "degree_of"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="graph<geometry, geometry> g1 <- directed(as_edge_graph([ edge({10,5}, {30,30}), edge({30,30}, {80,35}), node ({30,30})]));\r\ng1 out_degree_of {30,30} = 1"), @GamlAnnotations.test(value="graph<geometry, geometry> g2 <- directed(as_edge_graph([ edge({30,30}, {10,5}), edge({30,30}, {80,35}), node ({30,30})]));\r\ng2 out_degree_of {30,30} = 2")})
    public static int outDregreeOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        if (iGraph.containsVertex(object)) {
            return iGraph.outDegreeOf(object);
        }
        return 0;
    }

    @GamlAnnotations.operator(value={"degree_of"}, type=1, category={"Graphs-related operators"}, concept={"graph", "node"})
    @GamlAnnotations.doc(value="returns the degree (in+out) of a vertex (right-hand operand) in the graph given as left-hand operand.", examples={@GamlAnnotations.example(value="graph graphFromMap <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="graphFromMap degree_of (node(3))", equals="3", test=false)}, see={"in_degree_of", "out_degree_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n (g degree_of ({10,5})) = 3")
    public static int degreeOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        if (iGraph.containsVertex(object)) {
            return iGraph.degreeOf(object);
        }
        return 0;
    }

    @GamlAnnotations.operator(value={"connected_components_of"}, type=5, content_type=5, category={"Graphs-related operators"}, concept={"graph", "node", "edge"})
    @GamlAnnotations.doc(value="returns the connected components of a graph, i.e. the list of all vertices that are in the maximally connected component together with the specified vertex. ", examples={@GamlAnnotations.example(value="graph my_graph <- graph([]);"), @GamlAnnotations.example(value="connected_components_of (my_graph)", equals="the list of all the components as list", test=false)}, see={"alpha_index", "connectivity_index", "nb_cycles"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n list comp <- connected_components_of(g);  length(comp) = 1")
    public static IList<IList> connectedComponentOf(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        ConnectivityInspector connectivityInspector = new ConnectivityInspector((Graph)iGraph);
        IList<IList> iList = GamaListFactory.create(Types.LIST);
        for (Object e : connectivityInspector.connectedSets()) {
            iList.add(GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), (Set)e));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"connected_components_of"}, type=5, content_type=5, category={"Graphs-related operators"}, concept={"graph", "node", "edge"})
    @GamlAnnotations.doc(value="returns the connected components of a graph, i.e. the list of all edges (if the boolean is true) or vertices (if the boolean is false) that are in the connected components. ", examples={@GamlAnnotations.example(value="graph my_graph2 <- graph([]);"), @GamlAnnotations.example(value="connected_components_of (my_graph2, true)", equals="the list of all the components as list", test=false)}, see={"alpha_index", "connectivity_index", "nb_cycles"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n list comp <- connected_components_of(g, true);  length(comp) = 1")
    public static IList<IList> connectedComponentOf(IScope iScope, IGraph iGraph, boolean bl) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        ConnectivityInspector connectivityInspector = new ConnectivityInspector((Graph)iGraph);
        IList<IList> iList = GamaListFactory.create(Types.LIST);
        for (Object e : connectivityInspector.connectedSets()) {
            if (bl) {
                IList<Object> iList2 = GamaListFactory.create(iScope, iGraph.getGamlType().getContentType(), new Object[0]);
                for (Object e2 : (Set)e) {
                    iList2.addAll(iGraph.edgesOf(e2));
                }
                iList.add(Containers.remove_duplicates(iScope, iList2));
                continue;
            }
            iList.add(GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), (Set)e));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"main_connected_component"}, type=15, category={"Graphs-related operators"}, concept={"graph", "node", "edge"})
    @GamlAnnotations.doc(value="returns the sub-graph corresponding to the main connected components of the graph", examples={@GamlAnnotations.example(value="main_connected_component(my_graph)", isExecutable=false, equals="the sub-graph corresponding to the main connected components of the graph", test=false)}, see={"connected_components_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n length(main_connected_component(g)) = 5")
    public static IGraph reduceToMainconnectedComponentOf(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        IList<IList> iList = Graphs.connectedComponentOf(iScope, iGraph);
        IGraph iGraph2 = (IGraph)iGraph.copy(iScope);
        IList collection = null;
        int n = 0;
        for (IList collection2 : iList) {
            if (collection2.size() <= n) continue;
            n = collection2.size();
            collection = collection2;
        }
        if (collection != null) {
            Set set = iGraph.vertexSet();
            set.removeAll(collection);
            for (Iterator iterator : set) {
                iGraph2.removeVertex(iterator);
            }
        }
        return iGraph2;
    }

    @GamlAnnotations.operator(value={"maximal_cliques_of"}, type=5, content_type=5, category={"Graphs-related operators"}, concept={"graph", "node", "edge"})
    @GamlAnnotations.doc(value="returns the maximal cliques of a graph using the Bron-Kerbosch clique detection algorithm: A clique is maximal if it is impossible to enlarge it by adding another vertex from the graph. Note that a maximal clique is not necessarily the biggest clique in the graph. ", examples={@GamlAnnotations.example(value="graph my_graph <- graph([]);"), @GamlAnnotations.example(value="maximal_cliques_of (my_graph)", equals="the list of all the maximal cliques as list", test=false)}, see={"biggest_cliques_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n maximal_cliques_of(g) = [[{10.0,5.0,0.0},{20.0,3.0,0.0}],[{30.0,30.0,0.0},{10.0,5.0,0.0}],[{20.0,3.0,0.0}],[{30.0,30.0,0.0},{80.0,35.0,0.0}],[{40.0,60.0,0.0},{80.0,35.0,0.0}],[{40.0,60.0,0.0}]]  ")
    public static IList<IList> getMaximalCliques(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        BronKerboschCliqueFinder bronKerboschCliqueFinder = new BronKerboschCliqueFinder((Graph)iGraph);
        IList<IList> iList = GamaListFactory.create(Types.LIST);
        Iterator iterator = bronKerboschCliqueFinder.iterator();
        while (iterator.hasNext()) {
            iList.add(GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), (Set)iterator.next()));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"biggest_cliques_of"}, type=5, content_type=5, category={"Graphs-related operators"}, concept={"graph", "node", "edge"})
    @GamlAnnotations.doc(value="returns the biggest cliques of a graph using the Bron-Kerbosch clique detection algorithm", examples={@GamlAnnotations.example(value="graph my_graph <- graph([]);"), @GamlAnnotations.example(value="biggest_cliques_of (my_graph)", equals="the list of the biggest cliques as list", test=false)}, see={"maximal_cliques_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n biggest_cliques_of(g) = [[{10.0,5.0,0.0},{20.0,3.0,0.0}],[{30.0,30.0,0.0},{10.0,5.0,0.0}],[{30.0,30.0,0.0},{80.0,35.0,0.0}],[{40.0,60.0,0.0},{80.0,35.0,0.0}]]  ")
    public static IList<IList> getBiggestCliques(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        BronKerboschCliqueFinder bronKerboschCliqueFinder = new BronKerboschCliqueFinder((Graph)iGraph);
        IList<IList> iList = GamaListFactory.create(Types.LIST);
        Iterator iterator = bronKerboschCliqueFinder.maximumIterator();
        while (iterator.hasNext()) {
            iList.add(GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), (Set)iterator.next()));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"nb_cycles"}, type=1, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="returns the maximum number of independent cycles in a graph. This number (u) is estimated through the number of nodes (v), links (e) and of sub-graphs (p): u = e - v + p.", examples={@GamlAnnotations.example(value="graph graphEpidemio <- graph([]);"), @GamlAnnotations.example(value="nb_cycles(graphEpidemio)", equals="the number of cycles in the graph", test=false)}, see={"alpha_index", "beta_index", "gamma_index", "connectivity_index"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n nb_cycles(g) = 1 ")
    public static int nbCycles(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        int n = iGraph.vertexSet().size();
        int n2 = Graphs.connectedComponentOf(iScope, iGraph).size();
        int n3 = iGraph.edgeSet().size();
        return n3 - n + n2;
    }

    @GamlAnnotations.operator(value={"alpha_index"}, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="returns the alpha index of the graph (measure of connectivity which evaluates the number of cycles in a graph in comparison with the maximum number of cycles. The higher the alpha index, the more a network is connected: alpha = nb_cycles / (2`*`S-5) - planar graph)", examples={@GamlAnnotations.example(value="graph graphEpidemio <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="alpha_index(graphEpidemio)", equals="the alpha index of the graph", test=false)}, see={"beta_index", "gamma_index", "nb_cycles", "connectivity_index"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n alpha_index(g) = 0.2 ")
    public static double alphaIndex(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        int n = iGraph.vertexSet().size();
        return (double)Graphs.nbCycles(iScope, iGraph) / (2.0 * (double)n - 5.0);
    }

    @GamlAnnotations.operator(value={"beta_index"}, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="returns the beta index of the graph (Measures the level of connectivity in a graph and is expressed by the relationship between the number of links (e) over the number of nodes (v) : beta = e/v.", examples={@GamlAnnotations.example(value="graph graphEpidemio <- graph([]);"), @GamlAnnotations.example(value="beta_index(graphEpidemio)", equals="the beta index of the graph", test=false)}, see={"alpha_index", "gamma_index", "nb_cycles", "connectivity_index"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n beta_index(g) = 1.0 ")
    public static double betaIndex(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        return ((double)iGraph.edgeSet().size() + 0.0) / (double)iGraph.vertexSet().size();
    }

    @GamlAnnotations.operator(value={"gamma_index"}, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="returns the gamma index of the graph (A measure of connectivity that considers the relationship between the number of observed links and the number of possible links: gamma = e/(3 `*` (v - 2)) - for planar graph.", examples={@GamlAnnotations.example(value="graph graphEpidemio <- graph([]);"), @GamlAnnotations.example(value="gamma_index(graphEpidemio)", equals="the gamma index of the graph", test=false)}, see={"alpha_index", "beta_index", "nb_cycles", "connectivity_index"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n gamma_index(g) = 1.0 ")
    public static double gammaIndex(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        return (double)iGraph.edgeSet().size() / (2.0 * (double)iGraph.vertexSet().size() - 5.0);
    }

    @GamlAnnotations.operator(value={"connectivity_index"}, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="returns a simple connectivity index. This number is estimated through the number of nodes (v) and of sub-graphs (p) : IC = (v - p) /(v - 1).", examples={@GamlAnnotations.example(value="graph graphEpidemio <- graph([]);"), @GamlAnnotations.example(value="connectivity_index(graphEpidemio)", equals="the connectivity index of the graph", test=false)}, see={"alpha_index", "beta_index", "gamma_index", "nb_cycles"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n connectivity_index(g) = 1.0 ")
    public static double connectivityIndex(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        int n = iGraph.vertexSet().size();
        int n2 = Graphs.connectedComponentOf(iScope, iGraph).size();
        return (double)(n - n2) / ((double)n - 1.0);
    }

    @GamlAnnotations.operator(value={"betweenness_centrality"}, type=10, content_type=1, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="returns a map containing for each vertex (key), its betweenness centrality (value): number of shortest paths passing through each vertex ", examples={@GamlAnnotations.example(value="graph graphEpidemio <- graph([]);"), @GamlAnnotations.example(value="betweenness_centrality(graphEpidemio)", equals="the betweenness centrality index of the graph", test=false)}, see={})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n betweenness_centrality(g) = [{10.0,5.0,0.0}::5,{20.0,3.0,0.0}::0,{30.0,30.0,0.0}::2,{80.0,35.0,0.0}::4,{40.0,60.0,0.0}::0] ")
    public static IMap betweennessCentrality(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        IMap iMap = GamaMapFactory.create(iGraph.getGamlType().getKeyType(), Types.INT);
        IList iList = Cast.asList(iScope, iGraph.vertexSet());
        for (Object e : iList) {
            iMap.put(e, 0);
        }
        boolean bl = iGraph.isDirected();
        int n = 0;
        while (n < iList.size()) {
            int n2 = bl ? 0 : n + 1;
            while (n2 < iList.size()) {
                IList iList2;
                Object e;
                Object e2 = iList.get(n);
                if (e2 != (e = iList.get(n2)) && (iList2 = iGraph.getPathComputer().computeBestRouteBetween(iScope, e2, e)) != null) {
                    Object object = e2;
                    for (Object e3 : iList2) {
                        Object object2 = iGraph.getEdgeTarget(e3);
                        if (object2 == object) {
                            object2 = iGraph.getEdgeSource(e3);
                        }
                        if (object2 != e && object2 != e2) {
                            iMap.put(object2, (Integer)iMap.get(object2) + 1);
                        }
                        object = object2;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return iMap;
    }

    @GamlAnnotations.operator(value={"edge_betweenness"}, type=10, content_type=1, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="returns a map containing for each edge (key), its betweenness centrality (value): number of shortest paths passing through each edge ", examples={@GamlAnnotations.example(value="graph graphEpidemio <- graph([]);"), @GamlAnnotations.example(value="edge_betweenness(graphEpidemio)", equals="the edge betweenness index of the graph", test=false)}, see={})
    public static IMap edgeBetweenness(IScope iScope, IGraph iGraph) {
        Object object2;
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        IMap iMap = GamaMapFactory.create(iGraph.getGamlType().getContentType(), Types.INT);
        for (Object object2 : iGraph.edgeSet()) {
            iMap.put(object2, 0);
        }
        object2 = Cast.asList(iScope, iGraph.vertexSet());
        boolean bl = iGraph.isDirected();
        int n = 0;
        while (n < object2.size()) {
            int n2 = bl ? 0 : n + 1;
            while (n2 < object2.size()) {
                IList iList;
                Object e;
                Object e2 = object2.get(n);
                if (e2 != (e = object2.get(n2)) && (iList = iGraph.getPathComputer().computeBestRouteBetween(iScope, e2, e)) != null) {
                    for (Object e3 : iList) {
                        iMap.put(e3, (Integer)iMap.get(e3) + 1);
                    }
                }
                ++n2;
            }
            ++n;
        }
        return iMap;
    }

    @GamlAnnotations.operator(value={"neighbors_of"}, type=5, content_type=-399, category={"Graphs-related operators"}, concept={"graph", "node", "neighbors"})
    @GamlAnnotations.doc(value="returns the list of neighbors of the given vertex (right-hand operand) in the given graph (left-hand operand)", examples={@GamlAnnotations.example(value="graphEpidemio neighbors_of (node(3))", equals="[node0,node2]", isExecutable=false), @GamlAnnotations.example(value="graphFromMap neighbors_of node({12,45})", equals="[{1.0,5.0},{34.0,56.0}]", isExecutable=false)}, see={"predecessors_of", "successors_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n(g neighbors_of ({10,5}) sort_by point(each)) = [{20.0,3.0,0.0},{30.0,30.0,0.0},{80.0,35.0,0.0}]")
    public static IList neighborsOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph == null) {
            throw GamaRuntimeException.error("The graph is nil", iScope);
        }
        if (iGraph.containsVertex(object)) {
            return GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), org.jgrapht.Graphs.neighborListOf((Graph)iGraph, (Object)object));
        }
        return GamaListFactory.create(iGraph.getGamlType().getKeyType());
    }

    @GamlAnnotations.operator(value={"predecessors_of"}, type=5, content_type=-399, category={"Graphs-related operators"}, concept={"graph", "node", "neighbors"})
    @GamlAnnotations.doc(value="returns the list of predecessors (i.e. sources of in edges) of the given vertex (right-hand operand) in the given graph (left-hand operand)", examples={@GamlAnnotations.example(value="graph graphEpidemio <- as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);", isTestOnly=true), @GamlAnnotations.example(value="graphEpidemio predecessors_of ({1,5})", equals="[]", test=false), @GamlAnnotations.example(value="graphEpidemio predecessors_of node({34,56})", equals="[{12;45}]", test=false)}, see={"neighbors_of", "successors_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\ng predecessors_of ({10,5}) = [{80.0,35.0,0.0}]")
    public static IList predecessorsOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph.containsVertex(object)) {
            return GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), org.jgrapht.Graphs.predecessorListOf((Graph)iGraph, (Object)object));
        }
        return GamaListFactory.create(iGraph.getGamlType().getKeyType());
    }

    @GamlAnnotations.operator(value={"successors_of"}, content_type=-399, category={"Graphs-related operators"}, concept={"graph", "node", "neighbors"})
    @GamlAnnotations.doc(value="returns the list of successors (i.e. targets of out edges) of the given vertex (right-hand operand) in the given graph (left-hand operand)", examples={@GamlAnnotations.example(value="graph graphEpidemio <- as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);", isTestOnly=true), @GamlAnnotations.example(value="graphEpidemio successors_of ({1,5})", equals="[{12,45}]"), @GamlAnnotations.example(value="graphEpidemio successors_of node({34,56})", equals="[]")}, see={"predecessors_of", "neighbors_of"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\ng successors_of ({10,5}) = [{20.0,3.0,0.0},{30.0,30.0,0.0}]")
    public static IList successorsOf(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph.containsVertex(object)) {
            return GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), org.jgrapht.Graphs.successorListOf((Graph)iGraph, (Object)object));
        }
        return GamaListFactory.create(iGraph.getGamlType().getKeyType());
    }

    @GamlAnnotations.operator(value={"as_edge_graph"}, content_type=-299, index_type=13, category={"Graphs-related operators"}, concept={"graph", "cast", "map", "list", "edge"})
    @GamlAnnotations.doc(value="creates a graph from the list/map of edges given as operand", masterDoc=true, usages={@GamlAnnotations.usage(value="if the operand is a list, the graph will be built with elements of the list as edges", examples={@GamlAnnotations.example(value="as_edge_graph([line([{1,5},{12,45}]),line([{12,45},{34,56}])])", equals="a graph with two edges and three vertices", test=false)})}, see={"as_intersection_graph", "as_distance_graph"})
    @GamlAnnotations.test(value=" graph<geometry,geometry> comp <- as_edge_graph([line([{1,5},{12,45}]),line([{12,45},{34,56}])]);  ( ({1,5} in comp.vertices) and  ({12,45} in comp.vertices) and  ({34,56} in comp.vertices) ) ")
    public static IGraph spatialFromEdges(IScope iScope, IContainer iContainer) {
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(iContainer, true, false, false, null, null, iScope, (IType)Types.GEOMETRY, iContainer.getGamlType().getContentType());
        if (Types.AGENT.equals(iContainer.getGamlType().getContentType())) {
            GraphFromAgentContainerSynchronizer.synchronize(iScope, null, iContainer, gamaSpatialGraph);
        }
        return gamaSpatialGraph;
    }

    @GamlAnnotations.operator(value={"as_intersection_graph"}, content_type=13, index_type=13, category={"Graphs-related operators"}, concept={})
    @GamlAnnotations.doc(value="creates a graph from a list of vertices (left-hand operand). An edge is created between each pair of vertices with an intersection (with a given tolerance).", see={"as_distance_graph", "as_edge_graph"})
    public static IGraph spatialFromVertices(IScope iScope, IContainer iContainer, Double d, ISpecies iSpecies) {
        IType iType = iScope.getType(iSpecies.getName());
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(iContainer, false, false, true, new IntersectionRelation(d), iSpecies, iScope, iContainer.getGamlType().getContentType(), iType);
        if (Types.AGENT.equals(iContainer.getGamlType().getContentType())) {
            GraphFromAgentContainerSynchronizer.synchronize(iScope, iContainer, iSpecies, gamaSpatialGraph);
        }
        return gamaSpatialGraph;
    }

    @GamlAnnotations.operator(value={"as_edge_graph"}, content_type=-299, index_type=13, category={"Graphs-related operators"}, concept={"graph", "cast", "map", "list", "edge"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the operand is a list and a tolerance (max distance in meters to consider that 2 points are the same node) is given, the graph will be built with elements of the list as edges and two edges will be connected by a node if the distance between their extremity (first or last points) are at distance lower or equal to the tolerance", examples={@GamlAnnotations.example(value="as_edge_graph([line([{1,5},{12,45}]),line([{13,45},{34,56}])],1)", equals="a graph with two edges and three vertices", test=false)})}, see={"as_intersection_graph", "as_distance_graph"})
    @GamlAnnotations.test(value=" graph<geometry,geometry> g <- as_edge_graph([line([{1,5},{12,45}]),line([{13,45},{34,56}])],1);  [{1.0,5.0,0.0},{12.0,45.0,0.0},{34.0,56.0,0.0}] = g.vertices  ")
    public static IGraph spatialFromEdges(IScope iScope, IContainer iContainer, Double d) {
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(iContainer, true, false, false, null, null, iScope, Types.GEOMETRY, iContainer.getGamlType().getContentType(), d);
        if (Types.AGENT.equals(iContainer.getGamlType().getContentType())) {
            GraphFromAgentContainerSynchronizer.synchronize(iScope, null, iContainer, gamaSpatialGraph);
        }
        return gamaSpatialGraph;
    }

    @GamlAnnotations.operator(value={"as_edge_graph"}, index_type=-299, category={"Graphs-related operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the operand is a map, the graph will be built by creating edges from pairs of the map", examples={@GamlAnnotations.example(value="as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}])", equals="a graph with these three vertices and two edges", test=false)})})
    @GamlAnnotations.test(value=" graph<geometry,geometry> g <- as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);  length(g.vertices) = 3 and length(g.edges) = 2")
    public static IGraph spatialFromEdges(IScope iScope, IMap iMap) {
        return GamaGraphType.from(iScope, iMap, true);
    }

    @GamlAnnotations.operator(value={"as_edge_graph"}, content_type=-299, index_type=13, category={"Graphs-related operators"}, concept={"graph", "cast", "map", "list", "edge"})
    @GamlAnnotations.doc(value="creates a graph from the first list of edges and the list nodes", masterDoc=false, see={"as_intersection_graph", "as_distance_graph"})
    @GamlAnnotations.test(value="graph<geometry,geometry> comp <- as_edge_graph([line([{1,5},{12,45}]),line([{12,45},{34,56}])], [{1,5},{12,45},{34,56}]); ( ({1,5} in comp.vertices) and  ({12,45} in comp.vertices) and  ({34,56} in comp.vertices) ) ")
    public static IGraph spatialFromEdges(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        return new GamaSpatialGraph(iContainer, iContainer2, iScope);
    }

    @GamlAnnotations.operator(value={"as_intersection_graph"}, content_type=13, index_type=-299, category={"Graphs-related operators"}, concept={"graph", "node", "cast"})
    @GamlAnnotations.doc(value="creates a graph from a list of vertices (left-hand operand). An edge is created between each pair of vertices with an intersection (with a given tolerance).", comment="as_intersection_graph is more efficient for a list of geometries (but less accurate) than as_distance_graph.", examples={@GamlAnnotations.example(value="list(ant) as_intersection_graph 0.5", isExecutable=false)}, see={"as_distance_graph", "as_edge_graph"})
    public static IGraph spatialFromVertices(IScope iScope, IContainer iContainer, Double d) {
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(iContainer, false, false, true, new IntersectionRelation(d), null, iScope, iContainer.getGamlType().getContentType(), (IType)Types.GEOMETRY);
        if (Types.AGENT.equals(iContainer.getGamlType().getContentType())) {
            GraphFromAgentContainerSynchronizer.synchronize(iScope, iContainer, null, gamaSpatialGraph);
        }
        return gamaSpatialGraph;
    }

    public static IGraph spatialLineIntersection(IScope iScope, IContainer iContainer) {
        return new GamaSpatialGraph(iContainer, false, false, false, new IntersectionRelationLineTriangle(true), null, iScope, iContainer.getGamlType().getContentType(), (IType)Types.GEOMETRY);
    }

    public static IGraph spatialLineIntersectionTriangle(IScope iScope, IContainer iContainer) {
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(iScope, iContainer.getGamlType().getContentType(), Types.GEOMETRY);
        for (Object ValueType : iContainer.iterable(iScope)) {
            gamaSpatialGraph.addVertex(ValueType);
        }
        for (Object ValueType : iContainer.iterable(iScope)) {
            Coordinate[] coordinateArray = ((IShape)ValueType).getInnerGeometry().getCoordinates();
            for (Object ValueType2 : iContainer.iterable(iScope)) {
                Coordinate[] coordinateArray2 = ((IShape)ValueType2).getInnerGeometry().getCoordinates();
                if (ValueType == ValueType2 || !Graphs.lineInter(coordinateArray, coordinateArray2)) continue;
                gamaSpatialGraph.addEdge(ValueType, ValueType2);
            }
        }
        return gamaSpatialGraph;
    }

    static boolean lineInter(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            Coordinate coordinate = coordinateArray[n2];
            int n3 = 0;
            while (n3 < 3) {
                Coordinate coordinate2 = coordinateArray2[n3];
                if (coordinate.x == coordinate2.x && coordinate.y == coordinate2.y) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return n == 2;
    }

    @GamlAnnotations.operator(value={"as_distance_graph"}, content_type=13, index_type=-299, category={"Graphs-related operators"}, concept={"graph", "node", "edge", "cast"})
    @GamlAnnotations.doc(value="creates a graph from a list of vertices (left-hand operand). An edge is created between each pair of vertices close enough (less than a distance, right-hand operand).", masterDoc=true, comment="as_distance_graph is more efficient for a list of points than as_intersection_graph.", examples={@GamlAnnotations.example(value="list(ant) as_distance_graph 3.0", isExecutable=false)}, see={"as_intersection_graph", "as_edge_graph"})
    public static IGraph spatialDistanceGraph(IScope iScope, IContainer iContainer, Double d) {
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(iContainer, false, false, true, new DistanceRelation(d), null, iScope, iContainer.getGamlType().getContentType(), (IType)Types.GEOMETRY);
        if (iContainer.getGamlType().getContentType().isAgentType()) {
            GraphFromAgentContainerSynchronizer.synchronize(iScope, iContainer, null, gamaSpatialGraph);
        }
        return gamaSpatialGraph;
    }

    @GamlAnnotations.operator(value={"as_distance_graph"}, content_type=13, index_type=13, category={"Graphs-related operators"}, concept={})
    @GamlAnnotations.doc(value="creates an undirected graph from a list of vertices (left-hand operand). An edge is created between each pair of vertices close enough (less than a distance, right-hand operand).", see={"as_intersection_graph", "as_edge_graph"})
    public static IGraph spatialDistanceGraph(IScope iScope, IContainer iContainer, Double d, ISpecies iSpecies) {
        IType iType = iScope.getType(iSpecies.getName());
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(iContainer, false, false, true, new DistanceRelation(d), iSpecies, iScope, iContainer.getGamlType().getContentType(), iType);
        GraphFromAgentContainerSynchronizer.synchronize(iScope, iContainer, iSpecies, gamaSpatialGraph);
        return gamaSpatialGraph;
    }

    @GamlAnnotations.operator(value={"spatial_graph"}, index_type=-299, category={"Graphs-related operators"}, concept={"graph", "geometry", "point"})
    @GamlAnnotations.doc(value="allows to create a spatial graph from a container of vertices, without trying to wire them. The container can be empty. Emits an error if the contents of the container are not geometries, points or agents", see={"graph"})
    public static IGraph spatial_graph(IScope iScope, IContainer iContainer) {
        return new GamaSpatialGraph(iContainer, false, false, false, null, null, iScope, iContainer.getGamlType().getContentType(), (IType)Types.GEOMETRY);
    }

    @GamlAnnotations.operator(value={"as_spatial_graph"}, index_type=-299, category={"Graphs-related operators"}, concept={"graph", "geometry", "point"})
    @GamlAnnotations.doc(value="Creates a spatial graph out of an arbitrary graph. If the argument is already a spatial graph, returns it unchanged. If it contains geometrical nodes or edges, they are kept unchanged")
    public static ISpatialGraph as_spatial_graph(IScope iScope, IGraph iGraph) {
        if (iGraph instanceof ISpatialGraph) {
            return (ISpatialGraph)iGraph;
        }
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(iScope, Types.GEOMETRY, Types.GEOMETRY);
        IMap iMap = GamaMapFactory.create(Types.NO_TYPE, Types.GEOMETRY);
        IShape iShape = iScope.getSimulation().getGeometry();
        iGraph.vertexSet().forEach(object -> {
            IShape iShape2 = object instanceof IShape ? (IShape)object : SpatialPunctal.any_location_in(iScope, iShape);
            iShape2.setAttribute("value", object);
            iMap.put(object, iShape2);
            gamaSpatialGraph.addVertex(iShape2);
        });
        iGraph.edgeSet().forEach(object -> {
            Object object2 = iGraph.getEdgeSource(object);
            Object object3 = iGraph.getEdgeTarget(object);
            IShape iShape = (IShape)iMap.get(object2);
            IShape iShape2 = (IShape)iMap.get(object3);
            gamaSpatialGraph.addEdge(object instanceof IShape ? Graphs.edge((Object)iShape, (Object)iShape2, object) : Graphs.edge((Object)iShape, iShape2));
        });
        return gamaSpatialGraph;
    }

    @GamlAnnotations.operator(value={"grid_cells_to_graph"}, content_type=13, index_type=-299, category={"Graphs-related operators"}, concept={"graph", "grid", "cast", "neighbors"})
    @GamlAnnotations.doc(value="creates a graph from a list of cells (operand). An edge is created between neighbors.", masterDoc=true, comment="", examples={@GamlAnnotations.example(value="my_cell_graph <- grid_cells_to_graph(cells_list);", isExecutable=false)}, see={})
    public static IGraph gridCellsToGraph(IScope iScope, IContainer iContainer) {
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(iContainer, false, false, false, new GridNeighborsRelation(), null, iScope, iContainer.getGamlType().getContentType(), (IType)Types.GEOMETRY);
        for (Object e : gamaSpatialGraph.edgeSet()) {
            gamaSpatialGraph.setEdgeWeight(e, ((IShape)e).getPerimeter());
        }
        return gamaSpatialGraph;
    }

    @GamlAnnotations.operator(value={"grid_cells_to_graph"}, content_type=13, index_type=13, category={"Graphs-related operators"}, concept={})
    @GamlAnnotations.doc(value="creates a graph from a list of cells (operand). An edge is created between neighbors.", see={"as_intersection_graph", "as_edge_graph"})
    public static IGraph gridCellsToGraph(IScope iScope, IContainer iContainer, ISpecies iSpecies) {
        IType iType = iScope.getType(iSpecies.getName());
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(iContainer, false, false, false, new GridNeighborsRelation(), iSpecies, iScope, iContainer.getGamlType().getContentType(), iType);
        for (Object e : gamaSpatialGraph.edgeSet()) {
            gamaSpatialGraph.setEdgeWeight(e, ((IShape)e).getPerimeter());
        }
        return gamaSpatialGraph;
    }

    @GamlAnnotations.operator(value={"use_cache"}, category={"Graphs-related operators", "Path-related operators"}, concept={"graph", "shortest_path"})
    @GamlAnnotations.doc(value="if the second operand is true, the operand graph will store in a cache all the previously computed shortest path (the cache be cleared if the graph is modified).", comment="WARNING / side effect: this operator modifies the operand and does not create a new graph.", see={"path_between"})
    public static IGraph useCacheForShortestPaths(IGraph iGraph, boolean bl) {
        iGraph.getPathComputer().setSaveComputedShortestPaths(bl);
        return iGraph;
    }

    @GamlAnnotations.operator(value={"directed"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="the operand graph becomes a directed graph.", comment="WARNING / side effect: this operator modifies the operand and does not create a new graph.", see={"undirected"})
    public static IGraph asDirectedGraph(IGraph iGraph) {
        iGraph.getPathComputer().incVersion();
        return GamaGraphType.asDirectedGraph(iGraph);
    }

    @GamlAnnotations.operator(value={"undirected"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph", "shortest_path"})
    @GamlAnnotations.doc(value="the operand graph becomes an undirected graph.", comment="WARNING / side effect: this operator modifies the operand and does not create a new graph.", see={"directed"})
    public static IGraph asUndirectedGraph(IGraph iGraph) {
        iGraph.getPathComputer().incVersion();
        return GamaGraphType.asUndirectedGraph(iGraph);
    }

    @GamlAnnotations.operator(value={"with_weights"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph", "graph_weight"})
    @GamlAnnotations.doc(value="returns the graph (left-hand operand) with weight given in the map (right-hand operand).", masterDoc=true, comment="WARNING / side effect: this operator modifies the operand and does not create a new graph. It also re-initializes the path finder", usages={@GamlAnnotations.usage(value="if the left-hand operand is a map, the map should contains pairs such as: vertex/edge::double", examples={@GamlAnnotations.example(value="graph_from_edges (list(ant) as_map each::one_of (list(ant))) with_weights (list(ant) as_map each::each.food)", isExecutable=false)})})
    public static IGraph withWeights(IScope iScope, IGraph iGraph, IMap iMap) {
        iGraph.setWeights(iMap);
        iGraph.getPathComputer().incVersion();
        if (iGraph instanceof GamaSpatialGraph) {
            GamaSpatialGraph gamaSpatialGraph = (GamaSpatialGraph)iGraph;
            gamaSpatialGraph.getPathComputer().reInitPathFinder();
        }
        return iGraph;
    }

    @GamlAnnotations.operator(value={"with_weights"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the right-hand operand is a list, assigns the n elements of the list to the n first edges. Note that the ordering of edges may change overtime, which can create some problems...")})
    public static IGraph withWeights(IScope iScope, IGraph iGraph, IList iList) {
        IList iList2 = iGraph.getEdges();
        int n = iList2.size();
        if (n != iList.size()) {
            return iGraph;
        }
        int n2 = 0;
        while (n2 < n) {
            iGraph.setEdgeWeight(iList2.get(n2), Cast.asFloat(iScope, iList.get(n2)));
            ++n2;
        }
        iGraph.getPathComputer().incVersion();
        if (iGraph instanceof GamaSpatialGraph) {
            GamaSpatialGraph gamaSpatialGraph = (GamaSpatialGraph)iGraph;
            gamaSpatialGraph.getPathComputer().reInitPathFinder();
        }
        return iGraph;
    }

    @GamlAnnotations.operator(value={"with_k_shortest_path_algorithm"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph", "shortest_path", "graph_weight", "optimization", "algorithm"})
    @GamlAnnotations.doc(value="changes the K shortest paths computation algorithm of the given graph", comment="the right-hand operand can be #Yen and #Bhandari to use the associated algorithm. ", examples={@GamlAnnotations.example(value="the_graph <- the_graph with_k_shortest_path_algorithm #Yen;", isExecutable=false)})
    public static IGraph setKShortestPathAlgorithm(IScope iScope, IGraph iGraph, String string) {
        List<String> list = Arrays.asList(PathComputer.KShortestPathAlgorithmEnum.values()).stream().map(Enum::toString).toList();
        if (!list.contains(string)) {
            throw GamaRuntimeException.error("The K shortest paths algorithm " + string + " does not exist. Possible K shortest paths algorithms: " + String.valueOf(list), iScope);
        }
        iGraph.getPathComputer().setKShortestPathAlgorithm(string);
        return iGraph;
    }

    @GamlAnnotations.operator(value={"with_shortest_path_algorithm"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph", "shortest_path", "graph_weight", "optimization", "algorithm"})
    @GamlAnnotations.doc(value="changes the shortest path computation algorithm of the given graph", comment="the right-hand operand can be #Djikstra, #BidirectionalDijkstra, #BellmannFord, #FloydWarshall, #Astar, #NBAStar, #NBAStarApprox, #DeltaStepping, #CHBidirectionalDijkstra, #TransitNodeRouting to use the associated algorithm. ", examples={@GamlAnnotations.example(value="road_network <- road_network with_shortestpath_algorithm #TransitNodeRouting;", isExecutable=false)})
    public static IGraph setShortestPathAlgorithm(IScope iScope, IGraph iGraph, String string) {
        List<String> list = Arrays.asList(PathComputer.ShortestPathAlgorithmEnum.values()).stream().map(Enum::toString).toList();
        if (!list.contains(string)) {
            throw GamaRuntimeException.error("The shortest path algorithm " + string + " does not exist. Possible shortest path algorithms: " + String.valueOf(list), iScope);
        }
        iGraph.getPathComputer().setShortestPathAlgorithm(string);
        return iGraph;
    }

    @GamlAnnotations.operator(value={"add_node"}, type=15, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph", "node"})
    @GamlAnnotations.doc(comment="WARNING / side effect: this operator modifies the operand and does not create a new graph", value="adds a node in a graph.", examples={@GamlAnnotations.example(value="graph add_node node(0)", equals="the graph, to which node(0) has been added", isExecutable=false)}, see={"add_edge", "graph"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\ng <- g add_node {10,40} ; length(g.vertices) = 6")
    public static IGraph addNode(IGraph iGraph, IShape iShape) {
        iGraph.addVertex(iShape);
        return iGraph;
    }

    @GamlAnnotations.operator(value={"remove_node_from"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph", "node"})
    @GamlAnnotations.doc(comment="WARNING / side effect: this operator modifies the operand and does not create a new graph. All the edges containing this node are also removed.", value="removes a node from a graph.", examples={@GamlAnnotations.example(value="node(0) remove_node_from graphEpidemio", equals="the graph without node(0)", isExecutable=false)})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\ng <- geometry({10,5}) remove_node_from g;  length(g.vertices) = 4 and length(g.edges) = 2")
    public static IGraph removeNodeFrom(IShape iShape, IGraph iGraph) {
        iGraph.removeVertex(iShape);
        return iGraph;
    }

    @GamlAnnotations.operator(value={"rewire_n"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph", "edge"})
    @GamlAnnotations.doc(comment="WARNING / side effect: this operator modifies the operand and does not create a new graph. If there are too many edges, all the edges will be rewired.", value="rewires the given count of edges.", examples={@GamlAnnotations.example(value="graph graphEpidemio <- as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);", isTestOnly=true), @GamlAnnotations.example(value="graphEpidemio rewire_n 10", equals="the graph with 3 edges rewired", test=false)})
    public static IGraph rewireGraph(IScope iScope, IGraph iGraph, Integer n) {
        GraphAlgorithmsHandmade.rewireGraphCount(iScope, iGraph, n);
        iGraph.getPathComputer().incVersion();
        return iGraph;
    }

    @GamlAnnotations.operator(value={"add_edge"}, type=15, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph", "edge"})
    @GamlAnnotations.doc(comment="WARNING / side effect: this operator modifies the operand and does not create a new graph. If the edge already exists, the graph is unchanged", value="add an edge between a source vertex and a target vertex (resp. the left and the right element of the pair operand)", examples={@GamlAnnotations.example(value="graph <- graph add_edge (source::target);", isExecutable=false)}, see={"add_node", "graph"})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\ng <- g add_edge ({40,60}::{50,50});  length(g.edges) = 6")
    public static IGraph addEdge(IGraph iGraph, GamaPair gamaPair) {
        iGraph.addEdge(gamaPair.first(), gamaPair.last());
        iGraph.getPathComputer().incVersion();
        return iGraph;
    }

    @GamlAnnotations.operator(value={"path_between"}, content_type=-299, category={"Graphs-related operators", "Path-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="The shortest path between a list of two objects in a graph", masterDoc=true, examples={@GamlAnnotations.example(value="path_between (my_graph, ag1, ag2)", equals="A path between ag1 and ag2", isExecutable=false)})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([edge({10,5}, {20,3}), edge({10,5}, {30,30}),edge({30,30}, {80,35}),edge({80,35}, {40,60}),edge({80,35}, {10,5})]));\r\n length((path_between (g, {10,5}, {50,50}))) = 1 ")
    public static IPath path_between(IScope iScope, IGraph iGraph, Object object, Object object2) throws GamaRuntimeException {
        if (iGraph instanceof GamaSpatialGraph) {
            return Cast.asTopology(iScope, iGraph).pathBetween(iScope, (IShape)object, (IShape)object2);
        }
        return iGraph.getPathComputer().computeShortestPathBetween(iScope, object, object2);
    }

    @GamlAnnotations.operator(value={"paths_between"}, type=5, content_type=-299, category={"Graphs-related operators", "Path-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="The K shortest paths between a list of two objects in a graph", examples={@GamlAnnotations.example(value="paths_between(my_graph, ag1:: ag2, 2)", equals="the 2 shortest paths (ordered by length) between ag1 and ag2", isExecutable=false)})
    @GamlAnnotations.test(value="graph<geometry, geometry> g <- directed(as_edge_graph([\n\t\t\t\t\t\t\tedge({10,5}, {20,3}),\n\t\t\t\t\t\t\tedge({10,5}, {30,30}),\n\t\t\t\t\t\t\tedge({30,30}, {80,35}),\n\t\t\t\t\t\t\tedge({80,35}, {40,60}),\n\t\t\t\t\t\t\tedge({80,35}, {10,5}),\n\t\t\t\t\t\t\tedge({10,5}, {80,35}),\n\t\t\t\t\t\t\tedge({30,30}, {85,25}),\n\t\t\t\t\t\t\tedge({85,35}, {80,35})\n\t\t\t\t\t\t\t]));\n   length((paths_between(g, {10,5}:: {80,35}, 2))) = 2\n\n")
    public static IList<GamaSpatialPath> kPathsBetween(IScope iScope, GamaGraph gamaGraph, GamaPair gamaPair, int n) throws GamaRuntimeException {
        return Cast.asTopology(iScope, gamaGraph).kPathsBetween(iScope, (IShape)gamaPair.key, (IShape)gamaPair.value, n);
    }

    @GamlAnnotations.operator(value={"max_flow_between"}, type=5, content_type=-299, category={"Graphs-related operators", "Path-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="The max flow (map<edge,flow> in a graph between the source and the sink using Edmonds-Karp algorithm", examples={@GamlAnnotations.example(value="max_flow_between(my_graph, vertice1, vertice2)", isExecutable=false)})
    public static IMap<Object, Double> maxFlowBetween(IScope iScope, GamaGraph gamaGraph, Object object, Object object2) throws GamaRuntimeException {
        EdmondsKarpMFImpl edmondsKarpMFImpl = new EdmondsKarpMFImpl((Graph)gamaGraph);
        MaximumFlowAlgorithm.MaximumFlow maximumFlow = edmondsKarpMFImpl.getMaximumFlow(object, object2);
        IMap iMap = GamaMapFactory.create();
        iMap.putAll(maximumFlow.getFlowMap());
        return iMap;
    }

    @GamlAnnotations.operator(value={"as_path"}, type=17, content_type=-299, category={"Graphs-related operators", "Path-related operators"}, concept={"graph", "cast"})
    @GamlAnnotations.doc(value="create a graph path from the list of shape", examples={@GamlAnnotations.example(value="[road1,road2,road3] as_path my_graph", equals="a path road1->road2->road3 of my_graph", isExecutable=false)})
    public static IPath as_path(IScope iScope, IList<IShape> iList, GamaGraph gamaGraph) throws GamaRuntimeException {
        IPath iPath = GamaPathType.staticCast(iScope, iList, null, false);
        iPath.setGraph(gamaGraph);
        return iPath;
    }

    @GamlAnnotations.operator(value={"load_shortest_paths"}, content_type=-299, index_type=-399, category={"Graphs-related operators", "Path-related operators"}, concept={"graph", "shortest_path"})
    @GamlAnnotations.doc(value="put in the graph cache the computed shortest paths contained in the matrix (rows: source, columns: target)", examples={@GamlAnnotations.example(value="load_shortest_paths(shortest_paths_matrix)", equals="return my_graph with all the shortest paths computed", isExecutable=false)})
    public static IGraph primShortestPathFile(IScope iScope, GamaGraph gamaGraph, GamaMatrix gamaMatrix) throws GamaRuntimeException {
        if (gamaGraph == null) {
            throw GamaRuntimeException.error("In the load_shortest_paths operator, the graph should not be null!", iScope);
        }
        gamaGraph.getPathComputer().loadShortestPaths(iScope, gamaMatrix);
        return gamaGraph;
    }

    @GamlAnnotations.operator(value={"all_pairs_shortest_path"}, type=8, content_type=1, category={"Graphs-related operators", "Path-related operators"}, concept={"graph", "shortest_path"})
    @GamlAnnotations.doc(value="returns the successor matrix of shortest paths between all node pairs (rows: source, columns: target): a cell (i,j) will thus contains the next node in the shortest path between i and j.", examples={@GamlAnnotations.example(value="all_pairs_shortest_paths(my_graph)", equals="shortest_paths_matrix will contain all pairs of shortest paths", isExecutable=false)})
    public static GamaIntMatrix primAllPairShortestPaths(IScope iScope, GamaGraph gamaGraph) throws GamaRuntimeException {
        if (gamaGraph == null) {
            throw GamaRuntimeException.error("In the all_pairs_shortest_paths operator, the graph should not be null!", iScope);
        }
        return gamaGraph.getPathComputer().saveShortestPaths(iScope);
    }

    @GamlAnnotations.operator(value={"layout_force"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="layouts a GAMA graph using Force model (in a given spatial  bound and given coeff_force, cooling_rate, max_iteration, and equilibirum criterion parameters). ", masterDoc=true, special_cases={"usage: layoutForce(graph, bounds, coeff_force, cooling_rate, max_iteration, equilibirum criterion). graph is the graph to which applied the layout;  bounds is the shape (geometry) in which the graph should be located; coeff_force is the coefficien use to compute the force, typical value is 0.4; cooling rate is the decreasing coefficient of the temperature, typical value is 0.01;  max_iteration is the maximal number of iterations; equilibirum criterion is the maximaldistance of displacement for a vertice to be considered as in equilibrium"})
    public static IGraph layoutForce(IScope iScope, GamaGraph gamaGraph, IShape iShape, double d, double d2, int n, double d3) {
        LayoutForceDirected layoutForceDirected = new LayoutForceDirected(gamaGraph, iShape, d, d2, n, true, d3);
        layoutForceDirected.startSimulation(iScope);
        return gamaGraph;
    }

    @GamlAnnotations.operator(value={"layout_force_FR"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="layouts a GAMA graph using Fruchterman and Reingold Force-Directed Placement Algorithm (in a given spatial bound, normalization factor and max_iteration parameters). ", masterDoc=true, special_cases={"usage: layoutForce(graph, bounds, normalization_factor, max_iteration, equilibirum criterion). graph is the graph to which applied the layout;  bounds is the shape (geometry) in which the graph should be located; normalization_factor is the normalization factor for the optimal distance, typical value is 1.0;   max_iteration is the maximal number of iterations"})
    public static IGraph layoutForceFR(IScope iScope, GamaGraph gamaGraph, IShape iShape, double d, int n) {
        FRLayoutAlgorithm2D fRLayoutAlgorithm2D = new FRLayoutAlgorithm2D(n, d, iScope.getSimulation().getRandomGenerator().getGenerator());
        LayoutModel2D layoutModel2D = Graphs.toModel(gamaGraph, iShape);
        fRLayoutAlgorithm2D.layout((Graph)gamaGraph, layoutModel2D);
        return Graphs.update_loc(gamaGraph, layoutModel2D);
    }

    @GamlAnnotations.operator(value={"layout_force_FR_indexed"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="layouts a GAMA graph using Fruchterman and Reingold Force-Directed Placement Algorithm with The Barnes-Hut indexing technique(in a given spatial bound, theta, normalization factor and max_iteration parameters). ", masterDoc=true, special_cases={"usage: layoutForce(graph, bounds, normalization_factor, max_iteration, equilibirum criterion). graph is the graph to which applied the layout;  bounds is the shape (geometry) in which the graph should be located; theta value for approximation using the Barnes-Hut technique, typical value is 0.5; normalization_factor is the normalization factor for the optimal distance, typical value is 1.0;   max_iteration is the maximal number of iterations"})
    public static IGraph indexedFRLayout(IScope iScope, GamaGraph gamaGraph, IShape iShape, double d, double d2, int n) {
        IndexedFRLayoutAlgorithm2D indexedFRLayoutAlgorithm2D = new IndexedFRLayoutAlgorithm2D(n, d, d2, iScope.getSimulation().getRandomGenerator().getGenerator());
        LayoutModel2D layoutModel2D = Graphs.toModel(gamaGraph, iShape);
        indexedFRLayoutAlgorithm2D.layout((Graph)gamaGraph, layoutModel2D);
        return Graphs.update_loc(gamaGraph, layoutModel2D);
    }

    static IGraph update_loc(IGraph iGraph, LayoutModel2D layoutModel2D) {
        for (Object e : iGraph.vertexSet()) {
            if (!(e instanceof IShape)) continue;
            Point2D point2D = layoutModel2D.get(e);
            ((IShape)e).setLocation(new GamaPoint(point2D.getX(), point2D.getY()));
        }
        return iGraph;
    }

    static LayoutModel2D toModel(GamaGraph gamaGraph, IShape iShape) {
        Envelope3D envelope3D = iShape.getEnvelope();
        MapLayoutModel2D mapLayoutModel2D = new MapLayoutModel2D(new Box2D(envelope3D.getMinY(), envelope3D.getMinY(), envelope3D.getWidth(), envelope3D.getHeight()));
        for (Object e : gamaGraph.vertexSet()) {
            if (!(e instanceof IShape)) continue;
            mapLayoutModel2D.put(e, new Point2D(((IShape)e).getLocation().getX(), ((IShape)e).getLocation().getY()));
        }
        return mapLayoutModel2D;
    }

    @GamlAnnotations.operator(value={"layout_force"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="layouts a GAMA graph using Force model (in a given spatial  bound and given coeff_force, cooling_rate, and max_iteration parameters).", special_cases={"usage: layoutForce(graph, bounds, coeff_force, cooling_rate, max_iteration). graph is the graph to which applied the layout;  bounds is the shape (geometry) in which the graph should be located; coeff_force is the coefficient used to compute the force, typical value is 0.4; cooling rate is the decreasing coefficient of the temperature, typical value is 0.01;  max_iteration is the maximal number of iterationsdistance of displacement for a vertice to be considered as in equilibrium"})
    public static IGraph layoutForce(IScope iScope, GamaGraph gamaGraph, IShape iShape, double d, double d2, int n) {
        LayoutForceDirected layoutForceDirected = new LayoutForceDirected(gamaGraph, iShape, d, d2, n, false, 0.0);
        layoutForceDirected.startSimulation(iScope);
        return gamaGraph;
    }

    @GamlAnnotations.operator(value={"layout_circle"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="layouts a Gama graph on a circle with equidistance between nodes. For now there is no optimization on node ordering.", special_cases={"Usage: layoutCircle(graph, bound, shuffle) => graph : the graph to layout, bound : the geometry to display the graph within, shuffle : if true shuffle the nodes, then render same ordering"}, examples={@GamlAnnotations.example(value="layout_circle(graph, world.shape, false);", isExecutable=false)})
    public static IGraph layoutCircle(IScope iScope, GamaGraph gamaGraph, IShape iShape, boolean bl) {
        LayoutCircle layoutCircle = new LayoutCircle(gamaGraph, iShape);
        layoutCircle.applyLayout(iScope, bl);
        return gamaGraph;
    }

    @GamlAnnotations.operator(value={"layout_grid"}, content_type=-299, index_type=-399, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.doc(value="layouts a Gama graph based on a grid latice. usage: layoutForce(graph, bounds, coeff_nb_cells). graph is the graph to which\tthe layout is applied;  bounds is the shape (geometry) in which the graph should be located; coeff_nb_cellsthe coefficient for the number of cells to locate the vertices (nb of places = coeff_nb_cells * nb of vertices). ", examples={@GamlAnnotations.example(value="layout_grid(graph, world.shape);", isExecutable=false)})
    public static IGraph layoutGrid(IScope iScope, GamaGraph gamaGraph, IShape iShape, double d) {
        LayoutGrid layoutGrid = new LayoutGrid(gamaGraph, iShape, Math.max(1.0, d));
        layoutGrid.applyLayout(iScope);
        return gamaGraph;
    }

    @GamlAnnotations.operator(value={"adjacency"}, category={"Graphs-related operators"}, concept={})
    @GamlAnnotations.doc(value="adjacency matrix of the given graph.")
    public static GamaFloatMatrix adjacencyMatrix(IScope iScope, GamaGraph gamaGraph) {
        return gamaGraph.toMatrix(iScope);
    }

    @GamlAnnotations.operator(value={"strahler"}, content_type=-299, category={"Graphs-related operators", "edge"})
    @GamlAnnotations.doc(value="retur for each edge, its strahler number")
    public static IMap strahlerNumber(IScope iScope, GamaGraph gamaGraph) {
        IGraph iGraph;
        IMap iMap = GamaMapFactory.create(Types.NO_TYPE, Types.INT);
        if (gamaGraph == null || gamaGraph.isEmpty(iScope)) {
            return iMap;
        }
        IGraph iGraph2 = iGraph = gamaGraph.getConnected() != false ? Graphs.asDirectedGraph(gamaGraph) : Graphs.asDirectedGraph(Graphs.reduceToMainconnectedComponentOf(iScope, gamaGraph));
        if (iGraph.hasCycle().booleanValue()) {
            throw GamaRuntimeException.error("Strahler number can only be computed for Tree (connected graph with no cycle)!", iScope);
        }
        ArrayList arrayList = StreamEx.of(iGraph.getEdges()).filter(object -> iGraph.outDegreeOf(iGraph.getEdgeTarget(object)) == 0).toList();
        while (!arrayList.isEmpty()) {
            ArrayList arrayList2 = new ArrayList();
            for (Object e : arrayList) {
                Integer n;
                IList iList = Graphs.inEdgesOf(iScope, iGraph, iGraph.getEdgeSource(e));
                IList iList2 = Graphs.outEdgesOf(iScope, iGraph, iGraph.getEdgeTarget(e));
                if (iList2.isEmpty()) {
                    iMap.put(e, 1);
                    arrayList2.addAll(iList);
                    continue;
                }
                boolean bl = iList2.stream().anyMatch(object -> !iMap.containsKey(object));
                if (bl) {
                    arrayList2.add(e);
                    continue;
                }
                List list = StreamEx.of((Collection)iList2).map(object -> iMap.get(object)).toList();
                int n2 = Collections.frequency(list, n = (Integer)Collections.max(list));
                if (n2 > 1) {
                    iMap.put(e, n + 1);
                } else {
                    iMap.put(e, n);
                }
                arrayList2.addAll(iList);
            }
            arrayList = arrayList2;
        }
        return iMap;
    }

    @GamlAnnotations.operator(value={"edge"}, type=0, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps two objects and indicates they should be considered as the source and the target of a new edge of a graph. The third (omissible) parameter indicates which weight this edge should have in the graph", masterDoc=true, comment="Useful only in graph-related operations (addition, removal of edges, creation of graphs)")
    public static Object edge(Object object, Object object2, Double d) {
        return Graphs.edge(object, object2, null, d);
    }

    @GamlAnnotations.operator(value={"edge"}, type=0, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps two objects and indicates they should be considered as the source and the target of a new edge of a graph. The third parameter indicates which weight this edge should have in the graph")
    public static Object edge(Object object, Object object2, Integer n) {
        return Graphs.edge(object, object2, null, n);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-198, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps a pair of objects and a third and indicates  they should respectively be considered as the source (key of the pair), the target (value of the pair) and the actual object representing an edge of a graph. The third parameter indicates which weight this edge should have in the graph")
    public static Object edge(GamaPair gamaPair, Object object, Double d) {
        return Graphs.edge(gamaPair.key, gamaPair.value, object, d);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-198, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps a pair of objects and a third and indicates  they should respectively be considered as the source (key of the pair), the target (value of the pair) and the actual object representing an edge of a graph. The third parameter indicates which weight this edge should have in the graph")
    public static Object edge(GamaPair gamaPair, Object object, Integer n) {
        return Graphs.edge(gamaPair.key, gamaPair.value, object, n);
    }

    @GamlAnnotations.operator(value={"edge"}, type=0, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps two objects and indicates they should be considered as the source and the target of a new edge of a graph ")
    public static Object edge(Object object, Object object2) {
        return Graphs.edge(object, object2, null, null);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-197, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps three objects and indicates they should respectively be considered as the source, the target and the actual object representing an edge of a graph")
    public static Object edge(Object object, Object object2, Object object3) {
        return Graphs.edge(object, object2, object3, null);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-197, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps two objects and indicates they should be considered as the source and the target of a new edge of a graph. The fourth parameter indicates which weight this edge should have in the graph")
    public static Object edge(Object object, Object object2, Object object3, Double d) {
        return new EdgeToAdd(object, object2, object3, d);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-197, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps two objects and indicates they should be considered as the source and the target of a new edge of a graph. The fourth parameter indicates which weight this edge should have in the graph")
    public static Object edge(Object object, Object object2, Object object3, Integer n) {
        return new EdgeToAdd(object, object2, object3, n);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-199, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps an actual object and indicates it should be considered as an edge of a graph. The second parameter indicates which weight this edge should have in the graph")
    public static Object edge(Object object, Double d) {
        return Graphs.edge(null, null, object, d);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-199, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps an actual object and indicates it should be considered as an edge of a graph. The second parameter indicates which weight this edge should have in the graph")
    public static Object edge(Object object, Integer n) {
        return Graphs.edge(null, null, object, n);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-299, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps a pair of objects and indicates they should be considered as the source and target of an edge. The second parameter indicates which weight this edge should have in the graph")
    public static Object edge(GamaPair gamaPair, Double d) {
        return Graphs.edge(gamaPair.key, gamaPair.value, null, d);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-299, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps a pair of objects and indicates they should be considered as the source and target of an edge. The second parameter indicates which weight this edge should have in the graph")
    public static Object edge(GamaPair gamaPair, Integer n) {
        return Graphs.edge(gamaPair.key, gamaPair.value, null, n);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-199, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps an actual object and indicates it should be considered as an edge of a graph")
    public static Object edge(Object object) {
        return Graphs.edge(null, null, object, null);
    }

    @GamlAnnotations.operator(value={"edge"}, type=-299, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps a pair of objects and indicates they should be considered as the source and target of an edge of a graph")
    public static Object edge(GamaPair gamaPair) {
        return Graphs.edge(gamaPair.key, gamaPair.value, null, null);
    }

    @GamlAnnotations.operator(value={"node"}, type=-199, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps an actual object and indicates it should be considered as a node of a graph. The second (optional) parameter indicates which weight the node should have in the graph", masterDoc=true, comment="Useful only in graph-related operations (addition, removal of nodes, creation of graphs)")
    public static Object node(Object object, Double d) {
        return new NodeToAdd(object, d);
    }

    @GamlAnnotations.operator(value={"node"}, type=-199, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type unknown) that wraps an actual object and indicates it should be considered as a node of a graph")
    public static Object node(Object object) {
        return Graphs.node(object, null);
    }

    @GamlAnnotations.operator(value={"nodes"}, type=-299, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type list) that wraps a list of objects and indicates they should be considered as nodes of a graph")
    public static IContainer nodes(IScope iScope, IContainer iContainer) {
        return NodesToAdd.from(iScope, iContainer);
    }

    @GamlAnnotations.operator(value={"edges"}, type=-299, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="Allows to create a wrapper (of type list) that wraps a list of objects and indicates they should be considered as edges of a graph")
    public static IContainer edges(IScope iScope, IContainer iContainer) {
        return EdgesToAdd.from(iScope, iContainer);
    }

    @GamlAnnotations.operator(value={"generate_barabasi_albert"}, concept={"algorithm"})
    @GamlAnnotations.doc(value="returns a random scale-free network (following Barabasi-Albert (BA) model).", masterDoc=true, comment="The Barabasi-Albert (BA) model is an algorithm for generating random scale-free networks using a preferential attachment mechanism. A scale-free network is a network whose degree distribution follows a power law, at least asymptotically.Such networks are widely observed in natural and human-made systems, including the Internet, the world wide web, citation networks, and some social networks. [From Wikipedia article]The map operand should includes following elements:", usages={@GamlAnnotations.usage(value="\"nbInitNodes\": number of initial nodes; \"nbEdgesAdded\": number of edges of each new node added during the network growth; \"nbNodes\": final number of nodes; \"directed\": is the graph directed or not; \"node_species\": the species of vertices; \"edges_species\": the species of edges", examples={@GamlAnnotations.example(value="graph<myVertexSpecy,myEdgeSpecy> myGraph <- generate_watts_strogatz(", isExecutable=false), @GamlAnnotations.example(value="\t\t\t60,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t1,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t100,", isExecutable=false), @GamlAnnotations.example(value="\t\ttrue,", isExecutable=false), @GamlAnnotations.example(value="\t\t\tmyVertexSpecies,", isExecutable=false), @GamlAnnotations.example(value="\t\t\tmyEdgeSpecies);", isExecutable=false)})}, see={"generate_watts_strogatz"})
    public static IGraph generateGraphBarabasiAlbert(IScope iScope, Integer n, Integer n2, Integer n3, Boolean bl, ISpecies iSpecies, ISpecies iSpecies2) {
        BarabasiAlbertGraphGenerator barabasiAlbertGraphGenerator = new BarabasiAlbertGraphGenerator(n.intValue(), n2.intValue(), n3.intValue(), iScope.getSimulation().getRandomGenerator().getGenerator());
        DirectedMultigraph directedMultigraph = bl != false ? new DirectedMultigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true) : new Multigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true);
        barabasiAlbertGraphGenerator.generateGraph((Graph)directedMultigraph);
        return new GamaGraph(iScope, (AbstractBaseGraph<?, DefaultEdge>)directedMultigraph, iSpecies, iSpecies2);
    }

    @GamlAnnotations.operator(value={"generate_barabasi_albert"}, concept={"algorithm"})
    @GamlAnnotations.doc(value="returns a random scale-free network (following Barabasi-Albert (BA) model).", masterDoc=false, comment="The Barabasi-Albert (BA) model is an algorithm for generating random scale-free networks using a preferential attachment mechanism. A scale-free network is a network whose degree distribution follows a power law, at least asymptotically.Such networks are widely observed in natural and human-made systems, including the Internet, the world wide web, citation networks, and some social networks. [From Wikipedia article]The map operand should includes following elements:", usages={@GamlAnnotations.usage(value="\"nbInitNodes\": number of initial nodes; \"nodes\": list of existing nodes to connect (agents or geometries); \"nbEdgesAdded\": number of edges of each new node added during the network growth; \"directed\": is the graph directed or not; ", examples={@GamlAnnotations.example(value="graph myGraph <- generate_watts_strogatz(people, 10,1,false);", isExecutable=false)})}, see={"generate_watts_strogatz"})
    public static IGraph generateGraphBarabasiAlbert(IScope iScope, IContainer iContainer, Integer n, Integer n2, Boolean bl) {
        BarabasiAlbertGraphGenerator barabasiAlbertGraphGenerator = new BarabasiAlbertGraphGenerator(n.intValue(), n2.intValue(), iContainer.length(iScope), iScope.getSimulation().getRandomGenerator().getGenerator());
        DirectedMultigraph directedMultigraph = bl != false ? new DirectedMultigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true) : new Multigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true);
        barabasiAlbertGraphGenerator.generateGraph((Graph)directedMultigraph);
        IList iList = iContainer.listValue(iScope, Types.NO_TYPE, false);
        GamaMap gamaMap = (GamaMap)GamaMapFactory.create();
        ArrayList arrayList = new ArrayList(directedMultigraph.vertexSet());
        int n3 = 0;
        while (n3 < directedMultigraph.vertexSet().size()) {
            gamaMap.put(arrayList.get(n3), iList.get(n3));
            ++n3;
        }
        return new GamaGraph(iScope, (AbstractBaseGraph<?, DefaultEdge>)directedMultigraph, gamaMap);
    }

    @GamlAnnotations.operator(value={"generate_barabasi_albert"}, concept={"algorithm"})
    @GamlAnnotations.doc(value="returns a random scale-free network (following Barabasi-Albert (BA) model).", masterDoc=false, comment="The Barabasi-Albert (BA) model is an algorithm for generating random scale-free networks using a preferential attachment mechanism. A scale-free network is a network whose degree distribution follows a power law, at least asymptotically.Such networks are widely observed in natural and human-made systems, including the Internet, the world wide web, citation networks, and some social networks. [From Wikipedia article]The map operand should includes following elements:", usages={@GamlAnnotations.usage(value="\"nbInitNodes\": number of initial nodes; \"nbEdgesAdded\": number of edges of each new node added during the network growth; \"nbNodes\": final number of nodes; \"directed\": is the graph directed or not; \"node_species\": the species of vertices; \"edges_species\": the species of edges", examples={@GamlAnnotations.example(value="graph<myVertexSpecy,myEdgeSpecy> myGraph <- generate_watts_strogatz(", isExecutable=false), @GamlAnnotations.example(value="\t\t\t60,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t1,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t100,", isExecutable=false), @GamlAnnotations.example(value="\t\ttrue,", isExecutable=false), @GamlAnnotations.example(value="\t\t\tmyVertexSpecies);", isExecutable=false)})}, see={"generate_watts_strogatz"})
    public static IGraph generateGraphBarabasiAlbert(IScope iScope, Integer n, Integer n2, Integer n3, Boolean bl, ISpecies iSpecies) {
        return Graphs.generateGraphBarabasiAlbert(iScope, n, n2, n3, bl, iSpecies, null);
    }

    @GamlAnnotations.operator(value={"generate_barabasi_albert"}, concept={"algorithm"})
    @GamlAnnotations.doc(value="returns a random scale-free network (following Barabasi-Albert (BA) model).", masterDoc=false, comment="The Barabasi-Albert (BA) model is an algorithm for generating random scale-free networks using a preferential attachment mechanism. A scale-free network is a network whose degree distribution follows a power law, at least asymptotically.Such networks are widely observed in natural and human-made systems, including the Internet, the world wide web, citation networks, and some social networks. [From Wikipedia article]The map operand should includes following elements:", usages={@GamlAnnotations.usage(value="\"nbInitNodes\": number of initial nodes; \"nbEdgesAdded\": number of edges of each new node added during the network growth; \"nbNodes\": final number of nodes; \"directed\": is the graph directed or not; ", examples={@GamlAnnotations.example(value="graph<myVertexSpecy,myEdgeSpecy> myGraph <- generate_watts_strogatz(", isExecutable=false), @GamlAnnotations.example(value="\t\t\t60,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t1,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t100,", isExecutable=false), @GamlAnnotations.example(value="\t\ttrue);", isExecutable=false)})}, see={"generate_watts_strogatz"})
    public static IGraph generateGraphBarabasiAlbert(IScope iScope, Integer n, Integer n2, Integer n3, Boolean bl) {
        return Graphs.generateGraphBarabasiAlbert(iScope, n, n2, n3, bl, null, null);
    }

    @GamlAnnotations.operator(value={"generate_watts_strogatz"}, concept={"algorithm"})
    @GamlAnnotations.doc(value="returns a random small-world network (following Watts-Strogatz model).", masterDoc=true, comment="The Watts-Strogatz model is a random graph generation model that produces graphs with small-world properties, including short average path lengths and high clustering.A small-world network is a type of graph in which most nodes are not neighbors of one another, but most nodes can be reached from every other by a small number of hops or steps. [From Wikipedia article]The map operand should includes following elements:", usages={@GamlAnnotations.usage(value="\"nbNodes\": the graph will contain (size + 1) nodes (size must be greater than k); \"p\": probability to \"rewire\" an edge (so it must be between 0 and 1, the parameter is often called beta in the literature); \"k\": the base degree of each node (k must be greater than 2 and even); \"directed\": is the graph directed or not; \"node_species\": the species of vertices; \"edges_species\": the species of edges", examples={@GamlAnnotations.example(value="graph<myVertexSpecy,myEdgeSpecy> myGraph <- generate_watts_strogatz(", isExecutable=false), @GamlAnnotations.example(value="\t\t\t100,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t0.3,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t5,", isExecutable=false), @GamlAnnotations.example(value="\t\ttrue,", isExecutable=false), @GamlAnnotations.example(value="\t\t\tmyVertexSpecies,", isExecutable=false), @GamlAnnotations.example(value="\t\t\tmyEdgeSpecies);", isExecutable=false)})}, see={"generate_barabasi_albert"})
    public static IGraph generateGraphWattsStrogatz(IScope iScope, Integer n, Double d, Integer n2, Boolean bl, ISpecies iSpecies, ISpecies iSpecies2) {
        WattsStrogatzGraphGenerator wattsStrogatzGraphGenerator = new WattsStrogatzGraphGenerator(n.intValue(), n2.intValue(), d.doubleValue(), false, iScope.getSimulation().getRandomGenerator().getGenerator());
        DirectedMultigraph directedMultigraph = bl != false ? new DirectedMultigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true) : new Multigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true);
        wattsStrogatzGraphGenerator.generateGraph((Graph)directedMultigraph);
        return new GamaGraph(iScope, (AbstractBaseGraph<?, DefaultEdge>)directedMultigraph, iSpecies, iSpecies2);
    }

    @GamlAnnotations.operator(value={"generate_watts_strogatz"}, concept={"algorithm"})
    @GamlAnnotations.doc(value="returns a random small-world network (following Watts-Strogatz model).", masterDoc=false, comment="The Watts-Strogatz model is a random graph generation model that produces graphs with small-world properties, including short average path lengths and high clustering.A small-world network is a type of graph in which most nodes are not neighbors of one another, but most nodes can be reached from every other by a small number of hops or steps. [From Wikipedia article]The map operand should includes following elements:", usages={@GamlAnnotations.usage(value="\"nbNodes\": the graph will contain (size + 1) nodes (size must be greater than k); \"p\": probability to \"rewire\" an edge (so it must be between 0 and 1, the parameter is often called beta in the literature); \"k\": the base degree of each node (k must be greater than 2 and even); \"directed\": is the graph directed or not; \"node_species\": the species of vertices", examples={@GamlAnnotations.example(value="graph<myVertexSpecy,myEdgeSpecy> myGraph <- generate_watts_strogatz(", isExecutable=false), @GamlAnnotations.example(value="\t\t\t100,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t0.3,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t5,", isExecutable=false), @GamlAnnotations.example(value="\t\ttrue,", isExecutable=false), @GamlAnnotations.example(value="\t\t\tmyVertexSpecies);", isExecutable=false)})}, see={"generate_barabasi_albert"})
    public static IGraph generateGraphWattsStrogatz(IScope iScope, Integer n, Double d, Integer n2, Boolean bl, ISpecies iSpecies) {
        return Graphs.generateGraphWattsStrogatz(iScope, n, d, n2, bl, iSpecies, null);
    }

    @GamlAnnotations.operator(value={"generate_watts_strogatz"}, concept={"algorithm"})
    @GamlAnnotations.doc(value="returns a random small-world network (following Watts-Strogatz model).", masterDoc=false, comment="The Watts-Strogatz model is a random graph generation model that produces graphs with small-world properties, including short average path lengths and high clustering.A small-world network is a type of graph in which most nodes are not neighbors of one another, but most nodes can be reached from every other by a small number of hops or steps. [From Wikipedia article]The map operand should includes following elements:", usages={@GamlAnnotations.usage(value="\"nbNodes\": the graph will contain (size + 1) nodes (size must be greater than k); \"p\": probability to \"rewire\" an edge (so it must be between 0 and 1, the parameter is often called beta in the literature); \"k\": the base degree of each node (k must be greater than 2 and even); \"directed\": is the graph directed or not", examples={@GamlAnnotations.example(value="graph<myVertexSpecy,myEdgeSpecy> myGraph <- generate_watts_strogatz(", isExecutable=false), @GamlAnnotations.example(value="\t\t\t100,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t0.3,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t5,", isExecutable=false), @GamlAnnotations.example(value="\t\ttrue);", isExecutable=false)})}, see={"generate_barabasi_albert"})
    public static IGraph generateGraphWattsStrogatz(IScope iScope, Integer n, Double d, Integer n2, Boolean bl) {
        return Graphs.generateGraphWattsStrogatz(iScope, n, d, n2, bl, null, null);
    }

    @GamlAnnotations.operator(value={"generate_watts_strogatz"}, concept={"algorithm"})
    @GamlAnnotations.doc(value="returns a random small-world network (following Watts-Strogatz model).", masterDoc=false, comment="The Watts-Strogatz model is a random graph generation model that produces graphs with small-world properties, including short average path lengths and high clustering.A small-world network is a type of graph in which most nodes are not neighbors of one another, but most nodes can be reached from every other by a small number of hops or steps. [From Wikipedia article]The map operand should includes following elements:", usages={@GamlAnnotations.usage(value="\"nodes\": the list of nodes to connect; \"p\": probability to \"rewire\" an edge (so it must be between 0 and 1, the parameter is often called beta in the literature); \"k\": the base degree of each node (k must be greater than 2 and even); \"directed\": is the graph directed or not", examples={@GamlAnnotations.example(value="graph<myVertexSpecy,myEdgeSpecy> myGraph <- generate_watts_strogatz(", isExecutable=false), @GamlAnnotations.example(value="\t\t\tpeople,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t0.3,", isExecutable=false), @GamlAnnotations.example(value="\t\t\t5,", isExecutable=false), @GamlAnnotations.example(value="\t\ttrue);", isExecutable=false)})}, see={"generate_barabasi_albert"})
    public static IGraph generateGraphWattsStrogatz(IScope iScope, IContainer iContainer, Double d, Integer n, Boolean bl) {
        WattsStrogatzGraphGenerator wattsStrogatzGraphGenerator = new WattsStrogatzGraphGenerator(iContainer.length(iScope), n.intValue(), d.doubleValue(), false, iScope.getSimulation().getRandomGenerator().getGenerator());
        DirectedMultigraph directedMultigraph = bl != false ? new DirectedMultigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true) : new Multigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true);
        wattsStrogatzGraphGenerator.generateGraph((Graph)directedMultigraph);
        IList iList = iContainer.listValue(iScope, Types.NO_TYPE, false);
        GamaMap gamaMap = (GamaMap)GamaMapFactory.create();
        ArrayList arrayList = new ArrayList(directedMultigraph.vertexSet());
        int n2 = 0;
        while (n2 < directedMultigraph.vertexSet().size()) {
            gamaMap.put(arrayList.get(n2), iList.get(n2));
            ++n2;
        }
        return new GamaGraph(iScope, (AbstractBaseGraph<?, DefaultEdge>)directedMultigraph, gamaMap);
    }

    @GamlAnnotations.operator(value={"generate_random_graph"}, concept={})
    @GamlAnnotations.doc(value="returns a random graph.", masterDoc=true, usages={@GamlAnnotations.usage(value="`nbNodes`: number of nodes to be created; `nbEdges`: number of edges to be created; `directed`: is the graph has to be directed or not;`node_species`: the species of nodes; `edges_species`: the species of edges ", examples={@GamlAnnotations.example(value="graph<node_species,edge_species> myGraph <- generate_random_graph(", isExecutable=false), @GamlAnnotations.example(value="50,", isExecutable=false), @GamlAnnotations.example(value="100,", isExecutable=false), @GamlAnnotations.example(value="true,", isExecutable=false), @GamlAnnotations.example(value="node_species,", isExecutable=false), @GamlAnnotations.example(value="edge_species);", isExecutable=false)})}, see={"generate_barabasi_albert", "generate_watts_strogatz"})
    public static IGraph generateGraphRandom(IScope iScope, int n, int n2, Boolean bl, ISpecies iSpecies, ISpecies iSpecies2) {
        DirectedMultigraph directedMultigraph = bl != false ? new DirectedMultigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true) : new Multigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true);
        GnmRandomGraphGenerator gnmRandomGraphGenerator = new GnmRandomGraphGenerator(n, n2, iScope.getSimulation().getSeed().longValue());
        gnmRandomGraphGenerator.generateGraph((Graph)directedMultigraph, null);
        return new GamaGraph(iScope, (AbstractBaseGraph<?, DefaultEdge>)directedMultigraph, iSpecies, iSpecies2);
    }

    @GamlAnnotations.operator(value={"generate_random_graph"}, concept={})
    @GamlAnnotations.doc(value="returns a random graph.", usages={@GamlAnnotations.usage(value="`nbNodes`: number of nodes to create;`nbEdges`: number of edges to create;`directed`: is the graph directed or not;`node_species`: the species of nodes", examples={@GamlAnnotations.example(value="graph myGraph <- generate_random_graph(", isExecutable=false), @GamlAnnotations.example(value="50,", isExecutable=false), @GamlAnnotations.example(value="100,", isExecutable=false), @GamlAnnotations.example(value="true,", isExecutable=false), @GamlAnnotations.example(value="node_species);", isExecutable=false)})}, see={"generate_barabasi_albert", "generate_watts_strogatz"})
    public static IGraph generateGraphRandom(IScope iScope, int n, int n2, Boolean bl, ISpecies iSpecies) {
        return Graphs.generateGraphRandom(iScope, n, n2, bl, iSpecies, null);
    }

    @GamlAnnotations.operator(value={"generate_random_graph"}, concept={})
    @GamlAnnotations.doc(value="returns a random graph.", usages={@GamlAnnotations.usage(value="`nbNodes`: number of nodes to create;`nbEdges`: number of edges to create;`directed`: is the graph directed or not", examples={@GamlAnnotations.example(value="graph myGraph <- generate_random_graph(", isExecutable=false), @GamlAnnotations.example(value="50,", isExecutable=false), @GamlAnnotations.example(value="100,", isExecutable=false), @GamlAnnotations.example(value="true);", isExecutable=false)})}, see={"generate_barabasi_albert", "generate_watts_strogatz"})
    public static IGraph generateGraphRandom(IScope iScope, int n, int n2, Boolean bl) {
        return Graphs.generateGraphRandom(iScope, n, n2, bl, null, null);
    }

    @GamlAnnotations.operator(value={"generate_complete_graph"}, concept={})
    @GamlAnnotations.doc(value="returns a fully connected graph.", masterDoc=true, usages={@GamlAnnotations.usage(value="\"directed\": is the graph has to be directed or not;\"nodes\": the list of existing nodes; \"edges_species\": the species of edges ", examples={@GamlAnnotations.example(value="graph<myVertexSpecy,myEdgeSpecy> myGraph <- generate_complete_graph(", isExecutable=false), @GamlAnnotations.example(value="true,", isExecutable=false), @GamlAnnotations.example(value="nodes,", isExecutable=false), @GamlAnnotations.example(value="edge_species);", isExecutable=false)})}, see={"generate_barabasi_albert", "generate_watts_strogatz"})
    public static IGraph generateGraphComplete(IScope iScope, Boolean bl, IList iList, ISpecies iSpecies) {
        DirectedMultigraph directedMultigraph = bl != false ? new DirectedMultigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true) : new Multigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true);
        int n = 0;
        while (n < iList.size()) {
            directedMultigraph.addVertex((Object)("" + n));
            ++n;
        }
        ComplementGraphGenerator complementGraphGenerator = new ComplementGraphGenerator((Graph)directedMultigraph);
        complementGraphGenerator.generateGraph((Graph)directedMultigraph, null);
        return new GamaGraph(iScope, (AbstractBaseGraph<String, DefaultEdge>)directedMultigraph, iList, iSpecies);
    }

    @GamlAnnotations.operator(value={"generate_complete_graph"}, concept={})
    @GamlAnnotations.doc(value="returns a fully connected graph.", usages={@GamlAnnotations.usage(value="\"directed\": is the graph has to be directed or not;\"nodes\": the list of existing nodes", examples={@GamlAnnotations.example(value="graph<myVertexSpecy,myEdgeSpecy> myGraph <- generate_complete_graph(", isExecutable=false), @GamlAnnotations.example(value="\t\t\ttrue,", isExecutable=false), @GamlAnnotations.example(value="\t\t\tnodes);", isExecutable=false)})}, see={"generate_barabasi_albert", "generate_watts_strogatz"})
    public static IGraph generateGraphComplete(IScope iScope, Boolean bl, IList iList) {
        return Graphs.generateGraphComplete(iScope, bl, iList, null);
    }

    @GamlAnnotations.operator(value={"generate_complete_graph"}, concept={})
    @GamlAnnotations.doc(value="returns a fully connected graph.", usages={@GamlAnnotations.usage(value="`nbNodes`: number of nodes to create;`directed`: is the graph directed or not;`node_species`: the species of nodes; `edges_species`: the species of edges ", examples={@GamlAnnotations.example(value="graph<myVertexSpecy,myEdgeSpecy> myGraph <- generate_complete_graph(", isExecutable=false), @GamlAnnotations.example(value="100,", isExecutable=false), @GamlAnnotations.example(value="true,", isExecutable=false), @GamlAnnotations.example(value="node_species,", isExecutable=false), @GamlAnnotations.example(value="edge_species);", isExecutable=false)})}, see={"generate_barabasi_albert", "generate_watts_strogatz"})
    public static IGraph generateGraphComplete(IScope iScope, int n, Boolean bl, ISpecies iSpecies, ISpecies iSpecies2) {
        DirectedMultigraph directedMultigraph = bl != false ? new DirectedMultigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true) : new Multigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true);
        int n2 = 0;
        while (n2 < n) {
            directedMultigraph.addVertex((Object)("" + n2));
            ++n2;
        }
        ComplementGraphGenerator complementGraphGenerator = new ComplementGraphGenerator((Graph)directedMultigraph);
        complementGraphGenerator.generateGraph((Graph)directedMultigraph, null);
        return new GamaGraph(iScope, (AbstractBaseGraph<?, DefaultEdge>)directedMultigraph, iSpecies, iSpecies2);
    }

    @GamlAnnotations.operator(value={"generate_complete_graph"}, concept={})
    @GamlAnnotations.doc(value="returns a fully connected graph.", usages={@GamlAnnotations.usage(value="`nbNodes`: number of nodes to create;`directed`: is the graph directed or not;`node_species`: the species of nodes", examples={@GamlAnnotations.example(value="graph myGraph <- generate_complete_graph(", isExecutable=false), @GamlAnnotations.example(value="\t\t\t100,", isExecutable=false), @GamlAnnotations.example(value="\t\t\ttrue,", isExecutable=false), @GamlAnnotations.example(value="\t\t\tnode_species);", isExecutable=false)})}, see={"generate_barabasi_albert", "generate_watts_strogatz"})
    public static IGraph generateGraphComplete(IScope iScope, int n, Boolean bl, ISpecies iSpecies) {
        return Graphs.generateGraphComplete(iScope, n, bl, iSpecies, null);
    }

    @GamlAnnotations.operator(value={"generate_complete_graph"}, concept={})
    @GamlAnnotations.doc(value="returns a fully connected graph.", usages={@GamlAnnotations.usage(value="`nbNodes`: number of nodes to create;`directed`: is the graph directed or not", examples={@GamlAnnotations.example(value="graph myGraph <- generate_complete_graph(", isExecutable=false), @GamlAnnotations.example(value="\t\t\t100,", isExecutable=false), @GamlAnnotations.example(value="\t\t\ttrue);", isExecutable=false)})}, see={"generate_barabasi_albert", "generate_watts_strogatz"})
    public static IGraph generateGraphComplete(IScope iScope, int n, Boolean bl) {
        return Graphs.generateGraphComplete(iScope, n, bl, null, null);
    }

    @GamlAnnotations.operator(value={"girvan_newman_clustering"}, type=-299, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="The Girvan\ufffdNewman algorithm is a hierarchical method used to detect communities. It detects communities by progressively removing edges from the original network.It returns a list of list of vertices and takes as operand the graph and the number of clusters")
    public static IList girvanNewmanClustering(IScope iScope, IGraph iGraph, int n) {
        if (iGraph.getVertices().isEmpty() || iGraph.getEdges().isEmpty()) {
            IList iList = GamaListFactory.create(Types.GRAPH);
            iList.add((IGraph)iGraph.copy(iScope));
            return iList;
        }
        GirvanNewmanClustering girvanNewmanClustering = new GirvanNewmanClustering((Graph)iGraph, n);
        ClusteringAlgorithm.Clustering clustering = girvanNewmanClustering.getClustering();
        IList iList = GamaListFactory.create(Types.LIST);
        for (Object e : clustering.getClusters()) {
            iList.add(GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), (Set)e));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"k_spanning_tree_clustering"}, type=-299, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="The algorithm finds a minimum spanning tree T using Prim's algorithm, then executes Kruskal's algorithm only on the edges of T until k trees are formed. The resulting trees are the final clusters.It returns a list of list of vertices and takes as operand the graph and the number of clusters")
    public static IList KSpanningTreeClusteringAfl(IScope iScope, IGraph iGraph, int n) {
        if (iGraph.getVertices().isEmpty() || iGraph.getEdges().isEmpty()) {
            IList iList = GamaListFactory.create(Types.GRAPH);
            iList.add((IGraph)iGraph.copy(iScope));
            return iList;
        }
        KSpanningTreeClustering kSpanningTreeClustering = new KSpanningTreeClustering((Graph)iGraph, n);
        ClusteringAlgorithm.Clustering clustering = kSpanningTreeClustering.getClustering();
        IList iList = GamaListFactory.create(Types.LIST);
        for (Object e : clustering.getClusters()) {
            iList.add(GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), (Set)e));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"label_propagation_clustering"}, type=-299, category={"Graphs-related operators"})
    @GamlAnnotations.doc(value="The algorithm is a near linear time algorithm capable of discovering communities in large graphs. It is described in detail in the following: Raghavan, U. N., Albert, R., and Kumara, S. (2007). Near linear time algorithm to detect\r\n * community structures in large-scale networks. Physical review E, 76(3), 036106.It returns a list of list of vertices and takes as operand the graph and maximal number of iteration")
    public static IList labelPropagationClusteringAgl(IScope iScope, IGraph iGraph, int n) {
        if (iGraph.getVertices().isEmpty() || iGraph.getEdges().isEmpty()) {
            IList iList = GamaListFactory.create(Types.GRAPH);
            iList.add((IGraph)iGraph.copy(iScope));
            return iList;
        }
        LabelPropagationClustering labelPropagationClustering = new LabelPropagationClustering((Graph)iGraph, n, iScope.getSimulation().getRandomGenerator().getGenerator());
        ClusteringAlgorithm.Clustering clustering = labelPropagationClustering.getClustering();
        IList iList = GamaListFactory.create(Types.LIST);
        for (Object e : clustering.getClusters()) {
            iList.add(GamaListFactory.create(iScope, iGraph.getGamlType().getKeyType(), (Set)e));
        }
        return iList;
    }

    private static class DistanceRelation
    implements GamaSpatialGraph.VertexRelationship<IShape> {
        double distance;

        DistanceRelation(double d) {
            this.distance = d;
        }

        @Override
        public boolean related(IScope iScope, IShape iShape, IShape iShape2) {
            if (iShape == null || iShape2 == null) {
                return false;
            }
            return SpatialRelations.distance_to(iScope, iShape.getGeometry(), iShape2.getGeometry()) <= this.distance;
        }

        @Override
        public boolean equivalent(IScope iScope, IShape iShape, IShape iShape2) {
            if (iShape == null) {
                return iShape2 == null;
            }
            return iShape == iShape2 || iShape.getGeometry().equals(iShape2.getGeometry());
        }
    }

    public static class EdgeToAdd
    implements GraphObjectToAdd {
        public Object source;
        public Object target;
        public Object object;
        public Double weight;

        public EdgeToAdd(Object object, Object object2, Object object3, Double d) {
            this.object = object3;
            this.weight = d;
            this.source = object;
            this.target = object2;
        }

        public EdgeToAdd(Object object, Object object2, Object object3, Integer n) {
            this.object = object3;
            this.weight = n == null ? null : Double.valueOf(n.doubleValue());
            this.source = object;
            this.target = object2;
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        public EdgeToAdd(Object object) {
            this.object = object;
        }
    }

    public static class EdgesToAdd
    extends GamaList<GraphObjectToAdd>
    implements GraphObjectToAdd {
        private static final long serialVersionUID = 1L;

        public EdgesToAdd() {
            super(0, Types.NO_TYPE);
        }

        public static EdgesToAdd from(IScope iScope, IContainer iContainer) {
            EdgesToAdd edgesToAdd = new EdgesToAdd();
            for (Object ValueType : iContainer.iterable(iScope)) {
                edgesToAdd.add((GraphObjectToAdd)ValueType);
            }
            return edgesToAdd;
        }

        @Override
        public Object getObject() {
            return this;
        }
    }

    public static interface GraphObjectToAdd {
        public Object getObject();
    }

    private static class GridNeighborsRelation
    implements GamaSpatialGraph.VertexRelationship<IShape> {
        GridNeighborsRelation() {
        }

        @Override
        public boolean related(IScope iScope, IShape iShape, IShape iShape2) {
            if (!(iShape instanceof IGridAgent)) {
                return false;
            }
            return ((IGridAgent)iShape).getNeighbors(iScope).contains(iShape2);
        }

        @Override
        public boolean equivalent(IScope iScope, IShape iShape, IShape iShape2) {
            return iShape == iShape2;
        }
    }

    private static class IntersectionRelation
    implements GamaSpatialGraph.VertexRelationship<IShape> {
        double tolerance;

        IntersectionRelation(double d) {
            this.tolerance = d;
        }

        @Override
        public boolean related(IScope iScope, IShape iShape, IShape iShape2) {
            return SpatialProperties.intersects(SpatialTransformations.enlarged_by(iScope, iShape.getGeometry(), this.tolerance), SpatialTransformations.enlarged_by(iScope, iShape2.getGeometry(), this.tolerance));
        }

        @Override
        public boolean equivalent(IScope iScope, IShape iShape, IShape iShape2) {
            return iShape == null ? iShape2 == null : iShape.getGeometry().equals(iShape2.getGeometry());
        }
    }

    private static class IntersectionRelationLineTriangle
    implements GamaSpatialGraph.VertexRelationship<IShape> {
        final boolean optimizedForTriangulation;

        IntersectionRelationLineTriangle(boolean bl) {
            this.optimizedForTriangulation = bl;
        }

        @Override
        public boolean related(IScope iScope, IShape iShape, IShape iShape2) {
            if (this.optimizedForTriangulation) {
                int n = 0;
                Coordinate[] coordinateArray = iShape.getInnerGeometry().getCoordinates();
                Object[] objectArray = iShape2.getInnerGeometry().getCoordinates();
                int n2 = 0;
                while (n2 < 3) {
                    if (ArrayUtils.contains((Object[])objectArray, (Object)coordinateArray[n2])) {
                        ++n;
                    }
                    ++n2;
                }
                return n == 2;
            }
            Throwable throwable = null;
            Object var5_8 = null;
            try (Collector.AsSet asSet = Collector.getSet();){
                Object[] objectArray = GeometryUtils.getPointsOf(iShape);
                GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf(iShape2);
                int n = gamaPointArray.length;
                int n3 = 0;
                while (n3 < n) {
                    GamaPoint gamaPoint = gamaPointArray[n3];
                    if (ArrayUtils.contains((Object[])objectArray, (Object)gamaPoint)) {
                        asSet.add(gamaPoint);
                    }
                    ++n3;
                }
                boolean bl = asSet.size() == 2;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public boolean equivalent(IScope iScope, IShape iShape, IShape iShape2) {
            if (this.optimizedForTriangulation) {
                return iShape == iShape2;
            }
            return iShape == null ? iShape2 == null : iShape.getGeometry().equals(iShape2.getGeometry());
        }
    }

    public static class NodeToAdd
    implements GraphObjectToAdd {
        public Object object;
        public Double weight;

        public NodeToAdd(Object object, Double d) {
            this.object = object;
            this.weight = d;
        }

        public NodeToAdd(Object object) {
            this.object = object;
        }

        @Override
        public Object getObject() {
            return this.object;
        }
    }

    public static class NodesToAdd
    extends GamaList<GraphObjectToAdd>
    implements GraphObjectToAdd {
        private static final long serialVersionUID = 1L;

        public NodesToAdd() {
            super(0, Types.NO_TYPE);
        }

        public static NodesToAdd from(IScope iScope, IContainer iContainer) {
            NodesToAdd nodesToAdd = new NodesToAdd();
            for (Object ValueType : iContainer.iterable(iScope)) {
                nodesToAdd.add((GraphObjectToAdd)ValueType);
            }
            return nodesToAdd;
        }

        @Override
        public Object getObject() {
            return this;
        }
    }
}

