/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators.spatial;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.gaml.types.Types;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;

public class SpatialThreeD {
    @GamlAnnotations.operator(value={"set_z"}, category={"Spatial operators", "3D"}, concept={"geometry", "spatial_computation", "point", "3d"})
    @GamlAnnotations.doc(value="Sets the z ordinate of the n-th point of a geometry to the value provided by the third argument", masterDoc=true, examples={@GamlAnnotations.example(value="set_z (triangle(3), 1, 3.0)", test=false)}, see={})
    @GamlAnnotations.test(value="set_z (triangle(3), 1, 3.0).points[1].z = 3.0")
    public static IShape set_z(IScope iScope, IShape iShape, final Integer n, final Double d) {
        if (iShape == null) {
            return null;
        }
        Geometry geometry = iShape.getInnerGeometry();
        if (geometry == null) {
            return iShape;
        }
        if (n < 0 || n > geometry.getNumPoints() - 1) {
            throw GamaRuntimeException.warning("Trying to modify a point outside the bounds of the geometry", iScope);
        }
        geometry.apply(new CoordinateSequenceFilter(){
            boolean done = false;

            public void filter(CoordinateSequence coordinateSequence, int n2) {
                if (n2 == n) {
                    coordinateSequence.getCoordinate((int)n2).z = d;
                    this.done = true;
                }
            }

            public boolean isDone() {
                return this.done;
            }

            public boolean isGeometryChanged() {
                return this.done;
            }
        });
        return iShape;
    }

    @GamlAnnotations.operator(value={"set_z"}, category={"Spatial operators", "3D"}, concept={})
    @GamlAnnotations.doc(value="Sets the z ordinate of each point of a geometry to the value provided, in order, by the right argument", examples={@GamlAnnotations.example(value="triangle(3) set_z [5,10,14]", test=false)}, see={})
    @GamlAnnotations.test(value="list<int> zzz <- (triangle(3) set_z [5,10,14]).points collect each.z; zzz[1] = 10")
    public static IShape set_z(IScope iScope, IShape iShape, IContainer iContainer) {
        if (iShape == null) {
            return null;
        }
        Geometry geometry = iShape.getInnerGeometry();
        if (geometry == null) {
            return iShape;
        }
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            return null;
        }
        if (iContainer.length(iScope) > geometry.getNumPoints()) {
            throw GamaRuntimeException.warning("Trying to modify a point outside the bounds of the geometry", iScope);
        }
        final double[] dArray = new double[iContainer.length(iScope)];
        int n = 0;
        for (Object ValueType : iContainer.iterable(iScope)) {
            dArray[n++] = Types.FLOAT.cast(iScope, ValueType, null, false);
        }
        geometry.apply(new CoordinateSequenceFilter(){

            public void filter(CoordinateSequence coordinateSequence, int n) {
                if (n <= dArray.length - 1) {
                    coordinateSequence.getCoordinate((int)n).z = dArray[n];
                }
            }

            public boolean isDone() {
                return false;
            }

            public boolean isGeometryChanged() {
                return true;
            }
        });
        return iShape;
    }
}

