/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.StringUtils;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.statements.SetStatement;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-204}, optional=false, doc={@GamlAnnotations.doc(value="The name of the temporary variable")}), @GamlAnnotations.facet(name="value", type={0}, optional=true, doc={@GamlAnnotations.doc(value="The value assigned to the temporary variable")}), @GamlAnnotations.facet(name="of", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="The type of the contents if this declaration concerns a container")}), @GamlAnnotations.facet(name="index", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="The type of the index if this declaration concerns a container")}), @GamlAnnotations.facet(name="type", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="The type of the temporary variable")})}, omissible="name")
@GamlAnnotations.inside(kinds={3, 11, 6})
@validator(value=LetValidator.class)
@serializer(value=LetSerializer.class)
@GamlAnnotations.doc(value="Declaration and initialization of a temporary variable.")
public class LetStatement
extends SetStatement {
    public LetStatement(IDescription iDescription) {
        super(iDescription);
        this.setName("let" + this.getVarName());
    }

    @Override
    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object = this.value.value(iScope);
        this.varExpr.setVal(iScope, object, true);
        return object;
    }

    public static class LetSerializer
    extends SetStatement.AssignmentSerializer {
        @Override
        protected void serialize(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append(symbolDescription.getGamlType().serializeToGaml(bl)).append(" ");
            super.serialize(symbolDescription, stringBuilder, bl);
        }
    }

    public static class LetValidator
    implements IDescriptionValidator<IDescription> {
        @Override
        public void validate(IDescription iDescription) {
            if (IDescriptionValidator.Assert.nameIsValid(iDescription)) {
                IExpressionDescription iExpressionDescription = iDescription.getFacet("name");
                IExpression iExpression = iExpressionDescription.getExpression();
                if (!(iExpression instanceof IVarExpression)) {
                    iDescription.error("The expression " + iDescription.getLitteral("name") + " is not a reference to a variable ", "name");
                    return;
                }
                IVarExpression iVarExpression = (IVarExpression)iExpression;
                IExpressionDescription iExpressionDescription2 = iDescription.getFacet("value");
                if (iExpressionDescription2 != null) {
                    IDescriptionValidator.Assert.typesAreCompatibleForAssignment("value", iDescription, StringUtils.toGaml(iExpression, false), iExpression.getGamlType(), iExpressionDescription2);
                }
            }
        }
    }
}

