/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import com.google.common.collect.Iterables;
import gama.core.util.Collector;
import gama.core.util.GamaMapFactory;
import gama.core.util.ICollector;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.data.ListExpression;
import gama.gaml.expressions.data.MapExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.interfaces.INamed;
import gama.gaml.types.GamaBoolType;
import gama.gaml.types.GamaColorType;
import gama.gaml.types.GamaFieldType;
import gama.gaml.types.GamaFloatType;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.GamaIntegerType;
import gama.gaml.types.GamaMapType;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.GamaNoType;
import gama.gaml.types.GamaPairType;
import gama.gaml.types.GamaPointType;
import gama.gaml.types.GamaStringType;
import gama.gaml.types.GamaTopologyType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.ITypesManager;
import gama.gaml.types.TypesManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;

public class Types {
    public static final ITypesManager builtInTypes;
    private static volatile Map<String, SpeciesDescription> builtInSpeciesMap;
    public static final IType NO_TYPE;
    public static IType AGENT;
    public static IType PATH;
    public static IType FONT;
    public static IType SKILL;
    public static IType DATE;
    public static IType ACTION;
    public static IType TYPE;
    public static GamaIntegerType INT;
    public static GamaFloatType FLOAT;
    public static GamaColorType COLOR;
    public static GamaBoolType BOOL;
    public static GamaStringType STRING;
    public static GamaPointType POINT;
    public static GamaGeometryType GEOMETRY;
    public static GamaTopologyType TOPOLOGY;
    public static GamaFieldType FIELD;
    public static IContainerType LIST;
    public static IContainerType MATRIX;
    public static IContainerType MAP;
    public static IContainerType GRAPH;
    public static IContainerType FILE;
    public static IContainerType PAIR;
    public static IContainerType CONTAINER;
    public static IContainerType SPECIES;
    public static final IMap<Class, String> CLASSES_TYPES_CORRESPONDANCE;

    static {
        DEBUG.ON();
        builtInTypes = new TypesManager(null);
        NO_TYPE = new GamaNoType();
        CLASSES_TYPES_CORRESPONDANCE = GamaMapFactory.createUnordered();
    }

    public static void cache(int n, IType iType) {
        switch (n) {
            case 1: {
                INT = (GamaIntegerType)iType;
                break;
            }
            case 2: {
                FLOAT = (GamaFloatType)iType;
                break;
            }
            case 3: {
                BOOL = (GamaBoolType)iType;
                break;
            }
            case 6: {
                COLOR = (GamaColorType)iType;
                break;
            }
            case 23: {
                DATE = iType;
                break;
            }
            case 4: {
                STRING = (GamaStringType)iType;
                break;
            }
            case 7: {
                POINT = (GamaPointType)iType;
                break;
            }
            case 13: {
                GEOMETRY = (GamaGeometryType)iType;
                break;
            }
            case 18: {
                TOPOLOGY = (GamaTopologyType)iType;
                break;
            }
            case 5: {
                LIST = (IContainerType)iType;
                break;
            }
            case 10: {
                MAP = (GamaMapType)iType;
                break;
            }
            case 15: {
                GRAPH = (IContainerType)iType;
                break;
            }
            case 12: {
                FILE = (IContainerType)iType;
                break;
            }
            case 9: {
                PAIR = (GamaPairType)iType;
                break;
            }
            case 11: {
                AGENT = iType;
                break;
            }
            case 17: {
                PATH = iType;
                break;
            }
            case 8: {
                MATRIX = (GamaMatrixType)iType;
                break;
            }
            case 16: {
                CONTAINER = (IContainerType)iType;
                break;
            }
            case 14: {
                SPECIES = (IContainerType)iType;
                break;
            }
            case 19: {
                FONT = iType;
                break;
            }
            case 22: {
                SKILL = iType;
                break;
            }
            case 28: {
                TYPE = iType;
                break;
            }
            case 26: {
                ACTION = iType;
                break;
            }
            case 31: {
                FIELD = (GamaFieldType)iType;
            }
        }
    }

    public static IType get(int n) {
        switch (n) {
            case 1: {
                return INT;
            }
            case 2: {
                return FLOAT;
            }
            case 3: {
                return BOOL;
            }
            case 6: {
                return COLOR;
            }
            case 23: {
                return DATE;
            }
            case 4: {
                return STRING;
            }
            case 7: {
                return POINT;
            }
            case 13: {
                return GEOMETRY;
            }
            case 18: {
                return TOPOLOGY;
            }
            case 5: {
                return LIST;
            }
            case 10: {
                return MAP;
            }
            case 15: {
                return GRAPH;
            }
            case 12: {
                return FILE;
            }
            case 9: {
                return PAIR;
            }
            case 11: {
                return AGENT;
            }
            case 17: {
                return PATH;
            }
            case 8: {
                return MATRIX;
            }
            case 16: {
                return CONTAINER;
            }
            case 14: {
                return SPECIES;
            }
            case 22: {
                return SKILL;
            }
            case 26: {
                return ACTION;
            }
            case 28: {
                return TYPE;
            }
        }
        return builtInTypes.get(String.valueOf(n));
    }

    public static IType get(String string) {
        return builtInTypes.get(string);
    }

    public static <T> IType<T> get(Class<T> clazz) {
        IType<T> iType = Types.internalGet(clazz);
        return iType == null ? NO_TYPE : iType;
    }

    private static <T> IType<T> internalGet(Class<T> clazz) {
        IType[] iTypeArray = new IType[]{builtInTypes.get((String)CLASSES_TYPES_CORRESPONDANCE.get(clazz))};
        boolean bl = false;
        if (iTypeArray[0] == NO_TYPE && !clazz.isInterface()) {
            boolean bl2 = bl = !CLASSES_TYPES_CORRESPONDANCE.forEachPair((clazz2, string) -> {
                if (clazz2 != Object.class && clazz2.isAssignableFrom(clazz)) {
                    iTypeArray[0] = builtInTypes.get((String)string);
                    return false;
                }
                return true;
            });
        }
        if (bl) {
            CLASSES_TYPES_CORRESPONDANCE.put(clazz, iTypeArray[0].toString());
        }
        return iTypeArray[0];
    }

    public static Iterable<String> getTypeNames() {
        return Iterables.transform(builtInTypes.getAllTypes(), INamed::getName);
    }

    public static void init() {
        IType<?> iType2;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Set<IType<?>> set = builtInTypes.getAllTypes();
        for (IType<?> iType2 : set) {
            hashMap.put(iType2, Collector.getSet());
            hashMap2.put(iType2, Collector.getSet());
        }
        for (IType<?> iType2 : set) {
            for (IType<Object> iType3 : set) {
                if (iType2 == iType3 || !iType2.toClass().isAssignableFrom(iType3.toClass())) continue;
                ((ICollector)hashMap.get(iType2)).add(iType3);
                ((ICollector)hashMap2.get(iType3)).add(iType2);
            }
        }
        iType2 = new ArrayDeque();
        iType2.push((IType)NO_TYPE);
        while (!iType2.isEmpty()) {
            IType iType4 = (IType)iType2.pop();
            for (IType<Object> iType3 : (ICollector)hashMap.get(iType4)) {
                ((ICollector)hashMap2.get(iType3)).remove(iType4);
                if (!((ICollector)hashMap2.get(iType3)).isEmpty()) continue;
                iType2.push(iType3);
                iType3.setParent(iType4);
                DescriptionFactory.addNewTypeName(iType3.toString(), iType3.getVarKind());
                iType3.setFieldGetters(GAML.getAllFields(iType3.toClass()));
            }
        }
    }

    public static Map<String, ? extends SpeciesDescription> getBuiltInSpecies() {
        if (builtInSpeciesMap != null) {
            return builtInSpeciesMap;
        }
        ModelDescription modelDescription = ModelDescription.ROOT;
        ArrayList<SpeciesDescription> arrayList = new ArrayList<SpeciesDescription>();
        modelDescription.getAllSpecies(arrayList);
        builtInSpeciesMap = StreamEx.of(arrayList).toMap(SymbolDescription::getName, speciesDescription -> speciesDescription);
        return builtInSpeciesMap;
    }

    public static boolean intFloatCase(IType iType, IType iType2) {
        return iType == FLOAT && iType2 == INT || iType2 == FLOAT && iType == INT;
    }

    public static boolean isEmptyContainerCase(IType iType, IExpression iExpression) {
        boolean bl;
        IType<?> iType2 = iType.getGamlType();
        boolean bl2 = bl = (iType2 == MAP || iType2 == LIST) && Types.isEmpty(iExpression);
        if (bl) {
            return true;
        }
        if (iExpression instanceof ListExpression) {
            IExpression[] iExpressionArray = ((ListExpression)iExpression).getElements();
            int n = iExpressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression2 = iExpressionArray[n2];
                if (!Types.isEmptyContainerCase(iType.getContentType(), iExpression2)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmpty(IExpression iExpression) {
        switch (iExpression.getGamlType().getGamlType().id()) {
            case 5: {
                if (!(iExpression instanceof ListExpression)) break;
                return ((ListExpression)iExpression).isEmpty();
            }
            case 10: {
                if (!(iExpression instanceof MapExpression)) break;
                return ((MapExpression)iExpression).isEmpty();
            }
        }
        return false;
    }

    public static Iterable<OperatorProto> getAllFields() {
        return Iterables.concat((Iterable)Iterables.transform(builtInTypes.getAllTypes(), iType -> iType.getFieldGetters().values()));
    }

    public static boolean hasType(String string) {
        return builtInTypes.containsType(string);
    }
}

