/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf;

import gama.dependencies.kabeja.dxf.Bounds;
import gama.dependencies.kabeja.dxf.DXFText;
import gama.dependencies.kabeja.dxf.helpers.DXFTextParser;
import gama.dependencies.kabeja.dxf.helpers.DXFUtils;
import gama.dependencies.kabeja.dxf.helpers.TextDocument;

public class DXFMText
extends DXFText {
    public static final int ATTACHMENT_TOP_LEFT = 1;
    public static final int ATTACHMENT_TOP_CENTER = 2;
    public static final int ATTACHMENT_TOP_RIGHT = 3;
    public static final int ATTACHMENT_MIDDLE_LEFT = 4;
    public static final int ATTACHMENT_MIDDLE_CENTER = 5;
    public static final int ATTACHMENT_MIDDLE_RIGHT = 6;
    public static final int ATTACHMENT_BOTTOM_LEFT = 7;
    public static final int ATTACHMENT_BOTTOM_CENTER = 8;
    public static final int ATTACHMENT_BOTTOM_RIGHT = 9;
    private int attachmentpointLocation = 1;
    private double refwidth = 0.0;
    private double refheight = 0.0;

    public void setAttachmentPoint(int n) {
        this.attachmentpointLocation = n;
    }

    public void setReferenceWidth(double d) {
        this.refwidth = d;
    }

    public double getReferenceWidth() {
        return this.refwidth;
    }

    public void setReferenceHeight(double d) {
        this.refheight = d;
    }

    public double getReferenceHeight() {
        return this.refheight;
    }

    @Override
    public String getType() {
        return "MTEXT";
    }

    @Override
    public double getRotation() {
        if (this.rotation != 0.0) {
            return this.rotation;
        }
        if (this.align_p1.getX() != 0.0 || this.align_p1.getY() != 0.0 || this.align_p1.getZ() != 0.0) {
            double[] dArray = new double[]{this.align_p1.getX(), this.align_p1.getY(), this.align_p1.getZ()};
            double d = this.align_p1.getX() / DXFUtils.vectorValue(dArray);
            d = Math.toDegrees(Math.acos(d));
            return d;
        }
        return this.rotation;
    }

    @Override
    public TextDocument getTextDocument() {
        return this.textDoc;
    }

    @Override
    public void setText(String string) {
        this.text = string;
        this.textDoc = DXFTextParser.parseDXFMText(this);
    }

    public int getAlignment() {
        return this.attachmentpointLocation;
    }

    @Override
    public boolean isOmitLineType() {
        return true;
    }

    @Override
    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        int n = this.textDoc.getMaximumLineLength();
        if (n > 0) {
            double d = this.getHeight();
            if (d == 0.0) {
                d = this.getReferenceHeight();
            }
            double d2 = (double)n * 0.7 * d;
            d *= (double)this.textDoc.getLineCount();
            switch (this.attachmentpointLocation) {
                case 8: {
                    bounds.addToBounds(this.p.getX() + d2 / 2.0, this.p.getY() + d, this.p.getZ());
                    bounds.addToBounds(this.p.getX() - d2 / 2.0, this.p.getY(), this.p.getZ());
                    break;
                }
                case 7: {
                    bounds.addToBounds(this.p.getX() + d2, this.p.getY() + d, this.p.getZ());
                    bounds.addToBounds(this.p.getX(), this.p.getY(), this.p.getZ());
                    break;
                }
                case 9: {
                    bounds.addToBounds(this.p.getX() - d2, this.p.getY() + d, this.p.getZ());
                    bounds.addToBounds(this.p.getX(), this.p.getY(), this.p.getZ());
                    break;
                }
                case 5: {
                    bounds.addToBounds(this.p.getX() + d2 / 2.0, this.p.getY() + d / 2.0, this.p.getZ());
                    bounds.addToBounds(this.p.getX() - d2 / 2.0, this.p.getY() - d / 2.0, this.p.getZ());
                    break;
                }
                case 4: {
                    bounds.addToBounds(this.p.getX(), this.p.getY() + d / 2.0, this.p.getZ());
                    bounds.addToBounds(this.p.getX() + d2, this.p.getY() - d / 2.0, this.p.getZ());
                    break;
                }
                case 6: {
                    bounds.addToBounds(this.p.getX(), this.p.getY() + d / 2.0, this.p.getZ());
                    bounds.addToBounds(this.p.getX() - d2, this.p.getY() - d / 2.0, this.p.getZ());
                    break;
                }
                case 1: {
                    bounds.addToBounds(this.p.getX(), this.p.getY(), this.p.getZ());
                    bounds.addToBounds(this.p.getX() + d2, this.p.getY() - d, this.p.getZ());
                    break;
                }
                case 2: {
                    bounds.addToBounds(this.p.getX() + d2 / 2.0, this.p.getY(), this.p.getZ());
                    bounds.addToBounds(this.p.getX() - d2 / 2.0, this.p.getY() - d, this.p.getZ());
                    break;
                }
                case 3: {
                    bounds.addToBounds(this.p.getX(), this.p.getY(), this.p.getZ());
                    bounds.addToBounds(this.p.getX() - d2, this.p.getY() - d, this.p.getZ());
                }
            }
        } else {
            bounds.setValid(false);
        }
        return bounds;
    }
}

