/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf.helpers;

import gama.dependencies.kabeja.dxf.DXFMText;
import gama.dependencies.kabeja.dxf.DXFText;
import gama.dependencies.kabeja.dxf.helpers.DXFUtils;
import gama.dependencies.kabeja.dxf.helpers.StyledTextParagraph;
import gama.dependencies.kabeja.dxf.helpers.TextDocument;
import java.util.Stack;
import java.util.StringTokenizer;

public class DXFTextParser {
    public static TextDocument parseDXFMText(DXFMText dXFMText) {
        TextDocument textDocument = new TextDocument();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StyledTextParagraph styledTextParagraph = new StyledTextParagraph();
        styledTextParagraph.setFontHeight(dXFMText.getHeight());
        styledTextParagraph.setInsertPoint(dXFMText.getInsertPoint());
        switch (dXFMText.getAlignment()) {
            case 1: {
                styledTextParagraph.setValign(2);
                break;
            }
            case 2: {
                styledTextParagraph.setValign(2);
                break;
            }
            case 3: {
                styledTextParagraph.setValign(2);
                break;
            }
            case 4: {
                styledTextParagraph.setValign(4);
                break;
            }
            case 5: {
                styledTextParagraph.setValign(4);
                break;
            }
            case 6: {
                styledTextParagraph.setValign(4);
                break;
            }
            case 7: {
                styledTextParagraph.setValign(1);
                break;
            }
            case 8: {
                styledTextParagraph.setValign(1);
                break;
            }
            case 9: {
                styledTextParagraph.setValign(1);
                break;
            }
            default: {
                styledTextParagraph.setValign(1);
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        Stack<StyledTextParagraph> stack = new Stack<StyledTextParagraph>();
        int n = 0;
        String string = dXFMText.getText();
        char c = ' ';
        string = DXFTextParser.parseSymbols(string);
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '\\': {
                    if (bl) {
                        if (!bl3) {
                            DXFTextParser.parseStyledTextParagraphSettings(c, stringBuilder2.toString(), styledTextParagraph);
                            stringBuilder2.delete(0, stringBuilder2.length());
                            bl = true;
                            bl2 = true;
                            break;
                        }
                        stringBuilder.append(c2);
                        bl = false;
                        break;
                    }
                    bl = true;
                    bl2 = true;
                    bl3 = false;
                    break;
                }
                case '~': {
                    if (!bl) break;
                    stringBuilder.append(c2);
                    bl = false;
                    bl2 = false;
                    break;
                }
                case ';': {
                    if (bl) {
                        DXFTextParser.parseStyledTextParagraphSettings(c, stringBuilder2.toString(), styledTextParagraph);
                        stringBuilder2.delete(0, stringBuilder2.length());
                        bl = false;
                        bl3 = true;
                        bl2 = false;
                        break;
                    }
                    stringBuilder.append(c2);
                    break;
                }
                case '}': {
                    if (bl && bl2) {
                        stringBuilder.append(c2);
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    if (bl) {
                        stringBuilder2.append(c2);
                        break;
                    }
                    textDocument.addStyledParagraph(styledTextParagraph);
                    styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                    if (stack.size() <= 0) break;
                    styledTextParagraph = (StyledTextParagraph)stack.pop();
                    break;
                }
                case '{': {
                    if (bl && bl2) {
                        stringBuilder.append(c2);
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    if (bl) {
                        stringBuilder2.append(c2);
                        break;
                    }
                    if (n2 == 0) break;
                    stack.add(styledTextParagraph);
                    styledTextParagraph = new StyledTextParagraph();
                    break;
                }
                case 'O': {
                    if (bl && bl2) {
                        styledTextParagraph.setText(stringBuilder.toString());
                        stringBuilder.delete(0, stringBuilder.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        styledTextParagraph.setOverline(true);
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    if (bl) {
                        stringBuilder2.append(c2);
                        break;
                    }
                    stringBuilder.append(c2);
                    break;
                }
                case 'o': {
                    if (bl && bl2) {
                        styledTextParagraph.setText(stringBuilder.toString());
                        stringBuilder.delete(0, stringBuilder.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        styledTextParagraph.setOverline(false);
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    if (bl) {
                        stringBuilder2.append(c2);
                        break;
                    }
                    stringBuilder.append(c2);
                    break;
                }
                case 'u': {
                    if (bl && bl2) {
                        styledTextParagraph.setText(stringBuilder.toString());
                        stringBuilder.delete(0, stringBuilder.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        styledTextParagraph.setUnderline(false);
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    if (bl) {
                        stringBuilder2.append(c2);
                        break;
                    }
                    stringBuilder.append(c2);
                    break;
                }
                case 'L': {
                    if (bl && bl2) {
                        styledTextParagraph.setText(stringBuilder.toString());
                        stringBuilder.delete(0, stringBuilder.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        styledTextParagraph.setUnderline(true);
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    if (bl) {
                        stringBuilder2.append(c2);
                        break;
                    }
                    stringBuilder.append(c2);
                    break;
                }
                case 'l': {
                    if (bl && bl2) {
                        styledTextParagraph.setText(stringBuilder.toString());
                        stringBuilder.delete(0, stringBuilder.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        styledTextParagraph.setUnderline(false);
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    if (bl) {
                        stringBuilder2.append(c2);
                        break;
                    }
                    stringBuilder.append(c2);
                    break;
                }
                case 'P': {
                    if (bl && bl2) {
                        ++n;
                        styledTextParagraph.setText(stringBuilder.toString());
                        stringBuilder.delete(0, stringBuilder.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        bl = false;
                        bl2 = false;
                        styledTextParagraph.setLineIndex(n);
                        styledTextParagraph.setNewline(true);
                        break;
                    }
                    if (bl) {
                        stringBuilder2.append(c2);
                        break;
                    }
                    stringBuilder.append(c2);
                    break;
                }
                default: {
                    if (bl) {
                        if (bl2) {
                            c = c2;
                            bl2 = false;
                            break;
                        }
                        stringBuilder2.append(c2);
                        break;
                    }
                    stringBuilder.append(c2);
                }
            }
            ++n2;
        }
        if (bl) {
            DXFTextParser.parseStyledTextParagraphSettings(c, stringBuilder2.toString(), styledTextParagraph);
        }
        if (stringBuilder.length() > 0) {
            styledTextParagraph.setText(stringBuilder.toString());
            textDocument.addStyledParagraph(styledTextParagraph);
        }
        if (textDocument.getParagraphCount() == 0) {
            textDocument.addStyledParagraph(styledTextParagraph);
        }
        return textDocument;
    }

    protected static StyledTextParagraph createParagraphFromParent(StyledTextParagraph styledTextParagraph) {
        StyledTextParagraph styledTextParagraph2 = new StyledTextParagraph();
        styledTextParagraph2.setValign(styledTextParagraph.getValign());
        styledTextParagraph2.setBold(styledTextParagraph.isBold());
        styledTextParagraph2.setFont(styledTextParagraph.getFont());
        styledTextParagraph2.setItalic(styledTextParagraph.isItalic());
        styledTextParagraph2.setUnderline(styledTextParagraph.isUnderline());
        styledTextParagraph2.setOverline(styledTextParagraph.isOverline());
        styledTextParagraph2.setWidth(styledTextParagraph.getWidth());
        styledTextParagraph2.setFontHeight(styledTextParagraph.getFontHeight());
        styledTextParagraph2.setInsertPoint(styledTextParagraph.getInsertPoint());
        return styledTextParagraph2;
    }

    public static TextDocument parseDXFText(DXFText dXFText) {
        TextDocument textDocument = new TextDocument();
        StringBuilder stringBuilder = new StringBuilder();
        StyledTextParagraph styledTextParagraph = new StyledTextParagraph();
        styledTextParagraph.setFontHeight(dXFText.getHeight());
        styledTextParagraph.setInsertPoint(dXFText.getAlignmentPoint());
        switch (dXFText.getValign()) {
            case 0: {
                if (dXFText.getAlign() == 4) {
                    styledTextParagraph.setValign(4);
                    break;
                }
                styledTextParagraph.setValign(1);
                break;
            }
            case 1: {
                styledTextParagraph.setValign(1);
                break;
            }
            case 2: {
                styledTextParagraph.setValign(4);
                break;
            }
            case 3: {
                styledTextParagraph.setValign(2);
            }
        }
        if (dXFText.getAlign() == 3 || dXFText.getAlign() == 5) {
            double d = DXFUtils.distance(dXFText.getInsertPoint(), dXFText.getAlignmentPoint());
            styledTextParagraph.setWidth(d);
        }
        String string = DXFTextParser.parseSymbols(dXFText.getText());
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '%') {
                ++n;
            } else if (n == 0) {
                stringBuilder.append(c);
            } else if (n == 2) {
                switch (c) {
                    case 'o': {
                        styledTextParagraph.setText(stringBuilder.toString());
                        styledTextParagraph.setUnderline(bl2);
                        styledTextParagraph.setOverline(bl);
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        stringBuilder.delete(0, stringBuilder.length());
                        bl = !bl;
                        styledTextParagraph.setOverline(bl);
                        break;
                    }
                    case 'u': {
                        styledTextParagraph.setText(stringBuilder.toString());
                        styledTextParagraph.setUnderline(bl2);
                        styledTextParagraph.setOverline(bl);
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        stringBuilder.delete(0, stringBuilder.length());
                        bl2 = !bl2;
                        styledTextParagraph.setUnderline(bl2);
                    }
                }
                n = 0;
            }
            ++n2;
        }
        if (n == 1 || n == 3) {
            stringBuilder.append('%');
        }
        if (stringBuilder.length() > 0) {
            styledTextParagraph.setText(stringBuilder.toString());
            textDocument.addStyledParagraph(styledTextParagraph);
        }
        return textDocument;
    }

    public static void parseStyledTextParagraphSettings(char c, String string, StyledTextParagraph styledTextParagraph) {
        switch (c) {
            case 'A': {
                styledTextParagraph.setValign(Integer.parseInt(string));
                break;
            }
            case 'H': {
                if (string.endsWith("x")) {
                    styledTextParagraph.setFontHeight(styledTextParagraph.getFontHeight() * Double.parseDouble(string.substring(0, string.length() - 1)));
                    break;
                }
                styledTextParagraph.setFontHeight(Double.parseDouble(string));
                break;
            }
            case 'Q': {
                styledTextParagraph.setObliquiAngle(Double.parseDouble(string));
                break;
            }
            case 'W': {
                styledTextParagraph.setWidth(Double.parseDouble(string));
                break;
            }
            case 'T': {
                styledTextParagraph.setCharacterspace(Double.parseDouble(string));
                break;
            }
            case 'f': {
                DXFTextParser.parseFontSettings(string.trim(), styledTextParagraph);
                break;
            }
            case 'F': {
                styledTextParagraph.setFontFile(string.trim());
                break;
            }
        }
    }

    public static void parseFontSettings(String string, StyledTextParagraph styledTextParagraph) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        styledTextParagraph.setFont(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = string2.charAt(0);
            int n = Integer.parseInt(string2.substring(1));
            switch (c) {
                case 'b': {
                    styledTextParagraph.setBold(n == 1);
                    break;
                }
                case 'i': {
                    styledTextParagraph.setItalic(n == 1);
                    break;
                }
                case 'c': {
                    break;
                }
            }
        }
    }

    public static String parseSymbols(String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '%') {
                if (n == 2) {
                    stringBuilder.append('%');
                    n = 0;
                } else {
                    ++n;
                }
            } else if (c == '^') {
                bl = true;
            } else if (bl) {
                if (Character.isWhitespace(c)) {
                    stringBuilder.append('^');
                }
                bl = false;
            } else if (c == '\\') {
                if (string.length() > n2 + 6 && string.charAt(n2 + 1) == 'U' && string.charAt(n2 + 2) == '+') {
                    var6_6 = string.substring(n2 + 3, n2 + 7);
                    int n3 = Integer.parseInt((String)var6_6, 16);
                    stringBuilder.append((char)n3);
                    n2 += 6;
                } else {
                    stringBuilder.append('\\');
                }
            } else {
                switch (n) {
                    case 0: {
                        stringBuilder.append(c);
                        break;
                    }
                    case 1: {
                        stringBuilder.append('%');
                        n = 0;
                        break;
                    }
                    case 2: {
                        switch (c) {
                            case 'd': {
                                stringBuilder.append('\u00b0');
                                break;
                            }
                            case 'c': {
                                stringBuilder.append('\u2205');
                                break;
                            }
                            case 'p': {
                                stringBuilder.append('\u00b1');
                                break;
                            }
                            default: {
                                if (Character.isDigit(c) && n2 + 2 < string.length()) {
                                    var6_6 = "" + c + string.charAt(n2 + 1) + string.charAt(n2 + 2);
                                    try {
                                        c = (char)Integer.parseInt((String)var6_6);
                                        stringBuilder.append(c);
                                        n2 += 2;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        stringBuilder.append('?');
                                        ++n2;
                                    }
                                    break;
                                }
                                stringBuilder.append("%%");
                                stringBuilder.append(c);
                            }
                        }
                        n = 0;
                        break;
                    }
                    case 3: {
                        stringBuilder.append('%');
                        n = 0;
                        break;
                    }
                }
            }
            ++n2;
        }
        if (n == 1 || n == 3) {
            stringBuilder.append('%');
        }
        return stringBuilder.toString();
    }
}

