/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf.helpers;

import gama.dependencies.kabeja.dxf.DXFPolyline;
import gama.dependencies.kabeja.dxf.DXFVertex;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.dxf.helpers.Vector;
import gama.dependencies.kabeja.math.MathUtils;

public class PolylineSegment {
    public static double DELTA = 0.001;
    private boolean bulged = false;
    private Point point1 = new Point();
    private Point point2 = new Point();
    private Point point3 = new Point();
    private Point point4 = new Point();
    private double radius;
    private double bulgeHeight;
    private double innerRadius;
    private double outerRadius;
    private final DXFVertex start;
    private final DXFPolyline p;

    public PolylineSegment(DXFVertex dXFVertex, DXFVertex dXFVertex2, DXFPolyline dXFPolyline) {
        this.start = dXFVertex;
        this.p = dXFPolyline;
        if (this.start.getBulge() != 0.0) {
            double d = MathUtils.distance(dXFVertex.getPoint(), dXFVertex2.getPoint());
            this.radius = this.getRadius(Math.abs(dXFVertex.getBulge()), d);
            this.bulgeHeight = dXFVertex.getBulge() * d / 2.0;
            this.setBulged(true);
            this.createCurvedTrapezium(dXFVertex, dXFVertex2, this.radius, d);
        } else {
            this.createTrapezium(dXFVertex, dXFVertex2);
        }
    }

    public double getBulge() {
        return this.start.getBulge();
    }

    public boolean isBulged() {
        return this.bulged;
    }

    public void setBulged(boolean bl) {
        this.bulged = bl;
    }

    public Point getPoint1() {
        return this.point1;
    }

    public void setPoint1(Point point) {
        this.point1 = point;
    }

    public Point getPoint2() {
        return this.point2;
    }

    public void setPoint2(Point point) {
        this.point2 = point;
    }

    public Point getPoint3() {
        return this.point3;
    }

    public void setPoint3(Point point) {
        this.point3 = point;
    }

    public Point getPoint4() {
        return this.point4;
    }

    public void setPoint4(Point point) {
        this.point4 = point;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    protected void createCurvedTrapezium(DXFVertex dXFVertex, DXFVertex dXFVertex2, double d, double d2) {
        double d3;
        double d4 = d2 / 2.0;
        Vector vector = MathUtils.getVector(dXFVertex.getPoint(), dXFVertex2.getPoint());
        vector = MathUtils.normalize(vector);
        Point point = MathUtils.getPointOfStraightLine(dXFVertex.getPoint(), vector, d4);
        Vector vector2 = this.p.getExtrusion().getNormal();
        vector2 = MathUtils.crossProduct(vector2, vector);
        vector2 = MathUtils.normalize(vector2);
        double d5 = Math.abs(dXFVertex.getBulge() * d2) / 2.0;
        double d6 = this.p.getRadius(dXFVertex.getBulge(), d2);
        if (dXFVertex.getBulge() > 0.0) {
            d3 = d5 - d6;
            point = MathUtils.getPointOfStraightLine(point, vector2, d3);
        } else {
            d3 = d6 - d5;
            point = MathUtils.getPointOfStraightLine(point, vector2, d3);
        }
        d3 = 0.0;
        d3 = dXFVertex.getStartWidth() > 0.0 ? dXFVertex.getStartWidth() / 2.0 : this.p.getStartWidth() / 2.0;
        if (dXFVertex.getBulge() > 0.0) {
            d3 *= -1.0;
        }
        vector2 = MathUtils.getVector(dXFVertex.getPoint(), point);
        vector2 = MathUtils.normalize(vector2);
        this.point1 = MathUtils.getPointOfStraightLine(dXFVertex.getPoint(), vector2, d3);
        this.point2 = MathUtils.getPointOfStraightLine(dXFVertex.getPoint(), vector2, d3 * -1.0);
        d3 = dXFVertex.getEndWidth() > 0.0 ? dXFVertex.getEndWidth() / 2.0 : this.p.getEndWidth() / 2.0;
        if (dXFVertex.getBulge() > 0.0) {
            d3 *= -1.0;
        }
        vector2 = MathUtils.getVector(dXFVertex2.getPoint(), point);
        vector2 = MathUtils.normalize(vector2);
        this.point3 = MathUtils.getPointOfStraightLine(dXFVertex2.getPoint(), vector2, d3 * -1.0);
        this.point4 = MathUtils.getPointOfStraightLine(dXFVertex2.getPoint(), vector2, d3);
    }

    protected void createTrapezium(DXFVertex dXFVertex, DXFVertex dXFVertex2) {
        double d = 0.0;
        d = dXFVertex.getStartWidth() > 0.0 ? dXFVertex.getStartWidth() / 2.0 : this.p.getStartWidth() / 2.0;
        Vector vector = this.p.getExtrusion().getNormal();
        Vector vector2 = MathUtils.getVector(dXFVertex.getPoint(), dXFVertex2.getPoint());
        vector = MathUtils.crossProduct(vector, vector2);
        vector = MathUtils.normalize(vector);
        this.point1 = MathUtils.getPointOfStraightLine(dXFVertex.getPoint(), vector, d);
        this.point2 = MathUtils.getPointOfStraightLine(dXFVertex.getPoint(), vector, -1.0 * d);
        d = dXFVertex.getEndWidth() > 0.0 ? dXFVertex.getEndWidth() / 2.0 : this.p.getEndWidth() / 2.0;
        this.point3 = MathUtils.getPointOfStraightLine(dXFVertex2.getPoint(), vector, -1.0 * d);
        this.point4 = MathUtils.getPointOfStraightLine(dXFVertex2.getPoint(), vector, d);
    }

    protected double getRadius(double d, double d2) {
        double d3 = d * d2 / 2.0;
        return d3 / 2.0 + Math.pow(d2, 2.0) / (8.0 * d3);
    }

    public double getBulgeHeight() {
        return this.bulgeHeight;
    }

    public void connect(PolylineSegment polylineSegment) {
        Vector vector;
        Vector vector2 = MathUtils.getVector(this.point1, this.point4);
        double d = MathUtils.getAngle(vector2, vector = MathUtils.getVector(polylineSegment.getPoint4(), polylineSegment.getPoint1()));
        if (Math.abs(d) > DELTA) {
            Point point = MathUtils.getIntersection(this.point1, vector2, polylineSegment.getPoint4(), vector);
            this.setPoint4(point);
            polylineSegment.setPoint1(point);
            vector2 = MathUtils.getVector(this.point2, this.point3);
            vector = MathUtils.getVector(polylineSegment.getPoint3(), polylineSegment.getPoint2());
            point = MathUtils.getIntersection(this.point2, vector2, polylineSegment.getPoint3(), vector);
            this.setPoint3(point);
            polylineSegment.setPoint2(point);
        }
    }

    public double getInnerRadius() {
        double d = (this.start.getStartWidth() + this.start.getEndWidth()) / 2.0;
        if (d == 0.0) {
            d = (this.p.getStartWidth() + this.p.getEndWidth()) / 2.0;
        }
        return this.getRadius() - d;
    }

    public double getOuterRadius() {
        double d = (this.start.getStartWidth() + this.start.getEndWidth()) / 2.0;
        if (d == 0.0) {
            d = (this.p.getStartWidth() + this.p.getEndWidth()) / 2.0;
        }
        return this.getRadius() + d;
    }
}

