/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.CommonEntityData;
import gama.dependencies.osmosis.Entity;
import gama.dependencies.osmosis.EntityType;
import gama.dependencies.osmosis.OsmUser;
import gama.dependencies.osmosis.StoreClassRegister;
import gama.dependencies.osmosis.StoreReader;
import gama.dependencies.osmosis.StoreWriter;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;

public class Bound
extends Entity
implements Comparable<Bound> {
    private static final double MIN_LATITUDE = -90.0;
    private static final double MAX_LATITUDE = 90.0;
    private static final double MIN_LONGITUDE = -180.0;
    private static final double MAX_LONGITUDE = 180.0;
    private final double right;
    private final double left;
    private final double top;
    private final double bottom;
    private final String origin;

    public Bound(String string) {
        this(180.0, -180.0, 90.0, -90.0, string);
    }

    public Bound(double d, double d2, double d3, double d4, String string) {
        super(new CommonEntityData(0L, 0, new Date(), OsmUser.NONE, 0L));
        if (Double.compare(d, 181.0) > 0 || Double.compare(d, -181.0) < 0 || Double.compare(d2, 181.0) > 0 || Double.compare(d2, -181.0) < 0 || Double.compare(d3, 91.0) > 0 || Double.compare(d3, -91.0) < 0 || Double.compare(d4, 91.0) > 0 || Double.compare(d4, -91.0) < 0) {
            throw new IllegalArgumentException("Bound coordinates outside of valid range");
        }
        if (Double.compare(d3, d4) < 0) {
            throw new IllegalArgumentException("Bound top < bottom");
        }
        this.right = d;
        this.left = d2;
        this.top = d3;
        this.bottom = d4;
        this.origin = string;
    }

    public Bound(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        super(storeReader, storeClassRegister);
        this.right = storeReader.readDouble();
        this.left = storeReader.readDouble();
        this.top = storeReader.readDouble();
        this.bottom = storeReader.readDouble();
        this.origin = storeReader.readString();
    }

    @Override
    public void store(StoreWriter storeWriter, StoreClassRegister storeClassRegister) {
        super.store(storeWriter, storeClassRegister);
        storeWriter.writeDouble(this.right);
        storeWriter.writeDouble(this.left);
        storeWriter.writeDouble(this.top);
        storeWriter.writeDouble(this.bottom);
        storeWriter.writeString(this.origin);
    }

    @Override
    public EntityType getType() {
        return EntityType.Bound;
    }

    public double getRight() {
        return this.right;
    }

    public double getLeft() {
        return this.left;
    }

    public double getTop() {
        return this.top;
    }

    public double getBottom() {
        return this.bottom;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Bound intersect(Bound bound) {
        boolean bl;
        double d = 0.0;
        double d2 = 0.0;
        if (bound == null) {
            return null;
        }
        double d3 = Math.min(this.getTop(), bound.getTop());
        double d4 = Math.max(this.getBottom(), bound.getBottom());
        if (Double.compare(d4, d3) >= 0) {
            return null;
        }
        boolean bl2 = Double.compare(bound.getLeft(), bound.getRight()) > 0;
        boolean bl3 = bl = Double.compare(this.getLeft(), this.getRight()) > 0;
        if (bl2 && bl || !bl2 && !bl) {
            d = Math.min(this.getRight(), bound.getRight());
            d2 = Math.max(this.getLeft(), bound.getLeft());
            if (!bl2 && !bl && Double.compare(d2, d) >= 0) {
                return null;
            }
        } else {
            Bound bound2;
            Bound bound3;
            if (bl2 && !bl) {
                bound3 = this;
                bound2 = bound;
            } else {
                bound3 = bound;
                bound2 = this;
            }
            if (Double.compare(bound3.getRight(), bound2.getLeft()) > 0 && Double.compare(bound3.getLeft(), bound2.getRight()) < 0) {
                Double d5 = bound3.getRight() - bound3.getLeft();
                Double d6 = bound2.getRight() - -180.0 + 180.0 - bound2.getLeft();
                if (Double.compare(d5, d6) <= 0) {
                    d = bound3.getRight();
                    d2 = bound3.getLeft();
                } else {
                    d = bound2.getRight();
                    d2 = bound2.getLeft();
                }
            } else if (Double.compare(bound3.getRight(), bound2.getLeft()) > 0) {
                d = bound3.getRight();
                d2 = bound2.getLeft();
            } else if (Double.compare(bound3.getLeft(), bound2.getRight()) < 0) {
                d = bound2.getRight();
                d2 = bound3.getLeft();
            }
        }
        if (Double.compare(d, d2) == 0) {
            return null;
        }
        String string = !"".equals(this.origin) ? this.origin : bound.origin;
        return new Bound(d, d2, d3, d4, string);
    }

    public Bound union(Bound bound) {
        double d = 0.0;
        double d2 = 0.0;
        if (bound == null) {
            return this;
        }
        double d3 = Math.max(this.getTop(), bound.getTop());
        double d4 = Math.min(this.getBottom(), bound.getBottom());
        if (Double.compare(d4, d3) >= 0) {
            return null;
        }
        if (Double.compare(this.getLeft(), -180.0) == 0 && Double.compare(this.getRight(), 180.0) == 0 || Double.compare(bound.getLeft(), -180.0) == 0 && Double.compare(bound.getRight(), 180.0) == 0) {
            d = 180.0;
            d2 = -180.0;
        } else {
            boolean bl;
            boolean bl2 = Double.compare(bound.getLeft(), bound.getRight()) > 0;
            boolean bl3 = bl = Double.compare(this.getLeft(), this.getRight()) > 0;
            if (bl2 && bl) {
                d = Math.max(this.getRight(), bound.getRight());
                d2 = Math.min(this.getLeft(), bound.getLeft());
            } else if (!bl2 && !bl) {
                double d5;
                double d6 = Math.max(this.getRight(), bound.getRight()) - Math.min(this.getLeft(), bound.getLeft());
                if (Double.compare(d6, d5 = Math.min(this.getRight(), bound.getRight()) - -180.0 + (180.0 - Math.max(this.getLeft(), bound.getLeft()))) <= 0) {
                    d = Math.max(this.getRight(), bound.getRight());
                    d2 = Math.min(this.getLeft(), bound.getLeft());
                } else {
                    d = Math.min(this.getRight(), bound.getRight());
                    d2 = Math.max(this.getLeft(), bound.getLeft());
                }
            } else {
                Bound bound2;
                Bound bound3;
                if (bl2 && !bl) {
                    bound3 = bound;
                    bound2 = this;
                } else {
                    bound3 = this;
                    bound2 = bound;
                }
                if (Double.compare(bound3.getRight(), bound2.getLeft()) >= 0 && Double.compare(bound3.getLeft(), bound2.getRight()) <= 0) {
                    d2 = -180.0;
                    d = 180.0;
                } else {
                    double d7;
                    double d8 = Math.max(bound3.getRight(), bound2.getRight()) - -180.0 + (180.0 - bound3.getLeft());
                    if (Double.compare(d8, d7 = bound3.getRight() - -180.0 + (180.0 - Math.min(bound3.getLeft(), bound2.getLeft()))) <= 0) {
                        d = Math.max(bound3.getRight(), bound2.getRight());
                        d2 = bound3.getLeft();
                    } else {
                        d = bound3.getRight();
                        d2 = Math.min(bound3.getLeft(), bound2.getLeft());
                    }
                }
            }
        }
        if (Double.compare(d, d2) == 0) {
            return null;
        }
        String string = this.getOrigin() != null && !this.getOrigin().equals("") ? this.getOrigin() : bound.getOrigin();
        return new Bound(d, d2, d3, d4, string);
    }

    public Iterable<Bound> toSimpleBound() {
        LinkedList<Bound> linkedList = new LinkedList<Bound>();
        if (Double.compare(this.getLeft(), this.getRight()) < 0) {
            linkedList.add(this);
        } else {
            linkedList.add(new Bound(180.0, this.getLeft(), this.getTop(), this.getBottom(), this.getOrigin()));
            linkedList.add(new Bound(this.getRight(), -180.0, this.getTop(), this.getBottom(), this.getOrigin()));
        }
        return Collections.unmodifiableCollection(linkedList);
    }

    @Override
    public int compareTo(Bound bound) {
        double d = 0.0;
        double d2 = 0.0;
        for (Bound object2 : this.toSimpleBound()) {
            d += (object2.getRight() - object2.getLeft()) * (object2.getTop() - object2.getBottom());
        }
        for (Bound bound2 : bound.toSimpleBound()) {
            d2 += (bound2.getRight() - bound2.getLeft()) * (bound2.getTop() - bound2.getBottom());
        }
        int n = Double.compare(d, d2);
        if (n != 0) {
            return n;
        }
        n = Double.compare(this.getTop(), bound.getTop());
        if (n != 0) {
            return n;
        }
        n = Double.compare(this.getBottom(), bound.getBottom());
        if (n != 0) {
            return n;
        }
        n = Double.compare(this.getLeft(), bound.getLeft());
        if (n != 0) {
            return n;
        }
        n = Double.compare(this.getRight(), bound.getRight());
        if (n != 0) {
            return n;
        }
        String string = this.getOrigin();
        String string2 = bound.getOrigin();
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    public boolean equals(Object object) {
        if (object instanceof Bound) {
            return this.compareTo((Bound)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getId() + this.getVersion();
    }

    @Override
    public Bound getWriteableInstance() {
        return this;
    }

    public String toString() {
        return "Bound(top=" + this.getTop() + ", bottom=" + this.getBottom() + ", left=" + this.getLeft() + ", right=" + this.getRight() + ")";
    }
}

