/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.StoreClassRegister;
import gama.dependencies.osmosis.StoreReader;
import gama.dependencies.osmosis.StoreWriter;
import gama.dependencies.osmosis.Storeable;

public class WayNode
implements Comparable<WayNode>,
Storeable {
    public static final String METADATA_KEY_LOCATION_INCLUDED = "way_node.location_included";
    private final long nodeId;
    private double latitude;
    private double longitude;

    public WayNode(long l) {
        this.nodeId = l;
    }

    public WayNode(long l, double d, double d2) {
        this(l);
        this.latitude = d;
        this.longitude = d2;
    }

    public WayNode(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        this(storeReader.readLong(), storeReader.readDouble(), storeReader.readDouble());
    }

    @Override
    public void store(StoreWriter storeWriter, StoreClassRegister storeClassRegister) {
        storeWriter.writeLong(this.nodeId);
        storeWriter.writeDouble(this.latitude);
        storeWriter.writeDouble(this.longitude);
    }

    @Override
    public int compareTo(WayNode wayNode) {
        long l = this.nodeId - wayNode.nodeId;
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        return "WayNode(nodeID=" + this.getNodeId() + ")";
    }
}

