/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.common;

import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;

public class GamaNetworkException
extends GamaRuntimeException {
    public static final String CONNECTION_FAILURE = "Network cannot be reached! Check that your server is connected.";
    public static final String DISCONNECTION_FAILURE = "Cannot be disconnected!";
    public static final String SUBSCRIBE_FAILURE = "Cannot subscribe to the expected topic!";
    public static final String SENDING_FAILURE = "Cannot send the message to agent!";
    private static final long serialVersionUID = 1L;

    protected GamaNetworkException(IScope iScope, String string, boolean bl) {
        super(iScope, string, bl);
    }

    public static GamaNetworkException cannotBeDisconnectedFailure(IScope iScope) {
        return new GamaNetworkException(iScope, DISCONNECTION_FAILURE, false);
    }

    public static GamaNetworkException cannotBeConnectedFailure(IScope iScope) {
        return new GamaNetworkException(iScope, CONNECTION_FAILURE, false);
    }

    public static GamaNetworkException cannotSubscribeToTopic(IScope iScope, String string) {
        return new GamaNetworkException(iScope, "Cannot subscribe to the expected topic!\n" + string, false);
    }

    public static GamaNetworkException cannotSendMessage(IScope iScope, String string) {
        return new GamaNetworkException(iScope, "Cannot send the message to agent! to " + string, false);
    }

    public static GamaNetworkException cannotUnsuscribeToTopic(IScope iScope, String string) {
        return new GamaNetworkException(iScope, "Cannot send the message to agent! to " + string, false);
    }
}

