/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.serialize.binary;

import gama.core.common.interfaces.ISerialisationConstants;
import gama.core.common.util.FileUtils;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.serialize.binary.BinarySerialiser;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.nustaq.serialization.FSTConfiguration;

public class BinarySerialisation
implements ISerialisationConstants {
    private static FSTConfiguration FST = FSTConfiguration.createDefaultConfiguration();
    private static BinarySerialiser PROCESSOR = new BinarySerialiser();

    public static Object createFromFile(IScope iScope, String string) {
        try {
            return BinarySerialisation.createFromBytes(iScope, Files.readAllBytes(Path.of(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)true), new String[0])));
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create((Throwable)iOException, (IScope)iScope);
        }
    }

    public static Object createFromString(IScope iScope, String string) {
        if (string == null || string.isBlank()) {
            return null;
        }
        try {
            return BinarySerialisation.createFromBytes(iScope, string.getBytes(STRING_BYTE_ARRAY_CHARSET));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                return BinarySerialisation.createFromFile(iScope, string);
            }
            catch (Throwable throwable2) {
                throw GamaRuntimeException.create((Throwable)throwable2, (IScope)iScope);
            }
        }
    }

    public static Object createFromBytes(IScope iScope, byte[] byArray) {
        return PROCESSOR.createObjectFromBytes(iScope, byArray);
    }

    public static void restoreFromFile(IAgent iAgent, String string) {
        try {
            BinarySerialisation.restoreFromBytes(iAgent, Files.readAllBytes(Path.of(string, new String[0])));
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create((Throwable)iOException, (IScope)iAgent.getScope());
        }
    }

    public static void restoreFromString(IAgent iAgent, String string) {
        try {
            BinarySerialisation.restoreFromBytes(iAgent, string.getBytes(STRING_BYTE_ARRAY_CHARSET));
        }
        catch (Throwable throwable) {
            try {
                BinarySerialisation.restoreFromFile(iAgent, string);
            }
            catch (Throwable throwable2) {
                GAMA.reportAndThrowIfNeeded((IScope)iAgent.getScope(), (GamaRuntimeException)GamaRuntimeException.create((Throwable)throwable2, (IScope)iAgent.getScope()), (boolean)true);
            }
        }
    }

    public static void restoreFromBytes(IAgent iAgent, byte[] byArray) throws IOException {
        PROCESSOR.restoreAgentFromBytes(iAgent, byArray);
    }

    public static final void saveToFile(IScope iScope, Object object, String string, boolean bl) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStream outputStream = Files.newOutputStream(new File(string).toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                if (object instanceof SimulationAgent) {
                    SimulationAgent simulationAgent = (SimulationAgent)object;
                    simulationAgent.setAttribute("**serialise_history**", (Object)bl);
                }
                outputStream.write(BinarySerialisation.saveToBytes(iScope, object));
                if (object instanceof SimulationAgent) {
                    SimulationAgent simulationAgent = (SimulationAgent)object;
                    simulationAgent.setAttribute("**serialise_history**", (Object)false);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create((Throwable)iOException, (IScope)iScope);
        }
    }

    public static final String saveToString(IScope iScope, Object object) {
        return new String(BinarySerialisation.saveToBytes(iScope, object), STRING_BYTE_ARRAY_CHARSET);
    }

    public static final byte[] saveToBytes(IScope iScope, Object object) {
        return PROCESSOR.saveObjectToBytes(iScope, object);
    }

    public static final byte[] saveToBytes(Object object) {
        return BinarySerialisation.saveToBytes(GAMA.getRuntimeScope(), object);
    }
}

