/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import gama.core.metamodel.agent.IAgent;
import gama.dev.DEBUG;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.FSTObjectRegistry;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.VersionConflictListener;
import org.nustaq.serialization.coders.Unknown;
import org.nustaq.serialization.util.FSTUtil;

public class FSTObjectInput
implements ObjectInput {
    public static boolean REGISTER_ENUMS_READ = false;
    public static ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
    protected FSTDecoder codec;
    protected FSTObjectRegistry objects;
    protected Stack<String> debugStack;
    protected int curDepth;
    protected ArrayList<CallbackEntry> callbacks;
    protected boolean ignoreAnnotations;
    protected FSTClazzInfoRegistry clInfoRegistry;
    protected ConditionalCallback conditionalCallback;
    protected int readExternalReadAHead = 8000;
    protected VersionConflictListener versionConflictListener;
    protected FSTConfiguration conf;
    protected boolean isCrossPlatform;
    protected FSTClazzInfo.FSTFieldInfo infoCache;
    protected boolean closed = false;
    protected MyObjectStream fakeWrapper;

    public FSTConfiguration getConf() {
        return this.conf;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.getCodec().readPlainBytes(byArray, n, n2);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.getCodec().skip(n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.getCodec().readFByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.getCodec().readFByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.getCodec().readFByte() + 256 & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return this.getCodec().readFShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() + 65536 & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        return this.getCodec().readFChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.getCodec().readFInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.getCodec().readFLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.getCodec().readFFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.getCodec().readFDouble();
    }

    @Override
    public String readLine() throws IOException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String readUTF() throws IOException {
        return this.getCodec().readStringUTF();
    }

    public FSTDecoder getCodec() {
        return this.codec;
    }

    protected void setCodec(FSTDecoder fSTDecoder) {
        this.codec = fSTDecoder;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public FSTObjectInput(FSTConfiguration fSTConfiguration) {
        this(emptyStream, fSTConfiguration);
    }

    public FSTObjectInput(InputStream inputStream, FSTConfiguration fSTConfiguration) {
        this.setCodec(fSTConfiguration.createStreamDecoder());
        this.getCodec().setInputStream(inputStream);
        this.isCrossPlatform = fSTConfiguration.isCrossPlatform();
        this.initRegistries(fSTConfiguration);
        this.conf = fSTConfiguration;
    }

    public Class<?> getClassForName(String string) throws ClassNotFoundException {
        return this.getCodec().classForName(string);
    }

    protected void initRegistries(FSTConfiguration fSTConfiguration) {
        this.ignoreAnnotations = fSTConfiguration.getCLInfoRegistry().isIgnoreAnnotations();
        this.clInfoRegistry = fSTConfiguration.getCLInfoRegistry();
        this.objects = (FSTObjectRegistry)fSTConfiguration.getCachedObject(FSTObjectRegistry.class);
        if (this.objects == null) {
            this.objects = new FSTObjectRegistry(fSTConfiguration);
        } else {
            this.objects.clearForRead(fSTConfiguration);
        }
    }

    public ConditionalCallback getConditionalCallback() {
        return this.conditionalCallback;
    }

    public void setConditionalCallback(ConditionalCallback conditionalCallback) {
        this.conditionalCallback = conditionalCallback;
    }

    public int getReadExternalReadAHead() {
        return this.readExternalReadAHead;
    }

    public void setReadExternalReadAHead(int n) {
        this.readExternalReadAHead = n;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        try {
            return this.readObject(null);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public int read() throws IOException {
        return this.getCodec().readIntByte();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.getCodec().readPlainBytes(byArray, 0, byArray.length);
        return byArray.length;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.getCodec().readPlainBytes(byArray, n, n2);
        return byArray.length;
    }

    @Override
    public long skip(long l) throws IOException {
        this.getCodec().skip((int)l);
        return l;
    }

    @Override
    public int available() throws IOException {
        return this.getCodec().available();
    }

    protected void processValidation() throws InvalidObjectException {
        if (this.callbacks == null) {
            return;
        }
        Collections.sort(this.callbacks, (callbackEntry, callbackEntry2) -> callbackEntry2.prio - callbackEntry.prio);
        for (CallbackEntry callbackEntry3 : this.callbacks) {
            try {
                callbackEntry3.cb.validateObject();
            }
            catch (Exception exception) {
                FSTUtil.rethrow(exception);
            }
        }
    }

    public Object readObject(Class<?> ... classArray) throws Exception {
        ++this.curDepth;
        if (this.isCrossPlatform) {
            return this.readObjectInternal(new Class[0]);
        }
        try {
            Class<?> clazz;
            if (classArray != null && classArray.length > 1) {
                Class<?>[] classArray2 = classArray;
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    clazz = classArray2[n2];
                    this.getCodec().registerClass(clazz);
                    ++n2;
                }
            }
            clazz = this.readObjectInternal(classArray);
            this.processValidation();
            Class<?> clazz2 = clazz;
            return clazz2;
        }
        catch (Throwable throwable) {
            FSTUtil.rethrow(throwable);
        }
        finally {
            --this.curDepth;
        }
        return null;
    }

    public Object readObjectInternal(Class<?> ... classArray) {
        try {
            FSTClazzInfo.FSTFieldInfo fSTFieldInfo = this.infoCache;
            this.infoCache = null;
            if (fSTFieldInfo == null) {
                fSTFieldInfo = new FSTClazzInfo.FSTFieldInfo(classArray, null, this.ignoreAnnotations);
            } else {
                fSTFieldInfo.possibleClasses = classArray;
            }
            Object object = this.readObjectWithHeader(fSTFieldInfo);
            this.infoCache = fSTFieldInfo;
            return object;
        }
        catch (Throwable throwable) {
            FSTUtil.rethrow(throwable);
            return null;
        }
    }

    public Object readObjectWithHeader(FSTClazzInfo.FSTFieldInfo fSTFieldInfo) throws Exception {
        Class clazz;
        FSTClazzInfo fSTClazzInfo;
        int n = this.getCodec().getInputPos();
        byte by = this.getCodec().readObjectHeaderTag();
        if (by == 0) {
            fSTClazzInfo = this.readClass();
            clazz = fSTClazzInfo.getClazz();
            if (clazz.isArray()) {
                return this.readArrayNoHeader(fSTFieldInfo, n, clazz);
            }
        } else if (by == -3) {
            clazz = fSTFieldInfo.getType();
            fSTClazzInfo = this.getClazzInfo(clazz, fSTFieldInfo);
        } else if (by >= 1) {
            try {
                clazz = fSTFieldInfo.getPossibleClasses()[by - 1];
                fSTClazzInfo = this.getClazzInfo(clazz, fSTFieldInfo);
            }
            catch (Throwable throwable) {
                fSTClazzInfo = null;
                clazz = null;
                FSTUtil.rethrow(throwable);
            }
        } else {
            Object object = this.instantiateSpecialTag(fSTFieldInfo, n, by);
            return object;
        }
        try {
            FSTObjectSerializer fSTObjectSerializer = fSTClazzInfo.getSer();
            if (fSTObjectSerializer != null) {
                Object object = this.instantiateAndReadWithSer(clazz, fSTObjectSerializer, fSTClazzInfo, fSTFieldInfo, n);
                this.getCodec().readArrayEnd(fSTClazzInfo);
                return object;
            }
            Object object = this.instantiateAndReadNoSer(clazz, fSTClazzInfo, fSTFieldInfo, n);
            return object;
        }
        catch (Exception exception) {
            FSTUtil.rethrow(exception);
            return null;
        }
    }

    protected Object instantiateSpecialTag(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n, byte by) throws Exception {
        switch (by) {
            case -4: {
                String string = this.getCodec().readStringUTF();
                this.objects.registerObjectForRead(string, n);
                return string;
            }
            case -9: {
                return this.instantiateBigInt();
            }
            case -1: {
                return null;
            }
        }
        switch (by) {
            case -10: {
                return this.getCodec().readFLong();
            }
            case -17: {
                return Boolean.FALSE;
            }
            case -16: {
                return Boolean.TRUE;
            }
            case -18: {
                return fSTFieldInfo.getOneOf()[this.getCodec().readFByte()];
            }
            case -8: {
                Object object = this.getCodec().getDirectObject();
                this.objects.registerObjectForRead(object, n);
                return object;
            }
            case -2: {
                Object object = this.getCodec().getDirectObject();
                if (object.getClass() == byte[].class && fSTFieldInfo != null && fSTFieldInfo.getType() == boolean[].class) {
                    byte[] byArray = (byte[])object;
                    boolean[] blArray = new boolean[byArray.length];
                    int n2 = 0;
                    while (n2 < blArray.length) {
                        blArray[n2] = byArray[n2] != 0;
                        ++n2;
                    }
                    object = blArray;
                }
                this.objects.registerObjectForRead(object, n);
                return object;
            }
            case -7: {
                Object object = this.instantiateHandle(fSTFieldInfo);
                this.getCodec().readObjectEnd();
                return object;
            }
            case -5: {
                Object object = this.instantiateArray(fSTFieldInfo, n);
                return object;
            }
            case -6: {
                return this.instantiateEnum(fSTFieldInfo, n);
            }
        }
        throw new RuntimeException("unknown object tag " + by);
    }

    protected FSTClazzInfo getClazzInfo(Class<?> clazz, FSTClazzInfo.FSTFieldInfo fSTFieldInfo) {
        FSTClazzInfo fSTClazzInfo;
        FSTClazzInfo fSTClazzInfo2 = fSTFieldInfo.lastInfo;
        if (fSTClazzInfo2 != null && fSTClazzInfo2.clazz == clazz && fSTClazzInfo2.conf == this.conf) {
            fSTClazzInfo = fSTClazzInfo2;
        } else {
            fSTFieldInfo.lastInfo = fSTClazzInfo = this.clInfoRegistry.getCLInfo(clazz, this.conf);
        }
        return fSTClazzInfo;
    }

    protected Object instantiateHandle(FSTClazzInfo.FSTFieldInfo fSTFieldInfo) throws IOException {
        int n = this.getCodec().readFInt();
        Object object = this.objects.getReadRegisteredObject(n);
        if (object == null) {
            DEBUG.OUT((Object)"");
            throw new IOException("unable to ressolve handle " + n + " " + fSTFieldInfo.getDesc() + " " + this.getCodec().getInputPos());
        }
        return object;
    }

    protected Object instantiateArray(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
        Object object = this.readArray(fSTFieldInfo, n);
        return object;
    }

    protected Object instantiateEnum(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException, ClassNotFoundException {
        FSTClazzInfo fSTClazzInfo = this.readClass();
        int n2 = this.getCodec().readFInt();
        Object[] objectArray = fSTClazzInfo.getEnumConstants();
        if (objectArray == null) {
            return null;
        }
        Object object = objectArray[n2];
        if (REGISTER_ENUMS_READ && !fSTFieldInfo.isFlat()) {
            this.objects.registerObjectForRead(object, n);
        }
        return object;
    }

    protected Object instantiateBigInt() throws IOException {
        int n = this.getCodec().readFInt();
        return n;
    }

    protected Object instantiateAndReadWithSer(Class<?> clazz, FSTObjectSerializer fSTObjectSerializer, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
        boolean bl = false;
        Object object = fSTObjectSerializer.instantiate(clazz, this, fSTClazzInfo, fSTFieldInfo, n);
        if (object == null) {
            object = fSTClazzInfo.newInstance(this.getCodec().isMapBased());
        } else {
            bl = true;
        }
        if (object == null) {
            throw new IOException(fSTFieldInfo.getDesc() + ":Failed to instantiate '" + clazz.getName() + "'. Register a custom serializer implementing instantiate or define empty constructor..");
        }
        if ("REALLY_NULL".equals(object)) {
            object = null;
        } else {
            if (object.getClass() != clazz) {
                clazz = object.getClass();
                fSTClazzInfo = this.clInfoRegistry.getCLInfo(clazz, this.conf);
            }
            if (!(fSTFieldInfo.isFlat() || fSTClazzInfo.isFlat() || fSTObjectSerializer.alwaysCopy())) {
                this.objects.registerObjectForRead(object, n);
            }
            if (!bl) {
                fSTObjectSerializer.readObject(this, object, fSTClazzInfo, fSTFieldInfo);
            }
        }
        this.getCodec().consumeEndMarker();
        return object;
    }

    protected Object instantiateAndReadNoSer(Class<?> clazz, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
        boolean bl;
        Object object = fSTClazzInfo.newInstance(this.getCodec().isMapBased());
        if (object == null) {
            throw new IOException(fSTFieldInfo.getDesc() + ":Failed to instantiate '" + clazz.getName() + "'. Register a custom serializer implementing instantiate or define empty constructor.");
        }
        boolean bl2 = bl = !fSTFieldInfo.isFlat() && !fSTClazzInfo.isFlat();
        if (bl) {
            this.objects.registerObjectForRead(object, n);
        }
        if (fSTClazzInfo.isExternalizable()) {
            int n2 = n;
            this.getCodec().ensureReadAhead(this.readExternalReadAHead);
            ((Externalizable)object).readExternal(this);
            this.getCodec().readExternalEnd();
            if (fSTClazzInfo.getReadResolveMethod() != null) {
                Object object2 = object;
                if ((object = this.handleReadRessolve(fSTClazzInfo, object)) != object2 && bl) {
                    this.objects.replace(object2, object, n2);
                }
            }
        } else if (fSTClazzInfo.useCompatibleMode()) {
            Object object3 = this.readObjectCompatible(fSTFieldInfo, fSTClazzInfo, object);
            if (object3 != null && object3 != object) {
                this.objects.replace(object, object3, n);
                object = object3;
            }
        } else {
            FSTClazzInfo.FSTFieldInfo[] fSTFieldInfoArray = fSTClazzInfo.getFieldInfo();
            this.readObjectFields(fSTFieldInfo, fSTClazzInfo, fSTFieldInfoArray, object, 0, 0);
        }
        return object;
    }

    protected Object readObjectCompatible(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, FSTClazzInfo fSTClazzInfo, Object object) throws Exception {
        Class clazz = fSTClazzInfo.getClazz();
        this.readObjectCompatibleRecursive(fSTFieldInfo, object, fSTClazzInfo, clazz);
        if (object != null && fSTClazzInfo.getReadResolveMethod() != null) {
            object = this.handleReadRessolve(fSTClazzInfo, object);
        }
        return object;
    }

    protected Object handleReadRessolve(FSTClazzInfo fSTClazzInfo, Object object) throws IllegalAccessException {
        Object object2 = null;
        try {
            object2 = fSTClazzInfo.getReadResolveMethod().invoke(object, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            FSTUtil.rethrow(invocationTargetException);
        }
        object = object2;
        return object;
    }

    protected void readObjectCompatibleRecursive(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, Object object, FSTClazzInfo fSTClazzInfo, Class<?> clazz) throws Exception {
        FSTClazzInfo.FSTCompatibilityInfo fSTCompatibilityInfo = fSTClazzInfo.getCompInfo().get(clazz);
        if (!Serializable.class.isAssignableFrom(clazz)) {
            return;
        }
        this.readObjectCompatibleRecursive(fSTFieldInfo, object, fSTClazzInfo, clazz.getSuperclass());
        if (fSTCompatibilityInfo != null && fSTCompatibilityInfo.getReadMethod() != null) {
            try {
                byte by = this.readByte();
                if (by == 66) {
                    this.getCodec().moveTo(this.getCodec().getInputPos() - 1);
                }
                ObjectInputStream objectInputStream = this.getObjectInputStream(clazz, fSTClazzInfo, fSTFieldInfo, object);
                fSTCompatibilityInfo.getReadMethod().invoke(object, objectInputStream);
                this.fakeWrapper.pop();
            }
            catch (Exception exception) {
                FSTUtil.rethrow(exception);
            }
        } else if (fSTCompatibilityInfo != null) {
            byte by = this.readByte();
            if (by == 55 && (by = this.readByte()) == 77) {
                FSTClazzInfo.FSTFieldInfo[] fSTFieldInfoArray;
                HashMap hashMap = (HashMap)this.readObjectInternal(HashMap.class);
                FSTClazzInfo.FSTFieldInfo[] fSTFieldInfoArray2 = fSTFieldInfoArray = fSTCompatibilityInfo.getFieldArray();
                int n = fSTFieldInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FSTClazzInfo.FSTFieldInfo fSTFieldInfo2 = fSTFieldInfoArray2[n2];
                    Object v = hashMap.get(fSTFieldInfo2.getName());
                    if (v != null) {
                        fSTFieldInfo2.setObjectValue(object, v);
                    }
                    ++n2;
                }
                return;
            }
            this.readObjectFields(fSTFieldInfo, fSTClazzInfo, fSTCompatibilityInfo.getFieldArray(), object, 0, 0);
        }
    }

    public void defaultReadObject(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, FSTClazzInfo fSTClazzInfo, Object object) {
        try {
            this.readObjectFields(fSTFieldInfo, fSTClazzInfo, fSTClazzInfo.getFieldInfo(), object, 0, -1);
        }
        catch (Exception exception) {
            FSTUtil.rethrow(exception);
        }
    }

    protected void readObjectFields(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo[] fSTFieldInfoArray, Object object, int n, int n2) throws Exception {
        if (this.getCodec().isMapBased()) {
            this.readFieldsMapBased(fSTFieldInfo, fSTClazzInfo, object);
            if (n2 >= 0) {
                this.getCodec().readObjectEnd();
            }
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = 0;
        int n4 = 8;
        int n5 = fSTFieldInfoArray.length;
        int n6 = 0;
        int n7 = n;
        while (n7 < n5) {
            try {
                FSTClazzInfo.FSTFieldInfo fSTFieldInfo2 = fSTFieldInfoArray[n7];
                if (fSTFieldInfo2.getVersion() > n2) {
                    int n8 = this.getCodec().readVersionTag();
                    if (n8 == 0) {
                        this.oldVersionRead(object);
                        return;
                    }
                    if (n8 != fSTFieldInfo2.getVersion()) {
                        throw new RuntimeException("read version tag " + n8 + " fieldInfo has " + fSTFieldInfo2.getVersion());
                    }
                    this.readObjectFields(fSTFieldInfo, fSTClazzInfo, fSTFieldInfoArray, object, n7, n8);
                    return;
                }
                if (fSTFieldInfo2.isPrimitive()) {
                    int n9 = fSTFieldInfo2.getIntegralType();
                    if (n9 == 1) {
                        if (n4 == 8) {
                            n3 = this.getCodec().readFByte() + 256 & 0xFF;
                            n4 = 0;
                        }
                        boolean bl = (n3 & 0x80) != 0;
                        n3 <<= 1;
                        ++n4;
                        fSTFieldInfo2.setBooleanValue(object, bl);
                    } else {
                        switch (n9) {
                            case 2: {
                                fSTFieldInfo2.setByteValue(object, this.getCodec().readFByte());
                                break;
                            }
                            case 3: {
                                fSTFieldInfo2.setCharValue(object, this.getCodec().readFChar());
                                break;
                            }
                            case 4: {
                                fSTFieldInfo2.setShortValue(object, this.getCodec().readFShort());
                                break;
                            }
                            case 5: {
                                fSTFieldInfo2.setIntValue(object, this.getCodec().readFInt());
                                break;
                            }
                            case 6: {
                                fSTFieldInfo2.setLongValue(object, this.getCodec().readFLong());
                                break;
                            }
                            case 7: {
                                fSTFieldInfo2.setFloatValue(object, this.getCodec().readFFloat());
                                break;
                            }
                            case 8: {
                                fSTFieldInfo2.setDoubleValue(object, this.getCodec().readFDouble());
                            }
                        }
                    }
                } else if (fSTFieldInfo2.isConditional() && n6 == 0 && this.skipConditional(object, n6 = this.getCodec().readPlainInt(), fSTFieldInfo2)) {
                    this.getCodec().moveTo(n6);
                } else {
                    Object object2 = this.readObjectWithHeader(fSTFieldInfo2);
                    fSTFieldInfo2.setObjectValue(object, object2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException);
            }
            ++n7;
        }
        this.getCodec().readVersionTag();
    }

    public VersionConflictListener getVersionConflictListener() {
        return this.versionConflictListener;
    }

    public void setVersionConflictListener(VersionConflictListener versionConflictListener) {
        this.versionConflictListener = versionConflictListener;
    }

    protected void oldVersionRead(Object object) {
        if (this.versionConflictListener != null) {
            this.versionConflictListener.onOldVersionRead(object);
        }
    }

    protected void readFieldsMapBased(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, FSTClazzInfo fSTClazzInfo, Object object) throws Exception {
        int n = this.getCodec().getObjectHeaderLen();
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        int n2 = 0;
        boolean bl = object.getClass() == Unknown.class;
        boolean bl2 = bl && this.getCodec().inArray();
        this.getCodec().startFieldReading(object);
        block10: while (n2 < n) {
            Object object2;
            Object object3;
            if (bl2) {
                object3 = this.readObjectWithHeader(null);
                if (object3 != null && this.getCodec().isEndMarker(object3.toString())) {
                    return;
                }
                ((Unknown)object).add(object3);
                continue;
            }
            String string = this.getCodec().readStringUTF();
            if (n == Integer.MAX_VALUE && this.getCodec().isEndMarker(string)) {
                return;
            }
            ++n2;
            if (bl) {
                object3 = new FSTClazzInfo.FSTFieldInfo(null, null, true);
                ((FSTClazzInfo.FSTFieldInfo)object3).fakeName = string;
                object2 = this.readObjectWithHeader((FSTClazzInfo.FSTFieldInfo)object3);
                ((Unknown)object).set(string, object2);
                continue;
            }
            object3 = fSTClazzInfo.getFieldInfo(string, null);
            if (object3 == null) {
                DEBUG.OUT((Object)("warning: unknown field: " + string + " on class " + fSTClazzInfo.getClazz().getName()));
                continue;
            }
            if (((FSTClazzInfo.FSTFieldInfo)object3).isPrimitive()) {
                switch (((FSTClazzInfo.FSTFieldInfo)object3).getIntegralType()) {
                    case 1: {
                        ((FSTClazzInfo.FSTFieldInfo)object3).setBooleanValue(object, this.getCodec().readFByte() != 0);
                        continue block10;
                    }
                    case 2: {
                        ((FSTClazzInfo.FSTFieldInfo)object3).setByteValue(object, this.getCodec().readFByte());
                        continue block10;
                    }
                    case 3: {
                        ((FSTClazzInfo.FSTFieldInfo)object3).setCharValue(object, this.getCodec().readFChar());
                        continue block10;
                    }
                    case 4: {
                        ((FSTClazzInfo.FSTFieldInfo)object3).setShortValue(object, this.getCodec().readFShort());
                        continue block10;
                    }
                    case 5: {
                        ((FSTClazzInfo.FSTFieldInfo)object3).setIntValue(object, this.getCodec().readFInt());
                        continue block10;
                    }
                    case 6: {
                        ((FSTClazzInfo.FSTFieldInfo)object3).setLongValue(object, this.getCodec().readFLong());
                        continue block10;
                    }
                    case 7: {
                        ((FSTClazzInfo.FSTFieldInfo)object3).setFloatValue(object, this.getCodec().readFFloat());
                        continue block10;
                    }
                    case 8: {
                        ((FSTClazzInfo.FSTFieldInfo)object3).setDoubleValue(object, this.getCodec().readFDouble());
                        continue block10;
                    }
                    default: {
                        throw new RuntimeException("unkown primitive type " + String.valueOf(object3));
                    }
                }
            }
            object2 = this.readObjectWithHeader((FSTClazzInfo.FSTFieldInfo)object3);
            object2 = this.getCodec().coerceElement(((FSTClazzInfo.FSTFieldInfo)object3).getType(), object2);
            ((FSTClazzInfo.FSTFieldInfo)object3).setObjectValue(object, object2);
        }
        this.getCodec().endFieldReading(object);
    }

    protected boolean skipConditional(Object object, int n, FSTClazzInfo.FSTFieldInfo fSTFieldInfo) {
        if (this.conditionalCallback != null) {
            return this.conditionalCallback.shouldSkip(object, n, fSTFieldInfo.getField());
        }
        return false;
    }

    protected void readCompatibleObjectFields(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo[] fSTFieldInfoArray, Map<String, Object> map) throws Exception {
        int n = 0;
        int n2 = 8;
        FSTClazzInfo.FSTFieldInfo[] fSTFieldInfoArray2 = fSTFieldInfoArray;
        int n3 = fSTFieldInfoArray.length;
        int n4 = 0;
        while (n4 < n3) {
            FSTClazzInfo.FSTFieldInfo fSTFieldInfo2 = fSTFieldInfoArray2[n4];
            try {
                if (fSTFieldInfo2.isIntegral() && !fSTFieldInfo2.isArray()) {
                    var11_11 = fSTFieldInfo2.getType();
                    if (var11_11 == Boolean.TYPE) {
                        if (n2 == 8) {
                            n = this.getCodec().readFByte() + 256 & 0xFF;
                            n2 = 0;
                        }
                        boolean bl = (n & 0x80) != 0;
                        n <<= 1;
                        ++n2;
                        map.put(fSTFieldInfo2.getName(), bl);
                    }
                    if (var11_11 == Byte.TYPE) {
                        map.put(fSTFieldInfo2.getName(), this.getCodec().readFByte());
                    } else if (var11_11 == Character.TYPE) {
                        map.put(fSTFieldInfo2.getName(), Character.valueOf(this.getCodec().readFChar()));
                    } else if (var11_11 == Short.TYPE) {
                        map.put(fSTFieldInfo2.getName(), this.getCodec().readFShort());
                    } else if (var11_11 == Integer.TYPE) {
                        map.put(fSTFieldInfo2.getName(), this.getCodec().readFInt());
                    } else if (var11_11 == Double.TYPE) {
                        map.put(fSTFieldInfo2.getName(), this.getCodec().readFDouble());
                    } else if (var11_11 == Float.TYPE) {
                        map.put(fSTFieldInfo2.getName(), Float.valueOf(this.getCodec().readFFloat()));
                    } else if (var11_11 == Long.TYPE) {
                        map.put(fSTFieldInfo2.getName(), this.getCodec().readFLong());
                    }
                } else {
                    var11_11 = this.readObjectWithHeader(fSTFieldInfo2);
                    map.put(fSTFieldInfo2.getName(), var11_11);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException);
            }
            ++n4;
        }
    }

    public String readStringUTF() throws IOException {
        return this.getCodec().readStringUTF();
    }

    public String readStringAsc() throws IOException {
        return this.getCodec().readStringAsc();
    }

    protected Object readArray(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
        Object object = this.getCodec().readArrayHeader();
        if (n < 0) {
            n = this.getCodec().getInputPos();
        }
        if (!(object instanceof Class)) {
            return object;
        }
        Object object2 = this.readArrayNoHeader(fSTFieldInfo, n, (Class)object);
        this.getCodec().readArrayEnd(null);
        return object2;
    }

    protected Object readArrayNoHeader(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n, Class<?> clazz) throws Exception {
        int n2 = this.getCodec().readFInt();
        if (n2 == -1) {
            return null;
        }
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2.isArray()) {
            Object[] objectArray = (Object[])Array.newInstance(clazz2, n2);
            if (!fSTFieldInfo.isFlat()) {
                this.objects.registerObjectForRead(objectArray, n);
            }
            FSTClazzInfo.FSTFieldInfo fSTFieldInfo2 = new FSTClazzInfo.FSTFieldInfo(fSTFieldInfo.getPossibleClasses(), null, this.clInfoRegistry.isIgnoreAnnotations());
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                objectArray[n3] = object = this.readArray(fSTFieldInfo2, -1);
                ++n3;
            }
            return objectArray;
        }
        Object object = Array.newInstance(clazz2, n2);
        if (!fSTFieldInfo.isFlat()) {
            this.objects.registerObjectForRead(object, n);
        }
        if (clazz2.isPrimitive()) {
            return this.getCodec().readFPrimitiveArray(object, clazz2, n2);
        }
        Object[] objectArray = (Object[])object;
        int n4 = 0;
        while (n4 < n2) {
            Object object2 = this.readObjectWithHeader(fSTFieldInfo);
            objectArray[n4] = object2 = this.getCodec().coerceElement(clazz2, object2);
            ++n4;
        }
        this.getCodec().readObjectEnd();
        return object;
    }

    public void registerObject(Object object, int n, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo) {
        if (object instanceof IAgent) {
            DEBUG.OUT((Object)"");
        }
        if (!(this.objects.disabled || fSTFieldInfo.isFlat() || fSTClazzInfo != null && fSTClazzInfo.isFlat())) {
            this.objects.registerObjectForRead(object, n);
        }
    }

    public FSTClazzInfo readClass() throws IOException, ClassNotFoundException {
        return this.getCodec().readClass();
    }

    protected void resetAndClearRefs() {
        try {
            this.reset();
            this.objects.clearForRead(this.conf);
        }
        catch (IOException iOException) {
            FSTUtil.rethrow(iOException);
        }
    }

    public void reset() throws IOException {
        this.getCodec().reset();
    }

    public void resetForReuse(InputStream inputStream) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.getCodec().reset();
        this.getCodec().setInputStream(inputStream);
        this.objects.clearForRead(this.conf);
        this.callbacks = null;
    }

    public void resetForReuseCopyArray(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.getCodec().reset();
        this.objects.clearForRead(this.conf);
        this.getCodec().resetToCopyOf(byArray, n, n2);
        this.callbacks = null;
    }

    public void resetForReuseUseArray(byte[] byArray) throws IOException {
        this.resetForReuseUseArray(byArray, byArray.length);
    }

    public void resetForReuseUseArray(byte[] byArray, int n) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.objects.clearForRead(this.conf);
        this.getCodec().resetWith(byArray, n);
        this.callbacks = null;
    }

    public final int readFInt() throws IOException {
        return this.getCodec().readFInt();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.resetAndClearRefs();
        this.conf.returnObject(this.objects);
        this.getCodec().close();
    }

    protected ObjectInputStream getObjectInputStream(final Class<?> clazz, final FSTClazzInfo fSTClazzInfo, final FSTClazzInfo.FSTFieldInfo fSTFieldInfo, final Object object) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(){
            HashMap<String, Object> fieldMap;

            @Override
            public Object readObjectOverride() throws IOException, ClassNotFoundException {
                try {
                    byte by = FSTObjectInput.this.readByte();
                    if (by != -19) {
                        Constructor<?>[] constructorArray = OptionalDataException.class.getDeclaredConstructors();
                        FSTObjectInput.this.pushBack(1);
                        Constructor<?>[] constructorArray2 = constructorArray;
                        int n = constructorArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Constructor<?> constructor = constructorArray2[n2];
                            Class<?>[] classArray = constructor.getParameterTypes();
                            if (classArray != null && classArray.length == 1 && classArray[0] == Integer.TYPE) {
                                constructor.setAccessible(true);
                                try {
                                    OptionalDataException optionalDataException = (OptionalDataException)constructor.newInstance(0);
                                    throw optionalDataException;
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    break;
                                }
                            }
                            ++n2;
                        }
                        throw new EOFException("if your code relies on this, think");
                    }
                    return FSTObjectInput.this.readObjectInternal(fSTFieldInfo.getPossibleClasses());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    throw new IOException(reflectiveOperationException);
                }
            }

            @Override
            public Object readUnshared() throws IOException, ClassNotFoundException {
                try {
                    return FSTObjectInput.this.readObjectInternal(fSTFieldInfo.getPossibleClasses());
                }
                catch (RuntimeException runtimeException) {
                    throw new IOException(runtimeException);
                }
            }

            @Override
            public void defaultReadObject() throws IOException, ClassNotFoundException {
                try {
                    byte by = this.readByte();
                    if (by == 77) {
                        this.fieldMap = (HashMap)FSTObjectInput.this.readObjectInternal(HashMap.class);
                        for (String string : this.fieldMap.keySet()) {
                            FSTClazzInfo.FSTFieldInfo fSTFieldInfo2 = fSTClazzInfo.getFieldInfo(string, null);
                            if (fSTFieldInfo2 == null) continue;
                            fSTFieldInfo2.setObjectValue(object, this.fieldMap.get(string));
                        }
                    } else {
                        FSTObjectInput.this.readObjectFields(fSTFieldInfo, fSTClazzInfo, fSTClazzInfo.getCompInfo().get(clazz).getFieldArray(), object, 0, 0);
                    }
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
            }

            @Override
            public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
                byte by = this.readByte();
                try {
                    FSTClazzInfo.FSTCompatibilityInfo fSTCompatibilityInfo = fSTClazzInfo.getCompInfo().get(clazz);
                    if (by == 99 || by == 66) {
                        this.fieldMap = new HashMap();
                        FSTObjectInput.this.readCompatibleObjectFields(fSTFieldInfo, fSTClazzInfo, fSTCompatibilityInfo.getFieldArray(), this.fieldMap);
                        FSTObjectInput.this.getCodec().readVersionTag();
                    } else {
                        this.fieldMap = (HashMap)FSTObjectInput.this.readObjectInternal(HashMap.class);
                    }
                }
                catch (Exception exception) {
                    FSTUtil.rethrow(exception);
                }
                return new ObjectInputStream.GetField(){

                    @Override
                    public ObjectStreamClass getObjectStreamClass() {
                        return ObjectStreamClass.lookup(clazz);
                    }

                    @Override
                    public boolean defaulted(String string) throws IOException {
                        return fieldMap.get(string) == null;
                    }

                    @Override
                    public boolean get(String string, boolean bl) throws IOException {
                        if (fieldMap.get(string) == null) {
                            return bl;
                        }
                        return (Boolean)fieldMap.get(string);
                    }

                    @Override
                    public byte get(String string, byte by) throws IOException {
                        if (fieldMap.get(string) == null) {
                            return by;
                        }
                        return (Byte)fieldMap.get(string);
                    }

                    @Override
                    public char get(String string, char c) throws IOException {
                        if (fieldMap.get(string) == null) {
                            return c;
                        }
                        return ((Character)fieldMap.get(string)).charValue();
                    }

                    @Override
                    public short get(String string, short s) throws IOException {
                        if (fieldMap.get(string) == null) {
                            return s;
                        }
                        return (Short)fieldMap.get(string);
                    }

                    @Override
                    public int get(String string, int n) throws IOException {
                        if (fieldMap.get(string) == null) {
                            return n;
                        }
                        return (Integer)fieldMap.get(string);
                    }

                    @Override
                    public long get(String string, long l) throws IOException {
                        if (fieldMap.get(string) == null) {
                            return l;
                        }
                        return (Long)fieldMap.get(string);
                    }

                    @Override
                    public float get(String string, float f) throws IOException {
                        if (fieldMap.get(string) == null) {
                            return f;
                        }
                        return ((Float)fieldMap.get(string)).floatValue();
                    }

                    @Override
                    public double get(String string, double d) throws IOException {
                        if (fieldMap.get(string) == null) {
                            return d;
                        }
                        return (Double)fieldMap.get(string);
                    }

                    @Override
                    public Object get(String string, Object object) throws IOException {
                        Object object2 = fieldMap.get(string);
                        if (object2 == null) {
                            return object;
                        }
                        return object2;
                    }
                };
            }

            @Override
            public void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
                if (FSTObjectInput.this.callbacks == null) {
                    FSTObjectInput.this.callbacks = new ArrayList();
                }
                FSTObjectInput.this.callbacks.add(new CallbackEntry(objectInputValidation, n));
            }

            @Override
            public int read() throws IOException {
                return FSTObjectInput.this.getCodec().readFByte();
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                return FSTObjectInput.this.read(byArray, n, n2);
            }

            @Override
            public int available() throws IOException {
                return FSTObjectInput.this.available();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean readBoolean() throws IOException {
                return FSTObjectInput.this.readBoolean();
            }

            @Override
            public byte readByte() throws IOException {
                return FSTObjectInput.this.getCodec().readFByte();
            }

            @Override
            public int readUnsignedByte() throws IOException {
                return FSTObjectInput.this.readUnsignedByte();
            }

            @Override
            public char readChar() throws IOException {
                return FSTObjectInput.this.getCodec().readFChar();
            }

            @Override
            public short readShort() throws IOException {
                return FSTObjectInput.this.getCodec().readFShort();
            }

            @Override
            public int readUnsignedShort() throws IOException {
                return FSTObjectInput.this.readUnsignedShort();
            }

            @Override
            public int readInt() throws IOException {
                return FSTObjectInput.this.getCodec().readFInt();
            }

            @Override
            public long readLong() throws IOException {
                return FSTObjectInput.this.getCodec().readFLong();
            }

            @Override
            public float readFloat() throws IOException {
                return FSTObjectInput.this.getCodec().readFFloat();
            }

            @Override
            public double readDouble() throws IOException {
                return FSTObjectInput.this.getCodec().readFDouble();
            }

            @Override
            public void readFully(byte[] byArray) throws IOException {
                FSTObjectInput.this.readFully(byArray);
            }

            @Override
            public void readFully(byte[] byArray, int n, int n2) throws IOException {
                FSTObjectInput.this.readFully(byArray, n, n2);
            }

            @Override
            public int skipBytes(int n) throws IOException {
                return FSTObjectInput.this.skipBytes(n);
            }

            @Override
            public String readUTF() throws IOException {
                return FSTObjectInput.this.getCodec().readStringUTF();
            }

            @Override
            public String readLine() throws IOException {
                return FSTObjectInput.this.readLine();
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                return FSTObjectInput.this.read(byArray);
            }

            @Override
            public long skip(long l) throws IOException {
                return FSTObjectInput.this.skip(l);
            }

            @Override
            public void mark(int n) {
                throw new RuntimeException("not implemented");
            }

            @Override
            public void reset() throws IOException {
                FSTObjectInput.this.reset();
            }

            @Override
            public boolean markSupported() {
                return false;
            }
        };
        if (this.fakeWrapper == null) {
            this.fakeWrapper = new MyObjectStream();
        }
        this.fakeWrapper.push(objectInputStream);
        return this.fakeWrapper;
    }

    protected void pushBack(int n) {
        this.getCodec().pushBack(n);
    }

    protected static class CallbackEntry {
        ObjectInputValidation cb;
        int prio;

        CallbackEntry(ObjectInputValidation objectInputValidation, int n) {
            this.cb = objectInputValidation;
            this.prio = n;
        }
    }

    public static interface ConditionalCallback {
        public boolean shouldSkip(Object var1, int var2, Field var3);
    }

    protected static class MyObjectStream
    extends ObjectInputStream {
        ObjectInputStream wrapped;
        ArrayDeque<ObjectInputStream> wrappedStack = new ArrayDeque();

        public void push(ObjectInputStream objectInputStream) {
            this.wrappedStack.push(objectInputStream);
            this.wrapped = objectInputStream;
        }

        public void pop() {
            this.wrapped = this.wrappedStack.pop();
        }

        MyObjectStream() throws IOException, SecurityException {
        }

        @Override
        public Object readObjectOverride() throws IOException, ClassNotFoundException {
            return this.wrapped.readObject();
        }

        @Override
        public Object readUnshared() throws IOException, ClassNotFoundException {
            return this.wrapped.readUnshared();
        }

        @Override
        public void defaultReadObject() throws IOException, ClassNotFoundException {
            this.wrapped.defaultReadObject();
        }

        @Override
        public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
            return this.wrapped.readFields();
        }

        @Override
        public void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
            this.wrapped.registerValidation(objectInputValidation, n);
        }

        @Override
        public int read() throws IOException {
            return this.wrapped.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.wrapped.read(byArray, n, n2);
        }

        @Override
        public int available() throws IOException {
            return this.wrapped.available();
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.wrapped.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.wrapped.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.wrapped.readUnsignedByte();
        }

        @Override
        public char readChar() throws IOException {
            return this.wrapped.readChar();
        }

        @Override
        public short readShort() throws IOException {
            return this.wrapped.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.wrapped.readUnsignedShort();
        }

        @Override
        public int readInt() throws IOException {
            return this.wrapped.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.wrapped.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.wrapped.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.wrapped.readDouble();
        }

        @Override
        public void readFully(byte[] byArray) throws IOException {
            this.wrapped.readFully(byArray);
        }

        @Override
        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            this.wrapped.readFully(byArray, n, n2);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return this.wrapped.skipBytes(n);
        }

        @Override
        public String readUTF() throws IOException {
            return this.wrapped.readUTF();
        }

        @Override
        public String readLine() throws IOException {
            return this.wrapped.readLine();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.wrapped.read(byArray);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.wrapped.skip(l);
        }

        @Override
        public void mark(int n) {
            this.wrapped.mark(n);
        }

        @Override
        public void reset() throws IOException {
            this.wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this.wrapped.markSupported();
        }
    }
}

