/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

import org.nustaq.serialization.util.FSTInt2ObjectMap;
import org.nustaq.serialization.util.FSTObject2IntMap;
import org.nustaq.serialization.util.FSTUtil;

public class DefaultFSTInt2ObjectMap<V>
implements FSTInt2ObjectMap<V> {
    private int[] mKeys;
    private Object[] mValues;
    private int mNumberOfElements;
    private DefaultFSTInt2ObjectMap<V> next;
    private static final int GROWFAC = 2;

    public DefaultFSTInt2ObjectMap(int n) {
        if (n < 2) {
            n = 2;
        }
        n = FSTObject2IntMap.adjustSize(n * 2);
        this.mKeys = new int[n];
        this.mValues = new Object[n];
        this.mNumberOfElements = 0;
    }

    @Override
    public int size() {
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    @Override
    public final void put(int n, V v) {
        int n2 = n & Integer.MAX_VALUE;
        if (n == 0 && v == null) {
            throw new RuntimeException("key value pair not supported " + n + " " + String.valueOf(v));
        }
        this.putHash(n, v, n2, this);
    }

    private static final <V> void putHash(int n, V v, int n2, DefaultFSTInt2ObjectMap<V> defaultFSTInt2ObjectMap, DefaultFSTInt2ObjectMap<V> defaultFSTInt2ObjectMap2) {
        int n3 = 0;
        while (true) {
            int n4;
            if (defaultFSTInt2ObjectMap.mNumberOfElements * 2 > defaultFSTInt2ObjectMap.mKeys.length) {
                if (defaultFSTInt2ObjectMap2 != null && (defaultFSTInt2ObjectMap2.mNumberOfElements + defaultFSTInt2ObjectMap.mNumberOfElements) * 2 > defaultFSTInt2ObjectMap2.mKeys.length) {
                    defaultFSTInt2ObjectMap2.resize(defaultFSTInt2ObjectMap2.mKeys.length * 2);
                    defaultFSTInt2ObjectMap2.put(n, v);
                    return;
                }
                defaultFSTInt2ObjectMap.resize(defaultFSTInt2ObjectMap.mKeys.length * 2);
            }
            if (defaultFSTInt2ObjectMap.mKeys[n4 = n2 % defaultFSTInt2ObjectMap.mKeys.length] == 0 && defaultFSTInt2ObjectMap.mValues[n4] == null) {
                ++defaultFSTInt2ObjectMap.mNumberOfElements;
                defaultFSTInt2ObjectMap.mValues[n4] = v;
                defaultFSTInt2ObjectMap.mKeys[n4] = n;
                return;
            }
            if (defaultFSTInt2ObjectMap.mKeys[n4] == n) {
                defaultFSTInt2ObjectMap.mValues[n4] = v;
                return;
            }
            if (defaultFSTInt2ObjectMap.next == null) {
                if (n3 > 4 && defaultFSTInt2ObjectMap.mNumberOfElements < 5) {
                    var7_7 = defaultFSTInt2ObjectMap.mNumberOfElements * 2 + 1;
                    defaultFSTInt2ObjectMap.next = new DefaultFSTInt2ObjectMap<V>(var7_7);
                    n3 = 0;
                } else {
                    var7_7 = defaultFSTInt2ObjectMap.mNumberOfElements / 3;
                    defaultFSTInt2ObjectMap.next = new DefaultFSTInt2ObjectMap<V>(var7_7);
                }
            }
            defaultFSTInt2ObjectMap2 = defaultFSTInt2ObjectMap;
            defaultFSTInt2ObjectMap = defaultFSTInt2ObjectMap.next;
            ++n3;
        }
    }

    final void putHash(int n, V v, int n2, DefaultFSTInt2ObjectMap<V> defaultFSTInt2ObjectMap) {
        DefaultFSTInt2ObjectMap.putHash(n, v, n2, this, defaultFSTInt2ObjectMap);
    }

    @Override
    public final V get(int n) {
        int n2 = n & Integer.MAX_VALUE;
        return this.getHash(n, n2);
    }

    final V getHash(int n, int n2) {
        int n3 = n2 % this.mKeys.length;
        int n4 = this.mKeys[n3];
        Object object = this.mValues[n3];
        if (n4 == 0 && object == null) {
            return null;
        }
        if (n4 == n) {
            return (V)object;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.getHash(n, n2);
    }

    final void resize(int n) {
        n = FSTObject2IntMap.adjustSize(n);
        int[] nArray = this.mKeys;
        Object[] objectArray = this.mValues;
        this.mKeys = new int[n];
        this.mValues = new Object[n];
        this.mNumberOfElements = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] != 0 || objectArray[n2] != null) {
                this.put(nArray[n2], objectArray[n2]);
            }
            ++n2;
        }
        if (this.next != null) {
            DefaultFSTInt2ObjectMap<V> defaultFSTInt2ObjectMap = this.next;
            this.next = null;
            defaultFSTInt2ObjectMap.rePut(this);
        }
    }

    private void rePut(DefaultFSTInt2ObjectMap<V> defaultFSTInt2ObjectMap) {
        int n = 0;
        while (n < this.mKeys.length) {
            int n2 = this.mKeys[n];
            if (n2 != 0 || this.mValues[n] != null) {
                defaultFSTInt2ObjectMap.put(n2, this.mValues[n]);
            }
            ++n;
        }
        if (this.next != null) {
            this.next.rePut(defaultFSTInt2ObjectMap);
        }
    }

    @Override
    public void clear() {
        int n = this.size();
        if (n == 0) {
            return;
        }
        if (this.mKeys.length > 6 * this.size() && n > 0) {
            if (n < 2) {
                n = 2;
            }
            n = FSTObject2IntMap.adjustSize(n * 2);
            this.mKeys = new int[n];
            this.mValues = new Object[n];
            this.mNumberOfElements = 0;
        } else {
            FSTUtil.clear(this.mKeys);
            FSTUtil.clear(this.mValues);
            this.mNumberOfElements = 0;
            if (this.next != null) {
                this.next.clear();
            }
        }
    }
}

