/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.menus;

import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.extension.serialize.binary.BinarySerialisation;
import gama.ui.experiment.commands.ArrangeDisplayViews;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaCommand;
import java.io.IOException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SimulationsMenu
extends ContributionItem {
    public static final GamaCommand addNewSimulation = new GamaCommand("experiment/experiment.simulations.add", "Add Simulation", "Add a new simulation (with the current parameters) to this experiment", selectionEvent -> {
        SimulationAgent simulationAgent = GAMA.getExperiment().getAgent().createSimulation(new ParametersSet(), true);
        if (simulationAgent == null) {
            return;
        }
        WorkbenchHelper.runInUI((String)"Adding simulation", (int)0, iProgressMonitor -> {
            if ("None".equals(GamaPreferences.Displays.CORE_DISPLAY_LAYOUT.getValue())) {
                ArrangeDisplayViews.execute(2);
            } else {
                ArrangeDisplayViews.execute(GamaPreferences.Displays.LAYOUTS.indexOf(GamaPreferences.Displays.CORE_DISPLAY_LAYOUT.getValue()));
            }
        });
    });
    public static final GamaCommand duplicateCurrentSimulation = new GamaCommand("experiment/experiment.simulations.duplicate", "Duplicate Simulation", "Duplicate the current simulation and add it to the experiment", selectionEvent -> {
        byte[] byArray = BinarySerialisation.saveToBytes((IScope)GAMA.getRuntimeScope(), (Object)GAMA.getSimulation());
        SimulationAgent simulationAgent = GAMA.getExperiment().getAgent().createSimulation(new ParametersSet(), true);
        GAMA.runAndUpdateAll(() -> {
            try {
                BinarySerialisation.restoreFromBytes((IAgent)simulationAgent, (byte[])byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
    });
    public static final GamaCommand killCurrentSimulation = new GamaCommand("experiment/experiment.simulations.kill", "Kill Simulation", "Kill and remove the current simulation from the experiment", selectionEvent -> {
        SimulationAgent simulationAgent = GAMA.getSimulation();
        if (simulationAgent == null) {
            return;
        }
        simulationAgent.primDie(simulationAgent.getScope());
    });
    public static final GamaCommand saveCurrentSimulation = new GamaCommand("experiment/experiment.simulations.save", "Save Simulation...", "Save the current simulation to disk", selectionEvent -> {
        SimulationAgent simulationAgent = GAMA.getSimulation();
        if (simulationAgent == null) {
            return;
        }
        FileDialog fileDialog = new FileDialog(selectionEvent.display.getActiveShell(), 8192);
        fileDialog.setFilterNames(new String[]{"Simulation files"});
        fileDialog.setFilterExtensions(new String[]{"*.simulation"});
        fileDialog.setFileName(simulationAgent.getModel().getName() + "_cycle" + String.valueOf(simulationAgent.getCycle(simulationAgent.getScope())) + ".simulation");
        String string = fileDialog.open();
        BinarySerialisation.saveToFile((IScope)simulationAgent.getScope(), (Object)simulationAgent, (String)string, (boolean)false);
    });
    public static final GamaCommand saveCurrentSimulationAndHistory = new GamaCommand("experiment/experiment.simulations.save.history", "Save Simulation with its History...", "Save the current simulation and its history to disk", selectionEvent -> {
        SimulationAgent simulationAgent = GAMA.getSimulation();
        if (simulationAgent == null) {
            return;
        }
        FileDialog fileDialog = new FileDialog(selectionEvent.display.getActiveShell(), 8192);
        fileDialog.setFilterNames(new String[]{"binary"});
        fileDialog.setFilterExtensions(new String[]{"*.simulation"});
        fileDialog.setFileName(simulationAgent.getModel().getName() + "_" + String.valueOf(simulationAgent.getCycle(simulationAgent.getScope())) + "_cycles.simulation");
        String string = fileDialog.open();
        BinarySerialisation.saveToFile((IScope)simulationAgent.getScope(), (Object)simulationAgent, (String)string, (boolean)true);
    });
    public static final GamaCommand replaceCurrentSimulation = new GamaCommand("experiment/experiment.simulations.load.replace", "Load and Replace Simulation...", "Load a previously saved simulation and replace the current one", selectionEvent -> {
        SimulationAgent simulationAgent = GAMA.getSimulation();
        if (simulationAgent == null) {
            return;
        }
        FileDialog fileDialog = new FileDialog(selectionEvent.display.getActiveShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.simulation"});
        fileDialog.setFilterNames(new String[]{"Simulation files"});
        String string = fileDialog.open();
        if (string != null) {
            GAMA.runAndUpdateAll(() -> BinarySerialisation.restoreFromFile((IAgent)simulationAgent, (String)string));
            GAMA.changeCurrentTopLevelAgent((ITopLevelAgent)simulationAgent, (boolean)true);
        }
    });
    public static final GamaCommand loadNewSimulation = new GamaCommand("experiment/experiment.simulations.load.new", "Load New Simulation...", "Load a previously saved simulation and add it to the experiment", selectionEvent -> {
        FileDialog fileDialog = new FileDialog(selectionEvent.display.getActiveShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.simulation"});
        fileDialog.setFilterNames(new String[]{"Simulation files"});
        String string = fileDialog.open();
        if (string != null) {
            SimulationAgent simulationAgent = GAMA.getExperiment().getAgent().createSimulation(new ParametersSet(), true);
            BinarySerialisation.restoreFromFile((IAgent)simulationAgent, (String)string);
        }
    });

    public SimulationsMenu() {
        this("gama.ui.application.simulations.menu");
    }

    public SimulationsMenu(String string) {
        super(string);
    }

    public void fill(Menu menu, int n) {
        MenuItem menuItem = addNewSimulation.toItem(menu);
        MenuItem menuItem2 = killCurrentSimulation.toItem(menu);
        MenuItem menuItem3 = duplicateCurrentSimulation.toItem(menu);
        GamaMenu.separate((Menu)menu);
        MenuItem menuItem4 = saveCurrentSimulation.toItem(menu);
        MenuItem menuItem5 = saveCurrentSimulationAndHistory.toItem(menu);
        MenuItem menuItem6 = replaceCurrentSimulation.toItem(menu);
        MenuItem menuItem7 = loadNewSimulation.toItem(menu);
        boolean bl = GAMA.getCurrentTopLevelAgent() instanceof IExperimentAgent;
        boolean bl2 = GAMA.getCurrentTopLevelAgent() instanceof SimulationAgent;
        boolean bl3 = bl2 && GAMA.getExperiment() != null && GAMA.getExperiment().isMemorize();
        menuItem.setEnabled(bl || bl2);
        menuItem2.setEnabled(bl2);
        menuItem3.setEnabled(bl2);
        menuItem4.setEnabled(bl2);
        menuItem5.setEnabled(bl3);
        menuItem6.setEnabled(bl2);
        menuItem7.setEnabled(bl || bl2);
    }

    public boolean isDynamic() {
        return true;
    }
}

