/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.displays;

import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.GraphicsHelper;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.editor.ChartEditor;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;

public class SWTChartEditor
implements ChartEditor {
    final Shell shell;
    final JFreeChart chart;
    final SWTTitleEditor titleEditor;
    final SWTPlotEditor plotEditor;
    final SWTOtherEditor otherEditor;

    public SWTChartEditor(Display display, JFreeChart jFreeChart, Point point) {
        this.shell = new Shell(display, 65572);
        this.shell.setSize(400, 500);
        this.chart = jFreeChart;
        this.shell.setText("Chart properties");
        this.shell.setLocation(point);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginLeft = 5;
        this.shell.setLayout((Layout)gridLayout);
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TabFolder tabFolder = new TabFolder(composite, 2048);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" Title ");
        this.titleEditor = new SWTTitleEditor((Composite)tabFolder, 0, (Title)this.chart.getTitle());
        tabItem.setControl((Control)this.titleEditor);
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText(" Plot ");
        this.plotEditor = new SWTPlotEditor((Composite)tabFolder, 0, this.chart.getPlot());
        tabItem2.setControl((Control)this.plotEditor);
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText(" Other ");
        this.otherEditor = new SWTOtherEditor((Composite)tabFolder, 0, this.chart);
        tabItem3.setControl((Control)this.otherEditor);
        Button button = new Button((Composite)this.shell, 8);
        button.setText(" Cancel ");
        button.setLayoutData((Object)new GridData(131072, 4, false, false));
        button.pack();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SWTChartEditor.this.shell.dispose();
            }
        });
        Button button2 = new Button((Composite)this.shell, 40);
        button2.setText(" Ok ");
        button2.setLayoutData((Object)new GridData(131072, 4, false, false));
        button2.pack();
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SWTChartEditor.this.updateChart(SWTChartEditor.this.chart);
                SWTChartEditor.this.shell.dispose();
            }
        });
    }

    public void open() {
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public void updateChart(JFreeChart jFreeChart) {
        this.titleEditor.setTitleProperties(jFreeChart);
        this.plotEditor.updatePlotProperties(jFreeChart.getPlot());
        this.otherEditor.updateChartProperties(jFreeChart);
    }

    public static class SWTAxisEditor
    extends Composite {
        final Text label;
        FontData labelFont;
        Color labelPaintColor;
        FontData tickLabelFont;
        final Color tickLabelPaintColor;
        final Text labelFontField;
        final Text tickLabelFontField;
        Font font;
        final Button showTickLabelsCheckBox;
        final Button showTickMarksCheckBox;
        final TabFolder otherTabs;

        public SWTAxisEditor(Composite composite, int n, Axis axis) {
            super(composite, n);
            this.labelFont = GraphicsHelper.toSwtFontData((Device)this.getDisplay(), (java.awt.Font)axis.getLabelFont(), (boolean)true);
            this.labelPaintColor = GraphicsHelper.toSwtColor((Device)this.getDisplay(), (Paint)axis.getLabelPaint());
            this.tickLabelFont = GraphicsHelper.toSwtFontData((Device)this.getDisplay(), (java.awt.Font)axis.getTickLabelFont(), (boolean)true);
            this.tickLabelPaintColor = GraphicsHelper.toSwtColor((Device)this.getDisplay(), (Paint)axis.getTickLabelPaint());
            FillLayout fillLayout = new FillLayout(512);
            fillLayout.marginWidth = 4;
            fillLayout.marginHeight = 4;
            this.setLayout((Layout)fillLayout);
            Group group = new Group((Composite)this, 0);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setText("General");
            new Label((Composite)group, 0).setText("Label");
            this.label = new Text((Composite)group, 2048);
            if (axis.getLabel() != null) {
                this.label.setText(axis.getLabel());
            }
            this.label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            new Label((Composite)group, 0).setText("");
            new Label((Composite)group, 0).setText("Font");
            this.labelFontField = new Text((Composite)group, 2048);
            this.labelFontField.setText(this.labelFont.toString());
            this.labelFontField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button button = new Button((Composite)group, 8);
            button.setText("Select...");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FontDialog fontDialog = new FontDialog(this.getShell());
                    fontDialog.setText("Font Selection");
                    fontDialog.setFontList(new FontData[]{labelFont});
                    if (fontDialog.open() != null) {
                        if (font != null) {
                            font.dispose();
                        }
                        font = new Font((Device)this.getShell().getDisplay(), fontDialog.getFontList());
                        labelFontField.setText(font.getFontData()[0].toString());
                        labelFont = font.getFontData()[0];
                    }
                }
            });
            new Label((Composite)group, 0).setText("Paint");
            final SWTPaintCanvas sWTPaintCanvas = new SWTPaintCanvas((Composite)group, 0, this.labelPaintColor);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.heightHint = 20;
            sWTPaintCanvas.setLayoutData(gridData);
            Button button2 = new Button((Composite)group, 8);
            button2.setText("Select...");
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColorDialog colorDialog = new ColorDialog(this.getShell());
                    colorDialog.setText("Title_Color");
                    colorDialog.setRGB(labelPaintColor.getRGB());
                    RGB rGB = colorDialog.open();
                    if (rGB != null) {
                        labelPaintColor = new Color((Device)this.getDisplay(), rGB);
                        sWTPaintCanvas.setColor(labelPaintColor);
                    }
                }
            });
            Group group2 = new Group((Composite)this, 0);
            FillLayout fillLayout2 = new FillLayout();
            fillLayout2.marginWidth = 4;
            fillLayout2.marginHeight = 4;
            group2.setLayout((Layout)fillLayout2);
            group2.setText("Other");
            this.otherTabs = new TabFolder((Composite)group2, 0);
            TabItem tabItem = new TabItem(this.otherTabs, 0);
            tabItem.setText(" Ticks ");
            Composite composite2 = new Composite((Composite)this.otherTabs, 0);
            composite2.setLayout((Layout)new GridLayout(3, false));
            this.showTickLabelsCheckBox = new Button(composite2, 32);
            this.showTickLabelsCheckBox.setText("Show tick labels");
            this.showTickLabelsCheckBox.setSelection(axis.isTickLabelsVisible());
            this.showTickLabelsCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            new Label(composite2, 0).setText("Tick label font");
            this.tickLabelFontField = new Text(composite2, 2048);
            this.tickLabelFontField.setText(this.tickLabelFont.toString());
            this.tickLabelFontField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button button3 = new Button(composite2, 8);
            button3.setText("Select...");
            button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FontDialog fontDialog = new FontDialog(this.getShell());
                    fontDialog.setText("Font Selection");
                    fontDialog.setFontList(new FontData[]{tickLabelFont});
                    if (fontDialog.open() != null) {
                        if (font != null) {
                            font.dispose();
                        }
                        font = new Font((Device)this.getShell().getDisplay(), fontDialog.getFontList());
                        tickLabelFontField.setText(font.getFontData()[0].toString());
                        tickLabelFont = font.getFontData()[0];
                    }
                }
            });
            this.showTickMarksCheckBox = new Button(composite2, 32);
            this.showTickMarksCheckBox.setText("Show tick marks");
            this.showTickMarksCheckBox.setSelection(axis.isTickMarksVisible());
            this.showTickMarksCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            tabItem.setControl((Control)composite2);
        }

        public static SWTAxisEditor getInstance(Composite composite, int n, Axis axis) {
            if (axis == null) {
                return null;
            }
            if (axis instanceof NumberAxis) {
                return new SWTNumberAxisEditor(composite, n, (NumberAxis)axis);
            }
            return new SWTAxisEditor(composite, n, axis);
        }

        public TabFolder getOtherTabs() {
            return this.otherTabs;
        }

        public String getLabel() {
            return this.label.getText();
        }

        public java.awt.Font getLabelFont() {
            return GraphicsHelper.toAwtFont((Device)this.getDisplay(), (FontData)this.labelFont, (boolean)true);
        }

        public Paint getTickLabelPaint() {
            return GamaColors.toAwtColor((Color)this.tickLabelPaintColor);
        }

        public java.awt.Font getTickLabelFont() {
            return GraphicsHelper.toAwtFont((Device)this.getDisplay(), (FontData)this.tickLabelFont, (boolean)true);
        }

        public Paint getLabelPaint() {
            return GamaColors.toAwtColor((Color)this.labelPaintColor);
        }

        public void setAxisProperties(Axis axis) {
            axis.setLabel(this.getLabel());
            axis.setLabelFont(this.getLabelFont());
            axis.setLabelPaint(this.getLabelPaint());
            axis.setTickMarksVisible(this.showTickMarksCheckBox.getSelection());
            axis.setTickLabelsVisible(this.showTickLabelsCheckBox.getSelection());
            axis.setTickLabelFont(this.getTickLabelFont());
            axis.setTickLabelPaint(this.getTickLabelPaint());
        }
    }

    static class SWTNumberAxisEditor
    extends SWTAxisEditor
    implements FocusListener {
        private boolean autoRange;
        private double minimumValue;
        private double maximumValue;
        private final Button autoRangeCheckBox;
        private final Text minimumRangeValue;
        private final Text maximumRangeValue;

        public SWTNumberAxisEditor(Composite composite, int n, NumberAxis numberAxis) {
            super(composite, n, (Axis)numberAxis);
            this.autoRange = numberAxis.isAutoRange();
            this.minimumValue = numberAxis.getLowerBound();
            this.maximumValue = numberAxis.getUpperBound();
            TabItem tabItem = new TabItem(this.getOtherTabs(), 0);
            tabItem.setText(" Range ");
            Composite composite2 = new Composite((Composite)this.getOtherTabs(), 0);
            composite2.setLayout((Layout)new GridLayout(2, true));
            tabItem.setControl((Control)composite2);
            this.autoRangeCheckBox = new Button(composite2, 32);
            this.autoRangeCheckBox.setText("Auto-adjust range");
            this.autoRangeCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.autoRangeCheckBox.setSelection(this.autoRange);
            this.autoRangeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.toggleAutoRange();
                }
            });
            new Label(composite2, 0).setText("Minimum range value");
            this.minimumRangeValue = new Text(composite2, 2048);
            this.minimumRangeValue.setText(String.valueOf(this.minimumValue));
            this.minimumRangeValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.minimumRangeValue.setEnabled(!this.autoRange);
            this.minimumRangeValue.addFocusListener((FocusListener)this);
            new Label(composite2, 0).setText("Maximum range value");
            this.maximumRangeValue = new Text(composite2, 2048);
            this.maximumRangeValue.setText(String.valueOf(this.maximumValue));
            this.maximumRangeValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.maximumRangeValue.setEnabled(!this.autoRange);
            this.maximumRangeValue.addFocusListener((FocusListener)this);
        }

        public void toggleAutoRange() {
            this.autoRange = this.autoRangeCheckBox.getSelection();
            if (this.autoRange) {
                this.minimumRangeValue.setText(Double.toString(this.minimumValue));
                this.minimumRangeValue.setEnabled(false);
                this.maximumRangeValue.setText(Double.toString(this.maximumValue));
                this.maximumRangeValue.setEnabled(false);
            } else {
                this.minimumRangeValue.setEnabled(true);
                this.maximumRangeValue.setEnabled(true);
            }
        }

        public boolean validateMinimum(String string) {
            boolean bl = true;
            try {
                if (Double.parseDouble(string) >= this.maximumValue) {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            return bl;
        }

        public boolean validateMaximum(String string) {
            boolean bl = true;
            try {
                if (Double.parseDouble(string) <= this.minimumValue) {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            return bl;
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == this.minimumRangeValue) {
                if (!this.validateMinimum(this.minimumRangeValue.getText())) {
                    this.minimumRangeValue.setText(String.valueOf(this.minimumValue));
                } else {
                    this.minimumValue = Double.parseDouble(this.minimumRangeValue.getText());
                }
            } else if (focusEvent.getSource() == this.maximumRangeValue) {
                if (!this.validateMaximum(this.maximumRangeValue.getText())) {
                    this.maximumRangeValue.setText(String.valueOf(this.maximumValue));
                } else {
                    this.maximumValue = Double.parseDouble(this.maximumRangeValue.getText());
                }
            }
        }

        @Override
        public void setAxisProperties(Axis axis) {
            super.setAxisProperties(axis);
            NumberAxis numberAxis = (NumberAxis)axis;
            numberAxis.setAutoRange(this.autoRange);
            if (!this.autoRange) {
                numberAxis.setRange(this.minimumValue, this.maximumValue);
            }
        }
    }

    class SWTOtherEditor
    extends Composite {
        final Button antialias;
        final SWTPaintCanvas backgroundPaintCanvas;

        public SWTOtherEditor(Composite composite, int n, JFreeChart jFreeChart) {
            super(composite, n);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginWidth = 4;
            fillLayout.marginHeight = 4;
            this.setLayout((Layout)fillLayout);
            Group group = new Group((Composite)this, 0);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setText("General");
            this.antialias = new Button((Composite)group, 32);
            this.antialias.setText("Draw anti-aliased");
            this.antialias.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
            this.antialias.setSelection(jFreeChart.getAntiAlias());
            new Label((Composite)group, 0).setText("Background paint");
            this.backgroundPaintCanvas = new SWTPaintCanvas((Composite)group, 0, GraphicsHelper.toSwtColor((Device)this.getDisplay(), (Paint)jFreeChart.getBackgroundPaint()));
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.heightHint = 20;
            this.backgroundPaintCanvas.setLayoutData(gridData);
            Button button = new Button((Composite)group, 8);
            button.setText("Select...");
            button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColorDialog colorDialog = new ColorDialog(SWTOtherEditor.this.getShell());
                    colorDialog.setText("Background_paint");
                    colorDialog.setRGB(SWTOtherEditor.this.backgroundPaintCanvas.getColor().getRGB());
                    RGB rGB = colorDialog.open();
                    if (rGB != null) {
                        SWTOtherEditor.this.backgroundPaintCanvas.setColor(new Color((Device)SWTOtherEditor.this.getDisplay(), rGB));
                    }
                }
            });
        }

        public void updateChartProperties(JFreeChart jFreeChart) {
            jFreeChart.setAntiAlias(this.antialias.getSelection());
            jFreeChart.setBackgroundPaint((Paint)GamaColors.toAwtColor((Color)this.backgroundPaintCanvas.getColor()));
        }
    }

    public static class SWTPaintCanvas
    extends Canvas {
        private Color myColor;

        public SWTPaintCanvas(Composite composite, int n, Color color) {
            this(composite, n);
            this.setColor(color);
        }

        public SWTPaintCanvas(Composite composite, int n) {
            super(composite, n);
            this.addPaintListener(paintEvent -> {
                paintEvent.gc.setForeground(paintEvent.gc.getDevice().getSystemColor(2));
                paintEvent.gc.setBackground(this.myColor);
                paintEvent.gc.fillRectangle(this.getClientArea());
                paintEvent.gc.drawRectangle(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width - 1, this.getClientArea().height - 1);
            });
        }

        public void setColor(Color color) {
            if (this.myColor != null) {
                this.myColor.dispose();
            }
            this.myColor = color;
        }

        public Color getColor() {
            return this.myColor;
        }

        public void setBackground(Color color) {
        }

        public void setForeground(Color color) {
        }

        public void dispose() {
            this.myColor.dispose();
        }
    }

    static class SWTPlotAppearanceEditor
    extends Composite {
        final Spinner selectStroke;
        final SWTStrokeCanvas strokeCanvas;
        final SWTPaintCanvas backgroundPaintCanvas;
        final SWTPaintCanvas outlinePaintCanvas;
        PlotOrientation plotOrientation;
        Combo orientation;
        static final String[] orientationNames = new String[]{"Vertical", "Horizontal"};
        static final int ORIENTATION_VERTICAL = 0;
        static final int ORIENTATION_HORIZONTAL = 1;

        SWTPlotAppearanceEditor(Composite composite, int n, Plot plot) {
            super(composite, n);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginWidth = 4;
            fillLayout.marginHeight = 4;
            this.setLayout((Layout)fillLayout);
            Group group = new Group((Composite)this, 0);
            GridLayout gridLayout = new GridLayout(3, false);
            gridLayout.marginWidth = 4;
            gridLayout.marginHeight = 4;
            group.setLayout((Layout)gridLayout);
            group.setText("General");
            new Label((Composite)group, 0).setText("Outline stroke");
            this.strokeCanvas = new SWTStrokeCanvas((Composite)group, 0);
            this.strokeCanvas.setStroke(plot.getOutlineStroke());
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.heightHint = 20;
            this.strokeCanvas.setLayoutData(gridData);
            this.selectStroke = new Spinner((Composite)group, 2048);
            this.selectStroke.setMinimum(1);
            this.selectStroke.setMaximum(3);
            this.selectStroke.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.selectStroke.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = selectStroke.getSelection();
                    if (n > 0) {
                        strokeCanvas.setStroke(new BasicStroke(n));
                        strokeCanvas.redraw();
                    }
                }
            });
            new Label((Composite)group, 0).setText("Outline Paint");
            this.outlinePaintCanvas = new SWTPaintCanvas((Composite)group, 0, GraphicsHelper.toSwtColor((Device)this.getDisplay(), (Paint)plot.getOutlinePaint()));
            GridData gridData2 = new GridData(4, 0x1000000, true, false);
            gridData2.heightHint = 20;
            this.outlinePaintCanvas.setLayoutData(gridData2);
            Button button = new Button((Composite)group, 8);
            button.setText("Select...");
            button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColorDialog colorDialog = new ColorDialog(this.getShell());
                    colorDialog.setText("Outline Paint");
                    colorDialog.setRGB(outlinePaintCanvas.getColor().getRGB());
                    RGB rGB = colorDialog.open();
                    if (rGB != null) {
                        outlinePaintCanvas.setColor(new Color((Device)this.getDisplay(), rGB));
                    }
                }
            });
            new Label((Composite)group, 0).setText("Background paint");
            this.backgroundPaintCanvas = new SWTPaintCanvas((Composite)group, 0, GraphicsHelper.toSwtColor((Device)this.getDisplay(), (Paint)plot.getBackgroundPaint()));
            GridData gridData3 = new GridData(4, 0x1000000, true, false);
            gridData3.heightHint = 20;
            this.backgroundPaintCanvas.setLayoutData(gridData3);
            Button button2 = new Button((Composite)group, 8);
            button2.setText("Select...");
            button2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColorDialog colorDialog = new ColorDialog(this.getShell());
                    colorDialog.setText("Background paint");
                    colorDialog.setRGB(backgroundPaintCanvas.getColor().getRGB());
                    RGB rGB = colorDialog.open();
                    if (rGB != null) {
                        backgroundPaintCanvas.setColor(new Color((Device)this.getDisplay(), rGB));
                    }
                }
            });
            if (plot instanceof CategoryPlot) {
                this.plotOrientation = ((CategoryPlot)plot).getOrientation();
            } else if (plot instanceof XYPlot) {
                this.plotOrientation = ((XYPlot)plot).getOrientation();
            }
            if (this.plotOrientation != null) {
                boolean bl = this.plotOrientation.equals((Object)PlotOrientation.VERTICAL);
                int n2 = bl ? 0 : 1;
                new Label((Composite)group, 0).setText("Orientation");
                this.orientation = new Combo((Composite)group, 4);
                this.orientation.setItems(orientationNames);
                this.orientation.select(n2);
                this.orientation.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 2, 1));
                this.orientation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        switch (orientation.getSelectionIndex()) {
                            case 1: {
                                plotOrientation = PlotOrientation.HORIZONTAL;
                                break;
                            }
                            default: {
                                plotOrientation = PlotOrientation.VERTICAL;
                            }
                        }
                    }
                });
            }
        }

        public PlotOrientation getPlotOrientation() {
            return this.plotOrientation;
        }

        public Color getBackGroundPaint() {
            return this.backgroundPaintCanvas.getColor();
        }

        public Color getOutlinePaint() {
            return this.outlinePaintCanvas.getColor();
        }

        public Stroke getStroke() {
            return this.strokeCanvas.getStroke();
        }
    }

    class SWTPlotEditor
    extends Composite {
        private final SWTAxisEditor domainAxisPropertyPanel;
        private final SWTAxisEditor rangeAxisPropertyPanel;
        private final SWTPlotAppearanceEditor plotAppearance;

        public SWTPlotEditor(Composite composite, int n, Plot plot) {
            super(composite, n);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginWidth = 4;
            fillLayout.marginHeight = 4;
            this.setLayout((Layout)fillLayout);
            Group group = new Group((Composite)this, 0);
            FillLayout fillLayout2 = new FillLayout();
            fillLayout2.marginWidth = 4;
            fillLayout2.marginHeight = 4;
            group.setLayout((Layout)fillLayout2);
            group.setText(plot.getPlotType() + ":");
            TabFolder tabFolder = new TabFolder((Composite)group, 0);
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Domain Axis");
            CategoryAxis categoryAxis = null;
            if (plot instanceof CategoryPlot) {
                categoryAxis = ((CategoryPlot)plot).getDomainAxis();
            } else if (plot instanceof XYPlot) {
                categoryAxis = ((XYPlot)plot).getDomainAxis();
            }
            this.domainAxisPropertyPanel = SWTAxisEditor.getInstance((Composite)tabFolder, 0, (Axis)categoryAxis);
            tabItem.setControl((Control)this.domainAxisPropertyPanel);
            TabItem tabItem2 = new TabItem(tabFolder, 0);
            tabItem2.setText("Range Axis");
            ValueAxis valueAxis = null;
            if (plot instanceof CategoryPlot) {
                valueAxis = ((CategoryPlot)plot).getRangeAxis();
            } else if (plot instanceof XYPlot) {
                valueAxis = ((XYPlot)plot).getRangeAxis();
            }
            this.rangeAxisPropertyPanel = SWTAxisEditor.getInstance((Composite)tabFolder, 0, (Axis)valueAxis);
            tabItem2.setControl((Control)this.rangeAxisPropertyPanel);
            TabItem tabItem3 = new TabItem(tabFolder, 0);
            tabItem3.setText("Appearance");
            this.plotAppearance = new SWTPlotAppearanceEditor((Composite)tabFolder, 0, plot);
            tabItem3.setControl((Control)this.plotAppearance);
        }

        public Color getBackgroundPaint() {
            return this.plotAppearance.getBackGroundPaint();
        }

        public Color getOutlinePaint() {
            return this.plotAppearance.getOutlinePaint();
        }

        public Stroke getOutlineStroke() {
            return this.plotAppearance.getStroke();
        }

        public void updatePlotProperties(Plot plot) {
            CategoryPlot categoryPlot;
            CategoryAxis categoryAxis;
            plot.setBackgroundPaint((Paint)GamaColors.toAwtColor((Color)this.getBackgroundPaint()));
            plot.setOutlinePaint((Paint)GamaColors.toAwtColor((Color)this.getOutlinePaint()));
            plot.setOutlineStroke(this.getOutlineStroke());
            if (this.domainAxisPropertyPanel != null) {
                categoryAxis = null;
                if (plot instanceof CategoryPlot) {
                    categoryPlot = (CategoryPlot)plot;
                    categoryAxis = categoryPlot.getDomainAxis();
                } else if (plot instanceof XYPlot) {
                    categoryPlot = (XYPlot)plot;
                    categoryAxis = categoryPlot.getDomainAxis();
                }
                if (categoryAxis != null) {
                    this.domainAxisPropertyPanel.setAxisProperties((Axis)categoryAxis);
                }
            }
            if (this.rangeAxisPropertyPanel != null) {
                categoryAxis = null;
                if (plot instanceof CategoryPlot) {
                    categoryPlot = (CategoryPlot)plot;
                    categoryAxis = categoryPlot.getRangeAxis();
                } else if (plot instanceof XYPlot) {
                    categoryPlot = (XYPlot)plot;
                    categoryAxis = categoryPlot.getRangeAxis();
                }
                if (categoryAxis != null) {
                    this.rangeAxisPropertyPanel.setAxisProperties((Axis)categoryAxis);
                }
            }
            if (this.plotAppearance.getPlotOrientation() != null) {
                if (plot instanceof CategoryPlot) {
                    categoryAxis = (CategoryPlot)plot;
                    categoryAxis.setOrientation(this.plotAppearance.getPlotOrientation());
                } else if (plot instanceof XYPlot) {
                    categoryAxis = (XYPlot)plot;
                    categoryAxis.setOrientation(this.plotAppearance.getPlotOrientation());
                }
            }
        }
    }

    static class SWTStrokeCanvas
    extends Canvas {
        public SWTStrokeCanvas(Composite composite, int n) {
            super(composite, n);
            this.addPaintListener(paintEvent -> {
                BasicStroke basicStroke = this.getStroke();
                if (basicStroke != null) {
                    Rectangle rectangle = this.getClientArea();
                    int n = (rectangle.width - 100) / 2;
                    int n2 = (rectangle.height - 16) / 2;
                    Transform transform = new Transform(paintEvent.gc.getDevice());
                    paintEvent.gc.getTransform(transform);
                    transform.translate((float)n, (float)n2);
                    paintEvent.gc.setTransform(transform);
                    transform.dispose();
                    paintEvent.gc.setBackground(this.getDisplay().getSystemColor(2));
                    paintEvent.gc.setLineWidth((int)basicStroke.getLineWidth());
                    paintEvent.gc.drawLine(10, 8, 90, 8);
                }
            });
        }

        public void setStroke(Stroke stroke) {
            if (!(stroke instanceof BasicStroke)) {
                throw new RuntimeException("Can only handle 'Basic Stroke' at present.");
            }
            this.setData(stroke);
        }

        public BasicStroke getStroke() {
            return (BasicStroke)this.getData();
        }
    }

    class SWTTitleEditor
    extends Composite {
        boolean showTitle;
        final Button showTitleCheckBox;
        final Text titleField;
        FontData titleFont;
        final Text fontField;
        final Button selectFontButton;
        Color titleColor;
        final Button selectColorButton;
        Font font;

        SWTTitleEditor(Composite composite, int n, Title title) {
            super(composite, n);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginWidth = 4;
            fillLayout.marginHeight = 4;
            this.setLayout((Layout)fillLayout);
            TextTitle textTitle = title != null ? (TextTitle)title : new TextTitle("Title");
            this.showTitle = title != null;
            this.titleFont = GraphicsHelper.toSwtFontData((Device)this.getDisplay(), (java.awt.Font)textTitle.getFont(), (boolean)true);
            this.titleColor = GraphicsHelper.toSwtColor((Device)this.getDisplay(), (Paint)textTitle.getPaint());
            Group group = new Group((Composite)this, 0);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setText("General");
            Label label = new Label((Composite)group, 0);
            label.setText("Show Title");
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            this.showTitleCheckBox = new Button((Composite)group, 32);
            this.showTitleCheckBox.setSelection(this.showTitle);
            this.showTitleCheckBox.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.showTitleCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SWTTitleEditor.this.showTitle = SWTTitleEditor.this.showTitleCheckBox.getSelection();
                }
            });
            new Label((Composite)group, 0).setText("Text");
            this.titleField = new Text((Composite)group, 2048);
            this.titleField.setText(textTitle.getText());
            this.titleField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            new Label((Composite)group, 0).setText("");
            new Label((Composite)group, 0).setText("Font");
            this.fontField = new Text((Composite)group, 2048);
            this.fontField.setText(this.titleFont.toString());
            this.fontField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.selectFontButton = new Button((Composite)group, 8);
            this.selectFontButton.setText("Select...");
            this.selectFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FontDialog fontDialog = new FontDialog(SWTTitleEditor.this.getShell());
                    fontDialog.setText("Font_Selection");
                    fontDialog.setFontList(new FontData[]{SWTTitleEditor.this.titleFont});
                    if (fontDialog.open() != null) {
                        if (SWTTitleEditor.this.font != null) {
                            SWTTitleEditor.this.font.dispose();
                        }
                        SWTTitleEditor.this.font = new Font((Device)SWTTitleEditor.this.getShell().getDisplay(), fontDialog.getFontList());
                        SWTTitleEditor.this.fontField.setText(SWTTitleEditor.this.font.getFontData()[0].toString());
                        SWTTitleEditor.this.titleFont = SWTTitleEditor.this.font.getFontData()[0];
                    }
                }
            });
            new Label((Composite)group, 0).setText("Color");
            final SWTPaintCanvas sWTPaintCanvas = new SWTPaintCanvas((Composite)group, 0, this.titleColor);
            GridData gridData2 = new GridData(4, 0x1000000, true, false);
            gridData2.heightHint = 20;
            sWTPaintCanvas.setLayoutData(gridData2);
            this.selectColorButton = new Button((Composite)group, 8);
            this.selectColorButton.setText("Select...");
            this.selectColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColorDialog colorDialog = new ColorDialog(SWTTitleEditor.this.getShell());
                    colorDialog.setText("Title_Color");
                    colorDialog.setRGB(SWTTitleEditor.this.titleColor.getRGB());
                    RGB rGB = colorDialog.open();
                    if (rGB != null) {
                        SWTTitleEditor.this.titleColor = new Color((Device)SWTTitleEditor.this.getDisplay(), rGB);
                        sWTPaintCanvas.setColor(SWTTitleEditor.this.titleColor);
                    }
                }
            });
        }

        public String getTitleText() {
            return this.titleField.getText();
        }

        public FontData getTitleFont() {
            return this.titleFont;
        }

        public Color getTitleColor() {
            return this.titleColor;
        }

        public void setTitleProperties(JFreeChart jFreeChart) {
            if (this.showTitle) {
                TextTitle textTitle = jFreeChart.getTitle();
                if (textTitle == null) {
                    textTitle = new TextTitle();
                    jFreeChart.setTitle(textTitle);
                }
                textTitle.setText(this.getTitleText());
                textTitle.setFont(GraphicsHelper.toAwtFont((Device)this.getDisplay(), (FontData)this.getTitleFont(), (boolean)true));
                textTitle.setPaint((Paint)GamaColors.toAwtColor((Color)this.getTitleColor()));
            } else {
                jFreeChart.setTitle(null);
            }
        }
    }
}

