/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import gama.core.common.GamlFileExtension;
import gama.core.runtime.GAMA;
import gama.core.util.file.IFileMetaDataProvider;
import gama.dev.DEBUG;
import gama.gaml.statements.test.CompoundSummary;
import gama.ui.application.workspace.WorkspaceModelsManager;
import gama.ui.navigator.metadata.FileMetaDataProvider;
import gama.ui.navigator.view.contents.NavigatorRoot;
import gama.ui.navigator.view.contents.TopLevelFolder;
import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedContainer;
import gama.ui.navigator.view.contents.WrappedFile;
import gama.ui.navigator.view.contents.WrappedFolder;
import gama.ui.navigator.view.contents.WrappedGamaFile;
import gama.ui.navigator.view.contents.WrappedLink;
import gama.ui.navigator.view.contents.WrappedProject;
import gama.ui.navigator.view.contents.WrappedResource;
import gama.ui.shared.commands.TestsRunner;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.navigator.CommonViewer;

public class ResourceManager
implements IResourceChangeListener,
IResourceDeltaVisitor,
ISelectionChangedListener {
    public static ResourceManager INSTANCE;
    public static final Cache<IResource, WrappedResource<?, ?>> cache;
    final CommonViewer viewer;
    final IResourceChangeListener delegate;
    static volatile boolean BLOCKED;
    private static volatile boolean IN_INITIALIZATION_PHASE;
    private final List<Runnable> postEventActions = new ArrayList<Runnable>();
    private final Set<VirtualContent<?>> toRefresh = Collections.synchronizedSet(new HashSet());
    private final Set<VirtualContent<?>> toUpdate = Collections.synchronizedSet(new HashSet());
    private volatile Object toReveal = null;
    private static IStructuredSelection currentSelection;
    static final List<IResourceChangeEvent> BLOCKED_EVENTS;

    static {
        DEBUG.OFF();
        cache = CacheBuilder.newBuilder().initialCapacity(1000).concurrencyLevel(4).build();
        BLOCKED = false;
        IN_INITIALIZATION_PHASE = false;
        BLOCKED_EVENTS = new ArrayList<IResourceChangeEvent>();
    }

    public static void block() {
        BLOCKED = true;
    }

    public static void unblock(IProgressMonitor iProgressMonitor) {
        BLOCKED = false;
        WorkbenchHelper.run(() -> {
            iProgressMonitor.beginTask("Processing additions to the workspace", BLOCKED_EVENTS.size());
            try {
                NavigatorRoot.getInstance().resetVirtualFolders(null);
                NavigatorRoot.getInstance().recreateVirtualFolders();
                IN_INITIALIZATION_PHASE = true;
                for (IResourceChangeEvent iResourceChangeEvent : BLOCKED_EVENTS) {
                    INSTANCE.resourceChanged(iResourceChangeEvent);
                    iProgressMonitor.worked(1);
                }
            }
            finally {
                IN_INITIALIZATION_PHASE = false;
            }
        });
        BLOCKED_EVENTS.clear();
    }

    public static ResourceManager getInstance() {
        return INSTANCE;
    }

    public static void finishTests() {
        INSTANCE.refreshResource(NavigatorRoot.getInstance().getTestFolder());
    }

    public ResourceManager(IResourceChangeListener iResourceChangeListener, CommonViewer commonViewer) {
        this.viewer = commonViewer;
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.delegate = iResourceChangeListener;
        INSTANCE = this;
    }

    public void reveal(Object object) {
        this.toReveal = object;
    }

    public CompoundSummary<?, ?> getTestsSummary() {
        return TestsRunner.LAST_RUN;
    }

    public void post(Runnable runnable) {
        this.postEventActions.add(runnable);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        currentSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
    }

    public static void setSelectedFolder(Object object) {
        currentSelection = new StructuredSelection(object);
    }

    void runPostEventActions() {
        WorkbenchHelper.runInUI((String)"Resource changes", (int)5, iProgressMonitor -> {
            ImmutableList immutableList;
            if (this.viewer.getControl().isDisposed()) {
                return;
            }
            this.viewer.getControl().setRedraw(false);
            Object object2 = this.postEventActions;
            synchronized (object2) {
                immutableList = ImmutableList.copyOf(this.postEventActions);
                this.postEventActions.clear();
            }
            for (Object object2 : immutableList) {
                object2.run();
            }
            Object object3 = this.toRefresh;
            synchronized (object3) {
                object2 = ImmutableSet.copyOf(this.toRefresh);
                this.toRefresh.clear();
            }
            WrappedResource<?, ?> wrappedResource = object2.iterator();
            while (wrappedResource.hasNext()) {
                object3 = (VirtualContent)wrappedResource.next();
                if (this.viewer.getControl().isDisposed()) continue;
                this.viewer.refresh(object3);
            }
            wrappedResource = this.toUpdate;
            synchronized (wrappedResource) {
                object3 = ImmutableSet.copyOf(this.toUpdate);
                this.toUpdate.clear();
            }
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                wrappedResource = (VirtualContent)iterator.next();
                if (this.viewer.getControl().isDisposed()) continue;
                this.viewer.update(wrappedResource, null);
            }
            if (this.toReveal != null) {
                wrappedResource = this.findWrappedInstanceOf(this.toReveal);
                if (!this.viewer.getControl().isDisposed() && wrappedResource != null) {
                    this.viewer.setSelection((ISelection)new StructuredSelection(wrappedResource), true);
                }
                this.toReveal = null;
            }
            this.viewer.getControl().setRedraw(true);
            this.viewer.getControl().update();
        });
    }

    public static IResource getResource(Object object) {
        IAdaptable iAdaptable;
        IResource iResource;
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable && (iResource = (IResource)(iAdaptable = (IAdaptable)object).getAdapter(IResource.class)) != null) {
            return iResource;
        }
        return null;
    }

    public static IFile getFile(Object object) {
        IAdaptable iAdaptable;
        IFile iFile;
        if (object instanceof IFile) {
            return (IFile)object;
        }
        if (object instanceof IAdaptable && (iFile = (IFile)(iAdaptable = (IAdaptable)object).getAdapter(IFile.class)) != null) {
            return iFile;
        }
        return null;
    }

    public static boolean isFile(Object object) {
        return ResourceManager.getFile(object) != null;
    }

    public static boolean isResource(Object object) {
        return ResourceManager.getResource(object) != null;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (BLOCKED) {
            BLOCKED_EVENTS.add(iResourceChangeEvent);
            return;
        }
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)"========= New Event =========");
        }
        try {
            if (iResourceChangeEvent == null) {
                return;
            }
            int n = iResourceChangeEvent.getType();
            switch (n) {
                case 1: {
                    if (this.viewer.isBusy()) {
                        WorkbenchHelper.runInUI((String)"Resource changes", (int)50, iProgressMonitor -> this.delegate.resourceChanged(iResourceChangeEvent));
                    } else {
                        this.delegate.resourceChanged(iResourceChangeEvent);
                    }
                    try {
                        iResourceChangeEvent.getDelta().accept((IResourceDeltaVisitor)this);
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    break;
                }
                case 32: {
                    if (DEBUG.IS_ON()) {
                        DEBUG.OUT((Object)("Project " + iResourceChangeEvent.getResource().getName() + " about to be refreshed"));
                    }
                    break;
                }
                case 2: 
                case 4: {
                    if (!DEBUG.IS_ON()) break;
                    DEBUG.OUT((Object)("Project " + iResourceChangeEvent.getResource().getName() + " about to be closed or deleted"));
                }
                default: {
                    break;
                }
            }
        }
        finally {
            this.runPostEventActions();
        }
    }

    boolean processAddition(IResource iResource) {
        boolean bl = false;
        switch (iResource.getType()) {
            case 1: {
                if (GamlFileExtension.isAny((String)iResource.getName())) {
                    this.invalidateModelsCountCache(iResource.getParent());
                    this.invalidateSeverityCache((IResource)iResource.getParent());
                    bl = true;
                }
                this.fileAdded((IFile)iResource);
                break;
            }
            case 4: {
                this.projectAdded((IProject)iResource);
                bl = true;
                break;
            }
            case 2: {
                this.folderAdded((IFolder)iResource);
            }
        }
        IFileMetaDataProvider iFileMetaDataProvider = GAMA.getGui().getMetaDataProvider();
        iFileMetaDataProvider.storeMetaData(iResource, null, true);
        iFileMetaDataProvider.getMetaData((Object)iResource, false, true);
        return bl;
    }

    public void fileAdded(IFile iFile) {
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("File " + iFile.getName() + " has been added"));
        }
        WrappedContainer<?> wrappedContainer = this.findWrappedInstanceOf(iFile.getParent());
        this.wrap(wrappedContainer, (IResource)iFile);
        if (wrappedContainer != null) {
            wrappedContainer.initializeChildren();
            this.refreshResource(wrappedContainer);
        }
    }

    public TopLevelFolder chooseFolderForPasting(IProject iProject) {
        Object object;
        if (currentSelection != null && !currentSelection.isEmpty() && (object = currentSelection.getFirstElement()) instanceof VirtualContent) {
            return ((VirtualContent)object).getTopLevelFolder();
        }
        return NavigatorRoot.getInstance().getUserFolder();
    }

    public void projectAdded(IProject iProject) {
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("Project " + iProject.getName() + " has been added"));
        }
        if (!IN_INITIALIZATION_PHASE) {
            TopLevelFolder topLevelFolder = this.chooseFolderForPasting(iProject);
            String string = topLevelFolder.getNature();
            WrappedProject wrappedProject = (WrappedProject)this.wrap(topLevelFolder, (IResource)iProject);
            this.post(() -> {
                WorkspaceModelsManager.instance.setValuesProjectDescription(iProject, "gama.ui.application.builtinNature".equals(string), "gama.ui.application.pluginNature".equals(string), "gama.ui.application.testNature".equals(string), null);
                topLevelFolder.initializeChildren();
                this.refreshResource(topLevelFolder);
                this.reveal(wrappedProject);
            });
        }
    }

    private boolean projectOpened(IProject iProject) {
        WrappedProject wrappedProject;
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("Project " + iProject.getName() + " has been opened"));
        }
        if ((wrappedProject = this.findWrappedInstanceOf(iProject)) == null) {
            this.projectAdded(iProject);
            return false;
        }
        wrappedProject.initializeChildren();
        this.refreshResource(wrappedProject);
        this.updateResource(wrappedProject);
        return false;
    }

    private boolean projectClosed(IProject iProject) {
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("Project " + iProject.getName() + " has been closed"));
        }
        WrappedProject wrappedProject = this.findWrappedInstanceOf(iProject);
        wrappedProject.initializeChildren();
        wrappedProject.invalidateModelsCount();
        wrappedProject.invalidateSeverity();
        this.refreshResource(wrappedProject);
        this.updateResource(wrappedProject);
        return false;
    }

    public void folderAdded(IFolder iFolder) {
        WrappedContainer<?> wrappedContainer;
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("Folder " + iFolder.getName() + " has been added"));
        }
        if ((wrappedContainer = this.findWrappedInstanceOf(iFolder.getParent())) != null) {
            wrappedContainer.initializeChildren();
            this.refreshResource(wrappedContainer);
        }
    }

    boolean processRemoval(IResource iResource) {
        boolean bl = false;
        switch (iResource.getType()) {
            case 1: {
                if (GamlFileExtension.isAny((String)iResource.getName())) {
                    this.invalidateModelsCountCache(iResource.getParent());
                    this.invalidateSeverityCache((IResource)iResource.getParent());
                    bl = true;
                }
                this.fileRemoved((IFile)iResource);
                break;
            }
            case 2: {
                this.folderRemoved((IFolder)iResource);
                break;
            }
            case 4: {
                this.projectRemoved((IProject)iResource);
            }
        }
        return bl;
    }

    public void fileRemoved(IFile iFile) {
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("File " + iFile.getName() + " has been removed"));
        }
        cache.invalidate((Object)iFile);
        WrappedContainer<?> wrappedContainer = this.findWrappedInstanceOf(iFile.getParent());
        if (wrappedContainer != null) {
            wrappedContainer.initializeChildren();
            this.refreshResource(wrappedContainer);
        }
    }

    public void folderRemoved(IFolder iFolder) {
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("Folder " + iFolder.getName() + " has been removed"));
        }
        WrappedFolder wrappedFolder = (WrappedFolder)this.findWrappedInstanceOf((IContainer)iFolder);
        cache.invalidate((Object)iFolder);
        if (wrappedFolder != null) {
            ((WrappedContainer)wrappedFolder.getParent()).initializeChildren();
            this.refreshResource(wrappedFolder.getParent());
        }
    }

    public void projectRemoved(IProject iProject) {
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("Project " + iProject.getName() + " has been removed"));
        }
        WrappedProject wrappedProject = this.findWrappedInstanceOf(iProject);
        cache.invalidate((Object)iProject);
        TopLevelFolder topLevelFolder = (TopLevelFolder)wrappedProject.getParent();
        topLevelFolder.initializeChildren();
        this.refreshResource(topLevelFolder);
    }

    public boolean visit(IResourceDelta iResourceDelta) {
        IResource iResource = iResourceDelta.getResource();
        boolean bl = false;
        switch (iResourceDelta.getKind()) {
            case 16384: {
                if (iResource.isAccessible()) {
                    bl = this.projectOpened((IProject)iResource);
                    break;
                }
                bl = this.projectClosed((IProject)iResource);
                break;
            }
            case 1: {
                bl = this.processAddition(iResource);
                break;
            }
            case 2: {
                bl = this.processRemoval(iResource);
                break;
            }
            case 4: {
                int n = iResourceDelta.getFlags();
                if ((n & 0x20000) != 0) {
                    bl = this.processMarkersChanged(iResource);
                }
                if ((n & 0x8000) != 0 && DEBUG.IS_ON()) {
                    DEBUG.OUT((Object)("Resource type changed: " + String.valueOf(iResource)));
                }
                if ((n & 0x100) != 0 && DEBUG.IS_ON()) {
                    DEBUG.OUT((Object)("Resource contents changed: " + String.valueOf(iResource)));
                }
                if ((n & 0x10000) != 0 && DEBUG.IS_ON()) {
                    DEBUG.OUT((Object)("Resource sync info changed: " + String.valueOf(iResource)));
                }
                if ((n & 0x200000) == 0) break;
                if (DEBUG.IS_ON()) {
                    DEBUG.OUT((Object)("Linked resource target info changed: " + String.valueOf(iResource)));
                }
                bl = this.processLinkedTargerChanged(iResource);
            }
        }
        if (bl) {
            this.updateResource(iResource);
        }
        return true;
    }

    private boolean processLinkedTargerChanged(IResource iResource) {
        if (iResource.getType() == 1) {
            this.invalidateSeverityCache(iResource);
            WrappedFile wrappedFile = (WrappedFile)this.findWrappedInstanceOf(iResource);
            this.refreshResource(wrappedFile.getParent());
        }
        return true;
    }

    private boolean processMarkersChanged(IResource iResource) {
        WrappedFile wrappedFile;
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("File " + iResource.getName() + " markers have changed"));
        }
        this.invalidateSeverityCache(iResource);
        if (iResource.getType() == 1 && (wrappedFile = (WrappedFile)this.findWrappedInstanceOf(iResource)) != null && wrappedFile.isGamaFile()) {
            ((WrappedGamaFile)wrappedFile).computeURIProblems();
            this.refreshResource(wrappedFile);
        }
        return true;
    }

    private void updateResource(IResource iResource) {
        if (iResource == null) {
            return;
        }
        this.updateResource(this.findWrappedInstanceOf(iResource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateResource(VirtualContent<?> virtualContent) {
        if (virtualContent == null) {
            return;
        }
        VirtualContent<?> virtualContent2 = virtualContent;
        Set<VirtualContent<?>> set = this.toUpdate;
        synchronized (set) {
            while (virtualContent2 != null) {
                this.toUpdate.add(virtualContent2);
                virtualContent2 = virtualContent2.getParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshResource(VirtualContent<?> virtualContent) {
        Set<VirtualContent<?>> set = this.toRefresh;
        synchronized (set) {
            this.toRefresh.add(virtualContent);
        }
    }

    private void invalidateSeverityCache(IResource iResource) {
        WrappedResource<?, ?> wrappedResource = this.findWrappedInstanceOf(iResource);
        if (wrappedResource != null) {
            wrappedResource.invalidateSeverity();
        } else {
            IContainer iContainer = iResource.getParent();
            if (iContainer != null) {
                this.invalidateSeverityCache((IResource)iContainer);
            }
        }
    }

    private void invalidateModelsCountCache(IContainer iContainer) {
        WrappedContainer<?> wrappedContainer = this.findWrappedInstanceOf(iContainer);
        if (wrappedContainer != null) {
            wrappedContainer.invalidateModelsCount();
        }
    }

    public WrappedResource<?, ?> findWrappedInstanceOf(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof WrappedResource) {
            return (WrappedResource)object;
        }
        return (WrappedResource)cache.getIfPresent(object);
    }

    public WrappedContainer<?> findWrappedInstanceOf(IContainer iContainer) {
        if (iContainer == null) {
            return null;
        }
        return (WrappedContainer)cache.getIfPresent((Object)iContainer);
    }

    public WrappedProject findWrappedInstanceOf(IProject iProject) {
        if (iProject == null) {
            return null;
        }
        return (WrappedProject)cache.getIfPresent((Object)iProject);
    }

    public WrappedResource<?, ?> wrap(VirtualContent<?> virtualContent, IResource iResource) {
        if (virtualContent == null || iResource == null) {
            return null;
        }
        try {
            return (WrappedResource)cache.get((Object)iResource, () -> ResourceManager.privateCreateWrapping(virtualContent, iResource));
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    private static WrappedResource<?, ?> privateCreateWrapping(VirtualContent<?> virtualContent, IResource iResource) {
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("Creation of the wrapped instance of " + iResource.getName()));
        }
        switch (iResource.getType()) {
            case 1: {
                if ("gama.ui.gaml.type".equals(FileMetaDataProvider.getContentTypeId((IFile)iResource))) {
                    return new WrappedGamaFile((WrappedContainer)virtualContent, (IFile)iResource);
                }
                if (iResource.isLinked()) {
                    return new WrappedLink((WrappedContainer)virtualContent, (IFile)iResource);
                }
                return new WrappedFile((WrappedContainer)virtualContent, (IFile)iResource);
            }
            case 2: {
                return new WrappedFolder((WrappedContainer)virtualContent, (IFolder)iResource);
            }
            case 4: {
                return new WrappedProject((TopLevelFolder)virtualContent, (IProject)iResource);
            }
        }
        return null;
    }

    public boolean validateLocation(IFile iFile) {
        boolean bl;
        if (!iFile.isLinked()) {
            return true;
        }
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("Validating link location of " + String.valueOf(iFile)));
        }
        if (!(bl = ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)iFile, iFile.getLocation()).isOK())) {
            return false;
        }
        IFileStore iFileStore = EFS.getLocalFileSystem().getStore(iFile.getLocation());
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        return iFileInfo.exists();
    }
}

