/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.menus;

import gama.core.util.GamaColor;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.PreferencesHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.Selector;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Consumer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class GamaColorMenu
extends GamaMenu {
    public static final String[] SORT_NAMES = new String[]{"RGB value", "Name", "Brightness", "Luminescence"};
    IColorRunnable currentRunnable;
    SelectionListener defaultListener = new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            GamaColorMenu.this.currentListener.widgetSelected(selectionEvent);
        }
    };
    SelectionListener currentListener;
    private static Integer reverse = null;
    public static final Comparator<String> byRGB = (string, string2) -> GamaColorMenu.getReverse() * ((GamaColor)GamaColor.colors.get(string)).compareTo((Color)GamaColor.colors.get(string2));
    public static final Comparator<String> byBrightness = (string, string2) -> GamaColorMenu.getReverse() * ((GamaColor)GamaColor.colors.get(string)).compareBrightnessTo((Color)GamaColor.colors.get(string2));
    public static final Comparator<String> byName = (string, string2) -> GamaColorMenu.getReverse() * string.compareTo((String)string2);
    public static final Comparator<String> byLuminescence = (string, string2) -> GamaColorMenu.getReverse() * ((GamaColor)GamaColor.colors.get(string)).compareTo((Color)GamaColor.colors.get(string2));
    public static Comparator colorComp = null;
    public SelectionListener chooseSort = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            colorComp = (Comparator)menuItem.getData();
            GamaColorMenu.this.reset();
        }
    };
    public static Boolean breakdown = null;
    Selector chooseBreak = selectionEvent -> {
        breakdown = breakdown == false;
        this.reset();
    };
    Selector chooseReverse = selectionEvent -> {
        GamaColorMenu.setReverse(-1 * GamaColorMenu.getReverse());
        this.reset();
    };

    public GamaColorMenu(Menu menu) {
        this.mainMenu = menu;
    }

    public static void openView(IColorRunnable iColorRunnable, RGB rGB) {
        Shell shell = new Shell(WorkbenchHelper.getDisplay(), 0);
        ColorDialog colorDialog = new ColorDialog(shell, 0);
        colorDialog.setText("Choose a custom color");
        colorDialog.setRGB(rGB);
        RGB rGB2 = colorDialog.open();
        if (rGB2 != null && iColorRunnable != null) {
            iColorRunnable.run(rGB2.red, rGB2.green, rGB2.blue);
        }
    }

    @Override
    public void fillMenu() {
        String string;
        if (colorComp == null) {
            string = (String)PreferencesHelper.COLOR_MENU_SORT.getValue();
            colorComp = string.equals(SORT_NAMES[0]) ? byRGB : (string.equals(SORT_NAMES[1]) ? byName : (string.equals(SORT_NAMES[2]) ? byBrightness : byLuminescence));
        }
        if (GamaColorMenu.getReverse() == null) {
            GamaColorMenu.setReverse((Boolean)PreferencesHelper.COLOR_MENU_REVERSE.getValue() != false ? -1 : 1);
        }
        if (breakdown == null) {
            breakdown = (Boolean)PreferencesHelper.COLOR_MENU_GROUP.getValue();
        }
        this.action("Custom...", selectionEvent -> GamaColorMenu.openView(this.currentRunnable, null));
        string = this.sub("Options");
        Menu menu = this.sub((Menu)string, "Sort by...");
        this.check((Menu)string, "Breakdown", breakdown, this.chooseBreak);
        this.check((Menu)string, "Reverse order", GamaColorMenu.getReverse() == -1, this.chooseReverse);
        this.check(menu, SORT_NAMES[0], colorComp == byRGB, this.chooseSort).setData(byRGB);
        this.check(menu, SORT_NAMES[1], colorComp == byName, this.chooseSort).setData(byName);
        this.check(menu, SORT_NAMES[2], colorComp == byBrightness, this.chooseSort).setData(byBrightness);
        this.check(menu, SORT_NAMES[3], colorComp == byLuminescence, this.chooseSort).setData(byLuminescence);
        this.sep();
        ArrayList arrayList = new ArrayList(GamaColor.colors.keySet());
        Collections.sort(arrayList, colorComp);
        Menu menu2 = this.mainMenu;
        int n = 0;
        while (n < arrayList.size()) {
            Object object;
            String string2 = (String)arrayList.get(n);
            if (breakdown.booleanValue() && n % 10 == 0) {
                object = ((String)arrayList.get(Math.min(n + 9, arrayList.size() - 1))).replace("#", "");
                menu2 = this.sub(string2.replace("#", "") + " to " + (String)object);
            }
            object = GamaColorMenu.action(menu2, "#" + string2, this.defaultListener);
            GamaColor gamaColor = (GamaColor)GamaColor.colors.get(string2);
            object.setImage(GamaIcon.ofColor(gamaColor).image());
            ++n;
        }
    }

    public static void addColorSubmenuTo(Menu menu, String string, Consumer<GamaColor> consumer) {
        Menu menu2 = GamaColorMenu.sub(menu, string, string, GamaIcon.named("editor/reference.colors").image());
        ArrayList arrayList = new ArrayList(GamaColor.colors.keySet());
        Collections.sort(arrayList, colorComp);
        for (String string2 : arrayList) {
            GamaColor gamaColor = (GamaColor)GamaColor.colors.get(string2);
            MenuItem menuItem = GamaColorMenu.action(menu2, "#" + string2, selectionEvent -> consumer.accept((GamaColor)GamaColor.colors.get(string2)));
            menuItem.setImage(GamaIcon.ofColor(gamaColor).image());
        }
    }

    public void open(Control control, SelectionEvent selectionEvent, SelectionListener selectionListener, IColorRunnable iColorRunnable) {
        this.currentListener = selectionListener;
        this.currentRunnable = iColorRunnable;
        if (this.mainMenu == null) {
            this.mainMenu = new Menu((Decorations)WorkbenchHelper.getShell(), 8);
            this.fillMenu();
        }
        Point point = control.toDisplay(new Point(selectionEvent.x, selectionEvent.y));
        this.mainMenu.setLocation(point.x, point.y);
        this.mainMenu.setVisible(true);
    }

    @Override
    public void reset() {
        super.reset();
        this.currentListener = null;
        this.currentRunnable = null;
    }

    public static Integer getReverse() {
        return reverse;
    }

    public static void setReverse(Integer n) {
        reverse = n;
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.currentListener = selectionListener;
    }

    public void setCurrentRunnable(IColorRunnable iColorRunnable) {
        this.currentRunnable = iColorRunnable;
    }

    public static interface IColorRunnable {
        public void run(int var1, int var2, int var3);
    }
}

