/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.common.util.FileUtils;
import gama.core.kernel.experiment.IParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.GamaFolderFile;
import gama.core.util.file.IGamaFile;
import gama.gaml.operators.Files;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FileEditor
extends AbstractEditor<IGamaFile> {
    private final Set<String> fileExtensions;
    private FlatButton textBox;
    private final boolean isFolder;
    private final boolean isWorkspace;

    FileEditor(IAgent iAgent, IParameter iParameter, EditorListener editorListener, boolean bl) {
        super(iAgent, iParameter, editorListener);
        this.isFolder = bl;
        this.isWorkspace = iParameter.isWorkspace();
        this.fileExtensions = iParameter.getFileExtensions() == null || iParameter.getFileExtensions().length == 0 ? null : new HashSet<String>(Arrays.asList(iParameter.getFileExtensions()));
    }

    @Override
    public Control createCustomParameterControl(Composite composite) {
        this.textBox = FlatButton.menu(composite, null, "").light().small();
        this.textBox.setText("No " + (this.isFolder ? "folder" : "file"));
        this.textBox.addSelectionListener(this);
        return this.textBox;
    }

    @Override
    public void widgetSelected(SelectionEvent selectionEvent) {
        IGamaFile iGamaFile = (IGamaFile)this.currentValue;
        if (this.isWorkspace) {
            if (!this.isFolder) {
                Object[] objectArray;
                String string2 = "Choose a file for parameter '" + this.param.getTitle() + "'";
                if (iGamaFile == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new IFile[1];
                    objectArray = objectArray2;
                    objectArray2[0] = FileUtils.getFile((String)iGamaFile.getPath(this.getScope()), null, (boolean)true);
                }
                IFile iFile = WorkspaceResourceDialog.openFileSelection(null, "Choose file", string2, false, objectArray, Collections.singletonList(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object object, Object object2) {
                        IResource iResource = (IResource)object2;
                        return iResource instanceof IContainer || FileEditor.this.fileExtensions == null || FileEditor.this.fileExtensions != null && FileEditor.this.fileExtensions.contains(iResource.getFileExtension());
                    }
                }));
                if (iFile == null) {
                    return;
                }
                String string3 = FileUtils.constructAbsoluteFilePath((IScope)this.getScope(), (String)iFile.getLocation().toOSString(), (boolean)true);
                if (string3 != null) {
                    iGamaFile = Files.from((IScope)this.getScope(), (String)string3);
                }
            } else {
                Object[] objectArray;
                String string4 = "Choose a folder for parameter '" + this.param.getTitle() + "'";
                if (iGamaFile == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray3 = new IContainer[1];
                    objectArray = objectArray3;
                    objectArray3[0] = FileUtils.getFolder((String)iGamaFile.getPath(this.getScope()), null, (boolean)true);
                }
                IContainer iContainer = WorkspaceResourceDialog.openFolderSelection(null, "Choose folder", string4, false, objectArray, Collections.singletonList(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object object, Object object2) {
                        IResource iResource = (IResource)object2;
                        return iResource instanceof IContainer || FileEditor.this.fileExtensions == null || FileEditor.this.fileExtensions != null && FileEditor.this.fileExtensions.contains(iResource.getFileExtension());
                    }
                }));
                if (iContainer == null) {
                    return;
                }
                String string5 = FileUtils.constructAbsoluteFilePath((IScope)this.getScope(), (String)iContainer.getLocation().toOSString(), (boolean)true);
                if (string5 != null) {
                    iGamaFile = Files.from((IScope)this.getScope(), (String)string5);
                }
            }
        } else if (this.isFolder) {
            DirectoryDialog directoryDialog = new DirectoryDialog(WorkbenchHelper.getDisplay().getActiveShell(), 0);
            if (!(iGamaFile instanceof GamaFolderFile)) {
                iGamaFile = null;
            }
            directoryDialog.setFilterPath(iGamaFile != null ? iGamaFile.getPath(this.getScope()) : (GAMA.getModel() == null ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() : GAMA.getModel().getFilePath()));
            directoryDialog.setMessage("Choose a folder for parameter '" + this.param.getTitle() + "'");
            String string6 = directoryDialog.open();
            if (string6 != null) {
                iGamaFile = Files.folderFile((IScope)this.getScope(), (String)string6, (boolean)false);
            }
        } else {
            String string7;
            FileDialog fileDialog = new FileDialog(WorkbenchHelper.getDisplay().getActiveShell(), 0);
            fileDialog.setFilterPath(iGamaFile != null ? iGamaFile.getPath(this.getScope()) : (GAMA.getModel().getFilePath().isBlank() ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() : GAMA.getModel().getFilePath()));
            fileDialog.setFileName(iGamaFile != null ? iGamaFile.getPath(this.getScope()) : (GAMA.getModel().getFilePath().isBlank() ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() : GAMA.getModel().getFilePath()));
            fileDialog.setText("Choose a file for parameter '" + this.param.getTitle() + "'");
            if (this.fileExtensions != null) {
                fileDialog.setFilterExtensions((String[])StreamEx.of(this.fileExtensions).map(string -> "*." + string).toArray(String.class));
            }
            if ((string7 = fileDialog.open()) != null) {
                iGamaFile = Files.from((IScope)this.getScope(), (String)string7);
            }
        }
        this.modifyAndDisplayValue(iGamaFile);
    }

    @Override
    protected void displayParameterValue() {
        this.internalModification = true;
        if (this.currentValue == null) {
            this.textBox.setText("No " + (this.isFolder ? "folder" : "file"));
        } else {
            String string;
            IGamaFile iGamaFile = (IGamaFile)this.currentValue;
            try {
                string = iGamaFile.getPath(this.getScope());
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                string = iGamaFile.getOriginalPath();
            }
            this.textBox.setToolTipText(string);
            this.textBox.setText(string);
        }
        this.internalModification = false;
    }

    @Override
    public IType getExpectedType() {
        return Types.FILE;
    }

    @Override
    protected void applyEdit() {
        this.widgetSelected(null);
    }

    @Override
    protected int[] getToolItems() {
        return new int[]{2, 6};
    }

    public static class WorkspaceResourceDialog
    extends ElementTreeSelectionDialog
    implements ISelectionStatusValidator {
        protected boolean showNewFolderControl = false;
        protected boolean showFileControl = false;
        protected boolean showFiles = true;
        protected Button newFolderButton;
        protected Text fileText;
        protected String fileTextContent = "";
        protected IContainer selectedContainer;

        public static IContainer openFolderSelection(Shell shell, String string, String string2, boolean bl, Object[] objectArray, List<ViewerFilter> list) {
            WorkspaceResourceDialog workspaceResourceDialog = new WorkspaceResourceDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            workspaceResourceDialog.setAllowMultiple(bl);
            workspaceResourceDialog.setTitle(string != null ? string : "Choose folder");
            workspaceResourceDialog.setMessage(string2);
            workspaceResourceDialog.showNewFolderControl = true;
            workspaceResourceDialog.addFilter(workspaceResourceDialog.createDefaultViewerFilter(false));
            if (list != null) {
                for (ViewerFilter viewerFilter : list) {
                    workspaceResourceDialog.addFilter(viewerFilter);
                }
            }
            if (objectArray != null) {
                workspaceResourceDialog.setInitialSelections(objectArray);
            }
            workspaceResourceDialog.loadContents();
            return workspaceResourceDialog.open() == 0 ? workspaceResourceDialog.getSelectedContainer() : null;
        }

        public static IFile openFileSelection(Shell shell, String string, String string2, boolean bl, Object[] objectArray, List<ViewerFilter> list) {
            WorkspaceResourceDialog workspaceResourceDialog = new WorkspaceResourceDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            workspaceResourceDialog.setAllowMultiple(bl);
            workspaceResourceDialog.setTitle(string != null ? string : "Choose file");
            workspaceResourceDialog.setMessage(string2);
            workspaceResourceDialog.addFilter(workspaceResourceDialog.createDefaultViewerFilter(true));
            if (list != null) {
                for (ViewerFilter viewerFilter : list) {
                    workspaceResourceDialog.addFilter(viewerFilter);
                }
            }
            if (objectArray != null) {
                workspaceResourceDialog.setInitialSelections(objectArray);
            }
            workspaceResourceDialog.loadContents();
            return workspaceResourceDialog.open() == 0 ? workspaceResourceDialog.getSelectedFile() : null;
        }

        public WorkspaceResourceDialog(Shell shell, ILabelProvider iLabelProvider, ITreeContentProvider iTreeContentProvider) {
            super(shell, iLabelProvider, iTreeContentProvider);
            this.setComparator((ViewerComparator)new ResourceComparator(1));
            this.setValidator(this);
        }

        public void loadContents() {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.setInput(iWorkspaceRoot);
        }

        public ViewerFilter createDefaultViewerFilter(boolean bl) {
            this.showFiles = bl;
            return new ViewerFilter(){

                public boolean select(Viewer viewer, Object object, Object object2) {
                    if (object2 instanceof IResource) {
                        IResource iResource = (IResource)object2;
                        return iResource.isAccessible() && (showFiles || iResource.getType() != 1);
                    }
                    return false;
                }
            };
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            if (this.showNewFolderControl) {
                this.createNewFolderControl(composite2);
            }
            if (this.showFileControl) {
                this.createFileControl(composite2);
            }
            WorkspaceResourceDialog.applyDialogFont((Control)composite2);
            return composite2;
        }

        protected void createNewFolderControl(Composite composite) {
            this.newFolderButton = new Button(composite, 8);
            this.newFolderButton.setText("New Folder");
            this.newFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.newFolderButtonPressed();
                }
            });
            this.newFolderButton.setFont(composite.getFont());
            this.updateNewFolderButtonState();
        }

        protected void updateNewFolderButtonState() {
            Object object;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getTreeViewer().getSelection();
            this.selectedContainer = null;
            if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IContainer) {
                this.selectedContainer = (IContainer)object;
            }
            this.newFolderButton.setEnabled(this.selectedContainer != null);
        }

        protected void newFolderButtonPressed() {
            NewFolderDialog newFolderDialog = new NewFolderDialog(this.getShell(), this.selectedContainer);
            if (newFolderDialog.open() == 0) {
                TreeViewer treeViewer = this.getTreeViewer();
                treeViewer.refresh((Object)this.selectedContainer);
                Object object = newFolderDialog.getResult()[0];
                treeViewer.reveal(object);
                treeViewer.setSelection((ISelection)new StructuredSelection(object));
            }
        }

        protected void createFileControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(768));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginLeft = -5;
            gridLayout.marginRight = -5;
            gridLayout.marginTop = -5;
            gridLayout.marginBottom = -5;
            composite2.setLayout((Layout)gridLayout);
            gridLayout = new Label(composite2, 0);
            gridLayout.setText("File name");
            this.fileText = new Text(composite2, 2048);
            this.fileText.setLayoutData((Object)new GridData(768));
            this.fileText.addModifyListener(modifyEvent -> this.fileTextModified(this.fileText.getText()));
            if (this.fileTextContent != null) {
                this.fileText.setText(this.fileTextContent);
            }
        }

        protected void fileTextModified(String string) {
            this.fileTextContent = string;
            this.updateOKStatus();
        }

        public IStatus validate(Object[] objectArray) {
            if (this.showNewFolderControl) {
                this.updateNewFolderButtonState();
            }
            boolean bl = false;
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                if (object instanceof IContainer) {
                    bl = !this.showFiles || this.showFileControl && this.fileText.getText().trim().length() > 0;
                } else if (object instanceof IFile) {
                    if (this.showFileControl) {
                        this.fileText.setText(((IFile)object).getName());
                    }
                    bl = true;
                }
                if (bl) break;
                ++n2;
            }
            return bl ? new Status(0, "org.eclipse.emf.common.ui", 0, "", null) : new Status(4, "org.eclipse.emf.common.ui", 0, "", null);
        }

        public IContainer getSelectedContainer() {
            Object[] objectArray = this.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IContainer) {
                    return (IContainer)object;
                }
                ++n2;
            }
            return null;
        }

        public IFile getSelectedFile() {
            Object[] objectArray = this.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IFile) {
                    return (IFile)object;
                }
                ++n2;
            }
            return null;
        }

        public void setFileText(String string) {
            if (string == null) {
                string = "";
            }
            if (this.fileText != null && !this.fileText.isDisposed()) {
                this.fileText.setText(string);
            } else {
                this.fileTextContent = string;
            }
        }

        public String getFileText() {
            return this.fileText != null && !this.fileText.isDisposed() ? this.fileText.getText() : this.fileTextContent;
        }
    }
}

