/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.InputParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.parameters.ExpressionBasedEditor;
import gama.ui.shared.resources.GamaIcon;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class NumberEditor<T extends Comparable>
extends ExpressionBasedEditor<T> {
    static final String UNDEFINED_LABEL = "-- Undefined --";

    public NumberEditor(IScope iScope, InputParameter inputParameter, EditorListener<T> editorListener, boolean bl) {
        this(iScope.getAgent(), (IParameter)inputParameter, editorListener, bl);
    }

    public NumberEditor(IAgent iAgent, IParameter iParameter, EditorListener<T> editorListener, boolean bl) {
        super(iAgent, iParameter, editorListener);
        this.acceptNull = bl;
    }

    @Override
    public Control createCustomParameterControl(Composite composite) throws GamaRuntimeException {
        this.normalizeValues();
        return super.createCustomParameterControl(composite);
    }

    protected abstract Number normalizeValues() throws GamaRuntimeException;

    @Override
    protected void updateToolbar() {
        super.updateToolbar();
        Label label = this.editorToolbar.getItem(7);
        if (label == null || label.isDisposed()) {
            return;
        }
        if (this.param.isDefined()) {
            label.setToolTipText("Set the parameter to undefined");
            label.setImage(GamaIcon.named("overlays/small.undefine").image());
            this.editorControl.setActive(true);
        } else {
            label.setToolTipText("Define the parameter (currently undefined)");
            label.setImage(GamaIcon.named("overlays/small.define").image());
            this.editorControl.setActive(false);
        }
    }

    @Override
    protected void applyDefine() {
        if (this.param.isDefined()) {
            this.param.setDefined(false);
            this.internalModification = true;
            this.editorControl.setText(UNDEFINED_LABEL);
            this.internalModification = false;
            this.modifyValue(null);
        } else {
            this.param.setDefined(true);
            this.internalModification = true;
            this.expression.modifyValue();
            this.internalModification = false;
        }
        this.updateToolbar();
    }

    @Override
    protected int[] getToolItems() {
        if (this.acceptNull) {
            int[] nArray = new int[4];
            nArray[0] = 7;
            nArray[2] = 1;
            nArray[3] = 6;
            return nArray;
        }
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 6;
        return nArray;
    }
}

