/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views;

import com.google.common.primitives.Ints;
import gama.core.common.interfaces.IGamaView;
import gama.core.common.interfaces.ItemList;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.FileUtils;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.gaml.statements.test.AbstractSummary;
import gama.gaml.statements.test.CompoundSummary;
import gama.gaml.statements.test.TestExperimentSummary;
import gama.gaml.statements.test.TestState;
import gama.ui.shared.controls.ParameterExpandItem;
import gama.ui.shared.controls.StatusIconProvider;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.parameters.AssertEditor;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.ExpandableItemsView;
import gama.ui.shared.views.toolbar.GamaCommand;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class TestView
extends ExpandableItemsView<AbstractSummary<?>>
implements IGamaView.Test {
    static final Comparator<AbstractSummary<?>> BY_ORDER = (abstractSummary, abstractSummary2) -> Ints.compare((int)abstractSummary.getIndex(), (int)abstractSummary2.getIndex());
    static final Comparator<AbstractSummary<?>> BY_SEVERITY = (abstractSummary, abstractSummary2) -> {
        TestState testState;
        TestState testState2 = abstractSummary.getState();
        if (testState2 == (testState = abstractSummary2.getState())) {
            return BY_ORDER.compare((AbstractSummary<?>)abstractSummary, (AbstractSummary<?>)abstractSummary2);
        }
        return testState2.compareTo((Enum)testState);
    };
    public final List<AbstractSummary<?>> experiments = new ArrayList();
    private boolean runningAllTests;
    private final StatusIconProvider iconProvider = new StatusIconProvider();
    public static String ID = "gama.ui.application.view.TestView";
    boolean updateIcon = false;

    @Override
    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.experiments.clear();
        super.reset();
    }

    @Override
    protected boolean areItemsClosable() {
        return false;
    }

    protected void resortTests() {
        Comparator<AbstractSummary<?>> comparator = (Boolean)GamaPreferences.Runtime.TESTS_SORTED.getValue() != false ? BY_SEVERITY : BY_ORDER;
        this.experiments.sort(comparator);
    }

    public void startNewTestSequence(boolean bl) {
        this.runningAllTests = bl;
        this.experiments.clear();
        WorkbenchHelper.run(() -> {
            if (this.toolbar != null) {
                this.toolbar.status(null, "Run experiment to see the tests results", selectionEvent -> GAMA.startFrontmostExperiment((boolean)false), null);
            }
        });
        super.reset();
    }

    public void finishTestSequence() {
        super.reset();
        this.updateIcon = false;
        this.reset();
    }

    public void addTestResult(CompoundSummary<?, ?> compoundSummary) {
        if (compoundSummary instanceof TestExperimentSummary) {
            if (!this.experiments.contains(compoundSummary)) {
                this.experiments.add((AbstractSummary<?>)compoundSummary);
            }
        } else {
            for (AbstractSummary abstractSummary : compoundSummary.getSummaries().values()) {
                if (this.experiments.contains(abstractSummary)) continue;
                this.experiments.add(abstractSummary);
            }
        }
    }

    public boolean addItem(AbstractSummary<?> abstractSummary) {
        TestState testState;
        ParameterExpandItem parameterExpandItem;
        boolean bl = (Boolean)GamaPreferences.Runtime.FAILED_TESTS.getValue();
        ParameterExpandItem parameterExpandItem2 = parameterExpandItem = this.getViewer() == null ? null : this.getViewer().getItem(abstractSummary);
        if (parameterExpandItem != null) {
            parameterExpandItem.dispose();
        }
        if (bl && (testState = abstractSummary.getState()) != TestState.FAILED && testState != TestState.ABORTED) {
            return false;
        }
        parameterExpandItem = this.createItem(this.getParentComposite(), abstractSummary, !this.runningAllTests, GamaColors.get((Color)this.getItemDisplayColor(abstractSummary)));
        return true;
    }

    @Override
    public void ownCreatePartControl(Composite composite) {
    }

    @Override
    protected ParameterExpandItem createItem(Composite composite, AbstractSummary<?> abstractSummary, boolean bl, GamaColors.GamaUIColor gamaUIColor) {
        ParameterExpandItem parameterExpandItem;
        this.createViewer(composite);
        if (this.getViewer() == null) {
            return null;
        }
        EditorsGroup editorsGroup = this.createItemContentsFor(abstractSummary);
        if (bl) {
            this.createEditors(editorsGroup, abstractSummary);
            parameterExpandItem = this.createItem(composite, abstractSummary, editorsGroup, bl, gamaUIColor);
        } else {
            parameterExpandItem = this.createItem(composite, abstractSummary, editorsGroup, bl, gamaUIColor);
            parameterExpandItem.onExpand(() -> this.createEditors(editorsGroup, abstractSummary));
        }
        return parameterExpandItem;
    }

    protected EditorsGroup createItemContentsFor(AbstractSummary<?> abstractSummary) {
        EditorsGroup editorsGroup = new EditorsGroup(this.getViewer());
        editorsGroup.setBackground(this.getViewer().getBackground());
        return editorsGroup;
    }

    public void createEditors(EditorsGroup editorsGroup, AbstractSummary<?> abstractSummary) {
        Map map = abstractSummary.getSummaries();
        for (Map.Entry entry : map.entrySet()) {
            AbstractSummary abstractSummary2 = (AbstractSummary)entry.getValue();
            String string = (String)entry.getKey();
            this.createEditor(editorsGroup, abstractSummary, abstractSummary2, string);
            if (!(abstractSummary2 instanceof CompoundSummary)) continue;
            map = abstractSummary2.getSummaries();
            for (Map.Entry entry2 : map.entrySet()) {
                this.createEditor(editorsGroup, abstractSummary, (AbstractSummary)entry2.getValue(), (String)entry2.getKey());
            }
        }
    }

    public void createEditor(EditorsGroup editorsGroup, AbstractSummary<?> abstractSummary, AbstractSummary<?> abstractSummary2, String string) {
        Object object;
        if (((Boolean)GamaPreferences.Runtime.FAILED_TESTS.getValue()).booleanValue() && (object = abstractSummary2.getState()) != TestState.FAILED && object != TestState.ABORTED) {
            return;
        }
        object = new AssertEditor(GAMA.getRuntimeScope(), abstractSummary2);
        ((AbstractEditor)object).createControls(editorsGroup);
    }

    @Override
    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        super.createToolItems(gamaToolbar2);
        GamaPreferences.Runtime.TESTS_SORTED.removeChangeListeners();
        GamaPreferences.Runtime.FAILED_TESTS.removeChangeListeners();
        GamaToolbarSimple gamaToolbarSimple = this.toolbar.getToolbar(131072);
        gamaToolbarSimple.button("editor/local.menu", "More...", "More options", selectionEvent -> {
            GamaMenu gamaMenu = new GamaMenu(){

                @Override
                protected void fillMenu() {
                    GamaCommand.build("validation/test.sort", "Sort by severity", "When checked, sort the tests by their decreasing state severity (i.e. errored > failed > warning > passed > not run). Otherwise they are sorted by their order of execution.", selectionEvent -> {
                        GamaPreferences.Runtime.TESTS_SORTED.set((Object)((Boolean)GamaPreferences.Runtime.TESTS_SORTED.getValue() == false ? 1 : 0));
                        TestView.this.reset();
                        this.reset();
                    }).toCheckItem(this.mainMenu).setSelection(((Boolean)GamaPreferences.Runtime.TESTS_SORTED.getValue()).booleanValue());
                    GamaCommand.build("validation/test.filter", "Filter tests", "When checked, show only errored and failed tests and assertions", selectionEvent -> {
                        GamaPreferences.Runtime.FAILED_TESTS.set((Object)((Boolean)GamaPreferences.Runtime.FAILED_TESTS.getValue() == false ? 1 : 0));
                        TestView.this.reset();
                        this.reset();
                    }).toCheckItem(this.mainMenu).setSelection(((Boolean)GamaPreferences.Runtime.FAILED_TESTS.getValue()).booleanValue());
                    GamaMenu.separate(this.mainMenu);
                    GamaCommand.build("generic/menu.saveas", "Save tests", "Save the current tests as a text file", selectionEvent -> TestView.this.saveTests()).toItem(this.mainMenu);
                }
            };
            gamaMenu.open((Control)gamaToolbarSimple, selectionEvent, gamaToolbarSimple.getSize().y, 0);
        });
    }

    public void saveTests() {
        DirectoryDialog directoryDialog = new DirectoryDialog(WorkbenchHelper.getShell(), 0);
        directoryDialog.setFilterPath(GAMA.getModel() == null ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() : GAMA.getModel().getFilePath());
        directoryDialog.setMessage("Choose a folder for saving the tests");
        String string = directoryDialog.open();
        if (string == null) {
            return;
        }
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Object object = string + File.separator + "tests_" + new SimpleDateFormat("yyyy-MM-dd HH.mm.ss").format(timestamp) + ".txt";
        object = FileUtils.constructAbsoluteFilePath((IScope)GAMA.getRuntimeScope(), (String)object, (boolean)false);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintWriter printWriter = new PrintWriter((String)object);){
                for (AbstractSummary<?> abstractSummary : this.experiments) {
                    printWriter.println(abstractSummary.toString());
                    printWriter.flush();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void removeItem(AbstractSummary<?> abstractSummary) {
    }

    @Override
    public void pauseItem(AbstractSummary<?> abstractSummary) {
    }

    @Override
    public void resumeItem(AbstractSummary<?> abstractSummary) {
    }

    @Override
    public String getItemDisplayName(AbstractSummary<?> abstractSummary, String string) {
        StringBuilder stringBuilder = new StringBuilder(300);
        String string2 = abstractSummary.getTitle();
        stringBuilder.append(abstractSummary.getState()).append(ItemList.SEPARATION_CODE).append(string2).append(' ');
        return stringBuilder.toString();
    }

    @Override
    protected boolean shouldBeClosedWhenNoExperiments() {
        return !this.runningAllTests;
    }

    @Override
    public GamaColor getItemDisplayColor(AbstractSummary<?> abstractSummary) {
        return abstractSummary.getColor(null);
    }

    @Override
    public void focusItem(AbstractSummary<?> abstractSummary) {
    }

    @Override
    public List<AbstractSummary<?>> getItems() {
        return this.experiments;
    }

    @Override
    public void updateItemValues(boolean bl) {
    }

    @Override
    public void reset() {
        WorkbenchHelper.run(() -> {
            if (!this.getParentComposite().isDisposed()) {
                this.resortTests();
                this.displayItems();
                this.getParentComposite().layout(true, false);
                if (this.toolbar != null) {
                    this.toolbar.status(new CompoundSummary(this.experiments).getStringSummary());
                }
                ViewsHelper.bringToFront((IWorkbenchPart)this);
            }
        });
    }

    public Map<String, Runnable> handleMenu(AbstractSummary<?> abstractSummary, int n, int n2) {
        HashMap<String, Runnable> hashMap = new HashMap<String, Runnable>();
        hashMap.put("Copy summary to clipboard", () -> WorkbenchHelper.copy(abstractSummary.toString()));
        hashMap.put("Show in editor", () -> GAMA.getGui().editModel((Object)abstractSummary.getURI()));
        return hashMap;
    }

    @Override
    protected boolean needsOutput() {
        return false;
    }

    public void displayProgress(int n, int n2) {
        if (!this.updateIcon) {
            this.updateIcon = true;
            Callable<Boolean> callable = () -> !this.updateIcon;
            WorkbenchHelper.asyncRun(() -> {
                if (this.toolbar != null) {
                    this.toolbar.updateStatusImage(this.iconProvider.getIcon());
                    GAMA.getGui().getStatus().informStatus("Running tests", "status/status.simulation");
                }
            }, 100, callable);
        }
        WorkbenchHelper.asyncRun(() -> {
            if (this.toolbar != null) {
                this.toolbar.status(this.iconProvider.getIcon(), "Executing test models: " + n + " on " + n2, null);
            }
        });
    }
}

