/*
 * Decompiled with CFR 0.152.
 */
package gama.annotations.precompiler.doc;

import gama.annotations.precompiler.GamlAnnotations;
import gama.annotations.precompiler.doc.utils.TypeConverter;
import java.util.ArrayList;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DocProcessorAnnotations {
    public static final String PREFIX_CONSTANT = "#";

    public static org.w3c.dom.Element getDocElt(GamlAnnotations.doc docAnnot, Document doc2, Messager mes, String eltName, TypeConverter tc, ExecutableElement e) {
        return DocProcessorAnnotations.getDocElt(docAnnot, doc2, null, mes, eltName, tc, e);
    }

    public static org.w3c.dom.Element getDocElt(GamlAnnotations.doc[] docAnnotTab, Document doc2, Messager mes, String eltName, TypeConverter tc, ExecutableElement e) {
        if (docAnnotTab == null || docAnnotTab.length == 0) {
            return DocProcessorAnnotations.getDocElt(null, doc2, null, mes, eltName, tc, e);
        }
        return DocProcessorAnnotations.getDocElt(docAnnotTab[0], doc2, null, mes, eltName, tc, e);
    }

    public static org.w3c.dom.Element getDocElt(GamlAnnotations.doc docAnnot, Document doc2, org.w3c.dom.Element docElement, Messager mes, String eltName, TypeConverter tc, ExecutableElement e) {
        org.w3c.dom.Element docElt = docElement;
        if (docAnnot != null) {
            String comment;
            if (docElt == null) {
                docElt = doc2.createElement("documentation");
            }
            String value = docAnnot.value();
            boolean masterDoc = docAnnot.masterDoc();
            if (!"".equals(value)) {
                if (docElt.getElementsByTagName("result").getLength() != 0) {
                    resultElt = (org.w3c.dom.Element)docElt.getElementsByTagName("result").item(0);
                    if ("true".equals(resultElt.getAttribute("masterDoc")) && masterDoc || !"true".equals(resultElt.getAttribute("masterDoc")) && !masterDoc) {
                        resultElt.setTextContent(resultElt.getTextContent() + "\n" + value);
                    } else if (!resultElt.hasAttribute("masterDoc") && masterDoc) {
                        resultElt.setTextContent(value);
                        resultElt.setAttribute("masterDoc", "true");
                    }
                } else {
                    resultElt = doc2.createElement("result");
                    resultElt.setTextContent(value);
                    if (masterDoc) {
                        resultElt.setAttribute("masterDoc", "true");
                    }
                    docElt.appendChild(resultElt);
                }
            }
            if (!"".equals(comment = docAnnot.comment())) {
                if (docElt.getElementsByTagName("comment").getLength() != 0) {
                    docElt.getElementsByTagName("comment").item(0).setTextContent(docElt.getElementsByTagName("comment").item(0).getTextContent() + comment);
                } else {
                    org.w3c.dom.Element commentElt = doc2.createElement("comment");
                    commentElt.setTextContent(comment);
                    docElt.appendChild(commentElt);
                }
            }
            org.w3c.dom.Element seeAlsoElt = docElt.getElementsByTagName("seeAlso").getLength() != 0 ? (org.w3c.dom.Element)docElt.getElementsByTagName("seeAlso").item(0) : doc2.createElement("seeAlso");
            String[] stringArray = docAnnot.see();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String see = stringArray[n2];
                NodeList nLSee = seeAlsoElt.getElementsByTagName("see");
                int i = 0;
                boolean seeAlreadyInserted = false;
                while (i < nLSee.getLength() && !seeAlreadyInserted) {
                    if (((org.w3c.dom.Element)nLSee.item(i)).getAttribute("id").equals(see)) {
                        seeAlreadyInserted = true;
                    }
                    ++i;
                }
                if (!seeAlreadyInserted) {
                    org.w3c.dom.Element seesElt = doc2.createElement("see");
                    seesElt.setAttribute("id", see);
                    seeAlsoElt.appendChild(seesElt);
                }
                ++n2;
            }
            if (docAnnot.see().length != 0) {
                docElt.appendChild(seeAlsoElt);
            }
            org.w3c.dom.Element usagesElt = docElt.getElementsByTagName("usages").getLength() != 0 ? (org.w3c.dom.Element)docElt.getElementsByTagName("usages").item(0) : doc2.createElement("usages");
            org.w3c.dom.Element usagesExampleElt = docElt.getElementsByTagName("usagesExamples").getLength() != 0 ? (org.w3c.dom.Element)docElt.getElementsByTagName("usagesExamples").item(0) : doc2.createElement("usagesExamples");
            org.w3c.dom.Element usagesNoExampleElt = docElt.getElementsByTagName("usagesNoExample").getLength() != 0 ? (org.w3c.dom.Element)docElt.getElementsByTagName("usagesNoExample").item(0) : doc2.createElement("usagesNoExample");
            int numberOfUsages = 0;
            int numberOfUsagesWithExamplesOnly = 0;
            int numberOfUsagesWithoutExample = 0;
            Object[] objectArray = docAnnot.usages();
            int n3 = objectArray.length;
            int seesElt = 0;
            while (seesElt < n3) {
                GamlAnnotations.usage usage2 = objectArray[seesElt];
                org.w3c.dom.Element usageElt = doc2.createElement("usage");
                if ("".equals(usage2.value())) {
                    ++numberOfUsagesWithExamplesOnly;
                    examplesUsageElt = DocProcessorAnnotations.getExamplesElt(usage2.examples(), doc2, e, tc);
                    usageElt.appendChild(examplesUsageElt);
                    usagesExampleElt.appendChild(usageElt);
                } else if (usage2.examples().length == 0) {
                    ++numberOfUsagesWithoutExample;
                    usageElt.setAttribute("descUsageElt", usage2.value());
                    usagesNoExampleElt.appendChild(usageElt);
                } else {
                    ++numberOfUsages;
                    usageElt.setAttribute("descUsageElt", usage2.value());
                    examplesUsageElt = DocProcessorAnnotations.getExamplesElt(usage2.examples(), doc2, e, tc);
                    usageElt.appendChild(examplesUsageElt);
                    usagesElt.appendChild(usageElt);
                }
                ++seesElt;
            }
            if (docAnnot.examples().length != 0) {
                org.w3c.dom.Element usageExElt = doc2.createElement("usage");
                org.w3c.dom.Element examplesElt = DocProcessorAnnotations.getExamplesElt(docAnnot.examples(), doc2, e, tc);
                numberOfUsagesWithExamplesOnly += docAnnot.examples().length;
                usageExElt.appendChild(examplesElt);
                usagesExampleElt.appendChild(usageExElt);
            }
            objectArray = docAnnot.special_cases();
            n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object cases = objectArray[n4];
                if (!"".equals(cases)) {
                    org.w3c.dom.Element caseElt = doc2.createElement("usage");
                    caseElt.setAttribute("descUsageElt", (String)cases);
                    usagesNoExampleElt.appendChild(caseElt);
                    ++numberOfUsagesWithoutExample;
                }
                ++n4;
            }
            if (numberOfUsagesWithExamplesOnly != 0) {
                docElt.appendChild(usagesExampleElt);
            }
            if (numberOfUsagesWithoutExample != 0) {
                docElt.appendChild(usagesNoExampleElt);
            }
            if (numberOfUsages != 0) {
                docElt.appendChild(usagesElt);
            }
        }
        return docElt;
    }

    public static org.w3c.dom.Element getExamplesElt(GamlAnnotations.example[] examples, Document doc2, ExecutableElement e, TypeConverter tc) {
        org.w3c.dom.Element examplesElt = doc2.createElement("examples");
        GamlAnnotations.example[] exampleArray = examples;
        int n = examples.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.example example2 = exampleArray[n2];
            examplesElt.appendChild(DocProcessorAnnotations.getExampleElt(example2, doc2, e, tc));
            ++n2;
        }
        return examplesElt;
    }

    public static org.w3c.dom.Element getExampleElt(GamlAnnotations.example example2, Document doc2, ExecutableElement e, TypeConverter tc) {
        org.w3c.dom.Element exampleElt = doc2.createElement("example");
        exampleElt.setAttribute("code", example2.value());
        if (!"".equals(example2.var())) {
            exampleElt.setAttribute("var", example2.var());
        }
        if (!"".equals(example2.equals())) {
            exampleElt.setAttribute("equals", example2.equals());
        }
        if (!"".equals(example2.isNot())) {
            exampleElt.setAttribute("isNot", example2.isNot());
        }
        if (!"".equals(example2.raises())) {
            exampleElt.setAttribute("raises", example2.raises());
        }
        exampleElt.setAttribute("isTestOnly", "" + example2.isTestOnly());
        exampleElt.setAttribute("isExecutable", "" + example2.isExecutable());
        if (!example2.isExecutable()) {
            exampleElt.setAttribute("test", "false");
        } else {
            exampleElt.setAttribute("test", "" + example2.test());
        }
        if (!"".equals(example2.returnType())) {
            exampleElt.setAttribute("type", example2.returnType());
        } else if (e != null) {
            exampleElt.setAttribute("type", tc.getProperType(e.getReturnType().toString()));
        }
        return exampleElt;
    }

    public static org.w3c.dom.Element getConstantElt(GamlAnnotations.constant constant2, Document doc2, Element e, Messager mes, TypeConverter tc) {
        org.w3c.dom.Element constantElt = doc2.createElement("constant");
        constantElt.setAttribute("name", PREFIX_CONSTANT + constant2.value());
        Object valCst = ((VariableElement)e).getConstantValue();
        String valCstStr = valCst == null ? "No Default Value" : valCst.toString();
        constantElt.setAttribute("value", valCstStr);
        StringBuilder strBuilder = new StringBuilder();
        boolean firstPass = true;
        String[] stringArray = constant2.altNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (firstPass) {
                firstPass = false;
            } else {
                strBuilder.append(",");
            }
            strBuilder.append(PREFIX_CONSTANT);
            strBuilder.append(n3);
            ++n2;
        }
        String names = strBuilder.toString();
        if (!"".equals(names)) {
            constantElt.setAttribute("altNames", names);
        }
        constantElt.appendChild(DocProcessorAnnotations.getCategories(e, doc2, doc2.createElement("categories"), tc));
        org.w3c.dom.Element docConstantElt = DocProcessorAnnotations.getDocElt(constant2.doc(), doc2, mes, e.getSimpleName().toString(), null, null);
        if (docConstantElt != null) {
            constantElt.appendChild(docConstantElt);
        }
        return constantElt;
    }

    public static org.w3c.dom.Element getVarsElt(GamlAnnotations.vars varsAnnot, Document doc2, Messager mes, String skillName, TypeConverter tc) {
        if (varsAnnot == null) {
            return null;
        }
        org.w3c.dom.Element varsElt = doc2.createElement("vars");
        GamlAnnotations.variable[] variableArray = varsAnnot.value();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.variable v = variableArray[n2];
            org.w3c.dom.Element varElt = doc2.createElement("var");
            varElt.setAttribute("name", v.name());
            varElt.setAttribute("type", tc.getTypeString(v.type()));
            varElt.setAttribute("constant", "" + v.constant());
            org.w3c.dom.Element docEltVar = DocProcessorAnnotations.getDocElt(v.doc(), doc2, mes, "Var " + v.name() + " from " + skillName, tc, null);
            if (docEltVar != null) {
                varElt.appendChild(docEltVar);
            }
            StringBuilder strBuilder = new StringBuilder();
            int i = 0;
            while (i < v.depends_on().length) {
                String dependElement = v.depends_on()[i];
                strBuilder.append(dependElement);
                if (i < v.depends_on().length - 1) {
                    strBuilder.append(",");
                }
                ++i;
            }
            String dependsOn = strBuilder.toString();
            varElt.setAttribute("depends_on", dependsOn);
            varsElt.appendChild(varElt);
            ++n2;
        }
        return varsElt;
    }

    public static org.w3c.dom.Element getActionElt(GamlAnnotations.action actionAnnot, Document doc2, Messager mes, Element e, TypeConverter tc) {
        ExecutableElement eltMethod;
        block7: {
            block6: {
                if (!(e instanceof ExecutableElement)) break block6;
                eltMethod = (ExecutableElement)e;
                if (actionAnnot != null) break block7;
            }
            return null;
        }
        org.w3c.dom.Element actionElt = doc2.createElement("action");
        actionElt.setAttribute("name", actionAnnot.name());
        actionElt.setAttribute("returnType", tc.getProperType(eltMethod.getReturnType().toString()));
        org.w3c.dom.Element argsElt = doc2.createElement("args");
        GamlAnnotations.arg[] argArray = actionAnnot.args();
        int n = argArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.arg eltArg = argArray[n2];
            org.w3c.dom.Element argElt = doc2.createElement("arg");
            argElt.setAttribute("name", eltArg.name());
            String tabType = tc.getTypeString(eltArg.type());
            argElt.setAttribute("type", tabType);
            argElt.setAttribute("optional", "" + eltArg.optional());
            org.w3c.dom.Element docEltArg = DocProcessorAnnotations.getDocElt(eltArg.doc(), doc2, mes, "Arg " + eltArg.name() + " from " + String.valueOf(eltMethod.getSimpleName()), tc, null);
            if (docEltArg != null) {
                argElt.appendChild(docEltArg);
            }
            argsElt.appendChild(argElt);
            ++n2;
        }
        actionElt.appendChild(argsElt);
        org.w3c.dom.Element docEltAction = DocProcessorAnnotations.getDocElt(actionAnnot.doc(), doc2, mes, eltMethod.getSimpleName().toString(), tc, null);
        if (docEltAction != null) {
            actionElt.appendChild(docEltAction);
        }
        return actionElt;
    }

    public static org.w3c.dom.Element getFacetsElt(GamlAnnotations.facets facetsAnnot, Document doc2, Messager mes, String statName, TypeConverter tc) {
        if (facetsAnnot == null) {
            return null;
        }
        org.w3c.dom.Element facetsElt = doc2.createElement("facets");
        GamlAnnotations.facet[] facetArray = facetsAnnot.value();
        int n = facetArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.facet f = facetArray[n2];
            org.w3c.dom.Element facetElt = doc2.createElement("facet");
            facetElt.setAttribute("name", f.name());
            facetElt.setAttribute("type", tc.getTypeString(f.type()));
            facetElt.setAttribute("optional", "" + f.optional());
            if (f.values().length != 0) {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.append(", takes values in: {");
                strBuilder.append(f.values()[0]);
                int i = 1;
                while (i < f.values().length) {
                    strBuilder.append(", ");
                    strBuilder.append(f.values()[i]);
                    ++i;
                }
                strBuilder.append("}");
                facetElt.setAttribute("values", strBuilder.toString());
            }
            facetElt.setAttribute("omissible", f.name().equals(facetsAnnot.omissible()) ? "true" : "false");
            org.w3c.dom.Element docFacetElt = DocProcessorAnnotations.getDocElt(f.doc(), doc2, mes, "Facet " + f.name() + " from Statement" + statName, tc, null);
            if (docFacetElt != null) {
                facetElt.appendChild(docFacetElt);
            }
            facetsElt.appendChild(facetElt);
            ++n2;
        }
        return facetsElt;
    }

    public static org.w3c.dom.Element getInsideElt(GamlAnnotations.inside insideAnnot, Document doc2, TypeConverter tc) {
        if (insideAnnot == null) {
            return null;
        }
        org.w3c.dom.Element insideElt = doc2.createElement("inside");
        org.w3c.dom.Element symbolsElt = doc2.createElement("symbols");
        String[] stringArray = insideAnnot.symbols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String sym = stringArray[n2];
            org.w3c.dom.Element symElt = doc2.createElement("symbol");
            symElt.setTextContent(sym);
            symbolsElt.appendChild(symElt);
            ++n2;
        }
        insideElt.appendChild(symbolsElt);
        org.w3c.dom.Element kindsElt = doc2.createElement("kinds");
        int[] nArray = insideAnnot.kinds();
        int n3 = nArray.length;
        n = 0;
        while (n < n3) {
            int kind = nArray[n];
            org.w3c.dom.Element kindElt = doc2.createElement("kind");
            kindElt.setTextContent(tc.getSymbolKindStringFromISymbolKind(kind));
            kindsElt.appendChild(kindElt);
            ++n;
        }
        insideElt.appendChild(kindsElt);
        return insideElt;
    }

    public static org.w3c.dom.Element getOperatorElement(org.w3c.dom.Element operators, String eltName) {
        NodeList nL = operators.getElementsByTagName("operator");
        int i = 0;
        while (i < nL.getLength()) {
            org.w3c.dom.Element elt = (org.w3c.dom.Element)nL.item(i);
            if (eltName.equals(elt.getAttribute("id"))) {
                return elt;
            }
            ++i;
        }
        return null;
    }

    public static org.w3c.dom.Element getCategories(Element e, Document doc2, org.w3c.dom.Element categoriesElt, TypeConverter tc) {
        ArrayList<String> categories = new ArrayList<String>();
        String[] categoriesTab = null;
        NodeList nL = categoriesElt.getElementsByTagName("category");
        int i = 0;
        while (i < nL.getLength()) {
            categories.add(((org.w3c.dom.Element)nL.item(i)).getAttribute("id"));
            ++i;
        }
        if (e.getAnnotation(GamlAnnotations.operator.class) != null) {
            categoriesTab = e.getAnnotation(GamlAnnotations.operator.class).category();
        } else if (e.getAnnotation(GamlAnnotations.constant.class) != null) {
            categoriesTab = e.getAnnotation(GamlAnnotations.constant.class).category();
        }
        if (e.getAnnotation(GamlAnnotations.operator.class) != null && e.getAnnotation(GamlAnnotations.operator.class).category().length > 0 || e.getAnnotation(GamlAnnotations.constant.class) != null && e.getAnnotation(GamlAnnotations.constant.class).category().length > 0) {
            if (categoriesTab != null) {
                String[] stringArray = categoriesTab;
                int n = categoriesTab.length;
                int n2 = 0;
                while (n2 < n) {
                    String categoryName = stringArray[n2];
                    if (!categories.contains(categoryName)) {
                        categories.add(categoryName);
                        org.w3c.dom.Element catElt = doc2.createElement("category");
                        catElt.setAttribute("id", categoryName);
                        categoriesElt.appendChild(catElt);
                    }
                    ++n2;
                }
            }
        } else if (!categories.contains(tc.getProperCategory(e.getEnclosingElement().getSimpleName().toString()))) {
            org.w3c.dom.Element catElt = doc2.createElement("category");
            catElt.setAttribute("id", tc.getProperCategory(e.getEnclosingElement().getSimpleName().toString()));
            categoriesElt.appendChild(catElt);
        }
        if (e.getAnnotation(GamlAnnotations.operator.class) != null && e.getAnnotation(GamlAnnotations.operator.class).iterator()) {
            org.w3c.dom.Element catElt = doc2.createElement("category");
            catElt.setAttribute("id", "Iterator operators");
            categoriesElt.appendChild(catElt);
        }
        return categoriesElt;
    }

    public static org.w3c.dom.Element getCategories(Element e, Document doc2, TypeConverter tc) {
        org.w3c.dom.Element categoriesElt = doc2.createElement("operatorsCategories");
        return DocProcessorAnnotations.getCategories(e, doc2, categoriesElt, tc);
    }

    public static org.w3c.dom.Element getConcepts(Element e, Document doc2, org.w3c.dom.Element conceptElt, TypeConverter tc) {
        ArrayList<String> concepts = new ArrayList<String>();
        String[] conceptsTab = null;
        NodeList nL = conceptElt.getElementsByTagName("concept");
        int i = 0;
        while (i < nL.getLength()) {
            concepts.add(((org.w3c.dom.Element)nL.item(i)).getAttribute("id"));
            ++i;
        }
        if (e.getAnnotation(GamlAnnotations.operator.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.operator.class).concept();
        } else if (e.getAnnotation(GamlAnnotations.constant.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.constant.class).concept();
        } else if (e.getAnnotation(GamlAnnotations.type.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.type.class).concept();
        } else if (e.getAnnotation(GamlAnnotations.species.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.species.class).concept();
        } else if (e.getAnnotation(GamlAnnotations.symbol.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.symbol.class).concept();
        } else if (e.getAnnotation(GamlAnnotations.skill.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.skill.class).concept();
        }
        if ((e.getAnnotation(GamlAnnotations.operator.class) != null && e.getAnnotation(GamlAnnotations.operator.class).concept().length > 0 || e.getAnnotation(GamlAnnotations.constant.class) != null && e.getAnnotation(GamlAnnotations.constant.class).concept().length > 0 || e.getAnnotation(GamlAnnotations.type.class) != null && e.getAnnotation(GamlAnnotations.type.class).concept().length > 0 || e.getAnnotation(GamlAnnotations.skill.class) != null && e.getAnnotation(GamlAnnotations.skill.class).concept().length > 0 || e.getAnnotation(GamlAnnotations.species.class) != null && e.getAnnotation(GamlAnnotations.species.class).concept().length > 0 || e.getAnnotation(GamlAnnotations.symbol.class) != null && e.getAnnotation(GamlAnnotations.symbol.class).concept().length > 0) && conceptsTab != null) {
            String[] stringArray = conceptsTab;
            int n = conceptsTab.length;
            int n2 = 0;
            while (n2 < n) {
                String conceptName = stringArray[n2];
                if (!concepts.contains(conceptName)) {
                    concepts.add(conceptName);
                    org.w3c.dom.Element catElt = doc2.createElement("concept");
                    catElt.setAttribute("id", conceptName);
                    conceptElt.appendChild(catElt);
                }
                ++n2;
            }
        }
        if (e.getAnnotation(GamlAnnotations.operator.class) != null && e.getAnnotation(GamlAnnotations.operator.class).iterator()) {
            org.w3c.dom.Element catElt = doc2.createElement("concept");
            catElt.setAttribute("id", "Iterator operators");
            conceptElt.appendChild(catElt);
        }
        return conceptElt;
    }
}

