/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.batch.optimization.ALocalSearchAlgorithm;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.util.Collections;
import java.util.List;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true, doc={@GamlAnnotations.doc(value="The name of the method. For internal use only")}), @GamlAnnotations.facet(name="temp_end", type={2}, optional=true, doc={@GamlAnnotations.doc(value="final temperature")}), @GamlAnnotations.facet(name="init_solution", type={10}, optional=true, doc={@GamlAnnotations.doc(value="init solution: key: name of the variable, value: value of the variable")}), @GamlAnnotations.facet(name="temp_decrease", type={2}, optional=true, doc={@GamlAnnotations.doc(value="temperature decrease coefficient. At each iteration, the current temperature is multiplied by this coefficient.")}), @GamlAnnotations.facet(name="temp_init", type={2}, optional=true, doc={@GamlAnnotations.doc(value="initial temperature")}), @GamlAnnotations.facet(name="nb_iter_cst_temp", type={1}, optional=true, doc={@GamlAnnotations.doc(value="number of iterations per level of temperature")}), @GamlAnnotations.facet(name="maximize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to maximize")}), @GamlAnnotations.facet(name="minimize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to minimize")}), @GamlAnnotations.facet(name="aggregation", type={-200}, optional=true, values={"min", "max"}, doc={@GamlAnnotations.doc(value="the agregation method")})}, omissible="name")
@GamlAnnotations.doc(value="This algorithm is an implementation of the Simulated Annealing algorithm. See the wikipedia article and [batch161 the batch dedicated page].", usages={@GamlAnnotations.usage(value="As other batch methods, the basic syntax of the annealing statement uses `method annealing` instead of the expected `annealing name: id` : ", examples={@GamlAnnotations.example(value="method annealing [facet: value];", isExecutable=false)}), @GamlAnnotations.usage(value="For example: ", examples={@GamlAnnotations.example(value="method annealing temp_init: 100  temp_end: 1 temp_decrease: 0.5 nb_iter_cst_temp: 5 maximize: food_gathered;", isExecutable=false)})})
public class SimulatedAnnealing
extends ALocalSearchAlgorithm {
    double temperatureEnd = 1.0;
    double tempDimCoeff = 0.5;
    double temperatureInit = 100.0;
    int nbIterCstTemp = 5;
    protected static final String TEMP_END = "temp_end";
    protected static final String TEMP_DECREASE = "temp_decrease";
    protected static final String TEMP_INIT = "temp_init";
    protected static final String NB_ITER = "nb_iter_cst_temp";

    public SimulatedAnnealing(IDescription iDescription) {
        super(iDescription);
        this.initParams();
    }

    @Override
    public void initParams(IScope iScope) {
        IExpression iExpression;
        IExpression iExpression2;
        IExpression iExpression3;
        IExpression iExpression4 = this.getFacet(TEMP_END);
        if (iExpression4 != null) {
            this.temperatureEnd = Cast.asFloat(iScope, iExpression4.value(iScope));
        }
        if ((iExpression3 = this.getFacet(TEMP_DECREASE)) != null) {
            this.tempDimCoeff = Cast.asFloat(iScope, iExpression3.value(iScope));
        }
        if ((iExpression2 = this.getFacet(TEMP_INIT)) != null) {
            this.temperatureInit = Cast.asFloat(iScope, iExpression2.value(iScope));
        }
        if ((iExpression = this.getFacet(NB_ITER)) != null) {
            this.nbIterCstTemp = Cast.asInt(iScope, iExpression.value(iScope));
        }
    }

    @Override
    public ParametersSet findBestSolution(IScope iScope) throws GamaRuntimeException {
        this.initializeTestedSolutions();
        this.setBestSolution(new ParametersSet(this.solutionInit));
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return this.getBestSolution();
        }
        double d = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(this.getBestSolution()));
        ParametersSet parametersSet = this.solutionInit;
        this.testedSolutions.put(this.getBestSolution(), this.getBestFitness());
        this.setBestFitness(d);
        double d2 = this.temperatureInit;
        while (d2 > this.temperatureEnd) {
            List<ParametersSet> list = this.neighborhood.neighbor(iScope, parametersSet);
            if (list.isEmpty()) break;
            int n = 0;
            while (n < this.nbIterCstTemp) {
                ParametersSet parametersSet2 = list.get(iScope.getRandom().between(0, list.size() - 1));
                if (parametersSet2 == null) {
                    list.removeAll(Collections.singleton(null));
                    if (!list.isEmpty()) continue;
                    break;
                }
                Double d3 = (Double)this.testedSolutions.get(parametersSet2);
                if (d3 == null || d3 == Double.MAX_VALUE) {
                    d3 = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(parametersSet2));
                    this.testedSolutions.put(parametersSet2, d3);
                }
                if (this.isMaximize()) {
                    if (d3 >= d || iScope.getRandom().next() < Math.exp(Math.abs(d3 - d) / d2)) {
                        parametersSet = parametersSet2;
                        d = d3;
                    }
                } else if (d3 <= d || iScope.getRandom().next() < Math.exp(Math.abs(d - d3) / d2)) {
                    parametersSet = parametersSet2;
                    d = d3;
                }
                ++n;
            }
            d2 *= this.tempDimCoeff;
        }
        return this.getBestSolution();
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, BatchAgent batchAgent) {
        super.addParametersTo(list, batchAgent);
        list.add(new ParameterAdapter("Final temperature", "Calibration experiment", 2){

            @Override
            public Object value() {
                return SimulatedAnnealing.this.temperatureEnd;
            }
        });
        list.add(new ParameterAdapter("Initial temperature", "Calibration experiment", 2){

            @Override
            public Object value() {
                return SimulatedAnnealing.this.temperatureInit;
            }
        });
        list.add(new ParameterAdapter("Coefficient of diminution", "Calibration experiment", 2){

            @Override
            public Object value() {
                return SimulatedAnnealing.this.tempDimCoeff;
            }
        });
        list.add(new ParameterAdapter("Number of iterations at constant temperature", "Calibration experiment", 1){

            @Override
            public Object value() {
                return SimulatedAnnealing.this.nbIterCstTemp;
            }
        });
    }
}

