/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology;

import com.google.common.collect.Ordering;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.IIntersectable;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ISpatialIndex;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.runtime.IScope;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.gaml.operators.Maths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;

public class GamaQuadTree
implements ISpatialIndex {
    final QuadNode root;
    static final int maxCapacity = 100;
    double minSize = 10.0;
    final boolean parallel;

    static {
        DEBUG.OFF();
    }

    public static ISpatialIndex create(Envelope envelope, boolean bl) {
        GamaQuadTree gamaQuadTree = new GamaQuadTree(envelope, bl);
        if (GamaPreferences.Experimental.QUADTREE_SYNCHRONIZATION.getValue().booleanValue()) {
            return new QuadTreeSynchronizer(gamaQuadTree);
        }
        return gamaQuadTree;
    }

    private GamaQuadTree(Envelope envelope, boolean bl) {
        this.parallel = bl;
        this.root = new QuadNode(new Envelope(envelope));
        this.minSize = envelope.getWidth() / 100.0;
    }

    @Override
    public void dispose() {
        this.root.dispose();
    }

    @Override
    public void insert(IAgent iAgent) {
        if (iAgent == null) {
            return;
        }
        if (iAgent.isPoint()) {
            this.root.add(iAgent.getLocation(), iAgent);
        } else {
            this.root.add(iAgent.getEnvelope(), iAgent);
        }
    }

    @Override
    public void remove(Envelope3D envelope3D, IAgent iAgent) {
        Envelope3D envelope3D2;
        Envelope3D envelope3D3 = envelope3D2 = envelope3D == null ? iAgent.getEnvelope() : envelope3D;
        if (envelope3D2 == null) {
            return;
        }
        if (envelope3D2.getArea() == 0.0) {
            this.root.remove(envelope3D2.centre(), (IShape)iAgent);
        } else {
            this.root.remove(envelope3D2, (IShape)iAgent);
        }
        envelope3D2.dispose();
    }

    protected Collection<IAgent> findIntersects(IScope iScope, IShape iShape, Envelope envelope, IAgentFilter iAgentFilter) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (Collector.AsOrderedSet<IAgent> asOrderedSet = Collector.getOrderedSet();){
            this.root.findIntersects(envelope, asOrderedSet);
            if (asOrderedSet.isEmpty()) {
                return GamaListFactory.create();
            }
            iAgentFilter.filter(iScope, iShape, asOrderedSet);
            asOrderedSet.shuffleInPlaceWith(iScope.getRandom());
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Collection<IAgent> allAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter) {
        double d2 = d * Maths.SQRT2;
        Envelope3D envelope3D = Envelope3D.of(iShape.getEnvelope());
        envelope3D.expandBy(d2);
        try {
            Collection<IAgent> collection = this.findIntersects(iScope, iShape, envelope3D, iAgentFilter);
            if (collection.isEmpty()) {
                IList<IAgent> iList = GamaListFactory.create();
                return iList;
            }
            collection.removeIf(iAgent -> iShape.euclidianDistanceTo((IShape)iAgent) > d);
            Collection<IAgent> collection2 = collection;
            return collection2;
        }
        finally {
            envelope3D.dispose();
        }
    }

    @Override
    public Collection<IAgent> firstAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter, int n, Collection<IAgent> collection) {
        double d2 = d * Maths.SQRT2;
        Envelope3D envelope3D = Envelope3D.of(iShape.getEnvelope());
        envelope3D.expandBy(d2);
        try {
            Collection<IAgent> collection2 = this.findIntersects(iScope, iShape, envelope3D, iAgentFilter);
            collection2.removeAll(collection);
            if (collection2.isEmpty()) {
                IList<IAgent> iList = GamaListFactory.create();
                return iList;
            }
            if (collection2.size() <= n) {
                Collection<IAgent> collection3 = collection2;
                return collection3;
            }
            Ordering ordering = Ordering.natural().onResultOf(iShape2 -> Double.valueOf(iShape.euclidianDistanceTo((IShape)iShape2)));
            List list = ordering.leastOf(collection2, n);
            return list;
        }
        finally {
            envelope3D.dispose();
        }
    }

    @Override
    public IAgent firstAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter) {
        Envelope3D envelope3D = Envelope3D.of(iShape.getEnvelope());
        envelope3D.expandBy(d * Maths.SQRT2);
        try {
            Collection<IAgent> collection = this.findIntersects(iScope, iShape, envelope3D, iAgentFilter);
            if (collection.isEmpty()) {
                return null;
            }
            double d2 = d;
            IAgent iAgent = null;
            for (IAgent iAgent2 : collection) {
                Double d3 = iShape.euclidianDistanceTo(iAgent2);
                if (!(d3 < d2)) continue;
                d2 = d3;
                iAgent = iAgent2;
            }
            IAgent iAgent3 = iAgent;
            return iAgent3;
        }
        finally {
            envelope3D.dispose();
        }
    }

    @Override
    public Collection<IAgent> allInEnvelope(IScope iScope, IShape iShape, Envelope envelope, IAgentFilter iAgentFilter, boolean bl) {
        return this.findIntersects(iScope, iShape, envelope, iAgentFilter);
    }

    private class QuadNode {
        final Envelope bounds;
        protected final double halfx;
        protected final double halfy;
        protected volatile QuadNode nw;
        protected volatile QuadNode ne;
        protected volatile QuadNode sw;
        protected volatile QuadNode se;
        protected final Map<IAgent, IIntersectable> objects;
        protected final boolean canSplit;

        public QuadNode(Envelope envelope) {
            this.objects = GamaQuadTree.this.parallel ? GamaMapFactory.synchronizedOrderedMap() : GamaMapFactory.create();
            this.bounds = envelope;
            double d = envelope.getWidth();
            double d2 = envelope.getHeight();
            this.halfx = envelope.getMinX() + d / 2.0;
            this.halfy = envelope.getMinY() + d2 / 2.0;
            this.canSplit = d > GamaQuadTree.this.minSize && d2 > GamaQuadTree.this.minSize;
        }

        public void dispose() {
            this.objects.forEach((iAgent, iIntersectable) -> {
                if (iIntersectable != null) {
                    iIntersectable.dispose();
                }
            });
            this.objects.clear();
            if (this.nw != null) {
                this.nw.dispose();
                this.nw = null;
                this.sw.dispose();
                this.sw = null;
                this.ne.dispose();
                this.ne = null;
                this.se.dispose();
                this.se = null;
            }
        }

        private void add(GamaPoint gamaPoint, IAgent iAgent) {
            this.trySplit();
            if (this.nw == null) {
                this.objects.put(iAgent, gamaPoint);
            } else {
                this.getNode(gamaPoint).add(gamaPoint, iAgent);
            }
        }

        private void add(Envelope3D envelope3D, IAgent iAgent) {
            this.trySplit();
            if (this.nw == null) {
                this.objects.put(iAgent, envelope3D);
            } else {
                if (this.nw.bounds.intersects((Envelope)envelope3D)) {
                    this.nw.add(envelope3D, iAgent);
                }
                if (this.ne.bounds.intersects((Envelope)envelope3D)) {
                    this.ne.add(envelope3D, iAgent);
                }
                if (this.sw.bounds.intersects((Envelope)envelope3D)) {
                    this.sw.add(envelope3D, iAgent);
                }
                if (this.se.bounds.intersects((Envelope)envelope3D)) {
                    this.se.add(envelope3D, iAgent);
                }
            }
        }

        private void trySplit() {
            if (this.nw == null && this.canSplit && this.objects.size() >= 100) {
                this.split();
            }
        }

        private void remove(GamaPoint gamaPoint, IShape iShape) {
            if (this.nw == null) {
                IIntersectable iIntersectable = this.objects.remove(iShape);
                if (iIntersectable != null) {
                    iIntersectable.dispose();
                }
            } else {
                this.getNode(gamaPoint).remove(gamaPoint, iShape);
            }
        }

        private void remove(Envelope3D envelope3D, IShape iShape) {
            if (this.nw == null) {
                IIntersectable iIntersectable = this.objects.remove(iShape);
                if (iIntersectable != null) {
                    iIntersectable.dispose();
                }
            } else {
                if (this.nw.bounds.intersects((Envelope)envelope3D)) {
                    this.nw.remove(envelope3D, iShape);
                }
                if (this.ne.bounds.intersects((Envelope)envelope3D)) {
                    this.ne.remove(envelope3D, iShape);
                }
                if (this.sw.bounds.intersects((Envelope)envelope3D)) {
                    this.sw.remove(envelope3D, iShape);
                }
                if (this.se.bounds.intersects((Envelope)envelope3D)) {
                    this.se.remove(envelope3D, iShape);
                }
            }
        }

        private QuadNode getNode(GamaPoint gamaPoint) {
            boolean bl;
            boolean bl2 = gamaPoint.y >= this.bounds.getMinY() && gamaPoint.y < this.halfy;
            boolean bl3 = bl = gamaPoint.x >= this.bounds.getMinX() && gamaPoint.x < this.halfx;
            return bl2 ? (bl ? this.nw : this.ne) : (bl ? this.sw : this.se);
        }

        private void split() {
            try {
                double d = this.bounds.getMaxX();
                double d2 = this.bounds.getMinX();
                double d3 = this.bounds.getMinY();
                double d4 = this.bounds.getMaxY();
                this.nw = new QuadNode(new Envelope(d2, this.halfx, d3, this.halfy));
                this.ne = new QuadNode(new Envelope(this.halfx, d, d3, this.halfy));
                this.sw = new QuadNode(new Envelope(d2, this.halfx, this.halfy, d4));
                this.se = new QuadNode(new Envelope(this.halfx, d, this.halfy, d4));
                this.objects.forEach((iAgent, iIntersectable) -> {
                    if (iAgent != null && !iAgent.dead()) {
                        IShape iShape = iAgent.getGeometry();
                        if (iShape.isPoint()) {
                            this.add(iShape.getLocation(), (IAgent)iAgent);
                        } else {
                            this.add(iShape.getEnvelope(), (IAgent)iAgent);
                        }
                    }
                });
            }
            finally {
                this.objects.clear();
            }
        }

        public void findIntersects(Envelope envelope, Collection<IAgent> collection) {
            if (!this.bounds.intersects(envelope)) {
                return;
            }
            if (this.nw == null) {
                this.objects.forEach((iAgent, iIntersectable) -> {
                    if (iIntersectable != null && iIntersectable.intersects(envelope)) {
                        collection.add((IAgent)iAgent);
                    }
                });
            } else {
                this.nw.findIntersects(envelope, collection);
                this.ne.findIntersects(envelope, collection);
                this.sw.findIntersects(envelope, collection);
                this.se.findIntersects(envelope, collection);
            }
        }
    }

    static class QuadTreeSynchronizer
    implements ISpatialIndex {
        private final ISpatialIndex quadtree;

        public QuadTreeSynchronizer(ISpatialIndex iSpatialIndex) {
            this.quadtree = iSpatialIndex;
        }

        @Override
        public synchronized void insert(IAgent iAgent) {
            this.quadtree.insert(iAgent);
        }

        @Override
        public synchronized void remove(Envelope3D envelope3D, IAgent iAgent) {
            this.quadtree.remove(envelope3D, iAgent);
        }

        @Override
        public synchronized IAgent firstAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter) {
            return this.quadtree.firstAtDistance(iScope, iShape, d, iAgentFilter);
        }

        @Override
        public synchronized Collection<IAgent> firstAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter, int n, Collection<IAgent> collection) {
            return this.quadtree.firstAtDistance(iScope, iShape, d, iAgentFilter, n, collection);
        }

        @Override
        public synchronized Collection<IAgent> allInEnvelope(IScope iScope, IShape iShape, Envelope envelope, IAgentFilter iAgentFilter, boolean bl) {
            return this.quadtree.allInEnvelope(iScope, iShape, envelope, iAgentFilter, bl);
        }

        @Override
        public synchronized Collection<IAgent> allAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter) {
            return this.quadtree.allAtDistance(iScope, iShape, d, iAgentFilter);
        }

        @Override
        public void dispose() {
            this.quadtree.dispose();
        }
    }
}

