/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ISpatialIndex;
import gama.core.metamodel.topology.continuous.RootTopology;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.path.GamaSpatialPath;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="environment", type=13, doc={@GamlAnnotations.doc(value="Returns the environment of this topology, either an agent or a geometry, which defines its boundaries")}), @GamlAnnotations.variable(name="places", type=16, of=13, doc={@GamlAnnotations.doc(value="Returns the list of discrete places that compose this topology (e.g. the list of cells for a grid topology). The continuous topologies will return a singleton list with their environment")})})
public interface ITopology
extends IValue {
    public ISpatialIndex getSpatialIndex();

    public void initialize(IScope var1, IPopulation<? extends IAgent> var2) throws GamaRuntimeException;

    public void updateAgent(Envelope3D var1, IAgent var2);

    public void removeAgent(IAgent var1);

    public List<Geometry> listToroidalGeometries(Geometry var1);

    public Collection<IAgent> getAgentClosestTo(IScope var1, IShape var2, IAgentFilter var3, int var4);

    public IAgent getAgentClosestTo(IScope var1, IShape var2, IAgentFilter var3);

    public IAgent getAgentFarthestTo(IScope var1, IShape var2, IAgentFilter var3);

    public Collection<IAgent> getNeighborsOf(IScope var1, IShape var2, Double var3, IAgentFilter var4) throws GamaRuntimeException;

    public Collection<IAgent> getAgentsIn(IScope var1, IShape var2, IAgentFilter var3, SpatialRelation var4);

    public boolean isTorus();

    public boolean isContinuous();

    public Double distanceBetween(IScope var1, IShape var2, IShape var3);

    public Double distanceBetween(IScope var1, GamaPoint var2, GamaPoint var3);

    public GamaSpatialPath pathBetween(IScope var1, IShape var2, IShape var3) throws GamaRuntimeException;

    public GamaSpatialPath pathBetween(IScope var1, GamaPoint var2, GamaPoint var3) throws GamaRuntimeException;

    public GamaPoint getDestination(IScope var1, GamaPoint var2, double var3, double var5, boolean var7);

    public GamaPoint getDestination3D(IScope var1, GamaPoint var2, double var3, double var5, double var7, boolean var9);

    public GamaPoint getRandomLocation(IScope var1);

    @GamlAnnotations.getter(value="places")
    public IContainer<?, IShape> getPlaces();

    @GamlAnnotations.getter(value="environment")
    public IShape getEnvironment();

    public GamaPoint normalizeLocation(IScope var1, GamaPoint var2, boolean var3);

    public double getWidth();

    public double getHeight();

    public void dispose();

    public boolean isValidLocation(IScope var1, GamaPoint var2);

    public boolean isValidGeometry(IScope var1, IShape var2);

    public Double directionInDegreesTo(IScope var1, IShape var2, IShape var3);

    public IList<GamaSpatialPath> kPathsBetween(IScope var1, IShape var2, IShape var3, int var4);

    public IList<GamaSpatialPath> kPathsBetween(IScope var1, GamaPoint var2, GamaPoint var3, int var4);

    public void setRoot(IScope var1, RootTopology var2);

    @Override
    default public int intValue(IScope iScope) {
        return this.getPlaces().intValue(iScope);
    }

    @Override
    default public double floatValue(IScope iScope) {
        return this.getEnvironment().floatValue(iScope);
    }

    @Override
    default public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "environment", this.getEnvironment());
    }

    public static enum SpatialRelation {
        OVERLAP,
        COVER,
        INSIDE,
        TOUCH,
        CROSS,
        PARTIALLY_OVERLAP;

    }
}

