/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.graph;

import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph._Edge;
import gama.core.util.graph._Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;

public final class NBAStarPathfinder<V, E> {
    private final PriorityQueue<HeapEntry<V>> OPENA = new PriorityQueue();
    private final PriorityQueue<HeapEntry<V>> OPENB = new PriorityQueue();
    private final Map<V, V> PARENTSA = new HashMap<V, V>();
    private final Map<V, V> PARENTSB = new HashMap<V, V>();
    private final Map<V, Double> DISTANCEA = new HashMap<V, Double>();
    private final Map<V, Double> DISTANCEB = new HashMap<V, Double>();
    private final Set<V> CLOSED = new HashSet<V>();
    private final Map<V, _Vertex<V, E>> vertices = new IdentityHashMap<V, _Vertex<V, E>>();
    private boolean stopWhenPathFound = false;
    private double fA;
    private double fB;
    private double bestPathLength;
    private V touchNode;
    private V sourceNode;
    private V targetNode;
    GamaGraph<V, E> graph;
    boolean isSpatialGraph;

    public NBAStarPathfinder(GamaGraph<V, E> gamaGraph, boolean bl) {
        this.graph = gamaGraph;
        this.isSpatialGraph = gamaGraph instanceof GamaSpatialGraph;
        this.stopWhenPathFound = bl;
    }

    public IList<E> search(V v, V v2) {
        if (v.equals(v2)) {
            return GamaListFactory.EMPTY_LIST;
        }
        this.init(v, v2);
        while (!this.OPENA.isEmpty() && !this.OPENB.isEmpty()) {
            if (this.OPENA.size() < this.OPENB.size()) {
                this.expandInForwardDirection();
                continue;
            }
            this.expandInBackwardDirection();
        }
        if (this.touchNode == null) {
            return GamaListFactory.EMPTY_LIST;
        }
        return this.tracebackPath();
    }

    private void expandInForwardDirection() {
        Object v = ((HeapEntry)this.OPENA.remove()).getNode();
        if (this.CLOSED.contains(v)) {
            return;
        }
        _Vertex<V, E> _Vertex2 = this.graph.getVertex(v);
        if (_Vertex2 == null) {
            return;
        }
        this.vertices.put((_Vertex<V, E>)v, (_Vertex<_Vertex<V, E>, E>)_Vertex2);
        this.CLOSED.add(v);
        if (!(this.DISTANCEA.get(v) + this.estimateDistanceBetween(v, this.targetNode) >= this.bestPathLength) && !(this.DISTANCEA.get(v) + this.fB - this.estimateDistanceBetween(v, this.sourceNode) >= this.bestPathLength)) {
            Collection collection = null;
            if (this.graph.isDirected()) {
                collection = _Vertex2.getOutEdges();
            } else {
                collection = new ArrayList(_Vertex2.getOutEdges());
                collection.addAll(_Vertex2.getInEdges());
            }
            for (Object e : collection) {
                double d;
                Object object;
                _Edge<V, E> _Edge2 = this.graph.getEdge(e);
                Object object2 = this.graph.isDirected() ? _Edge2.getTarget() : (object = _Edge2.getTarget().equals(v) ? _Edge2.getSource() : _Edge2.getTarget());
                if (this.CLOSED.contains(object)) continue;
                double d2 = this.DISTANCEA.get(v) + _Edge2.getWeight();
                Double d3 = this.DISTANCEA.get(object);
                if (d3 != null && !(d3 > d2)) continue;
                this.DISTANCEA.put((Double)object, d2);
                this.PARENTSA.put(object, v);
                HeapEntry<Object> heapEntry = new HeapEntry<Object>(object, d2 + this.estimateDistanceBetween(object, this.targetNode));
                this.OPENA.add(heapEntry);
                Double d4 = this.DISTANCEB.get(object);
                if (d4 == null || !(this.bestPathLength > (d = d2 + d4))) continue;
                this.bestPathLength = d;
                this.touchNode = object;
                if (!this.stopWhenPathFound) continue;
                return;
            }
        }
        if (!this.OPENA.isEmpty()) {
            this.fA = this.OPENA.peek().getDistance();
        }
    }

    private void expandInBackwardDirection() {
        Object v = ((HeapEntry)this.OPENB.remove()).getNode();
        if (this.CLOSED.contains(v)) {
            return;
        }
        _Vertex<V, E> _Vertex2 = this.graph.getVertex(v);
        if (_Vertex2 == null) {
            return;
        }
        this.vertices.put((_Vertex<V, E>)v, (_Vertex<_Vertex<V, E>, E>)_Vertex2);
        this.CLOSED.add(v);
        if (!(this.DISTANCEB.get(v) + this.estimateDistanceBetween(v, this.sourceNode) >= this.bestPathLength) && !(this.DISTANCEB.get(v) + this.fA - this.estimateDistanceBetween(v, this.targetNode) >= this.bestPathLength)) {
            Collection collection = null;
            if (this.graph.isDirected()) {
                collection = _Vertex2.getInEdges();
            } else {
                collection = new ArrayList(_Vertex2.getInEdges());
                collection.addAll(_Vertex2.getOutEdges());
            }
            for (Object e : collection) {
                double d;
                Object object;
                _Edge<V, E> _Edge2 = this.graph.getEdge(e);
                Object object2 = this.graph.isDirected() ? _Edge2.getSource() : (object = _Edge2.getSource().equals(v) ? _Edge2.getTarget() : _Edge2.getSource());
                if (this.CLOSED.contains(object)) continue;
                double d2 = this.DISTANCEB.get(v) + _Edge2.getWeight();
                Double d3 = this.DISTANCEB.get(object);
                if (d3 != null && !(d3 > d2)) continue;
                this.DISTANCEB.put((Double)object, d2);
                this.PARENTSB.put(object, v);
                HeapEntry<Object> heapEntry = new HeapEntry<Object>(object, d2 + this.estimateDistanceBetween(object, this.sourceNode));
                this.OPENB.add(heapEntry);
                Double d4 = this.DISTANCEA.get(object);
                if (d4 == null || !(this.bestPathLength > (d = d2 + d4))) continue;
                this.bestPathLength = d;
                this.touchNode = object;
                if (!this.stopWhenPathFound) continue;
                return;
            }
        }
        if (!this.OPENB.isEmpty()) {
            this.fB = this.OPENB.peek().getDistance();
        }
    }

    private void init(V v, V v2) {
        double d;
        this.OPENA.clear();
        this.OPENB.clear();
        this.PARENTSA.clear();
        this.PARENTSB.clear();
        this.DISTANCEA.clear();
        this.DISTANCEB.clear();
        this.CLOSED.clear();
        this.fA = d = this.estimateDistanceBetween(v, v2);
        this.fB = d;
        this.bestPathLength = Double.MAX_VALUE;
        this.touchNode = null;
        this.sourceNode = v;
        this.targetNode = v2;
        this.OPENA.add(new HeapEntry<V>(v, this.fA));
        this.OPENB.add(new HeapEntry<V>(v2, this.fB));
        this.PARENTSA.put(v, null);
        this.PARENTSB.put(v2, null);
        this.DISTANCEA.put((Double)v, 0.0);
        this.DISTANCEB.put((Double)v2, 0.0);
    }

    protected IList<E> tracebackPath() {
        ArrayList<V> arrayList = new ArrayList<V>();
        V v = this.touchNode;
        while (v != null) {
            arrayList.add(v);
            v = this.PARENTSA.get(v);
        }
        Collections.reverse(arrayList);
        if (this.PARENTSB != null) {
            v = this.PARENTSB.get(this.touchNode);
            while (v != null) {
                arrayList.add(v);
                v = this.PARENTSB.get(v);
            }
        }
        IList iList = GamaListFactory.create();
        Object e = arrayList.get(0);
        int n = 1;
        while (n < arrayList.size()) {
            Object object;
            Object e2 = arrayList.get(n);
            _Vertex<V, E> _Vertex2 = this.vertices.get(e);
            if (_Vertex2 == null) {
                object = e;
                Optional<Object> optional = this.vertices.keySet().stream().filter(object2 -> object2.equals(object)).findFirst();
                if (!optional.isPresent()) {
                    return iList;
                }
                _Vertex2 = this.vertices.get(optional.get());
            }
            object = new ArrayList(_Vertex2.edgesTo(e2));
            if (!this.graph.isDirected()) {
                object.addAll(this.vertices.get(e2).edgesTo(e));
            }
            if (object.size() == 1) {
                iList.add(object.get(0));
            } else if (object.size() > 1) {
                double d = Double.MAX_VALUE;
                Object e3 = null;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e4 = iterator.next();
                    double d2 = this.graph.getEdgeWeight(e4);
                    if (!(d2 < d)) continue;
                    d = d2;
                    e3 = e4;
                }
                iList.add(e3);
            }
            e = e2;
            ++n;
        }
        return iList;
    }

    public double estimateDistanceBetween(V v, V v2) {
        if (this.isSpatialGraph) {
            GamaPoint gamaPoint = ((IShape)v).getLocation();
            GamaPoint gamaPoint2 = ((IShape)v2).getLocation();
            return gamaPoint.euclidianDistanceTo(gamaPoint2);
        }
        return 0.0;
    }

    static final class HeapEntry<V>
    implements Comparable<HeapEntry<V>> {
        private final V nodeId;
        private final double distance;

        public HeapEntry(V v, double d) {
            this.nodeId = v;
            this.distance = d;
        }

        public V getNode() {
            return this.nodeId;
        }

        public double getDistance() {
            return this.distance;
        }

        @Override
        public int compareTo(HeapEntry<V> heapEntry) {
            return Double.compare(this.distance, heapEntry.distance);
        }
    }
}

