/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.AbstractLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.operators.Cast;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="rotate", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Defines the angle of rotation of this layer, in degrees, around the z-axis.")}), @GamlAnnotations.facet(name="position", type={7}, optional=true, doc={@GamlAnnotations.doc(value="position of the upper-left corner of the layer. Note that if coordinates are in [0,1[, the position is relative to the size of the environment (e.g. {0.5,0.5} refers to the middle of the display) whereas it is absolute when coordinates are greater than 1 for x and y. The z-ordinate can only be defined between 0 and 1. The position can only be a 3D point {0.5, 0.5, 0.5}, the last coordinate specifying the elevation of the layer. In case of negative value OpenGl will position the layer out of the environment.")}), @GamlAnnotations.facet(name="size", type={7}, optional=true, doc={@GamlAnnotations.doc(value="extent of the layer in the screen from its position. Coordinates in [0,1[ are treated as percentages of the total surface, while coordinates > 1 are treated as absolute sizes in model units (i.e. considering the model occupies the entire view). Like in 'position', an elevation can be provided with the z coordinate, allowing to scale the layer in the 3 directions ")}), @GamlAnnotations.facet(name="transparency", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the transparency level of the layer (between 0 -- opaque -- and 1 -- fully transparent)")}), @GamlAnnotations.facet(name="visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Defines whether this layer is visible or not")}), @GamlAnnotations.facet(name="name", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the name/path of the image (in the case of a raster image), a matrix of int, an image file")}), @GamlAnnotations.facet(name="gis", type={12, 4}, optional=true, doc={@GamlAnnotations.doc(value="the name/path of the shape file (to display a shapefile as background, without creating agents from it)")}), @GamlAnnotations.facet(name="color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="in the case of a shapefile, this the color used to fill in geometries of the shapefile. In the case of an image, it is used to tint the image")}), @GamlAnnotations.facet(name="refresh", type={3}, optional=true, doc={@GamlAnnotations.doc(value="(openGL only) specify whether the image display is refreshed or not. (false by default, true should be used in cases of images that are modified over the simulation)")})}, omissible="name")
@GamlAnnotations.doc(value="`image_layer` allows modeler to display an image (e.g. as background of a simulation). Note that this image will not be dynamically changed or moved in OpenGL, unless the refresh: facet is set to true.", usages={@GamlAnnotations.usage(value="The general syntax is:", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="   image image_file [additional options];", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="For instance, in the case of a bitmap image", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="   image \"../images/my_backgound.jpg\";", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="If you already have your image stored in a matrix", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="   image my_image_matrix;", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="Or in the case of a shapefile:", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="   image testGIS gis: \"../includes/building.shp\" color: rgb('blue');", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="It is also possible to superpose images on different layers in the same way as for species using opengl display:", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="  image \"../images/image1.jpg\";", isExecutable=false), @GamlAnnotations.example(value="  image \"../images/image2.jpg\";", isExecutable=false), @GamlAnnotations.example(value="  image \"../images/image3.jpg\" position: {0,0,0.5};", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"display", "agents", "chart", "event", "graphics", "display_grid", "overlay", "species_layer"})
@validator(value=ImageLayerValidator.class)
public class ImageLayerStatement
extends AbstractLayerStatement {
    IExpression imageExpression = this.getFacet("name");

    public ImageLayerStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
    }

    @Override
    public IExpression getRefreshFacet() {
        IExpression iExpression = super.getRefreshFacet();
        if (iExpression == null) {
            iExpression = IExpressionFactory.FALSE_EXPR;
        }
        return iExpression;
    }

    @Override
    public ILayerStatement.LayerType getType(LayeredDisplayOutput layeredDisplayOutput) {
        if (this.hasFacet("gis")) {
            return ILayerStatement.LayerType.GIS;
        }
        return ILayerStatement.LayerType.IMAGE;
    }

    @Override
    public boolean _init(IScope iScope) throws GamaRuntimeException {
        if (this.imageExpression.isConst()) {
            this.setName(Cast.asString(iScope, this.imageExpression.value(iScope)));
        } else {
            this.setName(this.imageExpression.serializeToGaml(false));
        }
        return true;
    }

    @Override
    public boolean _step(IScope iScope) throws GamaRuntimeException {
        return true;
    }

    public static class ImageLayerValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            if (!statementDescription.hasFacet("gis") && !statementDescription.hasFacet("name")) {
                statementDescription.error("Missing facet name", "gaml.missing.facet.issue", statementDescription.getUnderlyingElement(), "file", "\"\"");
            }
        }
    }
}

