/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime;

import gama.core.common.preferences.GamaPreferences;
import gama.dev.DEBUG;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;

public final class MemoryUtils {
    public static final Runtime RUNTIME;

    static {
        DEBUG.OFF();
        RUNTIME = Runtime.getRuntime();
    }

    private MemoryUtils() {
    }

    public static boolean memoryIsLow() {
        return (double)MemoryUtils.availableMemory() * 1.0E9 < (double)(RUNTIME.totalMemory() * (long)GamaPreferences.Runtime.CORE_MEMORY_PERCENTAGE.getValue().intValue());
    }

    public static int availableMemory() {
        long l = RUNTIME.freeMemory() + RUNTIME.maxMemory() - RUNTIME.totalMemory();
        double d = (double)l / 1.0E7;
        return (int)d;
    }

    public static int maxMemory() {
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("Max memory via runtime: " + MemoryUtils.maxMemoryThroughRuntime()));
            DEBUG.OUT((Object)("Max memory via runtime bean: " + MemoryUtils.maxMemoryThroughRuntimeBean()));
            DEBUG.OUT((Object)("Max memory via memory bean: " + MemoryUtils.maxMemoryThroughMemoryBean()));
        }
        return MemoryUtils.maxMemoryThroughRuntimeBean();
    }

    public static int maxMemoryThroughRuntime() {
        long l = RUNTIME.maxMemory();
        double d = (double)l / 1.0E7;
        return (int)d;
    }

    public static int maxMemoryThroughMemoryBean() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        long l = memoryMXBean.getHeapMemoryUsage().getMax();
        double d = (double)l / 1.0E7;
        return (int)d;
    }

    public static int maxMemoryThroughRuntimeBean() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> list = runtimeMXBean.getInputArguments();
        for (String string : list) {
            DEBUG.OUT((Object)string);
            if (!string.startsWith("-Xmx")) continue;
            char c = string.charAt(string.length() - 1);
            double d = 1000000.0;
            boolean bl = false;
            switch (c) {
                case 'K': 
                case 'k': {
                    bl = true;
                    d = 1000.0;
                    break;
                }
                case 'M': 
                case 'm': {
                    bl = true;
                    d = 1.0;
                    break;
                }
                case 'G': 
                case 'g': {
                    bl = true;
                    d = 0.001;
                }
            }
            String string2 = string;
            string2 = string2.replace("-Xmx", "");
            if (bl) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            int n = Integer.parseInt(string2);
            return (int)((double)n / d);
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    public static int readMaxMemoryInMegabytes(File var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void changeMaxMemory(File file2, int n) {
        int n2 = n < 128 ? 128 : n;
        try {
            Closeable closeable;
            Closeable closeable2;
            Object var5_7;
            Throwable throwable;
            ArrayList<void> arrayList;
            block31: {
                arrayList = new ArrayList<void>();
                if (file2 == null) return;
                throwable = null;
                var5_7 = null;
                try {
                    closeable2 = new FileInputStream(file2);
                    try {
                        closeable = new BufferedReader(new InputStreamReader((InputStream)closeable2));
                        try {
                            void var8_15;
                            String string = ((BufferedReader)closeable).readLine();
                            while (var8_15 != null) {
                                void var8_17;
                                if (var8_15.startsWith("-Xmx")) {
                                    String string2 = "-Xmx" + n2 + "m";
                                }
                                arrayList.add(var8_17);
                                String string3 = ((BufferedReader)closeable).readLine();
                            }
                        }
                        finally {
                            if (closeable != null) {
                                ((BufferedReader)closeable).close();
                            }
                        }
                        if (closeable2 == null) break block31;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (closeable2 == null) throw throwable;
                        ((FileInputStream)closeable2).close();
                        throw throwable;
                    }
                    ((FileInputStream)closeable2).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            throwable = null;
            var5_7 = null;
            try {
                closeable2 = new FileOutputStream(file2);
                try {
                    closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)closeable2));
                    try {
                        Iterator iterator = arrayList.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                ((BufferedWriter)closeable).flush();
                                break;
                            }
                            String string = (String)iterator.next();
                            ((Writer)closeable).write(string);
                            ((BufferedWriter)closeable).newLine();
                        }
                    }
                    finally {
                        if (closeable != null) {
                            ((BufferedWriter)closeable).close();
                        }
                    }
                    if (closeable2 == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (closeable2 == null) throw throwable;
                    ((FileOutputStream)closeable2).close();
                    throw throwable;
                }
                ((FileOutputStream)closeable2).close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    public static File findIniFile() {
        return MemoryUtils.findIt(new File(Platform.getConfigurationLocation().getURL().getPath()));
    }

    public static File findIt(File file2) {
        File[] fileArray = file2.listFiles();
        if (fileArray != null) {
            ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray2[n2];
                if ("Gama.ini".equals(file3.getName())) {
                    return file3;
                }
                if (file3.isDirectory()) {
                    arrayList.add(file3);
                }
                ++n2;
            }
            for (File file3 : arrayList) {
                File file4 = MemoryUtils.findIt(file3);
                if (file4 == null) continue;
                return file4;
            }
        }
        return null;
    }
}

