/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.util.file.json.IJsonConstants;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonArray;
import gama.core.util.file.json.JsonFloat;
import gama.core.util.file.json.JsonGamaContentsObject;
import gama.core.util.file.json.JsonGamlAgent;
import gama.core.util.file.json.JsonGamlObject;
import gama.core.util.file.json.JsonGeometryObject;
import gama.core.util.file.json.JsonHandler;
import gama.core.util.file.json.JsonInt;
import gama.core.util.file.json.JsonObject;
import gama.core.util.file.json.JsonReferenceObject;
import gama.core.util.file.json.JsonString;
import gama.core.util.file.json.JsonValue;
import gama.gaml.types.Types;

class JsonGamaHandler
extends JsonHandler<JsonArray, JsonObject>
implements IJsonConstants {
    protected Json json;
    protected JsonValue value;

    JsonGamaHandler(Json json) {
        this.json = json;
    }

    @Override
    public JsonArray startArray() {
        return new JsonArray(this.json);
    }

    @Override
    public JsonObject startObject() {
        return new JsonObject(this.json);
    }

    @Override
    public void endNull() {
        this.value = IJsonConstants.NULL;
    }

    @Override
    public void endBoolean(boolean bl) {
        this.value = bl ? IJsonConstants.TRUE : IJsonConstants.FALSE;
    }

    @Override
    public void endString(String string) {
        this.value = new JsonString(string);
    }

    @Override
    public void endNumber(String string, boolean bl) {
        boolean bl2 = bl;
        if (!bl2) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = true;
            }
        }
        this.value = bl2 ? new JsonFloat(string) : new JsonInt(string);
    }

    @Override
    public void endArray(JsonArray jsonArray) {
        this.value = jsonArray;
    }

    @Override
    public void endObject(JsonObject jsonObject) {
        this.value = jsonObject.contains("gaml_species") ? new JsonGamlAgent(jsonObject.remove("gaml_species").asString(), jsonObject.remove("index").asInt(), jsonObject, this.json) : (jsonObject.contains("agent_reference") ? new JsonReferenceObject(jsonObject.get("agent_reference").asString(), this.json) : (jsonObject.contains("gama_contents") ? new JsonGamaContentsObject(jsonObject.get("gama_contents"), jsonObject.get("gama_references").asObject(), this.json) : jsonObject));
    }

    @Override
    public void endGamlObject(String string, JsonObject jsonObject) {
        this.value = Types.GEOMETRY.getName().equals(string) ? new JsonGeometryObject(jsonObject, this.json) : new JsonGamlObject(string, jsonObject, this.json);
    }

    @Override
    public void endArrayValue(JsonArray jsonArray) {
        jsonArray.add(this.value);
    }

    @Override
    public void endObjectValue(JsonObject jsonObject, String string) {
        jsonObject.add(string, this.value);
    }

    JsonValue getValue() {
        return this.value;
    }
}

