/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.matrix;

import gama.core.common.interfaces.ISafeConsumer;
import gama.core.common.util.RandomUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.matrix.IMatrix;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Strings;
import gama.gaml.types.GamaPointType;
import gama.gaml.types.GamaType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;

public abstract class GamaMatrix<T>
implements IMatrix<T> {
    private final IContainerType<IMatrix> type;
    public int numRows;
    public int numCols;

    @Override
    public IContainerType<?> getGamlType() {
        return this.type;
    }

    protected T buildValue(IScope iScope, Object object) {
        return (T)this.type.getContentType().cast(iScope, object, null, false);
    }

    protected IContainer<?, T> buildValues(IScope iScope, IContainer iContainer) {
        return this.type.cast(iScope, iContainer, null, false);
    }

    protected GamaPoint buildIndex(IScope iScope, Object object) {
        return GamaPointType.staticCast(iScope, object, false);
    }

    @Override
    public final String serializeToGaml(boolean bl) {
        return this.getGamlType().serializeToGaml(true) + "(" + this.getColumnsList().serializeToGaml(bl) + ")";
    }

    public static IMatrix opPlus(IScope iScope, IMatrix iMatrix, IMatrix iMatrix2) throws GamaRuntimeException {
        throw GamaRuntimeException.error("ATTENTION : Matrix additions not implemented. Returns nil for the moment", iScope);
    }

    public static IMatrix opMinus(IScope iScope, IMatrix iMatrix, IMatrix iMatrix2) throws GamaRuntimeException {
        throw GamaRuntimeException.error("ATTENTION : Matrix subtractions not implemented. Returns nil for the moment", iScope);
    }

    public static IMatrix opTimes(IScope iScope, IMatrix iMatrix, IMatrix iMatrix2) throws GamaRuntimeException {
        throw GamaRuntimeException.error("ATTENTION : Matrix multiplications not implemented. Returns nil for the moment", iScope);
    }

    @Override
    public int getRows(IScope iScope) {
        return this.numRows;
    }

    @Override
    public int getCols(IScope iScope) {
        return this.numCols;
    }

    protected GamaMatrix(int n, int n2, IType iType) {
        this.numRows = n2;
        this.numCols = n;
        this.type = Types.MATRIX.of(iType);
    }

    protected GamaMatrix(IScope iScope, List list, GamaPoint gamaPoint, IType iType) {
        if (gamaPoint != null) {
            this.numRows = (int)gamaPoint.getY();
            this.numCols = (int)gamaPoint.getX();
        } else if (list == null || list.isEmpty()) {
            this.numRows = 1;
            this.numCols = 1;
        } else if (GamaMatrix.isFlat(list)) {
            this.numRows = 1;
            this.numCols = list.size();
        } else {
            try {
                this.numCols = list.size();
                this.numRows = ((List)list.get(0)).size();
            }
            catch (Exception exception) {
                throw GamaRuntimeException.error(String.valueOf(list.get(0)) + " cannot be casted to a List (in matrix creation)", iScope);
            }
        }
        this.type = Types.MATRIX.of(iType);
    }

    @Override
    public T get(IScope iScope, GamaPoint gamaPoint) {
        double d = gamaPoint.getX();
        double d2 = gamaPoint.getY();
        if (d > (double)(this.numCols - 1) || d < 0.0) {
            throw GamaRuntimeException.error("Access to a matrix element out of its bounds: " + d, iScope);
        }
        if (d2 > (double)(this.numRows - 1) || d2 < 0.0) {
            throw GamaRuntimeException.error("Access to a matrix element out of its bounds: " + d2, iScope);
        }
        return this.get(iScope, (int)d, (int)d2);
    }

    @Override
    public T getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        int n = iList.size();
        if (n == 1) {
            Object e = iList.get(0);
            if (e instanceof GamaPoint) {
                return this.get(iScope, (GamaPoint)e);
            }
            return this.getNthElement(Cast.asInt(iScope, e));
        }
        int n2 = Cast.asInt(iScope, iList.get(0));
        int n3 = Cast.asInt(iScope, iList.get(1));
        if (n2 > this.numCols - 1 || n2 < 0) {
            throw GamaRuntimeException.error("Access to a matrix element out of its bounds: " + n2, iScope);
        }
        if (n3 > this.numRows - 1 || n3 < 0) {
            throw GamaRuntimeException.error("Access to a matrix element out of its bounds: " + n3, iScope);
        }
        return this.get(iScope, n2, n3);
    }

    public abstract T getNthElement(Integer var1);

    @Override
    public abstract Object remove(IScope var1, int var2, int var3);

    @Override
    public IMatrix<?> matrixValue(IScope iScope, IType iType, boolean bl) throws GamaRuntimeException {
        return this.matrixValue(iScope, iType, (GamaPoint)null, bl);
    }

    @Override
    public GamaPoint getDimensions() {
        return new GamaPoint(this.numCols, this.numRows);
    }

    @Override
    public final String stringValue(IScope iScope) throws GamaRuntimeException {
        StringBuilder stringBuilder = new StringBuilder(this.numRows * this.numCols * 5);
        this.rowByRow(iScope, object -> {
            StringBuilder stringBuilder2 = stringBuilder.append(Cast.asString(iScope, object));
        }, () -> {
            StringBuilder stringBuilder2 = stringBuilder.append(';');
        }, () -> {
            StringBuilder stringBuilder2 = stringBuilder.append(Strings.LN);
        });
        return stringBuilder.toString();
    }

    public void rowByRow(IScope iScope, ISafeConsumer<T> iSafeConsumer, ISafeRunnable iSafeRunnable, ISafeRunnable iSafeRunnable2) throws GamaRuntimeException {
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                if (iSafeConsumer != null) {
                    try {
                        iSafeConsumer.accept(this.get(iScope, n2, n));
                    }
                    catch (Throwable throwable) {
                        throw GamaRuntimeException.create(throwable, iScope);
                    }
                }
                if (n2 < this.numCols - 1 && iSafeRunnable != null) {
                    try {
                        iSafeRunnable.run();
                    }
                    catch (Exception exception) {
                        throw GamaRuntimeException.create(exception, iScope);
                    }
                }
                ++n2;
            }
            if (n < this.numRows - 1 && iSafeRunnable2 != null) {
                try {
                    iSafeRunnable2.run();
                }
                catch (Exception exception) {
                    throw GamaRuntimeException.create(exception, iScope);
                }
            }
            ++n;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.numRows * this.numCols * 5);
        stringBuilder.append('[');
        this.rowByRow(GAMA.getRuntimeScope(), object -> {
            StringBuilder stringBuilder2 = stringBuilder.append(object);
        }, () -> {
            StringBuilder stringBuilder2 = stringBuilder.append(',');
        }, () -> {
            StringBuilder stringBuilder2 = stringBuilder.append(';');
        });
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public IMap mapValue(IScope iScope, IType iType, IType iType2, boolean bl) {
        IType<?> iType3 = GamaType.findSpecificType(iType, this.type.getContentType());
        IType<?> iType4 = GamaType.findSpecificType(iType2, this.type.getContentType());
        IMap iMap = GamaMapFactory.create(iType3, iType4);
        int n = 0;
        while (n < this.numRows) {
            iMap.put(GamaType.toType(iScope, this.get(iScope, 0, n), iType3, bl), GamaType.toType(iScope, this.get(iScope, 1, n), iType4, bl));
            ++n;
        }
        return iMap;
    }

    @Override
    public final IMatrix copy(IScope iScope) {
        return this.copy(iScope, this.getDimensions(), true);
    }

    public static boolean isFlat(List list) {
        for (Object e : list) {
            if (!(e instanceof List)) continue;
            return false;
        }
        return true;
    }

    public void fillWith(IScope iScope, IExpression iExpression) {
    }

    @Override
    public final boolean contains(IScope iScope, Object object) throws GamaRuntimeException {
        return this._contains(iScope, object);
    }

    @Override
    public final T firstValue(IScope iScope) throws GamaRuntimeException {
        return (T)this._first(iScope);
    }

    @Override
    public final T lastValue(IScope iScope) throws GamaRuntimeException {
        return (T)this._last(iScope);
    }

    @Override
    public final int length(IScope iScope) {
        return this._length(iScope);
    }

    @Override
    public final boolean isEmpty(IScope iScope) {
        return this._isEmpty(iScope);
    }

    @Override
    public final IMatrix<T> reverse(IScope iScope) throws GamaRuntimeException {
        return this._reverse(iScope);
    }

    @Override
    public void addValue(IScope iScope, T t) {
    }

    @Override
    public void addValueAtIndex(IScope iScope, Object object, T t) {
    }

    @Override
    public void setValueAtIndex(IScope iScope, Object object, T t) {
        if (object instanceof Integer) {
            this.setNthElement(iScope, (Integer)object, t);
            return;
        }
        GamaPoint gamaPoint = this.buildIndex(iScope, object);
        this.set(iScope, (int)gamaPoint.getX(), (int)gamaPoint.getY(), t);
    }

    protected abstract void setNthElement(IScope var1, int var2, Object var3);

    @Override
    public void addValues(IScope iScope, Object object, IContainer iContainer) {
    }

    @Override
    public void setAllValues(IScope iScope, T t) {
        this._putAll(iScope, t);
    }

    @Override
    public void removeValue(IScope iScope, Object object) {
    }

    @Override
    public void removeIndex(IScope iScope, Object object) {
    }

    @Override
    public void removeIndexes(IScope iScope, IContainer<?, ?> iContainer) {
    }

    @Override
    public void removeValues(IScope iScope, IContainer<?, ?> iContainer) {
    }

    @Override
    public void removeAllOccurrencesOfValue(IScope iScope, Object object) {
    }

    @Override
    public final IList<T> listValue(IScope iScope, IType iType, boolean bl) {
        IType<?> iType2 = this.type.getContentType();
        if (!GamaType.requiresCasting(iType, iType2)) {
            return this._listValue(iScope, iType2, false);
        }
        return this._listValue(iScope, iType, true);
    }

    @Override
    public final IMatrix<T> matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        return this._matrixValue(iScope, gamaPoint, iType, bl);
    }

    @Override
    public IList<IList<T>> getRowsList() {
        IList<IList<T>> iList = GamaListFactory.create(Types.LIST.of(this.getGamlType().getContentType()));
        int n = 0;
        while (n < this.numRows) {
            iList.add(this.getRow(n));
            ++n;
        }
        return iList;
    }

    @Override
    public IList<IList<T>> getColumnsList() {
        IList<IList<T>> iList = GamaListFactory.create(Types.LIST.of(this.getGamlType().getContentType()));
        int n = 0;
        int n2 = this.numCols;
        while (n < n2) {
            iList.add(this.getColumn(n));
            ++n;
        }
        return iList;
    }

    @Override
    public IList<T> getRow(Integer n) {
        IList iList = GamaListFactory.create(this.getGamlType().getContentType());
        if (n >= this.numRows || n < 0) {
            return iList;
        }
        int n2 = 0;
        while (n2 < this.numCols) {
            iList.add(this.getNthElement(n * this.numCols + n2));
            ++n2;
        }
        return iList;
    }

    @Override
    public IList<T> getColumn(Integer n) {
        IList iList = GamaListFactory.create(this.getGamlType().getContentType());
        if (n >= this.numCols || n < 0) {
            return iList;
        }
        int n2 = 0;
        while (n2 < this.numRows) {
            iList.add(this.getNthElement(n2 * this.numCols + n));
            ++n2;
        }
        return iList;
    }

    @Override
    public IMatrix plus(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        return GamaMatrix.opPlus(iScope, this, iMatrix);
    }

    @Override
    public IMatrix times(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        return GamaMatrix.opTimes(iScope, this, iMatrix);
    }

    @Override
    public IMatrix<T> minus(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        return GamaMatrix.opMinus(iScope, this, iMatrix);
    }

    @Override
    public T anyValue(IScope iScope) {
        RandomUtils randomUtils = iScope.getRandom();
        int n = randomUtils.between(0, this.numCols - 1);
        int n2 = randomUtils.between(0, this.numRows - 1);
        return this.get(iScope, n, n2);
    }

    protected abstract IList<T> _listValue(IScope var1, IType var2, boolean var3);

    protected abstract IMatrix<T> _matrixValue(IScope var1, GamaPoint var2, IType var3, boolean var4);

    protected abstract void _clear();

    protected abstract boolean _removeFirst(IScope var1, T var2) throws GamaRuntimeException;

    protected abstract boolean _removeAll(IScope var1, IContainer<?, T> var2) throws GamaRuntimeException;

    protected abstract void _putAll(IScope var1, Object var2) throws GamaRuntimeException;

    protected abstract IMatrix<T> _reverse(IScope var1) throws GamaRuntimeException;

    protected abstract boolean _isEmpty(IScope var1);

    protected abstract boolean _contains(IScope var1, Object var2);

    protected abstract Integer _length(IScope var1);

    protected abstract Object _last(IScope var1);

    protected abstract Object _first(IScope var1);

    @Override
    public IMatrix divides(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        return this;
    }

    @Override
    public IMatrix times(Double d) throws GamaRuntimeException {
        return this;
    }

    @Override
    public IMatrix times(Integer n) throws GamaRuntimeException {
        return this;
    }

    @Override
    public IMatrix divides(Double d) throws GamaRuntimeException {
        return this;
    }

    @Override
    public IMatrix divides(Integer n) throws GamaRuntimeException {
        return this;
    }

    @Override
    public IMatrix plus(Double d) throws GamaRuntimeException {
        return this;
    }

    @Override
    public IMatrix plus(Integer n) throws GamaRuntimeException {
        return this;
    }

    @Override
    public IMatrix minus(Double d) throws GamaRuntimeException {
        return this;
    }

    @Override
    public IMatrix minus(Integer n) throws GamaRuntimeException {
        return this;
    }

    @Override
    public double getNoData(IScope iScope) {
        return Double.MAX_VALUE;
    }
}

