/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation;

import gama.core.common.util.FileUtils;
import gama.gaml.compilation.GamlCompilationError;
import java.util.List;

public class GamaCompilationFailedException
extends RuntimeException {
    private static final long serialVersionUID = 1392647532622819498L;
    public final List<GamlCompilationError> errorList;

    public GamaCompilationFailedException(List<GamlCompilationError> list) {
        this.errorList = list;
    }

    @Override
    public String getMessage() {
        return "The model couldn't be compiled because of compilation errors";
    }

    public String toJsonString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("\"exception\":\"").append(this.getClass().getSimpleName()).append("\",");
        stringBuilder.append("\"message\":\"").append(this.getMessage()).append("\",");
        stringBuilder.append("\"errors\":[");
        boolean bl = false;
        for (GamlCompilationError gamlCompilationError : this.errorList) {
            if (bl) {
                stringBuilder.append(",");
            }
            stringBuilder.append("{");
            stringBuilder.append("\"type\":\"").append(gamlCompilationError.errorType.name()).append("\",");
            stringBuilder.append("\"message\":\"").append(gamlCompilationError.message).append("\",");
            stringBuilder.append("\"code\":\"").append(gamlCompilationError.code).append("\",");
            stringBuilder.append("\"data\":[\"").append(String.join((CharSequence)"\",\"", gamlCompilationError.data)).append("\"],");
            stringBuilder.append("\"source\":\"").append(FileUtils.escapeFilePath(gamlCompilationError.source.eResource().getURI().toFileString())).append("\"");
            stringBuilder.append("}");
            bl = true;
        }
        stringBuilder.append("]");
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

