/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.gaml.statements.draw.IMeshColorProvider;
import java.awt.Color;
import java.util.List;

public class ListBasedMeshColorProvider
implements IMeshColorProvider {
    private final double[] components;
    private final int size;

    public ListBasedMeshColorProvider(List<? extends Color> list) {
        this.size = list.size();
        this.components = new double[this.size * 4];
        int n = 0;
        while (n < this.size) {
            Color color = list.get(n);
            if (color != null) {
                this.components[n * 3] = (double)color.getRed() / 255.0;
                this.components[n * 3 + 1] = (double)color.getGreen() / 255.0;
                this.components[n * 3 + 2] = (double)color.getBlue() / 255.0;
                this.components[n * 3 + 3] = (double)color.getAlpha() / 255.0;
            }
            ++n;
        }
    }

    @Override
    public double[] getColor(int n, double d, double d2, double d3, double[] dArray) {
        double[] dArray2 = dArray;
        if (dArray2 == null) {
            dArray2 = new double[4];
        }
        int n2 = n % this.size;
        dArray2[0] = this.components[n2 * 3];
        dArray2[1] = this.components[n2 * 3 + 1];
        dArray2[2] = this.components[n2 * 3 + 2];
        dArray2[3] = 1.0;
        return dArray2;
    }
}

