/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaPair;
import gama.core.util.IMap;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@GamlAnnotations.type(name="point", id=7, wraps={GamaPoint.class}, kind=101, concept={"type", "point"}, doc={@GamlAnnotations.doc(value="Represent locations in either 2 or 3 dimensions")})
public class GamaPointType
extends GamaType<GamaPoint> {
    @Override
    @GamlAnnotations.doc(value="Transforms the parameter into a point. If it is already a point, returns it. If it is a geometry, returns its location. If it is a list, interprets its elements as float values and use up to the first 3 ones to return a point. If it is a map, tries to find 'x', 'y' and 'z' keys in it. If it is a number, returns a point with the x, y and equal to this value")
    public GamaPoint cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaPointType.staticCast(iScope, object, bl);
    }

    public static GamaPoint staticCast(IScope iScope, Object object, boolean bl) {
        String string;
        if (object instanceof GamaPoint) {
            GamaPoint gamaPoint = (GamaPoint)object;
            if (bl) {
                return new GamaPoint(gamaPoint);
            }
            return gamaPoint;
        }
        if (object instanceof IShape) {
            return ((IShape)object).getLocation();
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() > 2) {
                return new GamaPoint(Cast.asFloat(iScope, list.get(0)), Cast.asFloat(iScope, list.get(1)), Cast.asFloat(iScope, list.get(2)));
            }
            if (list.size() > 1) {
                return new GamaPoint(Cast.asFloat(iScope, list.get(0)), Cast.asFloat(iScope, list.get(1)));
            }
            if (list.size() > 0) {
                return GamaPointType.staticCast(iScope, list.get(0), bl);
            }
            return new GamaPoint(0.0, 0.0, 0.0);
        }
        if (object instanceof GamaColor) {
            GamaColor gamaColor = (GamaColor)object;
            return new GamaPoint(gamaColor.getRed(), gamaColor.getGreen(), gamaColor.getBlue());
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            double d = Cast.asFloat(iScope, map.get("x"));
            double d2 = Cast.asFloat(iScope, map.get("y"));
            double d3 = Cast.asFloat(iScope, map.get("z"));
            return new GamaPoint(d, d2, d3);
        }
        if (object instanceof String && (string = ((String)object).trim()).startsWith("{") && string.endsWith("}")) {
            string = string.replace("{", "").replace("}", "").trim();
            return GamaPointType.staticCast(iScope, Arrays.asList(string.split(",")), false);
        }
        if (object instanceof GamaPair) {
            return new GamaPoint(Cast.asFloat(iScope, ((GamaPair)object).first()), Cast.asFloat(iScope, ((GamaPair)object).last()));
        }
        if (object == null) {
            return null;
        }
        double d = Cast.asFloat(iScope, object);
        return new GamaPoint(d, d, d);
    }

    @Override
    public GamaPoint getDefault() {
        return null;
    }

    @Override
    public IType getContentType() {
        return Types.get(2);
    }

    @Override
    public IType getKeyType() {
        return Types.get(1);
    }

    @Override
    public boolean canCastToConst() {
        return true;
    }

    @Override
    public boolean isDrawable() {
        return true;
    }

    @Override
    public boolean isCompoundType() {
        return true;
    }

    @Override
    public GamaPoint deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        return new GamaPoint(Cast.asFloat(iScope, iMap.get("x")), Cast.asFloat(iScope, iMap.get("y")), Cast.asFloat(iScope, iMap.get("z")));
    }
}

