/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.charts;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IDisposable;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.AbstractLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.charts.ChartDataSet;
import gama.core.outputs.layers.charts.ChartJFreeChartOutput;
import gama.core.outputs.layers.charts.ChartOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.core.util.IList;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import gama.gaml.types.Types;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jfree.chart.JFreeChart;

@GamlAnnotations.inside(symbols={"display"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="x_range", type={2, 1, 7, 5}, optional=true, doc={@GamlAnnotations.doc(value="range of the x-axis. Can be a number (which will set the axis total range) or a point (which will set the min and max of the axis).")}), @GamlAnnotations.facet(name="y_range", type={2, 1, 7, 5}, optional=true, doc={@GamlAnnotations.doc(value="range of the y-axis. Can be a number (which will set the axis total range) or a point (which will set the min and max of the axis).")}), @GamlAnnotations.facet(name="y2_range", type={2, 1, 7, 5}, optional=true, doc={@GamlAnnotations.doc(value="range of the second y-axis. Can be a number (which will set the axis total range) or a point (which will set the min and max of the axis).")}), @GamlAnnotations.facet(name="position", type={7}, optional=true, doc={@GamlAnnotations.doc(value="position of the upper-left corner of the layer. Note that if coordinates are in [0,1[, the position is relative to the size of the environment (e.g. {0.5,0.5} refers to the middle of the display) whereas it is absolute when coordinates are greater than 1 for x and y. The z-ordinate can only be defined between 0 and 1. The position can only be a 3D point {0.5, 0.5, 0.5}, the last coordinate specifying the elevation of the layer.")}), @GamlAnnotations.facet(name="size", type={7}, optional=true, doc={@GamlAnnotations.doc(value="the layer resize factor: {1,1} refers to the original size whereas {0.5,0.5} divides by 2 the height and the width of the layer. In case of a 3D layer, a 3D point can be used (note that {1,1} is equivalent to {1,1,0}, so a resize of a layer containing 3D objects with a 2D points will remove the elevation)")}), @GamlAnnotations.facet(name="reverse_axes", type={3}, optional=true, doc={@GamlAnnotations.doc(value="reverse X and Y axis (for example to get horizental bar charts")}), @GamlAnnotations.facet(name="background", type={6}, optional=true, doc={@GamlAnnotations.doc(value="the background color")}), @GamlAnnotations.facet(name="x_serie", type={5, 2, 1}, optional=true, doc={@GamlAnnotations.doc(value="for series charts, change the default common x serie (simulation cycle) for an other value (list or numerical).")}), @GamlAnnotations.facet(name="x_serie_labels", type={5, 2, 1, 4}, optional=true, doc={@GamlAnnotations.doc(value="change the default common x series labels (replace x value or categories) for an other value (string or numerical).")}), @GamlAnnotations.facet(name="y_serie_labels", type={5, 2, 1, 4}, optional=true, doc={@GamlAnnotations.doc(value="for heatmaps/3d charts, change the default y serie for an other value (string or numerical in a list or cumulative).")}), @GamlAnnotations.facet(name="x_log_scale", type={3}, optional=true, doc={@GamlAnnotations.doc(value="use Log Scale for X axis")}), @GamlAnnotations.facet(name="y_log_scale", type={3}, optional=true, doc={@GamlAnnotations.doc(value="use Log Scale for Y axis")}), @GamlAnnotations.facet(name="y2_log_scale", type={3}, optional=true, doc={@GamlAnnotations.doc(value="use Log Scale for second Y axis")}), @GamlAnnotations.facet(name="axes", type={6}, optional=true, doc={@GamlAnnotations.doc(value="the axis color")}), @GamlAnnotations.facet(name="x_tick_values_visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="X tick values visible")}), @GamlAnnotations.facet(name="y_tick_values_visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Y tick values visible")}), @GamlAnnotations.facet(name="title_visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="chart title visible")}), @GamlAnnotations.facet(name="x_tick_line_visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="X tick line visible")}), @GamlAnnotations.facet(name="y_tick_line_visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Y tick line visible")}), @GamlAnnotations.facet(name="tick_line_color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="the tick lines color")}), @GamlAnnotations.facet(name="type", type={-201}, values={"xy", "scatter", "histogram", "series", "pie", "radar", "heatmap", "box_whisker"}, optional=true, doc={@GamlAnnotations.doc(value="the type of chart. It could be histogram, series, xy, pie, radar, heatmap or box whisker. The difference between series and xy is that the former adds an implicit x-axis that refers to the numbers of cycles, while the latter considers the first declaration of data to be its x-axis.")}), @GamlAnnotations.facet(name="style", type={-201}, values={"line", "area", "bar", "dot", "step", "spline", "stack", "3d", "ring", "exploded", "default"}, doc={@GamlAnnotations.doc(value="The sub-style style, also default style for the series.")}, optional=true), @GamlAnnotations.facet(name="gap", type={2}, optional=true, doc={@GamlAnnotations.doc(value="minimum gap between bars (in proportion)")}), @GamlAnnotations.facet(name="y_tick_unit", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the tick unit for the x-axis (distance between vertical lines and values bellow the axis).")}), @GamlAnnotations.facet(name="y2_tick_unit", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the tick unit for the x-axis (distance between vertical lines and values bellow the axis).")}), @GamlAnnotations.facet(name="x_tick_unit", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the tick unit for the y-axis (distance between horizontal lines and values on the left of the axis).")}), @GamlAnnotations.facet(name="name", type={4}, optional=false, doc={@GamlAnnotations.doc(value="the identifier of the chart layer")}), @GamlAnnotations.facet(name="x_label", type={4}, optional=true, doc={@GamlAnnotations.doc(value="the title for the X axis")}), @GamlAnnotations.facet(name="y_label", type={4}, optional=true, doc={@GamlAnnotations.doc(value="the title for the Y axis")}), @GamlAnnotations.facet(name="y2_label", type={4}, optional=true, doc={@GamlAnnotations.doc(value="the title for the second Y axis")}), @GamlAnnotations.facet(name="color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="Text color")}), @GamlAnnotations.facet(name="series_label_position", type={-201}, values={"default", "none", "legend", "onchart", "yaxis", "xaxis"}, optional=true, doc={@GamlAnnotations.doc(value="Position of the Series names: default (best guess), none, legend, onchart, xaxis (for category plots) or yaxis (uses the first serie name).")}), @GamlAnnotations.facet(name="label_background_color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="Color of the label background (for Pie chart)")}), @GamlAnnotations.facet(name="label_text_color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="Color of the label text (for Pie chart)")}), @GamlAnnotations.facet(name="memorize", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether or not to keep the values in memory (in order to produce a csv file, for instance). The default value, true, can also be changed in the preferences")}), @GamlAnnotations.facet(name="tick_font", type={4, 19}, optional=true, doc={@GamlAnnotations.doc(value="Tick font face. Either the name of a font face or a font. When used for a series chart, it will set the font of values on the axes, but When used with a pie, it will modify the font of messages associated to each pie section.")}), @GamlAnnotations.facet(name="label_font", type={4, 19}, optional=true, doc={@GamlAnnotations.doc(value="Label font face. Either the name of a font face or a font")}), @GamlAnnotations.facet(name="transparency", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the transparency level of the layer (between 0 -- opaque -- and 1 -- fully transparent)")}), @GamlAnnotations.facet(name="visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Defines whether this layer is visible or not")}), @GamlAnnotations.facet(name="legend_font", type={4, 19}, optional=true, doc={@GamlAnnotations.doc(value="Legend font face. Either the name of a font face or a font")}), @GamlAnnotations.facet(name="title_font", type={4, 19}, optional=true, doc={@GamlAnnotations.doc(value="Title font face. Either the name of a font face or a font")})}, omissible="name")
@GamlAnnotations.doc(value="`chart` allows modeler to display a chart: this enables to display specific values of the model at each iteration. GAMA can display various chart types: time series (series), pie charts (pie) and histograms (histogram).", usages={@GamlAnnotations.usage(value="The general syntax is:", examples={@GamlAnnotations.example(value="display chart_display {", isExecutable=false), @GamlAnnotations.example(value="   chart \"chart name\" type: series [additional options] {", isExecutable=false), @GamlAnnotations.example(value="      [Set of data, datalists statements]", isExecutable=false), @GamlAnnotations.example(value="   }", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"display", "agents", "event", "graphics", "display_grid", "image_layer", "overlay", "quadtree", "species_layer", "text"})
public class ChartLayerStatement
extends AbstractLayerStatement {
    public static final String XRANGE = "x_range";
    public static final String YRANGE = "y_range";
    public static final String Y2RANGE = "y2_range";
    public static final String XLABEL = "x_label";
    public static final String YLABEL = "y_label";
    public static final String Y2LABEL = "y2_label";
    public static final String MEMORIZE = "memorize";
    public static final String SERIES_LABEL_POSITION = "series_label_position";
    public static final String X_LOGSCALE = "x_log_scale";
    public static final String Y_LOGSCALE = "y_log_scale";
    public static final String Y2_LOGSCALE = "y2_log_scale";
    public static final String YTICKUNIT = "y_tick_unit";
    public static final String Y2TICKUNIT = "y2_tick_unit";
    public static final String XTICKUNIT = "x_tick_unit";
    public static final String XTICKLINEVISIBLE = "x_tick_line_visible";
    public static final String YTICKLINEVISIBLE = "y_tick_line_visible";
    public static final String TICKLINECOLOR = "tick_line_color";
    public static final String TITLEVISIBLE = "title_visible";
    public static final String XTICKVALUEVISIBLE = "x_tick_values_visible";
    public static final String YTICKVALUEVISIBLE = "y_tick_values_visible";
    public static final String TICKFONTFACE = "tick_font";
    public static final String LABELTEXTCOLOR = "label_text_color";
    public static final String LABELBACKGROUNDCOLOR = "label_background_color";
    public static final String LABELFONTFACE = "label_font";
    public static final String LEGENDFONTFACE = "legend_font";
    public static final String TITLEFONTFACE = "title_font";
    public static final String CHARTDATASET = "chart_dataset_transfer";
    private ChartOutput chartOutput = null;
    final Map<String, Double> lastValues = new LinkedHashMap<String, Double>();
    DataDeclarationSequence dataDeclaration = new DataDeclarationSequence(this.getDescription());

    public ChartOutput getOutput() {
        return this.chartOutput;
    }

    public ChartLayerStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.dataDeclaration.setChildren(iterable);
    }

    public JFreeChart getChart() {
        return this.chartOutput.getJFChart();
    }

    @Override
    public boolean _init(IScope iScope) throws GamaRuntimeException {
        IDisposable iDisposable;
        this.setName(this.getChartName(iScope));
        this.lastValues.clear();
        IExpression iExpression = this.getFacet("type");
        this.chartOutput = ChartJFreeChartOutput.createChartOutput(iScope, this.getName(), iExpression);
        iExpression = this.getFacet("style");
        if (iExpression != null) {
            this.chartOutput.setStyle(iScope, Cast.asString(iScope, iExpression.value(iScope)));
        }
        if ((iExpression = this.getFacet("reverse_axes")) != null) {
            this.chartOutput.setReverseAxis(iScope, Cast.asBool(iScope, iExpression.value(iScope)));
        }
        if ((iExpression = this.getFacet(X_LOGSCALE)) != null) {
            this.chartOutput.setX_LogScale(iScope, Cast.asBool(iScope, iExpression.value(iScope)));
        }
        if ((iExpression = this.getFacet(Y_LOGSCALE)) != null) {
            this.chartOutput.setY_LogScale(iScope, Cast.asBool(iScope, iExpression.value(iScope)));
        }
        if ((iExpression = this.getFacet(Y2_LOGSCALE)) != null) {
            this.chartOutput.setY2_LogScale(iScope, Cast.asBool(iScope, iExpression.value(iScope)));
        }
        this.chartOutput.createChart(iScope);
        this.updateValues(iScope);
        boolean bl = GamaPreferences.Displays.CHART_MEMORIZE.getValue();
        IExpression iExpression2 = this.getFacet(MEMORIZE);
        if (iExpression2 != null) {
            bl = Cast.asBool(iScope, iExpression2.value(iScope));
        }
        this.chartOutput.initChart(iScope, this.getName());
        boolean bl2 = iScope.getExperiment().getSpecies().isBatch();
        boolean bl3 = this.getDisplayOutput().isPermanent();
        boolean bl4 = bl2 && bl3;
        ChartDataSet chartDataSet = new ChartDataSet(bl, bl4);
        this.chartOutput.setChartdataset(chartDataSet);
        this.chartOutput.initdataset();
        IExpression iExpression3 = this.getFacet("x_serie");
        if (iExpression3 != null) {
            iDisposable = this.getFacet("x_serie").resolveAgainst(iScope);
            chartDataSet.setXSource(iScope, (IExpression)iDisposable);
            this.chartOutput.setUseXSource(iScope, (IExpression)iDisposable);
        }
        if ((iExpression3 = this.getFacet("x_serie_labels")) != null) {
            iDisposable = this.getFacet("x_serie_labels").resolveAgainst(iScope);
            chartDataSet.setXLabels(iScope, (IExpression)iDisposable);
            this.chartOutput.setUseXLabels(iScope, (IExpression)iDisposable);
        }
        if ((iExpression3 = this.getFacet("y_serie_labels")) != null) {
            iDisposable = this.getFacet("y_serie_labels").resolveAgainst(iScope);
            chartDataSet.setYLabels(iScope, (IExpression)iDisposable);
            this.chartOutput.setUseYLabels(iScope, (IExpression)iDisposable);
        }
        iScope.addVarWithValue(CHARTDATASET, chartDataSet);
        IStatement[] iStatementArray = this.dataDeclaration.getCommands();
        int n = iStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            iDisposable = iStatementArray[n2];
            iScope.execute((IExecutable)((Object)iDisposable));
            ++n2;
        }
        chartDataSet = (ChartDataSet)iScope.getVarValue(CHARTDATASET);
        this.chartOutput.initChart_post_data_init(iScope);
        this.chartOutput.updateOutput(iScope);
        return true;
    }

    private String getChartName(IScope iScope) {
        return Cast.asString(iScope, this.getFacetValue(iScope, "name"));
    }

    public boolean updateValues(IScope iScope) {
        double d;
        Object object;
        Object object2;
        IExpression iExpression;
        IExpression iExpression2 = this.getFacet(XLABEL);
        if (iExpression2 != null) {
            this.chartOutput.setXLabel(iScope, Cast.asString(iScope, iExpression2.value(iScope)));
        }
        if ((iExpression2 = this.getFacet(YLABEL)) != null) {
            this.chartOutput.setYLabel(iScope, Cast.asString(iScope, iExpression2.value(iScope)));
        }
        if ((iExpression2 = this.getFacet(Y2LABEL)) != null) {
            this.chartOutput.setY2Label(iScope, Cast.asString(iScope, iExpression2.value(iScope)));
        }
        if ((iExpression2 = this.getFacet(SERIES_LABEL_POSITION)) != null) {
            this.chartOutput.setSeriesLabelPosition(iScope, Cast.asString(iScope, iExpression2.value(iScope)));
        }
        if ((iExpression = this.getFacet(XRANGE)) != null) {
            object2 = iExpression.value(iScope);
            if (object2 instanceof Number) {
                this.chartOutput.setXRangeInterval(iScope, ((Number)object2).doubleValue());
            } else if (object2 instanceof GamaPoint) {
                this.chartOutput.setXRangeMinMax(iScope, ((GamaPoint)object2).getX(), ((GamaPoint)object2).getY());
            } else if (object2 instanceof IList) {
                this.chartOutput.setXRangeMinMax(iScope, Cast.asFloat(iScope, ((IList)object2).get(0)), Cast.asFloat(iScope, ((IList)object2).get(1)));
            }
        }
        if ((iExpression = this.getFacet(YRANGE)) != null) {
            object2 = iExpression.value(iScope);
            if (object2 instanceof Number) {
                this.chartOutput.setYRangeInterval(iScope, ((Number)object2).doubleValue());
            } else if (object2 instanceof GamaPoint) {
                this.chartOutput.setYRangeMinMax(iScope, ((GamaPoint)object2).getX(), ((GamaPoint)object2).getY());
            } else if (object2 instanceof IList) {
                this.chartOutput.setYRangeMinMax(iScope, Cast.asFloat(iScope, ((IList)object2).get(0)), Cast.asFloat(iScope, ((IList)object2).get(1)));
            }
        }
        if ((iExpression = this.getFacet(Y2RANGE)) != null) {
            object2 = iExpression.value(iScope);
            if (object2 instanceof Number) {
                this.chartOutput.setY2RangeInterval(iScope, ((Number)object2).doubleValue());
            } else if (object2 instanceof GamaPoint) {
                this.chartOutput.setY2RangeMinMax(iScope, ((GamaPoint)object2).getX(), ((GamaPoint)object2).getY());
            } else if (object2 instanceof IList) {
                this.chartOutput.setY2RangeMinMax(iScope, Cast.asFloat(iScope, ((IList)object2).get(0)), Cast.asFloat(iScope, ((IList)object2).get(1)));
            }
        }
        if ((object2 = this.getFacet(XTICKUNIT)) != null && (object = object2.value(iScope)) instanceof Number) {
            d = ((Number)object).doubleValue();
            this.chartOutput.setXTickUnit(iScope, d);
        }
        if ((object2 = this.getFacet(YTICKUNIT)) != null && (object = object2.value(iScope)) instanceof Number) {
            d = ((Number)object).doubleValue();
            this.chartOutput.setYTickUnit(iScope, d);
        }
        if ((object2 = this.getFacet(Y2TICKUNIT)) != null && (object = object2.value(iScope)) instanceof Number) {
            d = ((Number)object).doubleValue();
            this.chartOutput.setY2TickUnit(iScope, d);
        }
        if ((object2 = this.getFacet("gap")) != null) {
            object = Cast.asFloat(iScope, object2.value(iScope));
            this.chartOutput.setGap(iScope, (Double)object);
        }
        object = GamaColor.get(Color.black);
        IExpression iExpression3 = this.getFacet("axes");
        if (iExpression3 != null) {
            object = Cast.asColor(iScope, iExpression3.value(iScope));
        }
        this.chartOutput.setAxesColorValue(iScope, (GamaColor)object);
        object = GamaColor.get(Color.black);
        iExpression3 = this.getFacet(TICKLINECOLOR);
        if (iExpression3 != null) {
            object = Cast.asColor(iScope, iExpression3.value(iScope));
        }
        this.chartOutput.setTickColorValue(iScope, (GamaColor)object);
        iExpression2 = this.getFacet(XTICKVALUEVISIBLE);
        if (iExpression2 != null) {
            this.chartOutput.setXTickValueVisible(iScope, Cast.asBool(iScope, iExpression2.value(iScope)));
        }
        if ((iExpression2 = this.getFacet(YTICKVALUEVISIBLE)) != null) {
            this.chartOutput.setYTickValueVisible(iScope, Cast.asBool(iScope, iExpression2.value(iScope)));
        }
        if ((iExpression2 = this.getFacet(TITLEVISIBLE)) != null) {
            this.chartOutput.setTitleVisible(iScope, Cast.asBool(iScope, iExpression2.value(iScope)));
        }
        if ((iExpression2 = this.getFacet(XTICKLINEVISIBLE)) != null) {
            this.chartOutput.setXTickLineVisible(iScope, Cast.asBool(iScope, iExpression2.value(iScope)));
        }
        if ((iExpression2 = this.getFacet(YTICKLINEVISIBLE)) != null) {
            this.chartOutput.setYTickLineVisible(iScope, Cast.asBool(iScope, iExpression2.value(iScope)));
        }
        if ((iExpression3 = this.getFacet("color")) != null) {
            object = Cast.asColor(iScope, iExpression3.value(iScope));
        }
        this.chartOutput.setColorValue(iScope, (GamaColor)object);
        object = GamaColor.get(Color.white);
        iExpression3 = this.getFacet("background");
        if (iExpression3 != null) {
            object = Cast.asColor(iScope, iExpression3.value(iScope));
        }
        this.chartOutput.setBackgroundColorValue(iScope, (GamaColor)object);
        iExpression3 = this.getFacet(LABELTEXTCOLOR);
        if (iExpression3 != null) {
            object = Cast.asColor(iScope, iExpression3.value(iScope));
            this.chartOutput.setLabelTextColorValue(iScope, (GamaColor)object);
        }
        if ((iExpression3 = this.getFacet(LABELBACKGROUNDCOLOR)) != null) {
            object = Cast.asColor(iScope, iExpression3.value(iScope));
            this.chartOutput.setLabelBackgroundColorValue(iScope, (GamaColor)object);
        }
        if ((iExpression3 = this.getFacet("background")) != null) {
            object = Cast.asColor(iScope, iExpression3.value(iScope));
            this.chartOutput.setBackgroundColorValue(iScope, (GamaColor)object);
        }
        GamaFont gamaFont = null;
        IExpression iExpression4 = this.getFacet(TICKFONTFACE);
        if (iExpression4 != null) {
            if (iExpression4.getGamlType() == Types.STRING) {
                this.chartOutput.setTickFontFace(iScope, Cast.asString(iScope, iExpression4.value(iScope)));
            } else {
                gamaFont = (GamaFont)Types.FONT.cast(iScope, iExpression4.value(iScope), null, false);
                if (gamaFont != null) {
                    this.chartOutput.setTickFontFace(iScope, gamaFont.getFontName());
                    this.chartOutput.setTickFontSize(iScope, gamaFont.getSize());
                    this.chartOutput.setTickFontStyle(iScope, gamaFont.getStyle());
                }
            }
        }
        if ((iExpression4 = this.getFacet(LABELFONTFACE)) != null) {
            if (iExpression4.getGamlType() == Types.STRING) {
                this.chartOutput.setLabelFontFace(iScope, Cast.asString(iScope, iExpression4.value(iScope)));
            } else {
                gamaFont = (GamaFont)Types.FONT.cast(iScope, iExpression4.value(iScope), null, false);
                if (gamaFont != null) {
                    this.chartOutput.setLabelFontFace(iScope, gamaFont.getFontName());
                    this.chartOutput.setLabelFontSize(iScope, gamaFont.getSize());
                    this.chartOutput.setLabelFontStyle(iScope, gamaFont.getStyle());
                }
            }
        }
        if ((iExpression4 = this.getFacet(LEGENDFONTFACE)) != null) {
            if (iExpression4.getGamlType() == Types.STRING) {
                this.chartOutput.setLegendFontFace(iScope, Cast.asString(iScope, iExpression4.value(iScope)));
            } else {
                gamaFont = (GamaFont)Types.FONT.cast(iScope, iExpression4.value(iScope), null, false);
                if (gamaFont != null) {
                    this.chartOutput.setLegendFontFace(iScope, gamaFont.getFontName());
                    this.chartOutput.setLegendFontSize(iScope, gamaFont.getSize());
                    this.chartOutput.setLegendFontStyle(iScope, gamaFont.getStyle());
                }
            }
        }
        if ((iExpression4 = this.getFacet(TITLEFONTFACE)) != null) {
            if (iExpression4.getGamlType() == Types.STRING) {
                this.chartOutput.setTitleFontFace(iScope, Cast.asString(iScope, iExpression4.value(iScope)));
            } else {
                gamaFont = (GamaFont)Types.FONT.cast(iScope, iExpression4.value(iScope), null, false);
                if (gamaFont != null) {
                    this.chartOutput.setTitleFontFace(iScope, gamaFont.getFontName());
                    this.chartOutput.setTitleFontSize(iScope, gamaFont.getSize());
                    this.chartOutput.setTitleFontStyle(iScope, gamaFont.getStyle());
                }
            }
        }
        return true;
    }

    @Override
    public boolean _step(IScope iScope) throws GamaRuntimeException {
        this.updateValues(iScope);
        this.chartOutput.step(iScope);
        return true;
    }

    @Override
    public ILayerStatement.LayerType getType(LayeredDisplayOutput layeredDisplayOutput) {
        return ILayerStatement.LayerType.CHART;
    }

    @Override
    public void dispose() {
        if (this.chartOutput != null) {
            this.chartOutput.dispose(null);
        }
        this.chartOutput = null;
        super.dispose();
    }

    public void saveHistory() {
        if (!this.chartOutput.getChartdataset().keepsHistory()) {
            return;
        }
        IScope.IGraphicsScope iGraphicsScope = this.getDisplayOutput().getScope().copy("in save");
        if (iGraphicsScope == null) {
            return;
        }
        try {
            try {
                this.chartOutput.getChartdataset().saveHistory(iGraphicsScope, this.getName() + "_cycle_" + iGraphicsScope.getClock().getCycle());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GAMA.releaseScope(iGraphicsScope);
                return;
            }
        }
        finally {
            GAMA.releaseScope(iGraphicsScope);
        }
    }

    public boolean keepsHistory() {
        return this.chartOutput.getChartdataset().keepHistory;
    }

    public static class DataDeclarationSequence
    extends AbstractStatementSequence {
        public DataDeclarationSequence(IDescription iDescription) {
            super(iDescription);
        }
    }
}

