/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime;

import gama.core.common.interfaces.IBenchmarkable;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.IGui;
import gama.core.common.interfaces.IStepable;
import gama.core.common.util.RandomUtils;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationClock;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulationFactory;
import gama.core.metamodel.topology.ITopology;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.FlowStatus;
import gama.core.runtime.IExecutionContext;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.runtime.server.GamaServerExperimentConfiguration;
import gama.core.util.IList;
import gama.gaml.compilation.ISymbol;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IExecutable;
import gama.gaml.types.IType;
import gama.gaml.types.ITypesManager;
import gama.gaml.types.Types;
import java.io.Closeable;
import java.util.EnumSet;
import java.util.Map;

public interface IScope
extends Closeable,
IBenchmarkable {
    public static final EnumSet<FlowStatus> INTERRUPTING_STATUSES = EnumSet.of(FlowStatus.BREAK, FlowStatus.RETURN, FlowStatus.CONTINUE, FlowStatus.DIE, FlowStatus.DISPOSE);

    public void clear();

    @Override
    default public void close() {
        this.clear();
    }

    public void setOnUserHold(boolean var1);

    public boolean isOnUserHold();

    public boolean isPaused();

    public void disableErrorReporting();

    public void enableErrorReporting();

    public boolean reportErrors();

    public void setTrace(boolean var1);

    public String getName();

    @Override
    default public String getNameForBenchmarks() {
        return this.getName();
    }

    public IScope copy(String var1);

    public IGraphicsScope copyForGraphics(String var1);

    public boolean interrupted();

    public void push(ISymbol var1);

    public void pop(ISymbol var1);

    public void setCurrentSymbol(ISymbol var1);

    public ISymbol getCurrentSymbol();

    public void pushReadAttributes(Map var1);

    public Map popReadAttributes();

    public Map peekReadAttributes();

    public void setEach(Object var1);

    public Object getEach();

    public ITopLevelAgent getRoot();

    public SimulationAgent getSimulation();

    public IExperimentAgent getExperiment();

    public void pop(IAgent var1);

    public boolean push(IAgent var1);

    public IAgent getAgent();

    public IAgent[] getAgentsStack();

    public RandomUtils getRandom();

    public IGui getGui();

    public SimulationClock getClock();

    public ITopology getTopology();

    public ITopology setTopology(ITopology var1);

    default public ExecutionResult execute(IExecutable iExecutable) {
        return this.execute(iExecutable, this.getAgent(), null);
    }

    default public ExecutionResult execute(IExecutable iExecutable, Arguments arguments) {
        return this.execute(iExecutable, this.getAgent(), arguments);
    }

    default public ExecutionResult execute(IExecutable iExecutable, IAgent iAgent, Arguments arguments) {
        return this.execute(iExecutable, iAgent, false, arguments);
    }

    public ExecutionResult evaluate(IExpression var1, IAgent var2) throws GamaRuntimeException;

    public Object getVarValue(String var1);

    public Object getAgentVarValue(IAgent var1, String var2) throws GamaRuntimeException;

    public void setAgentVarValue(IAgent var1, String var2, Object var3) throws GamaRuntimeException;

    public Object getGlobalVarValue(String var1) throws GamaRuntimeException;

    public boolean hasAccessToGlobalVar(String var1);

    public void setGlobalVarValue(String var1, Object var2) throws GamaRuntimeException;

    default public void setVarValue(String string, Object object) {
        this.setVarValue(string, object, false);
    }

    public void setVarValue(String var1, Object var2, boolean var3);

    public void saveAllVarValuesIn(Map<String, Object> var1);

    public void removeAllVars();

    public void addVarWithValue(String var1, Object var2);

    public Object getArg(String var1, int var2) throws GamaRuntimeException;

    default public Object getArgIfExists(String string, int n) {
        if (this.hasArg(string)) {
            return this.getArg(string, n);
        }
        return null;
    }

    default public <T> T getTypedArg(String string, int n) {
        return (T)this.getArg(string, n);
    }

    default public <T> T getTypedArgIfExists(String string, int n) {
        return this.getTypedArgIfExists(string, n, null);
    }

    default public <T> T getTypedArgIfExists(String string, int n, T t) {
        if (this.hasArg(string)) {
            return (T)this.getArg(string, n);
        }
        return t;
    }

    public Integer getIntArg(String var1) throws GamaRuntimeException;

    public Double getFloatArg(String var1) throws GamaRuntimeException;

    public <T> IList<T> getListArg(String var1) throws GamaRuntimeException;

    public String getStringArg(String var1) throws GamaRuntimeException;

    public Boolean getBoolArg(String var1) throws GamaRuntimeException;

    default public boolean getBoolArgIfExists(String string, boolean bl) {
        if (this.hasArg(string)) {
            return this.getBoolArg(string);
        }
        return bl;
    }

    public boolean hasArg(String var1);

    public IType getType(String var1);

    public IModel getModel();

    public void setFlowStatus(FlowStatus var1);

    public ExecutionResult init(IStepable var1);

    public ExecutionResult step(IStepable var1);

    public ExecutionResult init(IAgent var1);

    public ExecutionResult step(IAgent var1);

    public void stackArguments(Arguments var1);

    public ExecutionResult update(IAgent var1);

    public IExecutionContext getExecutionContext();

    public boolean isInTryMode();

    public void enableTryMode();

    public void disableTryMode();

    public void setCurrentError(GamaRuntimeException var1);

    public GamaRuntimeException getCurrentError();

    default public boolean isGraphics() {
        return false;
    }

    public ExecutionResult execute(IExecutable var1, IAgent var2, boolean var3, Arguments var4);

    default public FlowStatus getAndClearBreakStatus() {
        return this.getAndClearFlowStatus(FlowStatus.BREAK);
    }

    default public FlowStatus getAndClearContinueStatus() {
        return this.getAndClearFlowStatus(FlowStatus.CONTINUE);
    }

    default public FlowStatus getAndClearReturnStatus() {
        return this.getAndClearFlowStatus(FlowStatus.RETURN);
    }

    default public FlowStatus getAndClearDeathStatus() {
        return this.getAndClearFlowStatus(FlowStatus.DIE);
    }

    public FlowStatus getAndClearFlowStatus(FlowStatus var1);

    default public void setBreakStatus() {
        this.setFlowStatus(FlowStatus.BREAK);
    }

    default public void setContinueStatus() {
        this.setFlowStatus(FlowStatus.CONTINUE);
    }

    default public void setReturnStatus() {
        this.setFlowStatus(FlowStatus.RETURN);
    }

    default public void setDeathStatus() {
        this.setFlowStatus(FlowStatus.DIE);
    }

    default public void setDisposeStatus() {
        this.setFlowStatus(FlowStatus.DISPOSE);
    }

    public boolean isClosed();

    default public Object getData(String string) {
        return null;
    }

    default public void setData(String string, Object object) {
    }

    public IPopulationFactory getPopulationFactory();

    default public GamaServerExperimentConfiguration getServerConfiguration() {
        IExperimentAgent iExperimentAgent = this.getExperiment();
        if (iExperimentAgent == null) {
            return GamaServerExperimentConfiguration.NULL;
        }
        return iExperimentAgent.getScope().getServerConfiguration();
    }

    default public void setServerConfiguration(GamaServerExperimentConfiguration gamaServerExperimentConfiguration) {
        IExperimentAgent iExperimentAgent = this.getExperiment();
        if (iExperimentAgent == null) {
            return;
        }
        iExperimentAgent.getScope().setServerConfiguration(gamaServerExperimentConfiguration);
    }

    default public ITypesManager getTypes() {
        IModel iModel = this.getModel();
        if (iModel == null) {
            return Types.builtInTypes;
        }
        return iModel.getDescription().getTypesManager();
    }

    public static interface IGraphicsScope
    extends IScope {
        @Override
        public IGraphicsScope copy(String var1);

        public void setGraphics(IGraphics var1);

        public IGraphics getGraphics();

        @Override
        default public boolean isGraphics() {
            return true;
        }
    }
}

