/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.concurrent;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.AgentSpliterator;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.concurrent.ParallelAgentExecuter;
import gama.core.runtime.concurrent.ParallelAgentStepper;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.statements.IExecutable;
import java.util.Spliterator;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;

public abstract class ParallelAgentRunner<T>
extends RecursiveTask<T>
implements IExecutable {
    final Spliterator<IAgent> agents;
    final IScope originalScope;

    public static <T> T execute(ForkJoinTask<T> forkJoinTask) throws GamaRuntimeException {
        if (forkJoinTask == null) {
            return null;
        }
        return GamaExecutorService.AGENT_PARALLEL_EXECUTOR.invoke(forkJoinTask);
    }

    public static <A extends IShape> Boolean step(IScope iScope, A[] AArray, int n) throws GamaRuntimeException {
        ParallelAgentStepper parallelAgentStepper = ParallelAgentRunner.from((IScope)iScope, AArray, (int)n);
        if (AArray.length <= n) {
            return parallelAgentStepper.executeOn(iScope);
        }
        return ParallelAgentRunner.execute(parallelAgentStepper);
    }

    public static <A extends IShape> void execute(IScope iScope, IExecutable iExecutable, A[] AArray, int n) throws GamaRuntimeException {
        ParallelAgentExecuter parallelAgentExecuter = ParallelAgentRunner.from((IScope)iScope, (IExecutable)iExecutable, AArray, (int)n);
        if (AArray.length <= n) {
            ((ParallelAgentRunner)parallelAgentExecuter).executeOn(iScope);
        } else {
            ParallelAgentRunner.execute(parallelAgentExecuter);
        }
    }

    private static <A extends IShape> ParallelAgentStepper from(IScope iScope, A[] AArray, int n) {
        return new ParallelAgentStepper(iScope, AgentSpliterator.of(AArray, n));
    }

    private static <A extends IShape> ParallelAgentExecuter from(IScope iScope, IExecutable iExecutable, A[] AArray, int n) {
        return new ParallelAgentExecuter(iScope, iExecutable, AgentSpliterator.of(AArray, n));
    }

    protected <A extends IShape> ParallelAgentRunner(IScope iScope, Spliterator<IAgent> spliterator) {
        this.agents = spliterator;
        this.originalScope = iScope.copy(" - forked - ");
    }

    abstract ParallelAgentRunner<T> subTask(Spliterator<IAgent> var1);

    @Override
    protected T compute() throws GamaRuntimeException {
        T t;
        Spliterator<IAgent> spliterator = this.agents.trySplit();
        if (spliterator == null) {
            t = this.executeOn(this.originalScope);
        } else {
            ParallelAgentRunner<T> parallelAgentRunner = this.subTask(spliterator);
            parallelAgentRunner.fork();
            t = this.compute();
            parallelAgentRunner.join();
        }
        return t;
    }

    public abstract T executeOn(IScope var1) throws GamaRuntimeException;
}

